/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Aaron Laniewicz
 */

/**
 * API Status: **Private**
 * @since Niagara 4.3
 * @module nmodule/control/rc/baja/ManualTriggerMode
 */
define(['baja!', 'lex!control'], function (baja, lexs) {
  'use strict';

  var Simple = baja.Simple,
    callSuper = baja.callSuper,
    subclass = baja.subclass,
    controlLex = lexs[0],
    manualDisplayNameLex = controlLex.get({
      key: 'trigger.manual',
      def: 'Manual'
    });

  /**
   * Represents a `control:ManualTriggerMode` in BajaScript.
   *
   * When creating a `Simple`, always use the `make()` method instead of
   * creating a new object.
   *
   * @class
   * @extends baja.Simple
   * @alias module:nmodule/control/rc/baja/ManualTriggerMode
   */
  var ManualTriggerMode = function ManualTriggerMode() {
    callSuper(ManualTriggerMode, this, arguments);
  };
  subclass(ManualTriggerMode, Simple);

  /**
   * Make a new `ManualTriggerMode` instance.
   *
   * @returns {module:nmodule/control/rc/baja/ManualTriggerMode}
   */
  ManualTriggerMode.make = function () {
    return new ManualTriggerMode();
  };

  /**
   * Make a new `ManualTriggerMode` instance.
   *
   * @see module:nmodule/control/rc/baja/ManualTriggerMode.make
   */
  ManualTriggerMode.prototype.make = function () {
    return ManualTriggerMode.make.apply(ManualTriggerMode, arguments);
  };

  /**
   * Decode the Default `ManualTriggerMode` instance from any `String`.
   *
   * @param {String} str - any `String`.
   *
   * @returns {module:nmodule/control/rc/baja/ManualTriggerMode}
   */
  ManualTriggerMode.prototype.decodeFromString = function (str) {
    return ManualTriggerMode.make();
  };

  /**
   * Encode the `ManualTriggerMode` (itself) to a `String`.
   *
   * @returns {String}
   */
  ManualTriggerMode.prototype.encodeToString = function () {
    return 'manual';
  };

  /**
   * Default `ManualTriggerMode` instance.
   *
   * @type {module:nmodule/control/rc/baja/ManualTriggerMode}
   */
  ManualTriggerMode.DEFAULT = ManualTriggerMode.make();

  /**
   * Return the `String` representation of the `ManualTriggerMode` (itself).
   *
   * @returns {String}
   */
  ManualTriggerMode.prototype.toString = function () {
    return manualDisplayNameLex;
  };

  /**
   * Get the display name for this trigger from lexicon.
   */
  ManualTriggerMode.prototype.getDisplayName = function () {
    return manualDisplayNameLex;
  };
  return ManualTriggerMode;
});
