/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env node */

'use strict';

var requirejs = require('requirejs');
var extend = require('node.extend');
var path = require('path');

/**
 * A function that configures RequireJS for running BajaScript inside node.
 * @private
 * @module baja/env/require-node-config
 * @param {Object} config RequireJS configuration info
 * @param {Object} config.connectParams connection info BajaScript will use
 * to connect to the station
 */
module.exports = function (config) {
  extend(true, config, {
    nodeRequire: require,
    baseUrl: path.join(__dirname, '..'),
    paths: {
      'baja': 'plugin/baja',
      'ord': 'plugin/node-ord'
    },
    moduledev: {
      filePath: 'd:\\niagara\\r38\\rel\\lib\\moduledev.properties',
      alwaysReload: false
    },
    //TODO: can we move baja up a level?
    config: {
      baja: {
        start: {
          connectParams: config.connectParams
        }
      }
    }
  });
  requirejs.config(config);
  return requirejs;
};
