function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module baja/env/mux/BoxMessageRelay
 */
define(['bajaScript/comm', 'bajaPromises', 'bajaScript/env/mux/BoxEnvelopeDemux', 'bajaScript/env/mux/BoxEnvelopeMux', 'bajaScript/env/mux/muxUtils'], function (baja, bajaPromises, BoxEnvelopeDemux, BoxEnvelopeMux, muxUtils) {
  'use strict';

  var fromBytes = muxUtils.fromBytes;

  /*
   * we grab a permanent reference to the "real" setTimeout/clearTimeout.
   * otherwise, when a test uses jasmine.Clock.useMock(), and muxing is enabled,
   * it basically stops BajaScript.
   */
  var global = typeof jasmine !== 'undefined' && jasmine.Clock && jasmine.Clock.real ? jasmine.Clock.real : window;
  var clearTimeout = global.clearTimeout,
    setTimeout = global.setTimeout;

  /**
   * This class's job is to abstract away the details of packaging individual BOX messages into
   * BoxFrames and BoxEnvelopes. It handles the debouncing aspect of implicit batching: if many
   * messages try to go out at the same time, even if not in a Batch, make sure they go up in one
   * network call anyway.
   *
   * It delegates sending and receiving data through BoxEnvelopeMux/Demux, which handle the
   * splitting and reassembly of WebSocket messages.
   *
   * Its public API is simply to send a BOX message and receive its response.
   *
   * @class
   * @alias module:baja/env/mux/BoxMessageRelay
   */
  return /*#__PURE__*/function () {
    /**
     * @param {baja/env/mux/muxUtils~MuxSettings} params
     * @param {number} [params.checkInterval=16] - approximately how often to check
     * whether our buffered data should be sent
     */
    function BoxMessageRelay(params) {
      var _this = this;
      _classCallCheck(this, BoxMessageRelay);
      var checkInterval = params.checkInterval,
        minDelay = params.minDelay,
        maxDelay = params.maxDelay,
        onIncomingFrame = params.onIncomingFrame,
        setFragmentHandler = params.setFragmentHandler;
      this.$demux = new BoxEnvelopeDemux({
        onComplete: function onComplete(env) {
          return _this.$completeEnvelope(env);
        }
      });
      this.$mux = new BoxEnvelopeMux(params);
      this.$minDelay = minDelay;
      this.$maxDelay = maxDelay;
      this.$checkInterval = checkInterval || 16;
      this.$onIncomingFrame = onIncomingFrame;

      /**
       * Simple store of what envelopes were sent as a result of this BoxMessageRelay. This relay
       * will be notified of every completed envelope, and does not want to respond to envelopes it
       * did not actually send.
       * @type {Object.<number, boolean>}
       */
      this.$pendingEnvelopes = {};

      /**
       * Store of message numbers and promises waiting to be resolved with their responses.
       * @type {Object.<number, Deferred>}
       */
      this.$messageDeferreds = {};

      /**
       * BOX messages that are waiting to be sent.
       * @type {Array.<object>}
       */
      this.$queuedMessages = [];
      this.$startSpinning();
      if (setFragmentHandler) {
        setFragmentHandler(function (fragment) {
          return _this.$demux.receiveFragment(fragment);
        });
      }
    }

    /**
     * The public API of BoxMessageRelay: send a BOX message and get its response.
     * @param {object} msg BOX message to send
     * @returns {Promise.<object>} to be resolved with the BOX message response
     */
    return _createClass(BoxMessageRelay, [{
      key: "sendMessage",
      value: function sendMessage(msg) {
        var messageNumber = msg.r;
        var df = bajaPromises.deferred();
        this.$lastData = this.$now();
        this.$queuedMessages.push(msg);
        this.$messageDeferreds[messageNumber] = df;
        return df.promise();
      }

      /**
       * Start regularly checking for buffered data to be sent.
       * @private
       */
    }, {
      key: "$startSpinning",
      value: function $startSpinning() {
        var _this2 = this;
        var minDelay = this.$minDelay;
        var maxDelay = this.$maxDelay;
        var lastFlush = Number.MAX_VALUE;
        var checkDelays = function checkDelays() {
          var now = _this2.$now();
          if (_this2.$hasQueuedMessages()) {
            var lastData = _this2.$lastData;
            var timeSinceLastData = now - lastData;
            var timeSinceLastFlush = now - lastFlush;
            if (timeSinceLastFlush >= maxDelay || timeSinceLastData >= minDelay) {
              lastFlush = now;
              _this2.$flush();
            }
          }
          checkAgainLater();
        };
        var checkAgainLater = function checkAgainLater() {
          _this2.$checkTicket = _this2.$setTimeout(checkDelays, _this2.$checkInterval);
        };
        checkAgainLater();
      }

      /**
       * @private
       */
    }, {
      key: "$stopSpinning",
      value: function $stopSpinning() {
        this.$clearTimeout(this.$checkTicket);
      }

      /**
       * @private
       * @returns {number} current timestamp
       */
    }, {
      key: "$now",
      value: function $now() {
        return +new Date();
      }

      /**
       * @private
       * @returns {boolean} true if any BOX messages are waiting to go out
       */
    }, {
      key: "$hasQueuedMessages",
      value: function $hasQueuedMessages() {
        return !!this.$queuedMessages.length;
      }

      /**
       * Sends up any queued BOX messages to the station.
       * @private
       */
    }, {
      key: "$flush",
      value: function $flush() {
        var _this3 = this;
        var mux = this.$mux;
        this.$queuedMessages.forEach(function (msg) {
          var envelopeId = mux.sendMessage(stripServerSessionId(msg));
          _this3.$pendingEnvelopes[envelopeId] = true;
        });
        mux.$flush();
        this.$queuedMessages = [];
      }

      /**
       * Called when a completed envelope is received from the server.
       * @private
       * @param {module:baja/env/mux/BoxEnvelope} env
       */
    }, {
      key: "$completeEnvelope",
      value: function $completeEnvelope(env) {
        var envelopeId = env.getEnvelopeId();
        var unsolicited = env.isUnsolicited();
        var pendingEnvelopes = this.$pendingEnvelopes;
        var messageDeferreds = this.$messageDeferreds;
        if (!unsolicited && !pendingEnvelopes[envelopeId]) {
          // received reply to envelope id not requested - likely due to connection sharing
          return;
        }
        var boxFrameFromServer = JSON.parse(fromBytes(env.getPayload()))[0];
        if (unsolicited) {
          this.$onIncomingFrame(boxFrameFromServer);
        } else {
          var messageResponses = boxFrameFromServer.m;
          messageResponses.forEach(function (response) {
            var messageNumber = response.r;
            var df = messageDeferreds[messageNumber];
            df.resolve(response);
            delete messageDeferreds[messageNumber];
          });
          delete pendingEnvelopes[envelopeId];
        }
      }

      /**
       * @private
       * @param {function} func
       * @param {number} delay
       * @returns {number}
       */
    }, {
      key: "$setTimeout",
      value: function $setTimeout(func, delay) {
        return setTimeout(func, delay);
      }

      /**
       * @private
       * @param {number} ticket
       */
    }, {
      key: "$clearTimeout",
      value: function $clearTimeout(ticket) {
        return clearTimeout(ticket);
      }
    }]);
  }();

  /**
   * Strips the server session ID off a BOX message. When muxing enabled, it can be omitted when
   * sending the message up to the server as the server will default to the server session ID of the
   * containing envelope itself.
   *
   * @param {object} m BOX message
   * @returns {object} the message with the ID stripped out (if it matches the envelope's ID)
   */
  function stripServerSessionId(m) {
    var myId = baja.comm.getServerSessionId();
    var id = m.b && m.b.id;
    if (id === myId) {
      delete m.b.id;
    }
    return m;
  }
});
