/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/**
 * Defines {@link baja.BinderCacheScheme}.
 * @module baja/ord/BinderCacheScheme
 * @private
 */
define(["bajaScript/sys", "bajaScript/baja/ord/OrdScheme"], function (baja, OrdScheme) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper;

  /**
   * BinderCacheScheme.
   *
   * In Java, this scheme is used to mark certain ords as cacheable by a `Binder`.
   * In BajaScript, this scheme is just implemented to prevent any extra server side
   * resolution for an unknown OrdScheme.
   *
   * @class
   * @alias baja.BinderCacheScheme
   * @extends baja.OrdScheme
   * @private
   * @see baja.OrdQueryList#isClientResolvable
   */
  var BinderCacheScheme = function BinderCacheScheme() {
    callSuper(BinderCacheScheme, this, arguments);
  };
  subclass(BinderCacheScheme, OrdScheme);

  /**
   * Default BinderCacheScheme instance
   * @private
   * @type {baja.BinderCacheScheme}
   */
  BinderCacheScheme.DEFAULT = new BinderCacheScheme();

  /**
   * Called when an ORD is resolved.
   *
   * @private
   *
   * @see baja.OrdScheme#resolve
   *
   * @param {module:baja/ord/OrdTarget} target  the current ORD Target.
   * @param {baja.OrdQuery} query  the ORD Query used in resolving the ORD.
   * @param {module:baja/ord/OrdQueryListCursor} cursor  the ORD Query List
   * cursor used for helping to asynchronously resolve the ORD.
   * @param {Object} options  options used for resolving an ORD.
   */
  BinderCacheScheme.prototype.resolve = function (target, query, cursor, options) {
    cursor.resolveNext(target, options);
  };
  return BinderCacheScheme;
});
