/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

define([], function () {
  "use strict";

  /**
   * Date and Time formatting.
   * 
   * @readonly
   * @enum {Number}
   * @alias baja.TimeFormat
   * 
   * @see baja.AbsTime#toDateTimeString
   * @see baja.Time#toTimeString
   */
  var TimeFormat = {
    /**
     * Show the date field.
     */
    SHOW_DATE: 0x01,
    /**
     * Show the time field.
     */
    SHOW_TIME: 0x02,
    /**
     * Show the seconds field.
     */
    SHOW_SECONDS: 0x04,
    /**
     * Show the milliseconds field.
     */
    SHOW_MILLIS: 0x08,
    /**
     * Show the time zone field.
     */
    SHOW_ZONE: 0x10 // TODO: Implement timezones. Currently this is unsupported.
  };
  return TimeFormat;
});
