function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

define(["bajaScript/sys", "bajaScript/baja/obj/objUtil"], function (baja, objUtil) {
  'use strict';

  /**
   * The native JavaScript String constructor. BajaScript extends it to add
   * Niagara-related functionality: {@link String}
   * 
   * @external String
   * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String String}
   */

  /**
   * Represents `baja:String` in BajaScript.
   * 
   * All JavaScript `String`s are augmented to be `baja:String` objects.
   *
   * @class
   * @alias String
   * @extends external:String
   */
  var BString = String;

  /**
   * Default `String` instance.
   * @type {String}
   */
  BString.DEFAULT = "";

  /**
   * Make a `String`.
   * 
   * @param {String} [str]
   * @returns {String}
   */
  BString.make = function (str) {
    if (str === undefined) {
      return String.DEFAULT;
    }
    if (typeof str !== "string") {
      throw new Error("Must supply a String when making BString instances: " + str);
    }
    return str;
  };

  /**
   * Make a `String`.
   *
   * @param {String} [str]
   * @returns {String}
   */
  BString.prototype.make = function (str) {
    return String.make(str);
  };

  /**
   * Decode a `String`.
   *
   * @param {String} str
   * @returns {String}
   */
  BString.prototype.decodeFromString = function (str) {
    return str;
  };
  BString.prototype.decodeAsync = function (str) {
    return str;
  };

  /**
   * Encode a `String`.
   *
   * @returns {String}
   */
  BString.prototype.encodeToString = function () {
    return String(this);
  };

  /**
   * Returns a new `String` with the first letter Capitalized.
   *
   * @returns {String}
   */
  BString.prototype.capitalizeFirstLetter = function () {
    return objUtil.capitalizeFirstLetter(this);
  };

  /**
   * Replace patterned items in a string from an Object Map.
   *
   * @returns {String}
   * @example
   *   var str = "The weather is {state}!";
   *   str = str.patternReplace({state: "really warm"});
   */
  BString.prototype.patternReplace = function (obj) {
    var that = this;
    return that.replace(/\{[a-zA-Z0-9]*\}/g, function (match) {
      match = match.substring(1, match.length - 1);
      var to = _typeof(obj[match]);
      if (to === "string") {
        return obj[match];
      }
      if (to === "function") {
        return obj[match](that) || match;
      }
      return match;
    });
  };

  /**
   * Return the Symbol used for encoding this data type (primarily used for facets).
   *
   * @returns {String}
   */
  BString.prototype.getDataTypeSymbol = function () {
    return "s";
  };

  /**
   * Equality test.
   * 
   * @param obj
   * @returns {Boolean}
   */
  BString.prototype.equals = function (obj) {
    return objUtil.valueOfEquals(this, obj);
  };

  /**
   * Equivalence test.
   * 
   * `equivalent()` is used to compare if two objects have equivalent
   * state, but might not want to return true for equals since it
   * it has implied semantics for many operations.  The default
   * implementation returns the result of {@link baja.Object#equals}.
   *
   * @param obj
   * @returns {Boolean}
   */
  BString.prototype.equivalent = function (obj) {
    return objUtil.equalsEquivalent(this, obj);
  };

  /**
   * New Copy.
   *
   * @returns {String}
   */
  BString.prototype.newCopy = function (exact) {
    return objUtil.valueOfNewCopy(this, exact);
  };

  /**
   * Return the Object's Icon.
   *
   * @returns {baja.Icon}
   */
  BString.prototype.getIcon = function () {
    return objUtil.objectGetIcon(this);
  };
  /**
   * Returns a promise that resolves to the agent list for this BString.
   *
   * @see baja.registry.getAgents
   *
   * @param  {Array<String>} [is] An optional array of filters to add to the
   * agent query.
   * @param  {baja.comm.Batch} [batch] An optional object used to batch network
   * calls together.
   * @returns {Promise} A promise that will resolve with the Agent Info.
   * @since Niagara 4.15
   */
  BString.prototype.getAgents = function (is, batch) {
    return baja.registry.getAgents("type:" + this.getType().toString(), is, batch);
  };
  return String;
});
