/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * Defines {@link baja.ActionProperty}.
 * @module baja/comp/ActionProperty
 */
define(["bajaScript/sys", "bajaScript/baja/comp/Struct"], function (baja, Struct) {
  "use strict";

  var subclass = baja.subclass,
    callSuper = baja.callSuper;

  /**
   * Represents a `baja:Action` in BajaScript.
   * 
   * Please note: this represents the `Property`'s value and NOT the 
   * `Property` itself.
   *
   * @class
   * @alias baja.ActionProperty
   * @extends baja.Struct
   */
  var ActionProperty = function ActionProperty() {
    callSuper(ActionProperty, this, arguments);
    this.$paramType = null;
    this.$returnType = null;
  };
  subclass(ActionProperty, Struct);

  /**
   * Return the Action's parameter Type.
   *
   * @returns {Type} parameter type (or null if the Action has no parameter).
   */
  ActionProperty.prototype.getParamType = function () {
    return this.$paramType;
  };

  /**
   * Previously, this returned the Action's parameter default value.
   *
   * @throws {Error} throws an error, this method is no longer supported.
   * @deprecated
   */
  ActionProperty.prototype.getParamDefault = function () {
    throw new Error('Action parameter default is not available');
  };

  /**
   * Return the Action's return Type.
   *
   * @returns {Type} return type (or null if the Action has nothing to return).
   */
  ActionProperty.prototype.getReturnType = function () {
    return this.$returnType;
  };

  /**
   * Called when the Action Property is invoked.
   *
   * @private
   *
   * @param {baja.Component} target the Component target the Action is being invoked upon.
   * @param {baja.Value} arg the argument for the Action.
   * @param {Object} cx the Context for the Action invocation (could be null).
   * @returns {baja.Value} the Action's return value (null if nothing to return).
   */
  ActionProperty.prototype.invoke = function (target, arg, cx) {
    return null;
  };
  return ActionProperty;
});
