function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'baja!bajaui:Layout', 'lex!uxBuilder', 'log!nmodule.uxBuilder.rc.ux.wysiwyg.trackers.trackerUtil', 'Promise', 'underscore', 'nmodule/bajaui/rc/baja/Layout', 'nmodule/bajaui/rc/ux/shape/Ellipse', 'nmodule/bajaui/rc/ux/shape/Line', 'nmodule/bajaui/rc/ux/shape/Path', 'nmodule/bajaui/rc/ux/shape/Polygon', 'nmodule/bajaui/rc/ux/shape/Rect', 'nmodule/bajaui/rc/ux/shape/Shape', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand'], function (baja, types, lexs, log, Promise, _, Layout, Ellipse, Line, Path, Polygon, Rect, Shape, switchboard, uxBuilderUtils, wysiwygUtils, ModifyUxModelCommand) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var pluck = _.pluck;
  var getOriginatingNode = uxBuilderUtils.getOriginatingNode;
  var calculateSides = wysiwygUtils.calculateSides,
    getWidgetsToMove = wysiwygUtils.getWidgetsToMove;
  var modify = ModifyUxModelCommand.modify;

  /**
   * API Status: **Private**
   * @since Niagara 4.15
   * @exports nmodule/uxBuilder/rc/ux/wysiwyg/trackers/trackerUtil
   */
  var exports = {};

  /**
   * @param {JQuery.Event} event
   * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController} controller
   * @returns {boolean|undefined}
   */
  exports.keydownHandler = function (event, controller) {
    var selectedWidgets = controller.getSelectedWidgets();
    var keyCode = event.keyCode;
    if (selectedWidgets.length === 0) {
      return;
    }
    var isRight = keyCode === 39;
    var isUp = keyCode === 38;
    var isDown = keyCode === 40;
    var isLeft = keyCode === 37;
    if (!(isRight || isUp || isDown || isLeft)) {
      return;
    }
    exports.computeMovement(event, controller)["catch"](logSevere);
    return false; //there is a selection and arrows keys are being used, so avoid default event behavior so we don't move scrollbars too
  };

  /**
   * Generates an undoable keyboard event if there is space to move the selected widget(s).
   * @param {JQuery.Event} event
   * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController} controller
   * @returns {Promise}
   */
  exports.computeMovement = function (event, controller) {
    var selectedWidgets = controller.getSelectedWidgets();
    var _getWidgetsToMove = getWidgetsToMove(selectedWidgets),
      widgets = _getWidgetsToMove.widgets,
      canvasPane = _getWidgetsToMove.canvasPane;
    if (!widgets.length) {
      return Promise.resolve();
    }
    var snapSize = controller.$getUxBuilder().properties().getValue('snapSize');
    var keyCode = event.keyCode;
    var isRight = keyCode === 39;
    var isUp = keyCode === 38;
    var isDown = keyCode === 40;
    var isLeft = keyCode === 37;
    var moveAmount;
    if (event.ctrlKey) {
      moveAmount = 1;
    } else {
      moveAmount = snapSize >= 8 ? Math.round(snapSize / 2) : snapSize;
    }
    var snap = moveAmount;
    var canvasPaneBoundingBoxes = selectedWidgets.map(function (widget) {
      return calculateSides(controller.$translateRect({
        rect: widget,
        to: canvasPane
      }));
    });

    // bounding box around _all_ the selected widgets
    var bigCanvasPaneBoundingBox = {
      top: Math.min.apply(Math, _toConsumableArray(pluck(canvasPaneBoundingBoxes, 'top'))),
      right: Math.max.apply(Math, _toConsumableArray(pluck(canvasPaneBoundingBoxes, 'right'))),
      bottom: Math.max.apply(Math, _toConsumableArray(pluck(canvasPaneBoundingBoxes, 'bottom'))),
      left: Math.min.apply(Math, _toConsumableArray(pluck(canvasPaneBoundingBoxes, 'left')))
    };
    {
      // cancel the move if it would take anything outside viewSize.
      var viewSize = canvasPane.properties().getValue('viewSize');
      if (isRight && bigCanvasPaneBoundingBox.right + moveAmount > viewSize.getWidth() || isDown && bigCanvasPaneBoundingBox.bottom + moveAmount > viewSize.getHeight() || isLeft && bigCanvasPaneBoundingBox.left - moveAmount < 0 || isUp && bigCanvasPaneBoundingBox.top - moveAmount < 0) {
        moveAmount = 0;
      }
    }
    if (moveAmount === 0) {
      return Promise.resolve();
    }
    var deltaXOnCanvasPane = 0,
      deltaYOnCanvasPane = 0;
    if (isRight) {
      var moveTarget = bigCanvasPaneBoundingBox.left + moveAmount;
      deltaXOnCanvasPane = moveAmount + getDeltaToClosestSnap(moveTarget, snap);
    } else if (isLeft) {
      var _moveTarget = bigCanvasPaneBoundingBox.left - moveAmount;
      deltaXOnCanvasPane = -moveAmount + getDeltaToClosestSnap(_moveTarget, snap);
    } else if (isUp) {
      var _moveTarget2 = bigCanvasPaneBoundingBox.top - moveAmount;
      deltaYOnCanvasPane = -moveAmount + getDeltaToClosestSnap(_moveTarget2, snap);
    } else if (isDown) {
      var _moveTarget3 = bigCanvasPaneBoundingBox.top + moveAmount;
      deltaYOnCanvasPane = moveAmount + getDeltaToClosestSnap(_moveTarget3, snap);
    }
    return Promise.all(widgets.map(function (widget, i) {
      var node = getOriginatingNode(widget);
      var model = node.value();
      var properties;
      if (widget instanceof Shape) {
        properties = {
          geom: widget.properties().getValue('geom').translate(deltaXOnCanvasPane, deltaYOnCanvasPane)
        };
      } else {
        var _canvasPaneBoundingBo = canvasPaneBoundingBoxes[i],
          canvasPaneX = _canvasPaneBoundingBo.x,
          canvasPaneY = _canvasPaneBoundingBo.y;
        // use moveTo(), and not translate(), because translate() will not move widgets with
        // percent-based x and y. expected keyboard behavior is to "lock" the widgets at the
        // absolute target x/y.
        properties = {
          layout: model.getProperties().layout.moveTo(canvasPaneX + deltaXOnCanvasPane, canvasPaneY + deltaYOnCanvasPane)
        };
      }
      return model.clone({
        properties: properties
      }).then(function (model) {
        return {
          model: model,
          parentNode: node.getParent()
        };
      });
    })).then(function (ops) {
      return modify(ops, {
        redoText: function redoText() {
          return uxBuilderLex.get('commands.layout.modify.redoText');
        },
        undoText: function undoText() {
          return uxBuilderLex.get('commands.layout.modify.undoText');
        }
      });
    });
  };
  switchboard(exports, {
    computeMovement: {
      allow: 'oneAtATime',
      onRepeat: 'preempt'
    }
  });
  function getLowerSnap(n, snapSize) {
    return n - n % snapSize;
  }
  function getUpperSnap(n, snapSize) {
    return getLowerSnap(n, snapSize) + snapSize;
  }
  function isOnSnap(n, snapSize) {
    return n % snapSize === 0;
  }
  function getDeltaToClosestSnap(moveTarget, snap) {
    if (isOnSnap(moveTarget, snap)) {
      return 0;
    }
    var lowerSnap = getLowerSnap(moveTarget, snap);
    var upperSnap = getUpperSnap(moveTarget, snap);
    var deltaLow = Math.abs(lowerSnap - moveTarget);
    var deltaHigh = Math.abs(upperSnap - moveTarget);
    return deltaLow < deltaHigh ? lowerSnap - moveTarget : upperSnap - moveTarget;
  }
  return exports;
});
