function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/trackers/events/SplitPaneTracker
 */
define(['lex!uxBuilder', 'bajaux/commands/Command', 'jquery', 'Promise', 'nmodule/bajaui/rc/ux/SplitPane', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker', 'nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand'], function (lexs, Command, $, Promise, SplitPane, uxBuilderUtils, Tracker, ModifyUxModelCommand) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var cloneWithChanges = uxBuilderUtils.cloneWithChanges,
    getOriginatingNode = uxBuilderUtils.getOriginatingNode;

  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/events/SplitPaneTracker
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker
   */
  var SplitPaneTracker = /*#__PURE__*/function (_Tracker) {
    function SplitPaneTracker(controller, splitPane) {
      var _this;
      _classCallCheck(this, SplitPaneTracker);
      _this = _callSuper(this, SplitPaneTracker, [controller]);
      _this.$splitPane = splitPane;
      return _this;
    }

    /**
     * @param {module:bajaux/Widget} widget
     * @returns {boolean} true if it's a SplitPane
     */
    _inherits(SplitPaneTracker, _Tracker);
    return _createClass(SplitPaneTracker, [{
      key: "startsGesture",
      value:
      /**
       * @override
       * @param {JQuery.Event} mouseEvent
       * @returns {boolean}
       */
      function startsGesture(mouseEvent) {
        var _this$$elementsUnderM = this.$elementsUnderMouse(mouseEvent),
          _this$$elementsUnderM2 = _slicedToArray(_this$$elementsUnderM, 1),
          element = _this$$elementsUnderM2[0];
        return !!(mouseEvent.type === 'mousedown' && element && element.closest('.split-pane-divider'));
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @returns {Element[]}
       */
    }, {
      key: "$elementsUnderMouse",
      value: function $elementsUnderMouse(e) {
        return this.$controller.$elementsUnderMouse(e);
      }

      /**
       * @override
       * @param {JQuery.Event} mouseEvent
       */
    }, {
      key: "mousedown",
      value: function mousedown(mouseEvent) {
        var _this$$elementsUnderM3 = this.$elementsUnderMouse(mouseEvent),
          _this$$elementsUnderM4 = _slicedToArray(_this$$elementsUnderM3, 1),
          element = _this$$elementsUnderM4[0];
        if (element) {
          this.$retriggerOn(element, mouseEvent);
        }
      }

      /**
       * @override
       * @param {JQuery.Event} mouseEvent
       */
    }, {
      key: "mousemove",
      value: function mousemove(mouseEvent) {
        var _this$$elementsUnderM5 = this.$elementsUnderMouse(mouseEvent),
          _this$$elementsUnderM6 = _slicedToArray(_this$$elementsUnderM5, 1),
          element = _this$$elementsUnderM6[0];
        if (element) {
          this.$retriggerOn(element, mouseEvent);
        }
      }

      /**
       * @override
       * @param {JQuery.Event} mouseEvent
       */
    }, {
      key: "mouseup",
      value: function mouseup(mouseEvent) {
        var _this$$elementsUnderM7 = this.$elementsUnderMouse(mouseEvent),
          _this$$elementsUnderM8 = _slicedToArray(_this$$elementsUnderM7, 1),
          element = _this$$elementsUnderM8[0];
        if (element) {
          this.$retriggerOn(element, mouseEvent);
          return UpdateSplitPaneCommand.update(this.$splitPane, this.$getUxBuilder());
        }
      }

      /**
       * @private
       * @param {Element} element
       * @param {JQuery.Event} mouseEvent
       */
    }, {
      key: "$retriggerOn",
      value: function $retriggerOn(element, mouseEvent) {
        var target = mouseEvent.target,
          type = mouseEvent.type,
          pageX = mouseEvent.pageX,
          pageY = mouseEvent.pageY;
        if (type === 'mousemove') {
          // magic to avoid infinite retrigger loops
          $(target).one(type, function () {
            return false;
          });
        }
        $(element).trigger($.Event(type, {
          pageX: pageX,
          pageY: pageY
        }));
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/UxBuilder}
       */
    }, {
      key: "$getUxBuilder",
      value: function $getUxBuilder() {
        return this.$controller.$getUxBuilder();
      }
    }], [{
      key: "supports",
      value: function supports(widget) {
        return widget instanceof SplitPane;
      }
    }]);
  }(Tracker);
  /**
   * Handles the updating of the slider position in a SplitPane
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/events/SplitPaneTracker
   */
  var UpdateSplitPaneCommand = /*#__PURE__*/function (_Command) {
    /**
     * @param {module:nmodule/bajaui/rc/ux/SplitPane} splitPane the splitPane currently in focus
     * @param {module:nmodule/uxBuilder/rc/ux/UxBuilder} uxBuilder the current UxBuilder
     * @param {Object} params
     */
    function UpdateSplitPaneCommand(splitPane, uxBuilder) {
      var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      _classCallCheck(this, UpdateSplitPaneCommand);
      var _UpdateSplitPaneComma = UpdateSplitPaneCommand.$getUpdateValues(splitPane),
        splitPaneModel = _UpdateSplitPaneComma.splitPaneModel,
        newDividerPosition = _UpdateSplitPaneComma.newDividerPosition,
        parentNode = _UpdateSplitPaneComma.parentNode;
      var undoText = uxBuilderLex.get('commands.updateSplitPaneCommand.undoText');
      var redoText = uxBuilderLex.get('commands.updateSplitPaneCommand.redoText');
      return _callSuper(this, UpdateSplitPaneCommand, [Object.assign({
        func: function func() {
          return cloneWithChanges([splitPaneModel], {
            widgetChanges: {
              dividerPosition: newDividerPosition
            }
          }).then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 1),
              newSplitPaneModel = _ref2[0];
            var undoOp = {
              parentNode: parentNode,
              model: newSplitPaneModel
            };
            // todo: treeModified call should not be needed - we already call treeModified for affected nodes but don't wait for it
            return ModifyUxModelCommand.modify([undoOp], {
              undoText: undoText,
              redoText: redoText,
              onNewNodes: function onNewNodes() {
                return parentNode.treeModified();
              }
            });
          });
        }
      }, params)]);
    }

    /**
     * @param {module:nmodule/bajaui/rc/ux/SplitPane} splitPane the splitPane currently in focus
     * @param {module:nmodule/uxBuilder/rc/ux/UxBuilder} uxBuilder the current UxBuilder
     * @param {Object} [params]
     * @returns {Promise}
     */
    _inherits(UpdateSplitPaneCommand, _Command);
    return _createClass(UpdateSplitPaneCommand, null, [{
      key: "update",
      value: function update(splitPane, uxBuilder, params) {
        if (uxBuilder.isReadonly()) {
          var _UpdateSplitPaneComma2 = UpdateSplitPaneCommand.$getUpdateValues(splitPane),
            splitPaneModel = _UpdateSplitPaneComma2.splitPaneModel,
            splitPaneName = _UpdateSplitPaneComma2.splitPaneName,
            newDividerPosition = _UpdateSplitPaneComma2.newDividerPosition,
            parentNode = _UpdateSplitPaneComma2.parentNode;
          return cloneWithChanges([splitPaneModel], {
            widgetChanges: {
              dividerPosition: newDividerPosition
            }
          }).then(function (_ref3) {
            var _ref4 = _slicedToArray(_ref3, 1),
              newSplitPaneModel = _ref4[0];
            return parentNode.replaceKid(splitPaneName, newSplitPaneModel);
          });
        } else {
          return new UpdateSplitPaneCommand(splitPane, uxBuilder, params).invoke();
        }
      }

      /**
       * Returns the values necessary to update the SplitPane
       * @private
       * @param {module:nmodule/bajaui/rc/ux/SplitPane} splitPane
       * @returns {{splitPaneModel: module:bajaux/model/UxModel, splitPaneName: String, newDividerPosition: number, parentNode: module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode}}
       */
    }, {
      key: "$getUpdateValues",
      value: function $getUpdateValues(splitPane) {
        var splitPaneNode = getOriginatingNode(splitPane);
        var splitPaneModel = splitPaneNode.value();
        var splitPaneName = splitPaneModel.getName();
        // Normally you would get the value from the properties, but every so often the property is not
        // updated with the new value.  This gets me the value that the property should be set to, which
        // should be more accurate
        var newDividerPosition = splitPane.$getScreenDividerRatio() * 100;
        var parentNode = splitPaneNode.getParent();
        return {
          splitPaneModel: splitPaneModel,
          splitPaneName: splitPaneName,
          newDividerPosition: newDividerPosition,
          parentNode: parentNode
        };
      }
    }]);
  }(Command);
  SplitPaneTracker.UpdateSplitPaneCommand = UpdateSplitPaneCommand;
  return SplitPaneTracker;
});
