function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/trackers/events/ScrollPaneTracker
 */
define(['baja!', 'log!nmodule.uxBuilder.rc.ux.wysiwyg.trackers.events.ScrollPaneTracker', 'jquery', 'nmodule/bajaui/rc/ux/ScrollPane', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/wb/profile/selectionModeSettings'], function (baja, log, $, ScrollPane, uxBuilderUtils, Tracker, htmlUtils, selectionModeSettings) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var getCssTransformScaling = htmlUtils.getCssTransformScaling;
  var getSelectionModeFromEvent = selectionModeSettings.getSelectionModeFromEvent;
  var getOriginatingNode = uxBuilderUtils.getOriginatingNode;

  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/events/ScrollPaneTracker
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker
   */
  return /*#__PURE__*/function (_Tracker) {
    function ScrollPaneTracker(controller, scrollPane) {
      var _this;
      _classCallCheck(this, ScrollPaneTracker);
      _this = _callSuper(this, ScrollPaneTracker, [controller]);
      _this.$scrollPane = scrollPane;
      _this.$writeScrollPositionToNode = baja.throttle(function () {
        var scrollPaneNode = getOriginatingNode(_this.$scrollPane);
        _this.$applyScrollPaneChanges(scrollPaneNode, {
          scrollTop: _this.$getScrollTop(),
          scrollLeft: _this.$getScrollLeft()
        })["catch"](logSevere);
      }, {
        interval: 100,
        drop: false
      });
      return _this;
    }

    /**
     * @param {module:bajaux/Widget} widget
     * @returns {boolean} true if it's a ScrollPane
     */
    _inherits(ScrollPaneTracker, _Tracker);
    return _createClass(ScrollPaneTracker, [{
      key: "startsGesture",
      value:
      /**
       * @override
       * @param {JQuery.Event} mouseEvent
       * @returns {boolean}
       */
      function startsGesture(mouseEvent) {
        var scrollBar = this.$getScrollBar(mouseEvent);

        // if mousedown is on a scrollbar, we'll start the scrolling gesture
        return mouseEvent.type === 'mousedown' && (scrollBar === 'horizontal' || scrollBar === 'vertical');
      }

      /**
       * After mousing down on a scrollbar, we'll start listening for `scroll` events and writing
       * the `scrollTop` and `scrollLeft` to the ScrollPane instance itself, so they can persist on
       * rerender. Otherwise, the scrollbar scrolls back up to the top on rerender.
       * @override
       * @param {JQuery.Event} mouseEvent
       */
    }, {
      key: "mousedown",
      value: function mousedown(mouseEvent) {
        var _this2 = this;
        this.$mousedownEvent = mouseEvent;
        var scrollPane = this.$scrollPane;
        this.$initialScrollBar = this.$getScrollBar(mouseEvent);
        var scrollPaneJq = scrollPane.jq();
        var scrollEventHandler = this.$scrollEventHandler = function (event) {
          _this2.$writeScrollPositionToNode();
          _this2.$getController().paintSelected();
        };
        scrollPaneJq.on('scroll', scrollEventHandler);
      }

      /**
       * On mousemove (dragging the mouse after clicking the scrollbar), calculate
       * `scrollTop`/`scrollLeft` and manually apply to the element. In a future story, we'll look at
       * letting the events propagate through so the browser can handle them natively.
       *
       * @override
       * @param {JQuery.Event} mouseEvent
       */
    }, {
      key: "mousemove",
      value: function mousemove(mouseEvent) {
        var scrollPane = this.$scrollPane;
        var scrollBar = this.$initialScrollBar;
        var scrollPaneJq = scrollPane.jq();
        var scaling = this.$getScaling();
        // This value is a pointer offset that attempts to define the position of the mouse cursor
        // in the scroll bars.  Mainly to make it easier to deal with scrolling at extreme top and left
        // of the view area.
        var pointerOffset = 20;
        switch (scrollBar) {
          case 'vertical':
            var eventY = mouseEvent.pageY;
            return this.$setScrollTop(this.$computeScrollTop(eventY, pointerOffset, scrollPaneJq, scaling.y));
          case 'horizontal':
            var eventX = mouseEvent.pageX;
            return this.$setScrollLeft(this.$computeScrollLeft(eventX, pointerOffset, scrollPaneJq, scaling.x));
        }
      }

      /**
       * @private
       * @returns {Element}
       */
    }, {
      key: "$el",
      value: function $el() {
        return this.$scrollPane.jq()[0];
      }

      /**
       * @private
       * @returns {number}
       */
    }, {
      key: "$getScrollTop",
      value: function $getScrollTop() {
        return this.$el().scrollTop;
      }

      /**
       * @private
       * @returns {number}
       */
    }, {
      key: "$getScrollLeft",
      value: function $getScrollLeft() {
        return this.$el().scrollLeft;
      }

      /**
       * @private
       * @param {number} scrollTop
       */
    }, {
      key: "$setScrollTop",
      value: function $setScrollTop(scrollTop) {
        this.$el().scrollTop = scrollTop;
      }

      /**
       * @private
       * @param {number} scrollLeft
       */
    }, {
      key: "$setScrollLeft",
      value: function $setScrollLeft(scrollLeft) {
        this.$el().scrollLeft = scrollLeft;
      }

      /**
       * Notify the UxBuilder that the tree node has changed. This will trigger a rerender, but it's
       * ok since we're not scrolling anymore. It's necessary to get the properties to write to the
       * actual ScrollPane instance so it will respect them on the next layout.
       *
       * @override
       * @param {JQuery.Event} mouseEvent
       * @returns {Promise|*}
       */
    }, {
      key: "mouseup",
      value: function mouseup(mouseEvent) {
        var scrollPane = this.$scrollPane;
        var scrollPaneJq = scrollPane.jq();
        delete this.$scrollPaneMouseMove;
        var scrollPaneNode = getOriginatingNode(scrollPane);
        scrollPaneNode.treeModified({
          silent: true
        });

        // and stop listening for scroll events.
        scrollPaneJq.off('scroll', this.$scrollEventHandler);
        var _this$$mousedownEvent = this.$mousedownEvent,
          pageX = _this$$mousedownEvent.pageX,
          pageY = _this$$mousedownEvent.pageY;
        if (mouseEvent.pageX === pageX && mouseEvent.pageY === pageY) {
          var selectionMode = getSelectionModeFromEvent(mouseEvent);
          return scrollPaneNode.requestSelection(selectionMode === 'toggle' ? selectionMode : 'exclusive');
        }
      }

      /**
       * @override
       * @param {JQuery.Event} mouseEvent
       * @returns {Promise|*}
       */
    }, {
      key: "wheel",
      value: function wheel(mouseEvent) {
        var _mouseEvent$originalE = mouseEvent.originalEvent,
          deltaX = _mouseEvent$originalE.deltaX,
          deltaY = _mouseEvent$originalE.deltaY;
        this.$setScrollTop(this.$getScrollTop() + deltaY);
        this.$setScrollLeft(this.$getScrollLeft() + deltaX);
        this.$getController().paintSelected();
        this.$writeScrollPositionToNode();
      }

      /**
       * Determines if the mouse event took place on a scroll bar and returns which one
       * @private
       * @param {JQuery.Event} mouseEvent
       * @returns {string} A string that denotes which scroll bar the mouse event occurred on:
       * both, neither, horizontal, vertical
       */
    }, {
      key: "$getScrollBar",
      value: function $getScrollBar(mouseEvent) {
        if (!mouseEvent) {
          return undefined;
        }
        var scrollPane = this.$scrollPane;
        // the element for the ScrollPane
        var scrollPaneEl = scrollPane.jq()[0];
        var scaling = this.$getScaling();
        var boundRec = scrollPaneEl.getBoundingClientRect();
        var size = this.$getElementSize(scrollPaneEl);
        var x = (mouseEvent.pageX - boundRec.left) / scaling.x;
        var y = (mouseEvent.pageY - boundRec.top) / scaling.y;
        var onHorizontal = y > size.height;
        var onVertical = x > size.width;
        if (onHorizontal === onVertical) {
          return onHorizontal ? 'both' : 'neither';
        } else {
          return onHorizontal ? 'horizontal' : 'vertical';
        }
      }

      /**
       * Returns the current scaling values
       * @private
       * @returns {{x: number, y: number}}
       */
    }, {
      key: "$getScaling",
      value: function $getScaling() {
        var pxWidget = this.$getPxWidget();
        var offsetParent = pxWidget.$getRootWidget().jq();
        return getCssTransformScaling(offsetParent);
      }

      /**
       * Returns the width and height of the supplied element
       * @private
       * @param {Element} element the element you need the size for
       * @returns {{width: number, height: number}}
       */
    }, {
      key: "$getElementSize",
      value: function $getElementSize(element) {
        return {
          height: element.clientHeight,
          width: element.clientWidth
        };
      }

      /**
       * Computes the new scrollTop position of a ScrollPane
       * @private
       * @param {number} eventY the pageY position of the mouse
       * @param {number} pointerOffset an offset value that controls approximately where the mouse pointer appears on the scroll bar
       * @param {JQuery} scrollPaneJq the ScrollPane JQuery information
       * @param {number} scalingY the Y scaling value for PxEditor
       * @returns {number}
       */
    }, {
      key: "$computeScrollTop",
      value: function $computeScrollTop(eventY, pointerOffset, scrollPaneJq, scalingY) {
        var spBoundRec = scrollPaneJq[0].getBoundingClientRect();
        var contentBoundRec = scrollPaneJq.find('.-t-ScrollPane-content')[0].getBoundingClientRect();
        var heightRatio = spBoundRec.height / contentBoundRec.height;
        return (eventY - pointerOffset - spBoundRec.top) / heightRatio / scalingY;
      }

      /**
       * Computes the new scrollLeft position of the ScrollPane
       * @private
       * @param {number} eventX the pageX position of the mouse
       * @param {number} pointerOffset an offset value that controls approximately where the mouse pointer appears on the scroll bar
       * @param {JQuery} scrollPaneJq the ScrollPane JQuery information
       * @param {number} scalingX the Y scaling value for PxEditor
       * @returns {number}
       */
    }, {
      key: "$computeScrollLeft",
      value: function $computeScrollLeft(eventX, pointerOffset, scrollPaneJq, scalingX) {
        var spBoundRec = scrollPaneJq[0].getBoundingClientRect();
        var contentBoundRec = scrollPaneJq.find('.-t-ScrollPane-content')[0].getBoundingClientRect();
        var widthRatio = spBoundRec.width / contentBoundRec.width;
        return (eventX - pointerOffset - spBoundRec.left) / widthRatio / scalingX;
      }

      /**
       * Applies the changes to the scroll pane node
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} scrollPaneNode
       * @param {object} properties properties to write to the scroll pane
       * @returns {Promise}
       */
    }, {
      key: "$applyScrollPaneChanges",
      value: function $applyScrollPaneChanges(scrollPaneNode, properties) {
        var scrollPaneModel = scrollPaneNode.value();
        var scrollPaneName = scrollPaneModel.getName();
        var parentNode = scrollPaneNode.getParent();
        return scrollPaneModel.clone({
          properties: properties
        })
        // write changes silently. otherwise, the modify event causes a rerender on every scroll event.
        .then(function (newScrollPaneModel) {
          return parentNode.modifyKid(scrollPaneName, newScrollPaneModel, true);
        });
      }

      /**
       * @private
       * @returns {module:nmodule/bajaui/rc/ux/PxWidget}
       */
    }, {
      key: "$getPxWidget",
      value: function $getPxWidget() {
        return this.$controller.$getPxWidget();
      }
    }], [{
      key: "supports",
      value: function supports(widget) {
        return widget instanceof ScrollPane;
      }
    }]);
  }(Tracker);
});
