function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker
 */

define(['jquery', 'Promise', 'nmodule/js/rc/tinyevents/tinyevents'], function ($, Promise, tinyevents) {
  'use strict';

  /**
   * @since Niagara 4.15
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker
   */
  return /*#__PURE__*/function () {
    function Tracker(controller) {
      _classCallCheck(this, Tracker);
      tinyevents(this);
      if (!controller) {
        throw new Error('controller required');
      }
      this.$controller = controller;
    }

    /**
     * @private
     * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController}
     */
    return _createClass(Tracker, [{
      key: "$getController",
      value: function $getController() {
        return this.$controller;
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio}
       */
    }, {
      key: "$getStudio",
      value: function $getStudio() {
        return this.$controller.$getUxBuilder().$getPxStudio();
      }

      /**
       * @param {{ pageX: number, pageY: number }} e a point relative to the document itself
       * @returns {{ x: number, y: number }} the x and y coordinates of the input, in pixels, relative
       * to the top left corner of the overlay
       */
    }, {
      key: "eventToOverlayCoords",
      value: function eventToOverlayCoords(e) {
        return this.translatePoint({
          point: {
            x: e.pageX,
            y: e.pageY
          },
          from: 'document',
          to: 'overlay'
        });
      }

      /**
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController~PointTranslation} params
       * @returns {{ x: number, y: number }}
       */
    }, {
      key: "translatePoint",
      value: function translatePoint(params) {
        return this.$controller.$translatePoint(params);
      }

      /**
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController~RectTranslation} params
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle}
       */
    }, {
      key: "translateRect",
      value: function translateRect(params) {
        return this.$controller.$translateRect(params);
      }

      /**
       * @param {module:bajaux/Widget} widget
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle} the widget's bounding box on
       * screen, relative to the overlay
       */
    }, {
      key: "toOverlayBox",
      value: function toOverlayBox(widget) {
        return this.translateRect({
          rect: widget,
          to: 'overlay'
        });
      }

      /**
       * @param {JQuery.Event} e
       * @returns {Promise|*}
       */
    }, {
      key: "mousedown",
      value: function mousedown(e) {
        return Promise.resolve();
      }

      /**
       * @param {JQuery.Event} e
       * @returns {Promise|*}
       */
    }, {
      key: "mousemove",
      value: function mousemove(e) {
        return Promise.resolve();
      }

      /**
       * @param {JQuery.Event} e
       * @returns {Promise|*}
       */
    }, {
      key: "mouseup",
      value: function mouseup(e) {
        return Promise.resolve();
      }

      /**
       * @param {JQuery.Event} e
       * @returns {Promise|*}
       */
    }, {
      key: "wheel",
      value: function wheel(e) {
        return Promise.resolve();
      }

      /**
       * return false to prevent the default behavior of the keydown event.
       * @private
       * @param {JQuery.Event} e
       * @returns {boolean|undefined|Promise}
       */
    }, {
      key: "keydown",
      value: function keydown(e) {
        return Promise.resolve();
      }
    }]);
  }();
});

/**
 * An interface for a Tracker that "intercepts" what would otherwise be a standard tracker and
 * injects behavior specific to the kind of widget you clicked on.
 *
 * @interface InterceptingTracker
 * @memberOf module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker
 */

/**
 * Check if this tracker should start a gesture from the given event. If this returns true, it means
 * we won't do the usual gesture tracking of the given event (like moving a widget in response to a
 * drag gesture) - the tracker swoops in and handles it.
 *
 * @function startsGesture
 * @param {JQuery.Event} event
 * @returns {boolean}
 * @memberOf InterceptingTracker
 */

/**
 * Return true if an instance of this tracker can support handling events that would otherwise route
 * to the given widget.
 *
 * @function supports
 * @param {module:bajaux/Widget}
 * @returns {boolean}
 * @static
 * @memberOf InterceptingTracker
 */
