function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/trackers/SelectedTracker
 */

/* eslint-env browser */

define(['log!nmodule.uxBuilder.rc.ux.wysiwyg.trackers.SelectedTracker', 'Promise', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker', 'nmodule/webEditors/rc/wb/profile/selectionModeSettings'], function (log, Promise, wysiwygUtils, Tracker, selectionModeSettings) {
  'use strict';

  var finestLoggable = log.isLoggable('FINEST');
  var logFinest = log.finest.bind(log);
  var isWobble = wysiwygUtils.isWobble;
  var getSelectionMode = selectionModeSettings.getSelectionMode,
    getSelectionModeFromEvent = selectionModeSettings.getSelectionModeFromEvent,
    TOGGLE_MODE = selectionModeSettings.TOGGLE_MODE;
  var getMultiMode = function getMultiMode(e) {
    return (e ? getSelectionModeFromEvent(e) : getSelectionMode()) === TOGGLE_MODE;
  };

  /**
   * This tracker is for when you have done a mousedown on a widget, but haven't moved the mouse.
   * If you move the mouse, it will start a MoveTracker on that widget; if you release without
   * moving, it will select that widget.
   *
   * Comparable to pxEditor~HitSelectedTracker, this tracker simply creates 
   * a MoveTracker.
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/SelectedTracker
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker
   */
  return /*#__PURE__*/function (_Tracker) {
    function SelectedTracker(controller, widget) {
      var _this;
      var overlayX = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var overlayY = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      _classCallCheck(this, SelectedTracker);
      _this = _callSuper(this, SelectedTracker, [controller]);
      _this.$selectedWidget = widget;
      var _this$translatePoint = _this.translatePoint({
          point: {
            x: overlayX,
            y: overlayY
          },
          from: 'overlay',
          to: 'document'
        }),
        x = _this$translatePoint.x,
        y = _this$translatePoint.y;
      // passing actual event would be bigger refactor than i want to make right now
      _this.$origEvent = {
        pageX: x,
        pageY: y
      };
      return _this;
    }
    _inherits(SelectedTracker, _Tracker);
    return _createClass(SelectedTracker, [{
      key: "mousemove",
      value: function mousemove(e) {
        if (isWobble(e, this.$origEvent)) {
          finestLoggable && logFinest('SelectedTracker: ignoring mouse wobble, waiting for user to drag like they mean it');
          return Promise.resolve();
        } else {
          finestLoggable && logFinest('SelectedTracker: mousemove before mouseup, starting to move widget(s)');
          var _this$eventToOverlayC = this.eventToOverlayCoords(this.$origEvent),
            overlayX = _this$eventToOverlayC.x,
            overlayY = _this$eventToOverlayC.y;
          var controller = this.$getController();
          return controller.$startMoveTracker(overlayX, overlayY, this.$selectedWidget);
        }
      }
    }, {
      key: "mouseup",
      value: function mouseup(e) {
        var controller = this.$getController();
        // TODO NCCB-68996 (Touch/longpress support)
        if (e.which !== 3) {
          finestLoggable && logFinest('SelectedTracker: mouseup without moving, selecting widget');
          return controller.$select(this.$selectedWidget, getMultiMode(e));
        }
      }
    }]);
  }(Tracker);
});
