function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/trackers/RubberBandTracker
 */

/* eslint-env browser */

define(['Promise', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/trackerUtil'], function (Promise, uxBuilderUtils, Tracker, trackerUtil) {
  'use strict';

  var getModel = uxBuilderUtils.getModel,
    getOriginatingNode = uxBuilderUtils.getOriginatingNode,
    isUxModelLocked = uxBuilderUtils.isUxModelLocked;

  /**
   * This tracker is for when you've mousedowned on a CanvasPane and are now dragging around to
   * lasso widgets.
   */
  return /*#__PURE__*/function (_Tracker) {
    function RubberBandTracker(controller, overlayX, overlayY, canvasPane) {
      var _this;
      _classCallCheck(this, RubberBandTracker);
      _this = _callSuper(this, RubberBandTracker, [controller]);
      _this.$origX = overlayX;
      _this.$origY = overlayY;
      _this.$rubberBand = {
        x: overlayX,
        y: overlayY,
        w: 0,
        h: 0
      };
      _this.$canvasPane = canvasPane;
      return _this;
    }
    _inherits(RubberBandTracker, _Tracker);
    return _createClass(RubberBandTracker, [{
      key: "mousemove",
      value: function mousemove(e) {
        var controller = this.$getController();
        var _this$eventToOverlayC = this.eventToOverlayCoords(e),
          x = _this$eventToOverlayC.x,
          y = _this$eventToOverlayC.y;
        if (!this.$dragged) {
          if (controller.$isActiveDrag(e)) {
            this.$dragged = true;
            return this.track(x, y);
          }
        } else {
          return this.track(x, y);
        }
      }
    }, {
      key: "mouseup",
      value: function mouseup(e) {
        var controller = this.$getController();
        if (this.$dragged) {
          this.$dragged = false;
          return this.trackEnd();
        } else {
          return controller.$select(this.$canvasPane, false);
        }
      }
    }, {
      key: "keydown",
      value: function keydown(e) {
        var controller = this.$getController();
        return trackerUtil.keydownHandler(e, controller);
      }
    }, {
      key: "track",
      value: function track(overlayX, overlayY) {
        var origX = this.$origX,
          origY = this.$origY;
        var deltaX = overlayX - origX,
          deltaY = overlayY - origY;
        this.$rubberBand = {
          x: deltaX > 0 ? origX : origX + deltaX,
          y: deltaY > 0 ? origY : origY + deltaY,
          w: Math.abs(deltaX),
          h: Math.abs(deltaY)
        };
        this.emit('update');
      }
    }, {
      key: "trackEnd",
      value: function trackEnd() {
        var _this2 = this;
        return this.$setSelectedWidgets().then(function () {
          _this2.$rubberBand = null;
          _this2.emit('update');
        });
      }
    }, {
      key: "getRubberBand",
      value: function getRubberBand() {
        return this.$rubberBand;
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$setSelectedWidgets",
      value: function $setSelectedWidgets() {
        var _this3 = this;
        function isInsideRubberBand(widgetBounds, rubberband) {
          var x1 = rubberband.x,
            y1 = rubberband.y,
            w1 = rubberband.w,
            h1 = rubberband.h;
          var x2 = widgetBounds.x,
            y2 = widgetBounds.y,
            w2 = widgetBounds.w,
            h2 = widgetBounds.h;
          return x2 >= x1 && y2 >= y1 && x2 + w2 <= x1 + w1 && y2 + h2 <= y1 + h1;
        }
        var pxStudio = this.$getStudio();
        var controller = this.$getController();
        var pxWidget = pxStudio.$getPxWidget();
        var rootWidget = pxWidget.$getRootWidget(),
          rootModel = getModel(rootWidget);
        var widgetsWithin = [];
        return Promise["try"](function () {
          return rootModel && rootModel.visit(function (model) {
            var node = getOriginatingNode(model);
            var lastBuiltWidget = node.getLastBuiltWidget();
            if (!lastBuiltWidget || isUxModelLocked(getModel(lastBuiltWidget), pxStudio.$getPxLayers())) {
              return;
            }
            if (isInsideRubberBand(_this3.toOverlayBox(lastBuiltWidget), _this3.$rubberBand)) {
              widgetsWithin.push(lastBuiltWidget);
            }
          });
        }).then(function () {
          return controller.setSelectedWidgets(widgetsWithin);
        });
      }
    }]);
  }(Tracker);
});
