function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/trackers/RectangularHandleTracker
 */
define(['log!nmodule.uxBuilder.rc.ux.wysiwyg.trackers.RectangularHandleTracker', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/MoveTracker'], function (log, wysiwygUtils, MoveTracker) {
  'use strict';

  var finestLoggable = log.isLoggable('FINEST');
  var logFinest = log.finest.bind(log);
  var applySnapToPoint = wysiwygUtils.applySnapToPoint;

  /**
   * Applies aspect ratio math to the width and height.
   *
   * @param {number} newW
   * @param {number} newH
   * @param {number} origW
   * @param {number} origH
   * @param {boolean} preserveAspectRatio
   * @returns {{newW: number, newH: number}}
   */
  function applyAspectToCorner(newW, newH, origW, origH, preserveAspectRatio) {
    if (preserveAspectRatio && origH !== 0 && newH !== 0) {
      var oldAspectRatio = origW / origH;
      var newAspectRatio = newW / newH;
      if (oldAspectRatio > newAspectRatio) {
        if (origW !== 0) {
          newH = origH * (newW / origW);
        }
      } else if (oldAspectRatio < newAspectRatio) {
        newW = origW * (newH / origH);
      }
    }
    return {
      newW: newW,
      newH: newH
    };
  }

  /**
   * This tracker is for when you've mousedowned on a green square, and are moving your mouse around
   * to resize the selected widgets.
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/RectangularHandleTracker
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/MoveTracker
   */
  return /*#__PURE__*/function (_MoveTracker) {
    /**
     * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Artisan} artisan 
     * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController} controller
     * @param {module:nmodule/bajaui/rc/ux/CanvasPane} canvasPane the canvas pane we're moving
     * things around on
     * @param {Array.<module:bajaux/Widget>} widgets 
     * @param {Number} overlayX 
     * @param {Number} overlayY 
     * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Handle} handle 
     * @param {boolean} preserveAspectRatio
     */
    function RectangularHandleTracker(artisan, controller, canvasPane, widgets, overlayX, overlayY, handle, preserveAspectRatio) {
      var _this;
      _classCallCheck(this, RectangularHandleTracker);
      _this = _callSuper(this, RectangularHandleTracker, [controller, canvasPane, widgets, overlayX, overlayY]);
      _this.$handle = handle;
      _this.$widgets = widgets || [];
      _this.$origX = overlayX;
      _this.$origY = overlayY;
      _this.$preserveAspectRatio = !!preserveAspectRatio;
      _this.$artisan = artisan;

      // this stops the $doMove function from applying the snap to the whole layout
      _this.$snapAlreadyApplied = true;
      return _this;
    }
    _inherits(RectangularHandleTracker, _MoveTracker);
    return _createClass(RectangularHandleTracker, [{
      key: "track",
      value: function track(overlayX, overlayY, shiftKeyDown) {
        var _this2 = this;
        var handleName = this.$handle.getName();
        var widgets = this.$widgets;
        var deltaX = overlayX - this.$origX;
        var deltaY = overlayY - this.$origY;
        var newRubberBand;
        this.$rubberBands = [];
        widgets.forEach(function (widget) {
          var box = _this2.toOverlayBox(widget);
          switch (handleName) {
            case 'e':
              {
                newRubberBand = _this2.$movingEastHandle(box, shiftKeyDown, deltaX, _this2.$preserveAspectRatio);
                break;
              }
            case 'w':
              {
                newRubberBand = _this2.$movingWestHandle(box, shiftKeyDown, deltaX, _this2.$preserveAspectRatio);
                break;
              }
            case 's':
              {
                newRubberBand = _this2.$movingSouthHandle(box, shiftKeyDown, deltaY, _this2.$preserveAspectRatio);
                break;
              }
            case 'n':
              {
                newRubberBand = _this2.$movingNorthHandle(box, shiftKeyDown, deltaY, _this2.$preserveAspectRatio);
                break;
              }
            case 'nw':
              {
                newRubberBand = _this2.$movingNorthWestHandle(box, shiftKeyDown, deltaX, deltaY, _this2.$preserveAspectRatio);
                break;
              }
            case 'ne':
              {
                newRubberBand = _this2.$movingNorthEastHandle(box, shiftKeyDown, deltaX, deltaY, _this2.$preserveAspectRatio);
                break;
              }
            case 'sw':
              {
                newRubberBand = _this2.$movingSouthWestHandle(box, shiftKeyDown, deltaX, deltaY, _this2.$preserveAspectRatio);
                break;
              }
            case 'se':
              {
                newRubberBand = _this2.$movingSouthEastHandle(box, shiftKeyDown, deltaX, deltaY, _this2.$preserveAspectRatio);
                break;
              }
          }
          _this2.$rubberBands.push(newRubberBand);
        });
        finestLoggable && logFinest('RectangularHandleTracker: tracked resize, will apply on mouseup');
        this.emit('update');
      }

      /**
       * gets the use snap flag and snap size
       * @private
       * @param {Boolean} shiftKeyDown
       * @returns {{snapSize: *, useSnap: (*|boolean)}}
       */
    }, {
      key: "$getSnapInfo",
      value: function $getSnapInfo(shiftKeyDown) {
        var uxBuilder = this.$controller.$getUxBuilder();
        var useSnap = uxBuilder.properties().getValue('useSnap') && !shiftKeyDown;
        var snapSize = uxBuilder.properties().getValue('snapSize');
        return {
          useSnap: useSnap,
          snapSize: snapSize
        };
      }

      /**
       * Applies the movement of the east handle to the rubberband
       * @private
       * @param {module:nmodule/bajaui/rc/baja/Layout~Rectangle} box
       * @param {boolean} shiftKeyDown
       * @param {number} deltaX
       * @param {boolean} preserveAspectRatio
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle}
       */
    }, {
      key: "$movingEastHandle",
      value: function $movingEastHandle(box, shiftKeyDown, deltaX, preserveAspectRatio) {
        var _this$$getSnapInfo = this.$getSnapInfo(shiftKeyDown),
          useSnap = _this$$getSnapInfo.useSnap,
          snapSize = _this$$getSnapInfo.snapSize;
        var xIncreasing = deltaX > 0;
        var newX = box.x;
        var newY = box.y;
        var newW = box.w;
        var newH = box.h;
        if (useSnap && Math.abs(deltaX) < snapSize / 2) {
          useSnap = false;
          deltaX = 0;
        }
        newW = newW + deltaX;
        var wrkLeftX = newX;
        var wrkRightX = newX + newW;
        var leftX = Math.min(wrkLeftX, wrkRightX);
        var rightX = Math.max(wrkLeftX, wrkRightX);
        var flippedEW = leftX === wrkRightX || rightX === wrkLeftX;
        var point0 = {
          x: leftX,
          y: newY
        };
        var point1 = {
          x: rightX,
          y: newY + newH
        };
        if (useSnap) {
          var _this$$applySnapToTra = this.$applySnapToTrack(point0, point1, snapSize, xIncreasing, false),
            wrkPoint0 = _this$$applySnapToTra.wrkPoint0,
            wrkPoint1 = _this$$applySnapToTra.wrkPoint1;
          if (wrkPoint0.x === wrkPoint1.x) {
            wrkPoint1.x = leftX;
          }
          if (!flippedEW) {
            point1.x = wrkPoint1.x;
          } else {
            point0.x = wrkPoint0.x;
          }
          var width = point1.x - point0.x;
          if (width < 0) {
            width = width * -1;
            point0.x = point0.x - width;
          }
        }
        newX = point0.x;
        newY = point0.y;
        newW = point1.x - newX;
        if (preserveAspectRatio) {
          newH = box.w !== 0 ? box.h * (newW / box.w) : box.h;
        }
        return {
          x: newX,
          y: newY,
          w: newW,
          h: newH
        };
      }

      /**
       * Applies the movement of the west handle to the rubberband
       * @private
       * @param {module:nmodule/bajaui/rc/baja/Layout~Rectangle} box
       * @param {boolean} shiftKeyDown
       * @param {number} deltaX
       * @param {boolean} preserveAspectRatio
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle}
       */
    }, {
      key: "$movingWestHandle",
      value: function $movingWestHandle(box, shiftKeyDown, deltaX, preserveAspectRatio) {
        var _this$$getSnapInfo2 = this.$getSnapInfo(shiftKeyDown),
          useSnap = _this$$getSnapInfo2.useSnap,
          snapSize = _this$$getSnapInfo2.snapSize;
        var xIncreasing = deltaX > 0;
        var newX;
        var newY = box.y;
        var newW;
        var newH = box.h;
        if (useSnap && Math.abs(deltaX) < snapSize / 2) {
          useSnap = false;
          deltaX = 0;
        }
        newW = box.w - deltaX;
        newX = box.x + deltaX;
        var wrkLeftX = newX;
        var wrkRightX = newX + newW;
        var leftX = Math.min(wrkLeftX, wrkRightX);
        var rightX = Math.max(wrkLeftX, wrkRightX);
        var flippedEW = leftX === wrkRightX || rightX === wrkLeftX;
        var point0 = {
          x: leftX,
          y: newY
        };
        var point1 = {
          x: rightX,
          y: newY + newH
        };
        if (useSnap) {
          var _this$$applySnapToTra2 = this.$applySnapToTrack(point0, point1, snapSize, xIncreasing, false),
            wrkPoint0 = _this$$applySnapToTra2.wrkPoint0,
            wrkPoint1 = _this$$applySnapToTra2.wrkPoint1;
          if (!flippedEW) {
            point0.x = wrkPoint0.x;
          } else {
            point1.x = wrkPoint1.x;
          }
          var width = point1.x - point0.x;
          if (width < 0) {
            width = width * -1;
            point0.x = point0.x - width;
          }
        }
        newX = point0.x;
        newY = point0.y;
        newW = point1.x - newX;
        if (preserveAspectRatio) {
          newH = box.w !== 0 ? box.h * (newW / box.w) : box.h;
        }
        return {
          x: newX,
          y: newY,
          w: newW,
          h: newH
        };
      }

      /**
       * Applies the movement of the north handle to the rubberband
       * @private
       * @param {module:nmodule/bajaui/rc/baja/Layout~Rectangle} box
       * @param {boolean} shiftKeyDown
       * @param {number} deltaY
       * @param {boolean} preserveAspectRatio
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle}
       */
    }, {
      key: "$movingNorthHandle",
      value: function $movingNorthHandle(box, shiftKeyDown, deltaY, preserveAspectRatio) {
        var _this$$getSnapInfo3 = this.$getSnapInfo(shiftKeyDown),
          useSnap = _this$$getSnapInfo3.useSnap,
          snapSize = _this$$getSnapInfo3.snapSize;
        var yIncreasing = deltaY > 0;
        var newX = box.x;
        var newY;
        var newW = box.w;
        var newH;
        if (useSnap && Math.abs(deltaY) < snapSize / 2) {
          useSnap = false;
          deltaY = 0;
        }
        newH = box.h - deltaY;
        newY = box.y + deltaY;
        var wrkTopY = newY;
        var wrkBottomY = newY + newH;
        var topY = Math.min(wrkTopY, wrkBottomY);
        var bottomY = Math.max(wrkTopY, wrkBottomY);
        var flippedNS = topY === wrkBottomY || bottomY === wrkTopY;
        var point0 = {
          x: newX,
          y: topY
        };
        var point1 = {
          x: newX + newW,
          y: bottomY
        };
        if (useSnap) {
          var _this$$applySnapToTra3 = this.$applySnapToTrack(point0, point1, snapSize, false, yIncreasing),
            wrkPoint0 = _this$$applySnapToTra3.wrkPoint0,
            wrkPoint1 = _this$$applySnapToTra3.wrkPoint1;
          if (!flippedNS) {
            point0.y = wrkPoint0.y;
          } else {
            point1.y = wrkPoint1.y;
          }
          var height = point1.y - point0.y;
          if (height < 0) {
            height = height * -1;
            point0.y = point0.y - height;
          }
        }
        newX = point0.x;
        newY = point0.y;
        newH = point1.y - newY;
        if (preserveAspectRatio) {
          newW = box.h !== 0 ? box.w * (newH / box.h) : box.w;
        }
        return {
          x: newX,
          y: newY,
          w: newW,
          h: newH
        };
      }

      /**
       * Applies the movement of the south handle to the rubberband
       * @private
       * @param {module:nmodule/bajaui/rc/baja/Layout~Rectangle} box
       * @param {boolean} shiftKeyDown
       * @param {number} deltaY
       * @param {boolean} preserveAspectRatio
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle}
       */
    }, {
      key: "$movingSouthHandle",
      value: function $movingSouthHandle(box, shiftKeyDown, deltaY, preserveAspectRatio) {
        var _this$$getSnapInfo4 = this.$getSnapInfo(shiftKeyDown),
          useSnap = _this$$getSnapInfo4.useSnap,
          snapSize = _this$$getSnapInfo4.snapSize;
        var yIncreasing = deltaY > 0;
        var newX = box.x;
        var newY = box.y;
        var newW = box.w;
        var newH;
        if (useSnap && Math.abs(deltaY) < snapSize / 2) {
          useSnap = false;
          deltaY = 0;
        }
        newH = box.h + deltaY;
        var wrkTopY = newY;
        var wrkBottomY = newY + newH;
        var topY = Math.min(wrkTopY, wrkBottomY);
        var bottomY = Math.max(wrkTopY, wrkBottomY);
        var flippedNS = topY === wrkBottomY || bottomY === wrkTopY;
        var point0 = {
          x: newX,
          y: topY
        };
        var point1 = {
          x: newX + newW,
          y: bottomY
        };
        if (useSnap) {
          var _this$$applySnapToTra4 = this.$applySnapToTrack(point0, point1, snapSize, false, yIncreasing),
            wrkPoint0 = _this$$applySnapToTra4.wrkPoint0,
            wrkPoint1 = _this$$applySnapToTra4.wrkPoint1;
          if (wrkPoint0.y === wrkPoint1.y) {
            wrkPoint1.y = topY;
          }
          if (!flippedNS) {
            point1.y = wrkPoint1.y;
          } else {
            point0.y = wrkPoint0.y;
          }
          var height = point1.y - point0.y;
          if (height < 0) {
            height = height * -1;
            point0.y = point0.y - height;
          }
        }
        newX = point0.x;
        newY = point0.y;
        newH = point1.y - newY;
        if (preserveAspectRatio) {
          newW = box.h !== 0 ? box.w * (newH / box.h) : box.w;
        }
        return {
          x: newX,
          y: newY,
          w: newW,
          h: newH
        };
      }

      /**
       * Applies the movement of the south-east handle to the rubberband
       * @private
       * @param {module:nmodule/bajaui/rc/baja/Layout~Rectangle} box
       * @param {boolean} shiftKeyDown
       * @param {number} deltaX
       * @param {number} deltaY
       * @param {boolean} preserveAspectRatio
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle}
       */
    }, {
      key: "$movingSouthEastHandle",
      value: function $movingSouthEastHandle(box, shiftKeyDown, deltaX, deltaY, preserveAspectRatio) {
        var _this$$getSnapInfo5 = this.$getSnapInfo(shiftKeyDown),
          useSnap = _this$$getSnapInfo5.useSnap,
          snapSize = _this$$getSnapInfo5.snapSize;
        var xIncreasing = deltaX > 0;
        var yIncreasing = deltaY > 0;
        var newX = box.x;
        var newY = box.y;
        var newW = box.w;
        var newH;
        if (useSnap) {
          deltaX = Math.abs(deltaX) < snapSize / 2 ? 0 : deltaX;
          deltaY = Math.abs(deltaY) < snapSize / 2 ? 0 : deltaY;
          useSnap = !(deltaX === 0 && deltaY === 0);
        }
        newW = newW + deltaX;
        newH = box.h + deltaY;
        var wrkLeftX = newX;
        var wrkRightX = newX + newW;
        var wrkTopY = newY;
        var wrkBottomY = newY + newH;

        //adjust the height for flipped east west
        var leftX = Math.min(wrkLeftX, wrkRightX);
        var rightX = Math.max(wrkLeftX, wrkRightX);
        var flippedEW = leftX === wrkRightX || rightX === wrkLeftX;

        //adjust the height for flipped north-south
        var topY = Math.min(wrkTopY, wrkBottomY);
        var bottomY = Math.max(wrkTopY, wrkBottomY);
        var flippedNS = topY === wrkBottomY || bottomY === wrkTopY;
        var point0 = {
          x: leftX,
          y: topY
        };
        var point1 = {
          x: rightX,
          y: bottomY
        };
        if (useSnap) {
          var _this$$applySnapToTra5 = this.$applySnapToTrack(point0, point1, snapSize, xIncreasing, yIncreasing),
            wrkPoint0 = _this$$applySnapToTra5.wrkPoint0,
            wrkPoint1 = _this$$applySnapToTra5.wrkPoint1;
          if (wrkPoint0.x === wrkPoint1.x) {
            wrkPoint1.x = leftX;
          }
          if (wrkPoint0.y === wrkPoint1.y) {
            wrkPoint1.y = topY;
          }
          if (!flippedEW) {
            point1.x = wrkPoint1.x;
          } else {
            point0.x = wrkPoint0.x;
          }
          if (!flippedNS) {
            point1.y = wrkPoint1.y;
          } else {
            point0.y = wrkPoint0.y;
          }
          var width = point1.x - point0.x;
          if (width < 0) {
            width = width * -1;
            point0.x = point0.x - width;
          }
          var height = point1.y - point0.y;
          if (height < 0) {
            height = height * -1;
            point0.y = point0.y - height;
          }
        }
        newX = point0.x;
        newY = point0.y;
        newW = point1.x - newX;
        newH = point1.y - newY;
        if (newW < 0) {
          newW = newW * -1;
          newX = newX - newW;
        }
        if (newH < 0) {
          newH = newH * -1;
          newY = newY - newH;
        }
        if (preserveAspectRatio) {
          var _applyAspectToCorner = applyAspectToCorner(newW, newH, box.w, box.h, preserveAspectRatio),
            widthWithAspectRatio = _applyAspectToCorner.newW,
            heightWithAspectRatio = _applyAspectToCorner.newH;
          newW = widthWithAspectRatio;
          newH = heightWithAspectRatio;
          if (newY < box.y || newX < box.x) {
            newY = box.y - newH;
            newX = box.x - newW;
          }
        }
        return {
          x: newX,
          y: newY,
          w: newW,
          h: newH
        };
      }

      /**
       * Applies the movement of the south West handle to the rubberband
       * @private
       * @param {module:nmodule/bajaui/rc/baja/Layout~Rectangle} box
       * @param {boolean} shiftKeyDown
       * @param {number} deltaX
       * @param {number} deltaY
       * @param {boolean} preserveAspectRatio
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle}
       */
    }, {
      key: "$movingSouthWestHandle",
      value: function $movingSouthWestHandle(box, shiftKeyDown, deltaX, deltaY, preserveAspectRatio) {
        var _this$$getSnapInfo6 = this.$getSnapInfo(shiftKeyDown),
          useSnap = _this$$getSnapInfo6.useSnap,
          snapSize = _this$$getSnapInfo6.snapSize;
        var xIncreasing = deltaX > 0;
        var yIncreasing = deltaY > 0;
        var newX;
        var newY = box.y;
        var newW;
        var newH;
        if (useSnap) {
          deltaX = Math.abs(deltaX) < snapSize / 2 ? 0 : deltaX;
          deltaY = Math.abs(deltaY) < snapSize / 2 ? 0 : deltaY;
          useSnap = !(deltaX === 0 && deltaY === 0);
        }
        newW = box.w - deltaX;
        newH = box.h + deltaY;
        newX = box.x + (box.w - newW);
        var wrkLeftX = newX;
        var wrkRightX = newX + newW;
        var wrkTopY = newY;
        var wrkBottomY = newY + newH;

        //adjust the height for flipped east/west
        var leftX = Math.min(wrkLeftX, wrkRightX);
        var rightX = Math.max(wrkLeftX, wrkRightX);
        var flippedEW = leftX === wrkRightX || rightX === wrkLeftX;

        //adjust the height for flipped north/south
        var topY = Math.min(wrkTopY, wrkBottomY);
        var bottomY = Math.max(wrkTopY, wrkBottomY);
        var flippedNS = topY === wrkBottomY || bottomY === wrkTopY;
        var point0 = {
          x: leftX,
          y: topY
        };
        var point1 = {
          x: rightX,
          y: bottomY
        };
        if (useSnap) {
          var _this$$applySnapToTra6 = this.$applySnapToTrack(point0, point1, snapSize, xIncreasing, yIncreasing),
            wrkPoint0 = _this$$applySnapToTra6.wrkPoint0,
            wrkPoint1 = _this$$applySnapToTra6.wrkPoint1;
          if (wrkPoint0.y === wrkPoint1.y) {
            wrkPoint1.y = topY;
          }
          if (!flippedEW) {
            point0.x = wrkPoint0.x;
          } else {
            point1.x = wrkPoint1.x;
          }
          if (!flippedNS) {
            point1.y = wrkPoint1.y;
          } else {
            point0.y = wrkPoint0.y;
          }
          var width = point1.x - point0.x;
          if (width < 0) {
            width = width * -1;
            point0.x = point0.x - width;
          }
          var height = point1.y - point0.y;
          if (height < 0) {
            height = height * -1;
            point0.y = point0.y - height;
          }
        }
        newX = point0.x;
        newY = point0.y;
        newW = point1.x - newX;
        newH = point1.y - newY;
        if (newW < 0) {
          newW = newW * -1;
          newX = newX - newW;
        }
        if (newH < 0) {
          newH = newH * -1;
          newY = newY - newH;
        }
        if (preserveAspectRatio) {
          var _applyAspectToCorner2 = applyAspectToCorner(newW, newH, box.w, box.h, preserveAspectRatio),
            widthWithAspectRatio = _applyAspectToCorner2.newW,
            heightWithAspectRatio = _applyAspectToCorner2.newH;
          newW = widthWithAspectRatio;
          newH = heightWithAspectRatio;
          if (newY < box.y) {
            newX = box.x + box.w;
            newY = box.y - newH;
          } else {
            newX = box.x + (box.w - newW);
          }
        }
        return {
          x: newX,
          y: newY,
          w: newW,
          h: newH
        };
      }

      /**
       * Applies the movement of the north-east handle to the rubberband
       * @private
       * @param {module:nmodule/bajaui/rc/baja/Layout~Rectangle} box
       * @param {boolean} shiftKeyDown
       * @param {number} deltaX
       * @param {number} deltaY
       * @param {boolean} preserveAspectRatio
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle}
       */
    }, {
      key: "$movingNorthEastHandle",
      value: function $movingNorthEastHandle(box, shiftKeyDown, deltaX, deltaY, preserveAspectRatio) {
        var _this$$getSnapInfo7 = this.$getSnapInfo(shiftKeyDown),
          useSnap = _this$$getSnapInfo7.useSnap,
          snapSize = _this$$getSnapInfo7.snapSize;
        var xIncreasing = deltaX > 0;
        var yIncreasing = deltaY > 0;
        var newX = box.x;
        var newY;
        var newW = box.w;
        var newH;
        if (useSnap) {
          deltaX = Math.abs(deltaX) < snapSize / 2 ? 0 : deltaX;
          deltaY = Math.abs(deltaY) < snapSize / 2 ? 0 : deltaY;
          useSnap = !(deltaX === 0 && deltaY === 0);
        }
        newW = newW + deltaX;
        newH = box.h - deltaY;
        newY = box.y + (box.h - newH);
        var wrkLeftX = newX;
        var wrkRightX = newX + newW;
        var wrkTopY = newY;
        var wrkBottomY = newY + newH;

        //adjust the height for flipped east/west
        var leftX = Math.min(wrkLeftX, wrkRightX);
        var rightX = Math.max(wrkLeftX, wrkRightX);
        var flippedEW = leftX === wrkRightX || rightX === wrkLeftX;

        //adjust the height for flipped north/south
        var topY = Math.min(wrkTopY, wrkBottomY);
        var bottomY = Math.max(wrkTopY, wrkBottomY);
        var flippedNS = topY === wrkBottomY || bottomY === wrkTopY;
        var point0 = {
          x: leftX,
          y: topY
        };
        var point1 = {
          x: rightX,
          y: bottomY
        };
        if (useSnap) {
          var _this$$applySnapToTra7 = this.$applySnapToTrack(point0, point1, snapSize, xIncreasing, yIncreasing),
            wrkPoint0 = _this$$applySnapToTra7.wrkPoint0,
            wrkPoint1 = _this$$applySnapToTra7.wrkPoint1;
          if (wrkPoint0.x === wrkPoint1.x) {
            wrkPoint1.x = leftX;
          }
          if (!flippedEW) {
            point1.x = wrkPoint1.x;
          } else {
            point0.x = wrkPoint0.x;
          }
          if (!flippedNS) {
            point0.y = wrkPoint0.y;
          } else {
            point1.y = wrkPoint1.y;
          }
          var width = point1.x - point0.x;
          if (width < 0) {
            width = width * -1;
            point0.x = point0.x - width;
          }
          var height = point1.y - point0.y;
          if (height < 0) {
            height = height * -1;
            point0.y = point0.y - height;
          }
        }
        newX = point0.x;
        newY = point0.y;
        newW = point1.x - newX;
        newH = point1.y - newY;
        if (newW < 0) {
          newW = newW * -1;
          newX = newX - newW;
        }
        if (newH < 0) {
          newH = newH * -1;
          newY = newY - newH;
        }
        if (preserveAspectRatio) {
          var _applyAspectToCorner3 = applyAspectToCorner(newW, newH, box.w, box.h, preserveAspectRatio),
            widthWithAspectRatio = _applyAspectToCorner3.newW,
            heightWithAspectRatio = _applyAspectToCorner3.newH;
          newW = widthWithAspectRatio;
          newH = heightWithAspectRatio;
          if (newX < box.x) {
            newX = box.x - newW;
            newY = box.y + box.h;
          } else {
            newY = box.y + (box.h - newH);
          }
        }
        return {
          x: newX,
          y: newY,
          w: newW,
          h: newH
        };
      }

      /**
       * Applies the movement of the north-west handle to the rubberband
       * @private
       * @param {module:nmodule/bajaui/rc/baja/Layout~Rectangle} box
       * @param {boolean} shiftKeyDown
       * @param {number} deltaX
       * @param {number} deltaY
       * @param {boolean} preserveAspectRatio
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle}
       */
    }, {
      key: "$movingNorthWestHandle",
      value: function $movingNorthWestHandle(box, shiftKeyDown, deltaX, deltaY, preserveAspectRatio) {
        var _this$$getSnapInfo8 = this.$getSnapInfo(shiftKeyDown),
          useSnap = _this$$getSnapInfo8.useSnap,
          snapSize = _this$$getSnapInfo8.snapSize;
        var xIncreasing = deltaX > 0;
        var yIncreasing = deltaY > 0;
        var newX;
        var newY;
        var newW;
        var newH;
        if (useSnap) {
          deltaX = Math.abs(deltaX) < snapSize / 2 ? 0 : deltaX;
          deltaY = Math.abs(deltaY) < snapSize / 2 ? 0 : deltaY;
          useSnap = !(deltaX === 0 && deltaY === 0);
        }
        newH = box.h - deltaY;
        newW = box.w - deltaX;
        newY = box.y + (box.h - newH);
        newX = box.x + (box.w - newW);
        var wrkLeftX = newX;
        var wrkRightX = newX + newW;
        var wrkTopY = newY;
        var wrkBottomY = newY + newH;

        //adjust the height for flipped east/west
        var leftX = Math.min(wrkLeftX, wrkRightX);
        var rightX = Math.max(wrkLeftX, wrkRightX);
        var flippedEW = leftX === wrkRightX || rightX === wrkLeftX;

        //adjust the height for flipped north/south
        var topY = Math.min(wrkTopY, wrkBottomY);
        var bottomY = Math.max(wrkTopY, wrkBottomY);
        var flippedNS = topY === wrkBottomY || bottomY === wrkTopY;
        var point0 = {
          x: leftX,
          y: topY
        };
        var point1 = {
          x: rightX,
          y: bottomY
        };
        if (useSnap) {
          var _this$$applySnapToTra8 = this.$applySnapToTrack(point0, point1, snapSize, xIncreasing, yIncreasing),
            wrkPoint0 = _this$$applySnapToTra8.wrkPoint0,
            wrkPoint1 = _this$$applySnapToTra8.wrkPoint1;
          if (!flippedEW) {
            point0.x = wrkPoint0.x;
          } else {
            point1.x = wrkPoint1.x;
          }
          if (!flippedNS) {
            point0.y = wrkPoint0.y;
          } else {
            point1.y = wrkPoint1.y;
          }
          var width = point1.x - point0.x;
          if (width < 0) {
            width = width * -1;
            point0.x = point0.x - width;
          }
          var height = point1.y - point0.y;
          if (height < 0) {
            height = height * -1;
            point0.y = point0.y - height;
          }
        }
        newX = point0.x;
        newY = point0.y;
        newW = point1.x - newX;
        newH = point1.y - newY;
        if (newW < 0) {
          newW = newW * -1;
          newX = newX - newW;
        }
        if (newH < 0) {
          newH = newH * -1;
          newY = newY - newH;
        }
        if (preserveAspectRatio) {
          var lowerRightX = box.x + box.w;
          var lowerRightY = box.y + box.h;
          var _applyAspectToCorner4 = applyAspectToCorner(newW, newH, box.w, box.h, preserveAspectRatio),
            widthWithAspectRatio = _applyAspectToCorner4.newW,
            heightWithAspectRatio = _applyAspectToCorner4.newH;
          newW = widthWithAspectRatio;
          newH = heightWithAspectRatio;
          if (newY < lowerRightY || newX < lowerRightX) {
            newY = box.y + (box.h - newH);
            newX = box.x + (box.w - newW);
          } else {
            newY = lowerRightY;
            newX = lowerRightX;
          }
        }
        return {
          x: newX,
          y: newY,
          w: newW,
          h: newH
        };
      }

      /**
       * Applies the snap to a track of the rubber band
       * @private
       * @param {{ x: number, y: number }} pointLeftTop
       * @param {{ x: number, y: number }} pointBottomRight
       * @param {Number} snapSize
       * @param {Boolean} xIncreasing
       * @param {Boolean} yIncreasing
       * @returns {{wrkPoint1: {x: number, y: number }, wrkPoint1: {x: number, y: number}}}
       */
    }, {
      key: "$applySnapToTrack",
      value: function $applySnapToTrack(pointLeftTop, pointBottomRight, snapSize, xIncreasing, yIncreasing) {
        var wrkPoint0 = this.translatePoint({
          point: pointLeftTop,
          from: 'overlay',
          to: this.$canvasPane
        });
        var wrkPoint1 = this.translatePoint({
          point: pointBottomRight,
          from: 'overlay',
          to: this.$canvasPane
        });
        wrkPoint0 = applySnapToPoint(snapSize, wrkPoint0, xIncreasing, yIncreasing);
        wrkPoint1 = applySnapToPoint(snapSize, wrkPoint1, xIncreasing, yIncreasing);
        wrkPoint0 = this.translatePoint({
          point: wrkPoint0,
          from: this.$canvasPane,
          to: 'overlay'
        });
        wrkPoint1 = this.translatePoint({
          point: wrkPoint1,
          from: this.$canvasPane,
          to: 'overlay'
        });
        return {
          wrkPoint0: wrkPoint0,
          wrkPoint1: wrkPoint1
        };
      }
    }]);
  }(MoveTracker);
});
