function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/trackers/PathHandleTracker
 */

define(['lex!uxBuilder', 'log!nmodule.uxBuilder.rc.ux.wysiwyg.trackers.PathHandleTracker', 'nmodule/gx/rc/baja/PathGeom', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/MoveTracker'], function (lexs, log, PathGeom, uxBuilderUtils, wysiwygUtils, ModifyUxModelCommand, MoveTracker) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var modify = ModifyUxModelCommand.modify;
  var getOriginatingNode = uxBuilderUtils.getOriginatingNode;
  var finestLoggable = log.isLoggable('FINEST');
  var logFinest = log.finest.bind(log);
  var getIndexOfHandle = wysiwygUtils.getIndexOfHandle;

  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/PathHandleTracker
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/MoveTracker
   */
  return /*#__PURE__*/function (_MoveTracker) {
    function PathHandleTracker(pathArtisan, controller, canvasPane, widgets, overlayX, overlayY, handle) {
      var _this;
      _classCallCheck(this, PathHandleTracker);
      _this = _callSuper(this, PathHandleTracker, [controller, canvasPane, widgets, overlayX, overlayY]);
      _this.$artisan = pathArtisan;
      _this.$handle = handle;
      _this.$origOverlayX = overlayX;
      _this.$origOverlayY = overlayY;
      _this.$overlayTranslatedGeom = pathArtisan.$getOverlayTranslatedGeom();
      return _this;
    }
    _inherits(PathHandleTracker, _MoveTracker);
    return _createClass(PathHandleTracker, [{
      key: "track",
      value: function track(overlayX, overlayY, shiftKeyDown) {
        var handle = this.$handle;
        // Get the one-time translated geom (at instantiation)  
        var translatedToOverlayGeom = this.$overlayTranslatedGeom;
        // Apply deltas on the translated geom and
        var snapPoint = this.$getSnapPoint({
          x: overlayX,
          y: overlayY
        }, shiftKeyDown);
        this.$dx = snapPoint.x - this.$origOverlayX;
        this.$dy = snapPoint.y - this.$origOverlayY;
        this.$overlayGeom = handle.getRole().$apply(translatedToOverlayGeom, this.$dx, this.$dy);
        finestLoggable && logFinest('PathHandleTracker: tracked handle, will apply on mouseup');
        this.emit('geomUpdate');
      }
    }, {
      key: "trackEnd",
      value: function trackEnd() {
        var handle = this.$handle,
          path = handle.getWidget(),
          artisan = this.$artisan,
          origGeom = path.properties().getValue('geom');
        var overlayPt = {
            x: this.$origOverlayX + this.$dx,
            y: this.$origOverlayY + this.$dy
          },
          translatedHandleEndPt = artisan.translatePoint({
            point: {
              x: overlayPt.x,
              y: overlayPt.y
            },
            from: 'overlay',
            to: this.$canvasPane
          }),
          translatedHandleStartPt = artisan.translatePoint({
            point: {
              x: this.$origOverlayX,
              y: this.$origOverlayY
            },
            from: 'overlay',
            to: this.$canvasPane
          });
        var dx = translatedHandleEndPt.x - translatedHandleStartPt.x,
          dy = translatedHandleEndPt.y - translatedHandleStartPt.y;
        var propertiesToUpdate = {
          geom: this.$getTranslatedGeom(origGeom, dx, dy)
        };
        this.$overlayGeom = PathGeom.DEFAULT;
        this.emit('geomUpdate');
        finestLoggable && logFinest('PathHandleTracker: resizing Path');
        return this.$modifyWidgetProperties(path, propertiesToUpdate);
      }

      /**
       * TODO Move this to a common place to avoid duplicates
       * @private
       * @param {module:bajaux/Widget} widget
       * @param {object} properties
       * @returns {Promise}
       */
    }, {
      key: "$modifyWidgetProperties",
      value: function $modifyWidgetProperties(widget, properties) {
        var node = getOriginatingNode(widget);
        return node.value().clone({
          properties: properties
        }).then(function (model) {
          return {
            model: model,
            parentNode: node.getParent()
          };
        }).then(function (ops) {
          return modify([ops], {
            redoText: function redoText() {
              return uxBuilderLex.get('commands.geom.modify.redoText');
            },
            undoText: function undoText() {
              return uxBuilderLex.get('commands.geom.modify.undoText');
            }
          });
        });
      }

      /**
       * @private
       * @param {module:nmodule/gx/rc/baja/PathGeom} geom 
       * @param {number} dx 
       * @param {number} dy 
       * @returns {nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "$getTranslatedGeom",
      value: function $getTranslatedGeom(geom, dx, dy) {
        var artisan = this.$artisan,
          handle = this.$handle,
          canvasHandle = artisan.$canvasHandlesMap[getIndexOfHandle(handle)];
        return canvasHandle.getRole().$apply(geom, dx, dy);
      }
    }]);
  }(MoveTracker);
});
