function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/trackers/MoveTracker
 */

/* eslint-env browser */

define(['baja!', 'baja!bajaui:Layout', 'lex!uxBuilder', 'log!nmodule.uxBuilder.rc.ux.wysiwyg.trackers.MoveTracker', 'bajaux/Widget', 'bajaux/spandrel/logging', 'Promise', 'nmodule/bajaui/rc/ux/shape/Shape', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand', 'nmodule/uxBuilder/rc/ux/model/UxModelTreeNode', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker'], function (baja, types, lexs, log, Widget, logging, Promise, Shape, uxBuilderUtils, wysiwygUtils, ModifyUxModelCommand, UxModelTreeNode, Tracker) {
  'use strict';

  var finestLoggable = log.isLoggable('FINEST');
  var logFinest = log.finest.bind(log);
  var logSevere = log.severe.bind(log);
  var widgetName = logging.widgetName;
  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var getOriginatingNode = uxBuilderUtils.getOriginatingNode;
  var applySnapToLayout = wysiwygUtils.applySnapToLayout,
    applySnapToPoint = wysiwygUtils.applySnapToPoint,
    isCanvasPaneChild = wysiwygUtils.isCanvasPaneChild,
    roundLayoutRectangle = wysiwygUtils.roundLayoutRectangle;
  var modify = ModifyUxModelCommand.modify;
  function clamp(n, min, max) {
    return Math.max(Math.min(n, max), min);
  }

  /**
   * When a group of widgets are moved, we want to move them as a group maintaining their
   * existing positions with regards to each other. We make a 'bounding box' around the group of
   * widgets to move them as a whole.
   * @param {Array.<module:bajaux/Widget>} [widgets]
   * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/MoveTracker} tracker
   * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle} the bounding box around all the
   * widgets, relative to the overlay3
   */
  function getBoundingBox() {
    var widgets = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    var tracker = arguments.length > 1 ? arguments[1] : undefined;
    if (!widgets.length) {
      return {
        x: 0,
        y: 0,
        w: 0,
        h: 0
      };
    }
    var top = Number.MAX_VALUE,
      right = Number.MIN_VALUE,
      bottom = Number.MIN_VALUE,
      left = Number.MAX_VALUE;
    widgets.forEach(function (widget) {
      var _tracker$toOverlayBox = tracker.toOverlayBox(widget),
        x = _tracker$toOverlayBox.x,
        y = _tracker$toOverlayBox.y,
        w = _tracker$toOverlayBox.w,
        h = _tracker$toOverlayBox.h;
      top = Math.min(top, y);
      right = Math.max(right, x + w);
      bottom = Math.max(bottom, y + h);
      left = Math.min(left, x);
    });
    return {
      x: left,
      y: top,
      w: right - left,
      h: bottom - top
    };
  }

  /**
   * This tracker is for when you have pressed the mouse on a widget and are now moving your mouse
   * around.
   *
   * Handles moving a widget around and tracing their steps along the way.
   * Involves updating the move rubber band.
   * 
   * @since Niagara 4.15
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/MoveTracker
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker
   */
  return /*#__PURE__*/function (_Tracker) {
    /**
     * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController} controller
     * @param {module:nmodule/bajaui/rc/ux/CanvasPane} canvasPane the canvas pane we're moving
     * things around on
     * @param {Array.<module:bajaux/Widget>} widgets
     * @param {Number} overlayX
     * @param {Number} overlayY
     */
    function MoveTracker(controller, canvasPane, widgets, overlayX, overlayY) {
      var _this;
      _classCallCheck(this, MoveTracker);
      _this = _callSuper(this, MoveTracker, [controller]);
      if (!canvasPane) {
        throw new Error('CanvasPane required');
      }
      _this.$widgets = widgets || [];
      _this.$origX = overlayX;
      _this.$origY = overlayY;
      /** @type {Array.<module:nmodule/bajaui/rc/baja/Layout~Rectangle>} */
      _this.$rubberBands = [];
      _this.$canvasPane = canvasPane;
      return _this;
    }
    _inherits(MoveTracker, _Tracker);
    return _createClass(MoveTracker, [{
      key: "mousemove",
      value: function mousemove(e) {
        var controller = this.$getController();
        var _this$eventToOverlayC = this.eventToOverlayCoords(e),
          x = _this$eventToOverlayC.x,
          y = _this$eventToOverlayC.y;
        var shiftKeyDown = e.shiftKey;
        if (!this.$dragged) {
          if (controller.$isActiveDrag(e)) {
            this.$dragged = true;
            return this.track(x, y, shiftKeyDown);
          }
        } else {
          return this.track(x, y, shiftKeyDown);
        }
      }
    }, {
      key: "mouseup",
      value: function mouseup(e) {
        if (this.$dragged) {
          this.$dragged = false;
          return this.trackEnd(e.shiftKey);
        }
      }

      /**
       * @param {Number} overlayX
       * @param {Number} overlayY
       * @param {Boolean} shiftKeyDown is the shift key being pressed
       */
    }, {
      key: "track",
      value: function track(overlayX, overlayY, shiftKeyDown) {
        var _this2 = this;
        var uxBuilderProps = this.$controller.$getUxBuilder().properties();
        var useSnap = uxBuilderProps.getValue('useSnap') && !shiftKeyDown;
        var snapSize = uxBuilderProps.getValue('snapSize');
        var widgets = this.$widgets;
        var deltaX = overlayX - this.$origX,
          deltaY = overlayY - this.$origY;
        this.$rubberBands = [];
        var boundingBox = getBoundingBox(widgets, this);
        widgets.forEach(function (widget) {
          var box = _this2.toOverlayBox(widget);
          var _this2$getWidgetMovem = _this2.getWidgetMovementBox(widget),
            left = _this2$getWidgetMovem.x,
            top = _this2$getWidgetMovem.y,
            w = _this2$getWidgetMovem.w,
            h = _this2$getWidgetMovem.h;
          var widgetX = left + (box.x - boundingBox.x),
            widgetY = top + (box.y - boundingBox.y);
          var overlayPoint = {
            x: clamp(box.x + deltaX, widgetX, widgetX + w - boundingBox.w),
            y: clamp(box.y + deltaY, widgetY, widgetY + h - boundingBox.h)
          };
          if (useSnap) {
            overlayPoint = _this2.translatePoint({
              point: overlayPoint,
              from: 'overlay',
              to: _this2.$canvasPane
            });
            overlayPoint = applySnapToPoint(snapSize, overlayPoint);
            overlayPoint = _this2.translatePoint({
              point: overlayPoint,
              from: _this2.$canvasPane,
              to: 'overlay'
            });
          }
          _this2.$rubberBands.push({
            x: overlayPoint.x,
            y: overlayPoint.y,
            w: box.w,
            h: box.h
          });
        });
        finestLoggable && logFinest('MoveTracker: tracked move, will apply on mouseup');
        this.emit('update');
      }

      /**
       * Get the box within whose bounds this widget is allowed to move
       * @param {module:bajaux/Widget} widget
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle} box to confine widget movement,
       * relative to the overlay
       */
    }, {
      key: "getWidgetMovementBox",
      value: function getWidgetMovementBox(widget) {
        if (isCanvasPaneChild(widget)) {
          var viewPane = Widget["in"](widget.jq().parent());
          // move around anywhere in the viewPane
          return this.translateRect({
            rect: viewPane,
            to: 'overlay'
          });
        } else {
          // Cannot move if widget is not a CanvasPane child
          return {
            x: 0,
            y: 0,
            w: 0,
            h: 0
          };
        }
      }

      /**
       * @param {Boolean} shiftKeyDown
       * @returns {Promise}
       */
    }, {
      key: "trackEnd",
      value: function trackEnd(shiftKeyDown) {
        var _this3 = this;
        var newPositions = [];
        var widgets = this.$widgets;
        widgets.forEach(function (widget, i) {
          newPositions.push({
            widget: widget,
            rubberBand: _this3.$rubberBands[i]
          });
        });
        // Lets clear the rubber band and invoke a move command
        this.$rubberBands = [];
        finestLoggable && logFinest('MoveTracker: moving/resizing widgets');
        /*
        _don't_ emit update and trigger a repaint right at this moment. this would erase the
        rubberband instantly, but still with a split second before the widget actually moves on the
        screen: two paints.
         instead, let the rubberband sit for the few ms until the widget actually moves. this feels
        perceptibly smoother. the relayout afterward will repaint the controller and erase the
        rubberband.
         */
        //this.emit('update');
        return this.$doMove(newPositions, shiftKeyDown)["catch"](logSevere);
      }

      /**
       * @private
       * @returns {Array.<module:nmodule/bajaui/rc/baja/Layout~Rectangle>}
       */
    }, {
      key: "$getRubberBands",
      value: function $getRubberBands() {
        return this.$rubberBands;
      }

      /**
       * @private
       * @param {Boolean} shiftKeyDown
       * @param {Array.<object>} newPositions
       * @returns {Promise}
       */
    }, {
      key: "$doMove",
      value: function $doMove(newPositions, shiftKeyDown) {
        var _this4 = this;
        var uxBuilderProps = this.$controller.$getUxBuilder().properties();
        var useSnap = uxBuilderProps.getValue('useSnap') && !shiftKeyDown && !this.$snapAlreadyApplied;
        var snapSize = uxBuilderProps.getValue('snapSize');
        return Promise.all(newPositions.map(function (_ref) {
          var widget = _ref.widget,
            rubberBand = _ref.rubberBand;
          var node = getOriginatingNode(widget);
          var propertiesToUpdate = {};
          if (widget instanceof Shape) {
            var artisan = _this4.$getController().$makeArtisan(widget);
            var geom = artisan.getTranslatedGeom(widget, rubberBand);
            finestLoggable && logFinest("Setting geom property on Shape ".concat(widgetName(widget), " to ").concat(geom.encodeToString()));
            propertiesToUpdate.geom = geom;
          } else {
            var currLayout = node.value().getProperties().layout;
            var layoutValues = _this4.translateRect({
              rect: rubberBand,
              from: 'overlay',
              to: _this4.$canvasPane
            });
            layoutValues = roundLayoutRectangle(layoutValues);
            if (useSnap) {
              layoutValues = applySnapToLayout(snapSize, layoutValues, currLayout);
            }
            var layout = baja.$('bajaui:Layout', layoutValues);
            finestLoggable && logFinest("Setting layout property on Widget ".concat(widgetName(widget), " to ").concat(layout.encodeToString()));
            propertiesToUpdate.layout = layout;
          }
          return node.value().clone({
            properties: propertiesToUpdate
          }).then(function (model) {
            return {
              model: model,
              parentNode: node.getParent()
            };
          });
        })).then(function (ops) {
          return modify(ops, {
            redoText: function redoText() {
              return uxBuilderLex.get('commands.layout.modify.redoText');
            },
            undoText: function undoText() {
              return uxBuilderLex.get('commands.layout.modify.undoText');
            },
            onNewNodes: function onNewNodes() {
              return _this4.$getController().$getUxBuilder().rerender();
            }
          });
        });
      }

      /**
       * @private
       * @returns {boolean}
       */
    }, {
      key: "$useSnap",
      value: function $useSnap() {
        var uxBuilder = this.$controller.$getUxBuilder();
        return uxBuilder && uxBuilder.properties().getValue('useSnap');
      }

      /**
       * @private
       * @returns {number}
       */
    }, {
      key: "$getSnapSize",
      value: function $getSnapSize() {
        var uxBuilder = this.$controller.$getUxBuilder();
        return uxBuilder.properties().getValue('snapSize');
      }

      /**
       * Returns the snap point with respect to overlay.
       *
       * @private
       * @param {module:nmodule/bajaui/rc/baja/Layout~Rectangle} overlayPoint
       * @param {boolean} shiftKeyDown
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle}
       */
    }, {
      key: "$getSnapPoint",
      value: function $getSnapPoint(overlayPoint, shiftKeyDown) {
        var useSnap = this.$useSnap() && !shiftKeyDown;
        var snapPoint = Object.assign({}, overlayPoint);
        if (useSnap) {
          var snapSize = this.$getSnapSize();
          // Translate the overlay point to the canvas.
          var translatedCanvasPanePoint = this.translatePoint({
            point: snapPoint,
            from: 'overlay',
            to: this.$canvasPane
          });
          // Apply snap to the canvas point.
          var canvasPanePointWithSnap = applySnapToPoint(snapSize, translatedCanvasPanePoint);
          // Translate the snapped canvas point back to overlay and apply to the input overlay point.
          var translatedOverlayPoint = this.translatePoint({
            point: canvasPanePointWithSnap,
            from: this.$canvasPane,
            to: 'overlay'
          });
          snapPoint.x = translatedOverlayPoint.x;
          snapPoint.y = translatedOverlayPoint.y;
        }
        return snapPoint;
      }
    }]);
  }(Tracker);
});
