function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/trackers/LineHandleTracker
 */

define(['lex!uxBuilder', 'nmodule/gx/rc/baja/LineGeom', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/commands/ModifyUxModelCommand', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/MoveTracker'], function (lexs, LineGeom, uxBuilderUtils, wysiwygUtils, ModifyUxModelCommand, MoveTracker) {
  'use strict';

  var getIndexOfHandle = wysiwygUtils.getIndexOfHandle;
  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var modify = ModifyUxModelCommand.modify;
  var getOriginatingNode = uxBuilderUtils.getOriginatingNode;

  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/LineHandleTracker
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/MoveTracker
   */
  return /*#__PURE__*/function (_MoveTracker) {
    function LineHandleTracker(artisan, controller, canvasPane, widgets, overlayX, overlayY, handle) {
      var _this;
      _classCallCheck(this, LineHandleTracker);
      _this = _callSuper(this, LineHandleTracker, [controller, canvasPane, widgets, overlayX, overlayY]);
      _this.$handle = handle;
      _this.$widgets = widgets || [];
      _this.$origOverlayX = overlayX;
      _this.$origOverlayY = overlayY;
      _this.$artisan = artisan;
      _this.$idx = getIndexOfHandle(handle);
      return _this;
    }
    _inherits(LineHandleTracker, _MoveTracker);
    return _createClass(LineHandleTracker, [{
      key: "track",
      value: function track(overlayX, overlayY, shiftKeyDown) {
        var artisan = this.$artisan,
          handle = this.$handle,
          widget = handle.getWidget();
        var deltaX = overlayX - this.$origOverlayX,
          deltaY = overlayY - this.$origOverlayY;
        var handlePointsOnOverlay = artisan.getTranslatedPoints(widget).slice();
        var handlePointOnOverlay = handlePointsOnOverlay[this.$idx];
        handlePointOnOverlay.x += deltaX;
        handlePointOnOverlay.y += deltaY;

        // Get the snap point and apply it to the Geom points.
        var snapPoint = this.$getSnapPoint(handlePointOnOverlay, shiftKeyDown);
        handlePointOnOverlay.x = snapPoint.x;
        handlePointOnOverlay.y = snapPoint.y;
        var _handlePointsOnOverla = _slicedToArray(handlePointsOnOverlay, 2),
          p1 = _handlePointsOnOverla[0],
          p2 = _handlePointsOnOverla[1];
        this.$overlayGeom = new LineGeom(p1.x, p1.y, p2.x, p2.y);
        this.emit('geomUpdate');
      }

      /**
       * 
       * @returns {Promise}
       */
    }, {
      key: "trackEnd",
      value: function trackEnd() {
        var overlayGeom = this.$overlayGeom;
        var handle = this.$handle,
          widget = handle.getWidget(),
          idx = this.$idx;
        /**
         * At this point we have the overlayGeom wrt the overlay coordinate system.
         * We translate the original geom to the overlay coordinate system.
         * We calculate the delta and then translate the geom back to the original coordinate system.
         */
        var oldCanvasPaneGeom = widget.properties().getValue('geom');
        var oldCanvasPanePoint = oldCanvasPaneGeom.getPoints()[idx].toJson();
        var newOverlayPoint = overlayGeom.getPoints()[idx];
        var newCanvasPanePoint = this.translatePoint({
          point: newOverlayPoint.toJson(),
          from: 'overlay',
          to: this.$canvasPane
        });
        var deltaX = newCanvasPanePoint.x - oldCanvasPanePoint.x;
        var deltaY = newCanvasPanePoint.y - oldCanvasPanePoint.y;
        var propertiesToUpdate = {
          geom: oldCanvasPaneGeom.translate(deltaX, deltaY, idx)
        };
        this.$overlayGeom = LineGeom.DEFAULT;
        this.emit('geomUpdate');
        return this.$modifyWidgetProperties(widget, propertiesToUpdate);
      }

      /**
       * 
       * @param {module:bajaux/Widget} widget 
       * @param {object} properties 
       * @returns {Promise}
       */
    }, {
      key: "$modifyWidgetProperties",
      value: function $modifyWidgetProperties(widget, properties) {
        var node = getOriginatingNode(widget);
        return node.value().clone({
          properties: properties
        }).then(function (model) {
          return {
            model: model,
            parentNode: node.getParent()
          };
        }).then(function (ops) {
          return modify([ops], {
            redoText: function redoText() {
              return uxBuilderLex.get('commands.geom.modify.redoText');
            },
            undoText: function undoText() {
              return uxBuilderLex.get('commands.geom.modify.undoText');
            }
          });
        });
      }
    }]);
  }(MoveTracker);
});
