function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/trackers/DefaultTracker
 */

/* eslint-env browser */

define(['log!nmodule.uxBuilder.rc.ux.wysiwyg.trackers.DefaultTracker', 'bajaux/spandrel/logging', 'Promise', 'nmodule/bajaui/rc/ux/shape/Shape', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/PassThroughTracker', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/trackerUtil', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/events/ExpandablePaneTracker', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/events/ScrollPaneTracker', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/events/SplitPaneTracker', 'nmodule/webEditors/rc/wb/profile/selectionModeSettings'], function (log, logging, Promise, Shape, wysiwygUtils, PassThroughTracker, Tracker, trackerUtil, ExpandablePaneTracker, ScrollPaneTracker, SplitPaneTracker, selectionModeSettings) {
  'use strict';

  var finestLoggable = log.isLoggable('FINEST');
  var logFinest = log.finest.bind(log);
  var widgetName = logging.widgetName;
  var getParentLastBuiltWidget = wysiwygUtils.getParentLastBuiltWidget;
  var getSelectionMode = selectionModeSettings.getSelectionMode,
    getSelectionModeFromEvent = selectionModeSettings.getSelectionModeFromEvent,
    TOGGLE_MODE = selectionModeSettings.TOGGLE_MODE;
  var getMultiMode = function getMultiMode(e) {
    return (e ? getSelectionModeFromEvent(e) : getSelectionMode()) === TOGGLE_MODE;
  };
  var interceptingCtors = [ExpandablePaneTracker, ScrollPaneTracker, SplitPaneTracker];

  /**
   * This tracker is for when you're moving the mouse around on the editor without any buttons pressed.
   *
   * Comparable to pxEditor~UnpressedTracker, a DefaultTracker sets the expected 
   * cursor on the editor on mouse/touch movements and delegates selection handler to the controller
   * once a widget or handle is selected.
   * After any mouse/touch operation is complete, typically via a mouseup/touchend event, the studio will
   * reset to this tracker.
   * 
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/DefaultTracker
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker
   */
  return /*#__PURE__*/function (_Tracker) {
    function DefaultTracker() {
      _classCallCheck(this, DefaultTracker);
      return _callSuper(this, DefaultTracker, arguments);
    }
    _inherits(DefaultTracker, _Tracker);
    return _createClass(DefaultTracker, [{
      key: "mousemove",
      value: function mousemove(e) {
        return this.$getController().$setIdleCursor(e);
      }
    }, {
      key: "mousedown",
      value: function mousedown(e) {
        finestLoggable && logFinest('DefaultTracker: mousedown');
        var controller = this.$getController();
        var _this$eventToOverlayC = this.eventToOverlayCoords(e),
          x = _this$eventToOverlayC.x,
          y = _this$eventToOverlayC.y;
        return controller.$getEntityUnderMouse(e).then(function (entityInfo) {
          return Promise["try"](function () {
            var type = entityInfo.type,
              entity = entityInfo.entity;
            switch (type) {
              case 'handle':
                {
                  finestLoggable && logFinest('DefaultTracker: mousedown on handle, starting handle tracker');
                  return controller.$startHandleTracker(x, y, entity, e.ctrlKey);
                }
              case 'widget':
                {
                  if (entity instanceof Shape) {
                    finestLoggable && logFinest("DefaultTracker: mousedown on Shape ".concat(widgetName(entity), ", starting passthrough tracker"));
                    return controller.setTracker(new PassThroughTracker(controller, entity));
                  }
                  var interceptingTracker = DefaultTracker.$interceptorFor(e, entity, controller);
                  if (interceptingTracker && interceptingTracker.startsGesture(e)) {
                    finestLoggable && logFinest("DefaultTracker: mousedown on ".concat(widgetName(entity), ", intercepted by tracker"));
                    return Promise.resolve(interceptingTracker.mousedown(e)).then(function () {
                      return controller.setTracker(interceptingTracker);
                    });
                  }
                  finestLoggable && logFinest("DefaultTracker: mousedown on ".concat(widgetName(entity), ", handling selection"));
                  return controller.$handleSelect(x, y, entity, getMultiMode(e));
                }
            }
          });
        });
      }

      /**
       * @param {JQuery.Event} e
       * @returns {Promise|*}
       */
    }, {
      key: "wheel",
      value: function wheel(e) {
        var _arguments = arguments;
        /*
        there are some big assumptions here. we may find other cases where wheel behavior is wonky.
        - assumption: regular trackers won't handle mousewheel - it's a "special pane behavior"
        - wheel events "bubble" - walk up the widget tree until you find a special tracker and assume
          it will handle the wheel event (not going to implement "canHandleWheelEvent" rn)
        - in practice: if wheel happens, scroll the closest ScrollPane
         */
        var controller = this.$getController();
        return controller.$getWidgetUnderMouse(e.pageX, e.pageY).then(function (widget) {
          while (widget) {
            widget = getParentLastBuiltWidget(widget);
            var tracker = widget && DefaultTracker.$interceptorFor(e, widget, controller);
            if (tracker) {
              return tracker.wheel.apply(tracker, _toConsumableArray(_arguments));
            }
          }
        });
      }
    }, {
      key: "keydown",
      value: function keydown(e) {
        return trackerUtil.keydownHandler(e, this.$getController());
      }

      /**
       * @private
       * @param {JQuery.Event} mouseEvent
       * @param {module:bajaux/Widget} widget
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController} controller
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker|undefined}
       */
    }], [{
      key: "$interceptorFor",
      value: function $interceptorFor(mouseEvent, widget, controller) {
        for (var i = 0, len = interceptingCtors.length; i < len; ++i) {
          var Ctor = interceptingCtors[i];
          if (Ctor.supports(widget)) {
            return new Ctor(controller, widget);
          }
        }
      }
    }]);
  }(Tracker);
});
