function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/trackers/AddPolygonTracker
 */

/* eslint-env browser */

define(['baja!', 'baja!bajaui:Line,bajaui:Polygon,gx:Brush,gx:PolygonGeom', 'log!nmodule.uxBuilder.rc.ux.wysiwyg.trackers.AddPolygonTracker', 'Promise', 'nmodule/bajaui/rc/ux/CanvasPane', 'nmodule/bajaui/rc/ux/shape/Line', 'nmodule/bajaui/rc/ux/shape/Polygon', 'nmodule/gx/rc/baja/LineGeom', 'nmodule/gx/rc/baja/PolygonGeom', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker'], function (baja, types, log, Promise, CanvasPane, Line, Polygon, LineGeom, PolygonGeom, uxBuilderUtils, wysiwygUtils, Tracker) {
  'use strict';

  var finestLoggable = log.isLoggable('FINEST');
  var logFinest = log.finest.bind(log);
  var getOriginatingNode = uxBuilderUtils.getOriginatingNode;
  var closestWidgetOfType = wysiwygUtils.closestWidgetOfType;

  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/AddPolygonTracker
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker
   */
  return /*#__PURE__*/function (_Tracker) {
    function AddPolygonTracker(controller) {
      var _this;
      _classCallCheck(this, AddPolygonTracker);
      _this = _callSuper(this, AddPolygonTracker, [controller]);
      _this.$handles = [];
      controller.$setCursor('crosshair');
      return _this;
    }
    _inherits(AddPolygonTracker, _Tracker);
    return _createClass(AddPolygonTracker, [{
      key: "mousemove",
      value: function mousemove(e) {
        var handles = this.$handles;
        if (handles.length > 0) {
          var _this$eventToOverlayC = this.eventToOverlayCoords(e),
            x = _this$eventToOverlayC.x,
            y = _this$eventToOverlayC.y;
          return this.track(x, y);
        }
      }
    }, {
      key: "track",
      value: function track(overlayX, overlayY) {
        var widget = this.$getWidget();
        if (this.$handles.length === 1) {
          widget = this.$widget = new Line();
        } else if (widget instanceof Line) {
          widget = this.$widget = new Polygon();
        }
        this.$overlayGeom = this.$setGeom(widget, overlayX, overlayY);
        this.emit('geomUpdate');
      }
    }, {
      key: "mouseup",
      value: function mouseup(e) {
        var _this2 = this;
        var _this$eventToOverlayC2 = this.eventToOverlayCoords(e),
          x = _this$eventToOverlayC2.x,
          y = _this$eventToOverlayC2.y;
        finestLoggable && logFinest('AddPolygonTracker: mouseup');
        var controller = this.$getController();
        return controller.$getEntityUnderMouse(e).then(function (_ref) {
          var entity = _ref.entity;
          var canvasPane = closestWidgetOfType(CanvasPane, entity);
          if (canvasPane) {
            _this2.$canvasPane = canvasPane;
            _this2.$handles.push({
              x: x,
              y: y
            });
          }
        });
      }
    }, {
      key: "keydown",
      value: function keydown(e) {
        var _this3 = this;
        return Promise["try"](function () {
          finestLoggable && logFinest('AddPolygonTracker: keydown');
          // At least 3 points are needed to make a Polygon
          if (e.key === 'Escape' && _this3.$canvasPane && _this3.$handles.length >= 3) {
            // All the handles are in overlay coords, lets translate them to canvas
            var translatedPoints = _this3.$handles.map(function (point) {
              return _this3.translatePoint({
                point: point,
                from: 'overlay',
                to: _this3.$canvasPane
              });
            });
            var geom = new PolygonGeom(translatedPoints.map(function (pt) {
              return pt.x;
            }), translatedPoints.map(function (pt) {
              return pt.y;
            }), translatedPoints.length);
            return _this3.$insertNewPolygon(geom);
          }
        }).then(function () {
          return _this3.$clearTracker();
        });
      }

      /**
       * 
       * @private
       * @param {module:nmodule/gx/rc/baja/PolygonGeom} geom 
       * @returns {Promise}
       */
    }, {
      key: "$insertNewPolygon",
      value: function $insertNewPolygon(geom) {
        var _this4 = this;
        var widget = baja.$('bajaui:Polygon', {
          geom: geom,
          stroke: baja.$('gx:Brush', 'black')
        });
        var parentNode = getOriginatingNode(this.$canvasPane);
        return parentNode.insert([{
          object: widget
        }]).then(function () {
          return _this4.$getController().$getUxBuilder().rerender();
        });
      }

      /**
       * @private
       */
    }, {
      key: "$clearTracker",
      value: function $clearTracker() {
        this.$overlayGeom = PolygonGeom.DEFAULT;
        this.$widget = null;
        this.$handles = [];
        this.emit('geomUpdate');
      }

      /**
       * @private
       */
    }, {
      key: "$getWidget",
      value: function $getWidget() {
        return this.$widget;
      }

      /**
       * @private
       * @param {module:nmodule/bajaui/rc/ux/shape/Shape} widget 
       * @param {number} overlayX 
       * @param {number} overlayY 
       * @returns {module:nmodule/gx/rc/baja/LineGeom|module:nmodule/gx/rc/baja/PolygonGeom}
       */
    }, {
      key: "$setGeom",
      value: function $setGeom(widget, overlayX, overlayY) {
        var geom;
        var handles = this.$handles;
        if (widget instanceof Line) {
          var _handles$ = handles[0],
            x = _handles$.x,
            y = _handles$.y;
          geom = new LineGeom(x, y, overlayX, overlayY);
        } else {
          var size = handles.length;
          var xValues = handles.map(function (p) {
              return p.x;
            }).toSpliced(size, 0, overlayX),
            yValues = handles.map(function (p) {
              return p.y;
            }).toSpliced(size, 0, overlayY);
          geom = new PolygonGeom(xValues, yValues, size + 1);
        }
        widget.properties().setValue('geom', geom);
        return geom;
      }
    }]);
  }(Tracker);
});
