function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2025 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/trackers/AddPathTracker
 */

/* eslint-env browser */

define(['baja!', 'baja!bajaui:Path,gx:Brush,gx:PathGeom', 'log!nmodule.uxBuilder.rc.ux.wysiwyg.trackers.AddPolygonTracker', 'Promise', 'nmodule/bajaui/rc/ux/CanvasPane', 'nmodule/bajaui/rc/ux/shape/Path', 'nmodule/gx/rc/baja/PathGeom', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker'], function (baja, types, log, Promise, CanvasPane, Path, PathGeom, uxBuilderUtils, wysiwygUtils, Tracker) {
  'use strict';

  var finestLoggable = log.isLoggable('FINEST');
  var logFinest = log.finest.bind(log);
  var getOriginatingNode = uxBuilderUtils.getOriginatingNode;
  var closestWidgetOfType = wysiwygUtils.closestWidgetOfType;

  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/AddPathTracker
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker
   * @since Niagara 4.15
   */
  return /*#__PURE__*/function (_Tracker) {
    function AddPathTracker(controller) {
      var _this;
      _classCallCheck(this, AddPathTracker);
      _this = _callSuper(this, AddPathTracker, [controller]);
      _this.$handles = [];
      _this.$bars = [];
      controller.$setCursor('crosshair');
      return _this;
    }
    _inherits(AddPathTracker, _Tracker);
    return _createClass(AddPathTracker, [{
      key: "mousemove",
      value: function mousemove(e) {
        var controller = this.$getController();
        var handles = this.$handles,
          bars = this.$bars;
        if (handles.length > 0) {
          var _this$eventToOverlayC = this.eventToOverlayCoords(e),
            x = _this$eventToOverlayC.x,
            y = _this$eventToOverlayC.y;
          if (!this.$dragged) {
            if (controller.$isActiveDrag(e)) {
              this.$dragged = true;
            }
          } else {
            this.$bars[bars.length - 1] = {
              x: x,
              y: y
            };
          }
          return this.track(x, y, e.shiftKey);
        }
      }
    }, {
      key: "track",
      value: function track(overlayX, overlayY) {
        var widget = this.$getWidget();
        if (!widget) {
          widget = this.$widget = new Path();
        }
        var _this$$snap = this.$snap({
            x: overlayX,
            y: overlayY
          }),
          x = _this$$snap.x,
          y = _this$$snap.y;
        this.$overlayGeom = this.$makeGeom(widget, x, y);
        this.emit('geomUpdate');
      }
    }, {
      key: "mousedown",
      value: function mousedown(e) {
        var _this2 = this;
        var _this$eventToOverlayC2 = this.eventToOverlayCoords(e),
          x = _this$eventToOverlayC2.x,
          y = _this$eventToOverlayC2.y;
        finestLoggable && logFinest('AddPathTracker: mousedown');
        var controller = this.$getController();
        return controller.$getEntityUnderMouse(e).then(function (_ref) {
          var entity = _ref.entity;
          var canvasPane = closestWidgetOfType(CanvasPane, entity);
          if (canvasPane) {
            _this2.$canvasPane = canvasPane;
            _this2.$handles.push({
              x: x,
              y: y
            });
            _this2.$bars.push(null);
          }
        });
      }
    }, {
      key: "mouseup",
      value: function mouseup(e) {
        var bars = this.$bars;
        var _this$eventToOverlayC3 = this.eventToOverlayCoords(e),
          x = _this$eventToOverlayC3.x,
          y = _this$eventToOverlayC3.y;
        if (this.$dragged) {
          finestLoggable && logFinest('AddPathTracker: mouseup');
          this.$bars[bars.length - 1] = {
            x: x,
            y: y
          };
          this.$dragged = false;
        }
      }
    }, {
      key: "keydown",
      value: function keydown(e) {
        var _this3 = this;
        return Promise["try"](function () {
          finestLoggable && logFinest('AddPolygonTracker: keydown');
          var handles = _this3.$handles;
          var canvasPane = _this3.$canvasPane;
          if (e.key === 'Escape' && canvasPane && handles.length >= 2) {
            // All the handles are in overlay coords, lets translate them to canvas
            var overlayGeom = _this3.$overlayGeom;
            var _handles = _slicedToArray(handles, 1),
              startPoint = _handles[0];
            var translatedToCanvasPt = _this3.$getController().$translatePoint({
              point: startPoint,
              from: 'overlay',
              to: canvasPane
            });
            var geom = overlayGeom.translate(translatedToCanvasPt.x - startPoint.x, translatedToCanvasPt.y - startPoint.y);
            return _this3.$insertNewPath(geom);
          }
        }).then(function () {
          return _this3.$clearTracker();
        });
      }

      /**
       * 
       * @private
       * @param {module:nmodule/gx/rc/baja/PathGeom} geom 
       * @returns {Promise}
       */
    }, {
      key: "$insertNewPath",
      value: function $insertNewPath(geom) {
        var _this4 = this;
        var widget = baja.$('bajaui:Path', {
          geom: geom,
          stroke: baja.$('gx:Brush', 'black')
        });
        var parentNode = getOriginatingNode(this.$canvasPane);
        return parentNode.insert([{
          object: widget
        }]).then(function () {
          return _this4.$getController().$getUxBuilder().rerender();
        });
      }

      /**
       * @private
       * @param {{ x: number, y: number }} overlayPoint 
       * @param {boolean} shiftKeyDown 
       * @returns {{ x: number, y: number }}
       */
    }, {
      key: "$snap",
      value: function $snap(overlayPoint, shiftKeyDown) {
        // TODO NCCB-70593
        /* const uxBuilderProps = this.$controller.$getUxBuilder().properties();
        const useSnap = uxBuilderProps.getValue('useSnap') && !shiftKeyDown;
        const snapSize = uxBuilderProps.getValue('snapSize');
        if (useSnap) {
          return applySnapToPoint(snapSize, overlayPoint);
        } */
        return overlayPoint;
      }

      /**
       * @private
       */
    }, {
      key: "$clearTracker",
      value: function $clearTracker() {
        this.$overlayGeom = PathGeom.DEFAULT;
        this.$widget = null;
        this.$handles = [];
        this.$bars = [];
        this.emit('geomUpdate');
      }

      /**
       * @private
       * @param {module:nmodule/bajaui/rc/ux/shape/Shape} widget 
       * @param {number} overlayX 
       * @param {number} overlayY 
       * @returns {module:nmodule/gx/rc/baja/LineGeom|module:nmodule/gx/rc/baja/PathGeom} 
       */
    }, {
      key: "$makeGeom",
      value: function $makeGeom(widget, overlayX, overlayY) {
        var geom = new PathGeom();
        var handles = this.$handles,
          bars = this.$bars;
        var len = handles.length;
        if (len === 0) {
          return null;
        }
        // All points are overlay based
        // h = handle point
        // a = start point (always starts at the handle)
        // b = end point 
        var h = [],
          a = [],
          b = [];
        handles.forEach(function (handle, i) {
          var p = handle;
          h[i] = {
            x: p.x,
            y: p.y
          };
          p = bars[i];
          if (p) {
            a[i] = {
              x: p.x,
              y: p.y
            };
            var dx = a[i].x - h[i].x;
            var dy = a[i].y - h[i].y;
            b[i] = {
              x: h[i].x - dx,
              y: h[i].y - dy
            };
          }
        });
        h[len] = {
          x: overlayX,
          y: overlayY
        };
        var newPathSegments = []; // size of len + 1
        newPathSegments[0] = new PathGeom.MoveTo(true, h[0].x, h[0].y);
        // First segment
        if (!a[0]) {
          if (!a[1]) {
            newPathSegments[1] = new PathGeom.LineTo(true, h[1].x, h[1].y);
          } else {
            newPathSegments[1] = new PathGeom.QuadTo(true, b[1].x, b[1].y, h[1].x, h[1].y);
          }
        } else {
          if (!a[1]) {
            newPathSegments[1] = new PathGeom.QuadTo(true, a[0].x, a[0].y, h[1].x, h[1].y);
          } else {
            newPathSegments[1] = new PathGeom.CurveTo(true, a[0].x, a[0].y, b[1].x, b[1].y, h[1].x, h[1].y);
          }
        }

        // Draw rest of the segments
        for (var i = 2; i < len + 1; i++) {
          if (!a[i - 1]) {
            if (!a[i]) {
              newPathSegments[i] = new PathGeom.LineTo(true, h[i].x, h[i].y);
            } else {
              newPathSegments[i] = new PathGeom.QuadTo(true, b[i].x, b[i].y, h[i].x, h[i].y);
            }
          } else {
            if (!a[i]) {
              newPathSegments[i] = new PathGeom.SmoothQuadTo(true, h[i].x, h[i].y);
            } else {
              newPathSegments[i] = new PathGeom.SmoothCurveTo(true, b[i].x, b[i].y, h[i].x, h[i].y);
            }
          }
        }
        geom.$setSegments(newPathSegments);
        widget.properties().setValue('geom', geom);
        return geom;
      }

      /**
       * @private
       */
    }, {
      key: "$getWidget",
      value: function $getWidget() {
        return this.$widget;
      }
    }]);
  }(Tracker);
});
