function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SmoothCurveToArtisan
 */

define(['nmodule/gx/rc/baja/PathGeom', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandle', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SegmentArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/segmentArtisanUtil'], function (PathGeom, wysiwygUtils, PathHandle, PathHandleRole, SegmentArtisan, segmentArtisanUtil) {
  'use strict';

  var getParentLastBuiltWidget = wysiwygUtils.getParentLastBuiltWidget;
  var nextPoint = segmentArtisanUtil.nextPoint,
    mirror = segmentArtisanUtil.mirror;
  var SmoothCurveTo = PathGeom.SmoothCurveTo;

  /**
   * @inner
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SmoothCurveToArtisan~SmoothCurveToRole
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole
   */
  var SmoothCurveToRole = /*#__PURE__*/function (_PathHandleRole) {
    function SmoothCurveToRole(orig, segmentIdx, isAbsolute, which, p0, p2, mirror) {
      var _this;
      _classCallCheck(this, SmoothCurveToRole);
      _this = _callSuper(this, SmoothCurveToRole, [orig, segmentIdx, isAbsolute]);
      _this.$which = which;
      _this.$p0 = p0;
      _this.$p2 = p2;
      _this.$isMirror = !!mirror;
      return _this;
    }
    _inherits(SmoothCurveToRole, _PathHandleRole);
    return _createClass(SmoothCurveToRole, [{
      key: "translate",
      value: function translate(path, dx, dy) {
        var p0 = this.$p0,
          p2 = this.$p2,
          orig = this.$orig,
          which = this.$which,
          mirror = this.$isMirror;
        if (which === 0) {
          return new SmoothCurveTo(true, p2.x, p2.y, orig.x + dx, orig.y + dy);
        } else {
          if (mirror) {
            var z = this.$mirror(p0, {
              x: orig.x + dx,
              y: orig.y + dy
            });
            return new SmoothCurveTo(true, z.x, z.y, p0.x, p0.y);
          } else {
            return new SmoothCurveTo(true, orig.x + dx, orig.y + dy, p0.x, p0.y);
          }
        }
      }
    }]);
  }(PathHandleRole);
  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SmoothCurveToArtisan
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SegmentArtisan
   */
  return /*#__PURE__*/function (_SegmentArtisan) {
    function SmoothCurveToArtisan() {
      _classCallCheck(this, SmoothCurveToArtisan);
      return _callSuper(this, SmoothCurveToArtisan, arguments);
    }
    _inherits(SmoothCurveToArtisan, _SegmentArtisan);
    return _createClass(SmoothCurveToArtisan, [{
      key: "addHandles",
      value: function addHandles(path, refPt, handlesMap, segmentIdx, canvasHandlesMap) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();
        var endPt = segment.getEnd();
        var nextPt = nextPoint(refPt, isAbsolute, endPt.x(), endPt.y());
        var cp2 = segment.getCp2();
        var p2a = nextPoint(refPt, isAbsolute, cp2.x(), cp2.y());
        var p2b = mirror(nextPt, p2a);
        var canvasPane = getParentLastBuiltWidget(path);
        var translatedNextPt = this.translatePoint({
          point: {
            x: nextPt.x(),
            y: nextPt.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var translatedP2a = this.translatePoint({
          point: {
            x: p2a.x(),
            y: p2a.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var translatedP2b = this.translatePoint({
          point: {
            x: p2b.x(),
            y: p2b.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var nextPtRole = new SmoothCurveToRole(translatedNextPt, segmentIdx, isAbsolute, 0, translatedNextPt, translatedP2a);
        var p2aRole = new SmoothCurveToRole(translatedP2a, segmentIdx, isAbsolute, 1, translatedNextPt, translatedP2a, false);
        var p2bRole = new SmoothCurveToRole(translatedP2b, segmentIdx, isAbsolute, 1, translatedNextPt, translatedP2b, true);
        handlesMap.push(new PathHandle('s' + handlesMap.length, translatedNextPt.x, translatedNextPt.y, path, nextPtRole));
        handlesMap.push(new PathHandle('s' + handlesMap.length, translatedP2a.x, translatedP2a.y, path, p2aRole));
        handlesMap.push(new PathHandle('s' + handlesMap.length, translatedP2b.x, translatedP2b.y, path, p2bRole));

        // Setup the handles in canvas coords
        canvasHandlesMap.push(new PathHandle('s' + canvasHandlesMap.length, nextPt.x(), nextPt.y(), path, new SmoothCurveToRole(nextPt.toJson(), segmentIdx, isAbsolute, 0, nextPt.toJson(), p2a.toJson())));
        canvasHandlesMap.push(new PathHandle('s' + canvasHandlesMap.length, p2a.x(), p2a.y(), path, new SmoothCurveToRole(p2a.toJson(), segmentIdx, isAbsolute, 1, nextPt.toJson(), p2a.toJson(), false)));
        canvasHandlesMap.push(new PathHandle('s' + canvasHandlesMap.length, p2b.x(), p2b.y(), path, new SmoothCurveToRole(p2b.toJson(), segmentIdx, isAbsolute, 1, nextPt.toJson(), p2b.toJson(), true)));
        return nextPt;
      }
    }, {
      key: "paintPathBars",
      value: function paintPathBars(path, refPt, handlesMap, ctx) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();
        var endPt = segment.getEnd();
        var nextPt = nextPoint(refPt, isAbsolute, endPt.x(), endPt.y());
        var cp2 = segment.getCp2();
        var p2a = nextPoint(refPt, isAbsolute, cp2.x(), cp2.y());
        var p2b = mirror(nextPt, p2a);
        this.$paintPathBar(ctx, path, p2a, p2b);
        return nextPt;
      }
    }, {
      key: "paintHandles",
      value: function paintHandles(path, refPt, handlesMap, ctx) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();
        var endPt = segment.getEnd();
        var nextPt = nextPoint(refPt, isAbsolute, endPt.x(), endPt.y());
        this.$paintHandle(ctx, path, nextPt);
        return nextPt;
      }
    }]);
  }(SegmentArtisan);
});
