function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SegmentArtisan
 */

define(['nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Artisan'], function (wysiwygUtils, Artisan) {
  'use strict';

  var getParentLastBuiltWidget = wysiwygUtils.getParentLastBuiltWidget;
  var PATH_HANDLE_COLOR = 'lime';
  var PATH_BAR_COLOR = 'fuchsia';

  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SegmentArtisan
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Artisan
   */
  return /*#__PURE__*/function (_Artisan) {
    function SegmentArtisan(segment, controller) {
      var _this;
      _classCallCheck(this, SegmentArtisan);
      _this = _callSuper(this, SegmentArtisan, [controller]);
      _this.$segment = segment;
      return _this;
    }
    _inherits(SegmentArtisan, _Artisan);
    return _createClass(SegmentArtisan, [{
      key: "paintHandles",
      value: function paintHandles() {
        throw new Error('paintHandles() not implemented.');
      }
    }, {
      key: "paintPathBars",
      value: function paintPathBars() {
        throw new Error('paintPathBars() not implemented.');
      }

      /**
       * @private
       * @param {CanvasRenderingContext2D} ctx 
       * @param {module:nmodule/bajaui/rc/ux/shape/Path} path
       * @param {module:nmodule/gx/rc/baja/Point} point 
       * @param {string} [color]
       */
    }, {
      key: "$paintHandle",
      value: function $paintHandle(ctx, path, point, color) {
        var canvasPane = getParentLastBuiltWidget(path);
        var _this$translatePoint = this.translatePoint({
            point: {
              x: point.x(),
              y: point.y()
            },
            from: canvasPane,
            to: 'overlay'
          }),
          x = _this$translatePoint.x,
          y = _this$translatePoint.y;
        var handleSize = this.getHandleSize();
        var n = handleSize * 2 + 1;
        ctx.strokeStyle = 'black';
        ctx.fillStyle = color || PATH_HANDLE_COLOR;
        ctx.strokeRect(x - handleSize, y - handleSize, n, n);
        ctx.fillRect(x - handleSize, y - handleSize, n, n);
      }

      /**
       * Paint the guide handles and the line connecting them 
       * @private
       * @param {CanvasRenderingContext2D} ctx 
       * @param {module:nmodule/bajaui/rc/ux/shape/Path} path
       * @param {module:nmodule/gx/rc/baja/Point} a 
       * @param {module:nmodule/gx/rc/baja/Point} b 
       */
    }, {
      key: "$paintPathBar",
      value: function $paintPathBar(ctx, path, a, b) {
        this.$paintHandle(ctx, path, a, PATH_BAR_COLOR);
        this.$paintHandle(ctx, path, b, PATH_BAR_COLOR);

        // Draw the connecting line
        this.$paintLine(ctx, path, a, b);
      }

      /**
       * @private
       * @param {CanvasRenderingContext2D} ctx  
       * @param {module:nmodule/bajaui/rc/ux/shape/Path} path
       * @param {module:nmodule/gx/rc/baja/Point} a 
       * @param {module:nmodule/gx/rc/baja/Point} b 
       */
    }, {
      key: "$paintLine",
      value: function $paintLine(ctx, path, a, b) {
        var canvasPane = getParentLastBuiltWidget(path);
        var _this$translatePoint2 = this.translatePoint({
            point: {
              x: a.x(),
              y: a.y()
            },
            from: canvasPane,
            to: 'overlay'
          }),
          x1 = _this$translatePoint2.x,
          y1 = _this$translatePoint2.y;
        var _this$translatePoint3 = this.translatePoint({
            point: {
              x: b.x(),
              y: b.y()
            },
            from: canvasPane,
            to: 'overlay'
          }),
          x2 = _this$translatePoint3.x,
          y2 = _this$translatePoint3.y;
        ctx.beginPath();
        ctx.moveTo(x1, y1);
        ctx.lineTo(x2, y2);
        ctx.strokeStyle = PATH_BAR_COLOR;
        ctx.stroke();
      }
    }]);
  }(Artisan);
});
