function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/QuadToArtisan
 */

define(['nmodule/gx/rc/baja/PathGeom', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandle', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SegmentArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/segmentArtisanUtil'], function (PathGeom, wysiwygUtils, PathHandle, PathHandleRole, SegmentArtisan, segmentArtisanUtil) {
  'use strict';

  var getParentLastBuiltWidget = wysiwygUtils.getParentLastBuiltWidget;
  var nextPoint = segmentArtisanUtil.nextPoint,
    mirror = segmentArtisanUtil.mirror;
  var QuadTo = PathGeom.QuadTo;

  /**
   * @inner
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/QuadToArtisan~QuadToRole
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole
   */
  var QuadToRole = /*#__PURE__*/function (_PathHandleRole) {
    function QuadToRole(orig, segmentIdx, isAbsolute, which, p0, p1, mirror) {
      var _this;
      _classCallCheck(this, QuadToRole);
      _this = _callSuper(this, QuadToRole, [orig, segmentIdx, isAbsolute]);
      _this.$which = which;
      _this.$p0 = p0;
      _this.$p1 = p1;
      _this.$isMirror = !!mirror;
      return _this;
    }
    _inherits(QuadToRole, _PathHandleRole);
    return _createClass(QuadToRole, [{
      key: "translate",
      value: function translate(path, dx, dy) {
        var p0 = this.$p0,
          p1 = this.$p1,
          orig = this.$orig,
          which = this.$which,
          mirror = this.$isMirror;
        if (which === 0) {
          return new QuadTo(true, p1.x, p1.y, orig.x + dx, orig.y + dy);
        } else {
          if (mirror) {
            var z = this.$mirror(p0, {
              x: orig.x + dx,
              y: orig.y + dy
            });
            return new QuadTo(true, z.x, z.y, p0.x, p0.y);
          } else {
            return new QuadTo(true, orig.x + dx, orig.y + dy, p0.x, p0.y);
          }
        }
      }
    }]);
  }(PathHandleRole);
  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/QuadToArtisan
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SegmentArtisan
   */
  return /*#__PURE__*/function (_SegmentArtisan) {
    function QuadToArtisan() {
      _classCallCheck(this, QuadToArtisan);
      return _callSuper(this, QuadToArtisan, arguments);
    }
    _inherits(QuadToArtisan, _SegmentArtisan);
    return _createClass(QuadToArtisan, [{
      key: "addHandles",
      value: function addHandles(path, refPt, handlesMap, segmentIdx, canvasHandlesMap) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();
        var endPt = segment.getEnd();
        var nextPt = nextPoint(refPt, isAbsolute, endPt.x(), endPt.y());
        var cp = segment.getCp();
        var p1a = nextPoint(refPt, isAbsolute, cp.x(), cp.y());
        var p1b = mirror(nextPt, p1a);
        var canvasPane = getParentLastBuiltWidget(path);
        var translatedNextPt = this.translatePoint({
          point: {
            x: nextPt.x(),
            y: nextPt.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var translatedP1a = this.translatePoint({
          point: {
            x: p1a.x(),
            y: p1a.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var translatedP1b = this.translatePoint({
          point: {
            x: p1b.x(),
            y: p1b.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var nextPtRole = new QuadToRole(translatedNextPt, segmentIdx, isAbsolute, 0, translatedNextPt, translatedP1a);
        var p1aRole = new QuadToRole(translatedP1a, segmentIdx, isAbsolute, 1, translatedNextPt, translatedP1a, false);
        var p1bRole = new QuadToRole(translatedP1b, segmentIdx, isAbsolute, 1, translatedNextPt, translatedP1b, true);
        handlesMap.push(new PathHandle('q' + handlesMap.length, translatedNextPt.x, translatedNextPt.y, path, nextPtRole));
        handlesMap.push(new PathHandle('q' + handlesMap.length, translatedP1a.x, translatedP1a.y, path, p1aRole));
        handlesMap.push(new PathHandle('q' + handlesMap.length, translatedP1b.x, translatedP1b.y, path, p1bRole));

        // Setup the handles in canvas coords
        canvasHandlesMap.push(new PathHandle('q' + canvasHandlesMap.length, nextPt.x(), nextPt.y(), path, new QuadToRole(nextPt.toJson(), segmentIdx, isAbsolute, 0, nextPt.toJson(), p1a.toJson())));
        canvasHandlesMap.push(new PathHandle('q' + canvasHandlesMap.length, p1a.x(), p1a.y(), path, new QuadToRole(p1a.toJson(), segmentIdx, isAbsolute, 1, nextPt.toJson(), p1a.toJson(), false)));
        canvasHandlesMap.push(new PathHandle('q' + canvasHandlesMap.length, p1b.x(), p1b.y(), path, new QuadToRole(p1b.toJson(), segmentIdx, isAbsolute, 1, nextPt.toJson(), p1b.toJson(), true)));
        return nextPt;
      }
    }, {
      key: "paintPathBars",
      value: function paintPathBars(path, refPt, handlesMap, ctx) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();
        var endPt = segment.getEnd();
        var nextPt = nextPoint(refPt, isAbsolute, endPt.x(), endPt.y());
        var cp = segment.getCp();
        var p1a = nextPoint(refPt, isAbsolute, cp.x(), cp.y());
        var p1b = mirror(nextPt, p1a);
        this.$paintPathBar(ctx, path, p1a, p1b);
        return nextPt;
      }
    }, {
      key: "paintHandles",
      value: function paintHandles(path, refPt, handlesMap, ctx) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();
        var endPt = segment.getEnd();
        var nextPt = nextPoint(refPt, isAbsolute, endPt.x(), endPt.y());
        this.$paintHandle(ctx, path, nextPt);
        return nextPt;
      }
    }]);
  }(SegmentArtisan);
});
