function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole
 */

define(['nmodule/gx/rc/baja/PathGeom', 'nmodule/gx/rc/baja/Point', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/segmentArtisanUtil'], function (PathGeom, Point, segmentArtisanUtil) {
  'use strict';

  var mirror = segmentArtisanUtil.mirror;

  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole
   */
  return /*#__PURE__*/function () {
    /**
     * @param {{ x, y }} orig the overlay point to start plotting the next Path segment
     * @param {number} idx the segment index of the Path
     * @param {boolean} [isAbsolute=true] if the segment is absolute or relative
     */
    function PathHandleRole(orig, idx) {
      var isAbsolute = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
      _classCallCheck(this, PathHandleRole);
      this.$orig = orig;
      this.$idx = idx;
      this.$isAbsolute = !!isAbsolute;
    }

    /**
     * Given a path, apply the deltas to this handle and return the translated segment.
     * @param {module:nmodule/bajaui/rc/ux/shape/Path} path
     * @param {number} dx the x delta to apply to the segment
     * @param {number} dy the y delta to apply to the segment
     * @returns {module:nmodule/gx/rc/baja/PathGeom~Segment} the translated segment after applying deltas
     */
    return _createClass(PathHandleRole, [{
      key: "translate",
      value: function translate(path, dx, dy) {
        throw new Error('$translate() not implemented.');
      }

      /**
       * Given a path's geom, applies the translated segment and return a new PathGeom.
       * @private
       * @param {module:nmodule/gx/rc/baja/PathGeom} pathGeom
       * @param {number} dx the x delta to apply to the segment
       * @param {number} dy the y delta to apply to the segment
       * @returns {module:nmodule/gx/rc/baja/PathGeom} the new Path after applying the deltas to the segment
       */
    }, {
      key: "$apply",
      value: function $apply(pathGeom, dx, dy) {
        var translatedSegment = this.translate(pathGeom, dx, dy);
        var segments = pathGeom.$getSegments();
        segments.splice(this.$idx, 1, translatedSegment);
        var translatedGeom = new PathGeom();
        translatedGeom.$setSegments(segments);
        return translatedGeom;
      }

      /**
       * @private
       * @param {{ x, y }} p1 
       * @param {{ x, y }} p2 
       * @returns {{ x, y }}
       */
    }, {
      key: "$mirror",
      value: function $mirror(p1, p2) {
        return mirror(new Point(p1.x, p1.y), new Point(p2.x, p2.y)).toJson();
      }
    }]);
  }();
});
