function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/MoveToArtisan
 */

define(['nmodule/gx/rc/baja/PathGeom', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandle', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SegmentArtisan'], function (PathGeom, wysiwygUtils, PathHandle, PathHandleRole, SegmentArtisan) {
  'use strict';

  var getParentLastBuiltWidget = wysiwygUtils.getParentLastBuiltWidget;
  var MoveTo = PathGeom.MoveTo;

  /**
   * @inner
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/MoveToArtisan~MoveToRole
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole
   */
  var MoveToRole = /*#__PURE__*/function (_PathHandleRole) {
    function MoveToRole() {
      _classCallCheck(this, MoveToRole);
      return _callSuper(this, MoveToRole, arguments);
    }
    _inherits(MoveToRole, _PathHandleRole);
    return _createClass(MoveToRole, [{
      key: "translate",
      value: function translate(path, dx, dy) {
        var _this$$orig = this.$orig,
          x = _this$$orig.x,
          y = _this$$orig.y;
        return new MoveTo(true, x + dx, y + dy);
      }
    }, {
      key: "translateToCanvas",
      value: function translateToCanvas(dx, dy) {}
    }]);
  }(PathHandleRole);
  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/MoveToArtisan
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SegmentArtisan
   */
  var MoveToArtisan = /*#__PURE__*/function (_SegmentArtisan) {
    function MoveToArtisan() {
      _classCallCheck(this, MoveToArtisan);
      return _callSuper(this, MoveToArtisan, arguments);
    }
    _inherits(MoveToArtisan, _SegmentArtisan);
    return _createClass(MoveToArtisan, [{
      key: "addHandles",
      value: function addHandles(path, nextPt, handlesMap, segmentIdx, canvasHandlesMap) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();
        if (!isAbsolute) {
          return [];
        }
        var canvasPane = getParentLastBuiltWidget(path);
        nextPt = segment.getPoint();
        var translatedPt = this.translatePoint({
          point: {
            x: nextPt.x(),
            y: nextPt.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var moveToRole = new MoveToRole(translatedPt, segmentIdx);
        handlesMap.push(new PathHandle('m' + handlesMap.length, translatedPt.x, translatedPt.y, path, moveToRole));

        // Setup the handles in canvas coords
        canvasHandlesMap.push(new PathHandle('m' + canvasHandlesMap.length, nextPt.x(), nextPt.y(), path, new MoveToRole(nextPt.toJson(), segmentIdx)));
        return nextPt;
      }
    }, {
      key: "paintPathBars",
      value: function paintPathBars(path, nextPt, handlesMap, ctx) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();
        if (!isAbsolute) {
          return [];
        }
        nextPt = segment.getPoint();
        return nextPt;
      }
    }, {
      key: "paintHandles",
      value: function paintHandles(path, nextPt, handlesMap, ctx) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();
        if (!isAbsolute) {
          return [];
        }
        nextPt = segment.getPoint();
        this.$paintHandle(ctx, path, nextPt);
        return nextPt;
      }
    }]);
  }(SegmentArtisan);
  return MoveToArtisan;
});
