function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/CurveToArtisan
 */

define(['nmodule/gx/rc/baja/PathGeom', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandle', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SegmentArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/segmentArtisanUtil'], function (PathGeom, wysiwygUtils, PathHandle, PathHandleRole, SegmentArtisan, segmentArtisanUtil) {
  'use strict';

  var getParentLastBuiltWidget = wysiwygUtils.getParentLastBuiltWidget;
  var nextPoint = segmentArtisanUtil.nextPoint,
    mirror = segmentArtisanUtil.mirror;
  var CurveTo = PathGeom.CurveTo;

  /**
   * @inner
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/CurveToArtisan~Next
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole
   */
  var Next = /*#__PURE__*/function (_PathHandleRole) {
    function Next(orig, segmentIdx, isAbsolute, p1a, p2a) {
      var _this;
      _classCallCheck(this, Next);
      _this = _callSuper(this, Next, [orig, segmentIdx, isAbsolute]);
      _this.$p1a = p1a;
      _this.$p2a = p2a;
      return _this;
    }
    _inherits(Next, _PathHandleRole);
    return _createClass(Next, [{
      key: "translate",
      value: function translate(path, dx, dy) {
        var p1a = this.$p1a,
          p2a = this.$p2a,
          next = this.$orig;
        return new CurveTo(true, p1a.x, p1a.y, p2a.x, p2a.y, next.x + dx, next.y + dy);
      }
    }]);
  }(PathHandleRole);
  /**
   * @inner
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/CurveToArtisan~P1a
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole
   */
  var P1a = /*#__PURE__*/function (_PathHandleRole2) {
    function P1a(orig, segmentIdx, isAbsolute, p1a, p2a) {
      var _this2;
      _classCallCheck(this, P1a);
      _this2 = _callSuper(this, P1a, [orig, segmentIdx, isAbsolute]);
      _this2.$p1a = p1a;
      _this2.$p2a = p2a;
      return _this2;
    }
    _inherits(P1a, _PathHandleRole2);
    return _createClass(P1a, [{
      key: "translate",
      value: function translate(path, dx, dy) {
        var p1a = this.$p1a,
          p2a = this.$p2a,
          next = this.$orig;
        return new CurveTo(true, p1a.x + dx, p1a.y + dy, p2a.x, p2a.y, next.x, next.y);
      }
    }]);
  }(PathHandleRole);
  /**
   * @inner
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/CurveToArtisan~P1b
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole
   */
  var P1b = /*#__PURE__*/function (_PathHandleRole3) {
    function P1b(orig, segmentIdx, isAbsolute, p1b, p2a, refPt) {
      var _this3;
      _classCallCheck(this, P1b);
      _this3 = _callSuper(this, P1b, [orig, segmentIdx, isAbsolute]);
      _this3.$p1b = p1b;
      _this3.$p2a = p2a;
      _this3.$refPt = refPt;
      return _this3;
    }
    _inherits(P1b, _PathHandleRole3);
    return _createClass(P1b, [{
      key: "translate",
      value: function translate(path, dx, dy) {
        var p1b = this.$p1b;
        var p1a = this.$mirror(this.$refPt, {
            x: p1b.x + dx,
            y: p1b.y + dy
          }),
          p2a = this.$p2a,
          next = this.$orig;
        return new CurveTo(true, p1a.x, p1a.y, p2a.x, p2a.y, next.x, next.y);
      }
    }]);
  }(PathHandleRole);
  /**
   * @inner
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/CurveToArtisan~P2a
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole
   */
  var P2a = /*#__PURE__*/function (_PathHandleRole4) {
    function P2a(orig, segmentIdx, isAbsolute, p1a, p2a) {
      var _this4;
      _classCallCheck(this, P2a);
      _this4 = _callSuper(this, P2a, [orig, segmentIdx, isAbsolute]);
      _this4.$p1a = p1a;
      _this4.$p2a = p2a;
      return _this4;
    }
    _inherits(P2a, _PathHandleRole4);
    return _createClass(P2a, [{
      key: "translate",
      value: function translate(path, dx, dy) {
        var p1a = this.$p1a,
          p2a = this.$p2a,
          next = this.$orig;
        return new CurveTo(true, p1a.x, p1a.y, p2a.x + dx, p2a.y + dy, next.x, next.y);
      }
    }]);
  }(PathHandleRole);
  /**
   * @inner
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/CurveToArtisan~P2b
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole
   */
  var P2b = /*#__PURE__*/function (_PathHandleRole5) {
    function P2b(orig, segmentIdx, isAbsolute, p1a, p2b) {
      var _this5;
      _classCallCheck(this, P2b);
      _this5 = _callSuper(this, P2b, [orig, segmentIdx, isAbsolute]);
      _this5.$p1a = p1a;
      _this5.$p2b = p2b;
      return _this5;
    }
    _inherits(P2b, _PathHandleRole5);
    return _createClass(P2b, [{
      key: "translate",
      value: function translate(path, dx, dy) {
        var p1a = this.$p1a,
          p2b = this.$p2b,
          p2a = this.$mirror(this.$orig, {
            x: p2b.x + dx,
            y: p2b.y + dy
          }),
          next = this.$orig;
        return new CurveTo(true, p1a.x, p1a.y, p2a.x, p2a.y, next.x, next.y);
      }
    }]);
  }(PathHandleRole);
  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/CurveToArtisan
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SegmentArtisan
   */
  return /*#__PURE__*/function (_SegmentArtisan) {
    function CurveToArtisan() {
      _classCallCheck(this, CurveToArtisan);
      return _callSuper(this, CurveToArtisan, arguments);
    }
    _inherits(CurveToArtisan, _SegmentArtisan);
    return _createClass(CurveToArtisan, [{
      key: "addHandles",
      value: function addHandles(path, refPt, handlesMap, segmentIdx, canvasHandlesMap) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();
        var cp1 = segment.getCp1(),
          cp2 = segment.getCp2();
        var p1a = nextPoint(refPt, isAbsolute, cp1.x(), cp1.y());
        var p1b = mirror(refPt, p1a);
        var endPt = segment.getEnd();
        var nextPt = nextPoint(refPt, isAbsolute, endPt.x(), endPt.y());
        var p2a = nextPoint(refPt, isAbsolute, cp2.x(), cp2.y());
        var p2b = mirror(nextPt, p2a);
        var canvasPane = getParentLastBuiltWidget(path);
        var translatedNext = this.translatePoint({
          point: {
            x: nextPt.x(),
            y: nextPt.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var translatedP1a = this.translatePoint({
          point: {
            x: p1a.x(),
            y: p1a.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var translatedP1b = this.translatePoint({
          point: {
            x: p1b.x(),
            y: p1b.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var translatedP2a = this.translatePoint({
          point: {
            x: p2a.x(),
            y: p2a.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var translatedP2b = this.translatePoint({
          point: {
            x: p2b.x(),
            y: p2b.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var translatedRefPt = this.translatePoint({
          point: {
            x: refPt.x(),
            y: refPt.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var nextPtRole = new Next(translatedNext, segmentIdx, isAbsolute, translatedP1a, translatedP2a);
        handlesMap.push(new PathHandle('c' + handlesMap.length, translatedNext.x, translatedNext.y, path, nextPtRole));
        var p1aRole = new P1a(translatedNext, segmentIdx, isAbsolute, translatedP1a, translatedP2a);
        handlesMap.push(new PathHandle('c' + handlesMap.length, translatedP1a.x, translatedP1a.y, path, p1aRole));
        var p1bRole = new P1b(translatedNext, segmentIdx, isAbsolute, translatedP1b, translatedP2a, translatedRefPt);
        handlesMap.push(new PathHandle('c' + handlesMap.length, translatedP1b.x, translatedP1b.y, path, p1bRole));
        var p2aRole = new P2a(translatedNext, segmentIdx, isAbsolute, translatedP1a, translatedP2a);
        handlesMap.push(new PathHandle('c' + handlesMap.length, translatedP2a.x, translatedP2a.y, path, p2aRole));
        var p2bRole = new P2b(translatedNext, segmentIdx, isAbsolute, translatedP1a, translatedP2b);
        handlesMap.push(new PathHandle('c' + handlesMap.length, translatedP2b.x, translatedP2b.y, path, p2bRole));

        // Setup the handles in canvas coords
        // This is a pretty tedious process right now to avoid any significant refactor at this point.
        canvasHandlesMap.push(new PathHandle('c' + canvasHandlesMap.length, nextPt.x(), nextPt.y(), path, new Next(nextPt.toJson(), segmentIdx, isAbsolute, p1a.toJson(), p2a.toJson())));
        canvasHandlesMap.push(new PathHandle('c' + canvasHandlesMap.length, p1a.x(), p1a.y(), path, new P1a(nextPt.toJson(), segmentIdx, isAbsolute, p1a.toJson(), p2a.toJson())));
        canvasHandlesMap.push(new PathHandle('c' + canvasHandlesMap.length, p1b.x(), p1b.y(), path, new P1b(nextPt.toJson(), segmentIdx, isAbsolute, p1b.toJson(), p2a.toJson(), refPt.toJson())));
        canvasHandlesMap.push(new PathHandle('c' + canvasHandlesMap.length, p2a.x(), p2a.y(), path, new P2a(nextPt.toJson(), segmentIdx, isAbsolute, p1a.toJson(), p2a.toJson())));
        canvasHandlesMap.push(new PathHandle('c' + canvasHandlesMap.length, p2b.x(), p2b.y(), path, new P2b(nextPt.toJson(), segmentIdx, isAbsolute, p1a.toJson(), p2b.toJson())));
        return nextPt;
      }
    }, {
      key: "paintPathBars",
      value: function paintPathBars(path, refPt, handlesMap, ctx) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();
        var endPt = segment.getEnd();
        var nextPt = nextPoint(refPt, isAbsolute, endPt.x(), endPt.y());
        var cp1 = segment.getCp1(),
          cp2 = segment.getCp2();
        var p1a = nextPoint(refPt, isAbsolute, cp1.x(), cp1.y());
        var p1b = mirror(refPt, p1a);
        var p2a = nextPoint(refPt, isAbsolute, cp2.x(), cp2.y());
        var p2b = mirror(nextPt, p2a);
        this.$paintPathBar(ctx, path, p1a, p1b);
        this.$paintPathBar(ctx, path, p2a, p2b);
        return nextPt;
      }
    }, {
      key: "paintHandles",
      value: function paintHandles(path, refPt, handlesMap, ctx) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();
        var endPt = segment.getEnd();
        var nextPt = nextPoint(refPt, isAbsolute, endPt.x(), endPt.y());
        this.$paintHandle(ctx, path, nextPt);
        return nextPt;
      }
    }]);
  }(SegmentArtisan);
});
