function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/ArcToArtisan
 */

define(['nmodule/gx/rc/baja/PathGeom', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandle', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SegmentArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/segmentArtisanUtil'], function (PathGeom, wysiwygUtils, PathHandle, PathHandleRole, SegmentArtisan, segmentArtisanUtil) {
  'use strict';

  var getParentLastBuiltWidget = wysiwygUtils.getParentLastBuiltWidget;
  var nextPoint = segmentArtisanUtil.nextPoint;
  var ArcTo = PathGeom.ArcTo;

  /**
   * @inner
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/ArcToArtisan~Next
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole
   */
  var Next = /*#__PURE__*/function (_PathHandleRole) {
    function Next(orig, segmentIdx, isAbsolute, radPt, arc) {
      var _this;
      _classCallCheck(this, Next);
      _this = _callSuper(this, Next, [orig, segmentIdx, isAbsolute]);
      _this.$radPt = radPt;
      _this.$arc = arc;
      return _this;
    }
    _inherits(Next, _PathHandleRole);
    return _createClass(Next, [{
      key: "translate",
      value: function translate(path, dx, dy) {
        var arc = this.$arc,
          next = this.$orig,
          radPt = this.$radPt;
        return new ArcTo(this.$isAbsolute, radPt.x + dx, radPt.y + dy, arc.getXAxisRotation(), arc.getLargeArcFlag(), arc.getSweepFlag(), next.x + dx, next.y + dy);
      }
    }]);
  }(PathHandleRole);
  /**
   * @inner
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/ArcToArtisan~Radius
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/PathHandleRole
   */
  var Radius = /*#__PURE__*/function (_PathHandleRole2) {
    function Radius(orig, segmentIdx, isAbsolute, nextPt, arc) {
      var _this2;
      _classCallCheck(this, Radius);
      _this2 = _callSuper(this, Radius, [orig, segmentIdx, isAbsolute]);
      _this2.$next = nextPt;
      _this2.$arc = arc;
      return _this2;
    }
    _inherits(Radius, _PathHandleRole2);
    return _createClass(Radius, [{
      key: "translate",
      value: function translate(path, dx, dy) {
        var arc = this.$arc,
          radPt = this.$orig,
          next = this.$next;
        return new ArcTo(this.$isAbsolute, radPt.x + dx, radPt.y + dy, arc.getXAxisRotation(), arc.getLargeArcFlag(), arc.getSweepFlag(), next.x, next.y);
      }
    }]);
  }(PathHandleRole);
  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/ArcToArtisan
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SegmentArtisan
   */
  return /*#__PURE__*/function (_SegmentArtisan) {
    function ArcToArtisan() {
      _classCallCheck(this, ArcToArtisan);
      return _callSuper(this, ArcToArtisan, arguments);
    }
    _inherits(ArcToArtisan, _SegmentArtisan);
    return _createClass(ArcToArtisan, [{
      key: "addHandles",
      value: function addHandles(path, refPt, handlesMap, segmentIdx, canvasHandlesMap) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();
        // Add the radial point
        var radPt = nextPoint(refPt, isAbsolute, segment.getRadiusX(), segment.getRadiusY());
        var pt = segment.getEnd();
        var nextPt = nextPoint(refPt, isAbsolute, pt.x(), pt.y());
        var canvasPane = getParentLastBuiltWidget(path);
        var translatedNextPt = this.translatePoint({
          point: {
            x: nextPt.x(),
            y: nextPt.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var translatedRadPt = this.translatePoint({
          point: {
            x: radPt.x(),
            y: radPt.y()
          },
          from: canvasPane,
          to: 'overlay'
        });
        var nextRole = new Next(translatedNextPt, segmentIdx, isAbsolute, radPt.toJson(), segment);
        handlesMap.push(new PathHandle('a' + handlesMap.length, translatedNextPt.x, translatedNextPt.y, path, nextRole));
        var radRole = new Radius(radPt.toJson(), segmentIdx, isAbsolute, translatedNextPt, segment);
        handlesMap.push(new PathHandle('a' + handlesMap.length, translatedRadPt.x, translatedRadPt.y, path, radRole));

        // Setup the handles in canvas coords
        canvasHandlesMap.push(new PathHandle('a' + canvasHandlesMap.length, nextPt.x(), nextPt.y(), path, new Next(nextPt.toJson(), segmentIdx, isAbsolute, radPt.toJson(), segment)));
        canvasHandlesMap.push(new PathHandle('a' + canvasHandlesMap.length, radPt.x(), radPt.y(), path, new Radius(radPt.toJson(), segmentIdx, isAbsolute, nextPt.toJson(), segment)));
        return nextPt;
      }
    }, {
      key: "paintPathBars",
      value: function paintPathBars(path, refPt, handlesMap, ctx) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();

        // Add the radial point
        var radPt = nextPoint(refPt, isAbsolute, segment.getRadiusX(), segment.getRadiusY());
        var pt = segment.getEnd();
        var nextPt = nextPoint(refPt, isAbsolute, pt.x(), pt.y());
        this.$paintPathBar(ctx, path, refPt, radPt);
        this.$paintPathBar(ctx, path, nextPt, radPt);
        return nextPt;
      }
    }, {
      key: "paintHandles",
      value: function paintHandles(path, refPt, handlesMap, ctx) {
        var segment = this.$segment,
          isAbsolute = segment.getAbsolute();

        // Add the radial point
        var radPt = nextPoint(refPt, isAbsolute, segment.getRadiusX(), segment.getRadiusY());
        var pt = segment.getEnd();
        var nextPt = nextPoint(refPt, isAbsolute, pt.x(), pt.y());
        this.$paintHandle(ctx, path, nextPt);
        this.$paintHandle(ctx, path, radPt, 'fuchsia');
        return nextPt;
      }
    }]);
  }(SegmentArtisan);
});
