function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/ShapeArtisan
 */

/* eslint-env browser */

define(['log!nmodule.uxBuilder.rc.ux.wysiwyg.artisans.ShapeArtisan', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Artisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Handle'], function (log, wysiwygUtils, Artisan, Handle) {
  'use strict';

  var debugEnabled = log.isLoggable('FINEST');
  var getParentLastBuiltWidget = wysiwygUtils.getParentLastBuiltWidget,
    roundLayoutRectangle = wysiwygUtils.roundLayoutRectangle;

  /**
   * @class
   * @abstract
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/ShapeArtisan
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Artisan
   */
  return /*#__PURE__*/function (_Artisan) {
    function ShapeArtisan() {
      _classCallCheck(this, ShapeArtisan);
      return _callSuper(this, ShapeArtisan, arguments);
    }
    _inherits(ShapeArtisan, _Artisan);
    return _createClass(ShapeArtisan, [{
      key: "addHandles",
      value: function addHandles(widget) {
        var handlesMap = this.getHandlesMap();
        var points = this.getTranslatedPoints(widget);
        points.forEach(function (_ref, i) {
          var x = _ref.x,
            y = _ref.y;
          handlesMap.push(new Handle('p' + i, x, y, widget));
        });
      }
    }, {
      key: "paint",
      value: function paint(widget, ctx) {
        var _this = this;
        var handlesMap = this.getHandlesMap();
        // paint the handles
        handlesMap.forEach(function (handle) {
          return _this.$paintHandle(ctx, handle.getX(), handle.getY(), handle.getName());
        });
      }

      /**
       * @param {module:nmodule/bajaui/rc/ux/shape/Shape} shape
       * @param {{ x: number, y: number }} desiredOverlayPoint
       * @param {number} [idx] index of the point to translate
       * @returns {baja.Simple} the translated geom of the shape (gx:LineGeom|gx:PathGeom|gx:PolygonGeom)
       */
    }, {
      key: "getTranslatedGeom",
      value: function getTranslatedGeom(shape, desiredOverlayPoint, idx) {
        var canvasPane = this.$getCanvasPane(shape);
        var currentLayout = roundLayoutRectangle(this.translateRect({
          rect: shape,
          from: 'overlay',
          to: canvasPane
        }));
        var desiredLayoutPoint = this.translatePoint({
          point: desiredOverlayPoint,
          from: 'overlay',
          to: canvasPane
        });
        var deltaX = desiredLayoutPoint.x - currentLayout.x;
        var deltaY = desiredLayoutPoint.y - currentLayout.y;
        return shape.properties().getValue('geom').translate(deltaX, deltaY, idx);
      }

      /**
       * @private
       * @param {module:nmodule/bajaui/rc/ux/shape/Shape} shape
       * @returns {module:nmodule/bajaui/rc/ux/CanvasPane}
       */
    }, {
      key: "$getCanvasPane",
      value: function $getCanvasPane(shape) {
        return getParentLastBuiltWidget(shape);
      }

      /**
       * @private
       * @param {CanvasRenderingContext2D} ctx 
       * @param {Number} x 
       * @param {Number} y 
       * @param {string} handleName 
       */
    }, {
      key: "$paintHandle",
      value: function $paintHandle(ctx, x, y, handleName) {
        var handleSize = this.getHandleSize();
        var n = handleSize * 2 + 1;
        ctx.strokeStyle = 'black';
        ctx.fillStyle = 'lime';
        ctx.strokeRect(x - handleSize, y - handleSize, n, n);
        if (debugEnabled) {
          ctx.font = "15px serif";
          ctx.strokeText(handleName, x - handleSize, y - handleSize * 2);
        }
        ctx.fillRect(x - handleSize, y - handleSize, n, n);
      }

      /**
       * Translate the Shape's geometry to points relative to the overlay.
       * @param {module:bajaux/Widget} widget 
       * @returns {Array.<{ x: number, y: number }>}
       */
    }, {
      key: "getTranslatedPoints",
      value: function getTranslatedPoints(widget) {
        throw new Error('getTranslatedPoints() not implemented.');
      }

      /**
       * Return the start point of the same with the passed in geom
       * Note: PathArtisan overrides this method to return the Path start
       * @private
       * @param {module:nmodule/gx/rc/baja/LineGeom} geom 
       * @returns {module:nmodule/gx/rc/baja/Point}
       */
    }, {
      key: "$getStartingPoint",
      value: function $getStartingPoint(geom) {
        return geom.getPoints()[0];
      }
    }]);
  }(Artisan);
});
