function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/RectangularArtisan
 */

/* eslint-env browser */

define(['nmodule/js/rc/tinyevents/tinyevents', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Artisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Handle', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/RectangularHandleTracker'], function (tinyevents, Artisan, Handle, RectangularHandleTracker) {
  'use strict';

  /**
   * @since Niagara 4.15
   * @class
   * @alian module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/RectangularArtisan 
   */
  return /*#__PURE__*/function (_Artisan) {
    function RectangularArtisan() {
      var _this;
      _classCallCheck(this, RectangularArtisan);
      _this = _callSuper(this, RectangularArtisan, arguments);
      tinyevents(_this);
      return _this;
    }
    _inherits(RectangularArtisan, _Artisan);
    return _createClass(RectangularArtisan, [{
      key: "addHandles",
      value: function addHandles(widget) {
        var handlesMap = this.getHandlesMap();
        var _this$toOverlayBox = this.toOverlayBox(widget),
          x = _this$toOverlayBox.x,
          y = _this$toOverlayBox.y,
          w = _this$toOverlayBox.w,
          h = _this$toOverlayBox.h;
        handlesMap.push(new Handle('nw', x, y, widget));
        handlesMap.push(new Handle('ne', x + w, y, widget));
        handlesMap.push(new Handle('sw', x, y + h, widget));
        handlesMap.push(new Handle('se', x + w, y + h, widget));
        handlesMap.push(new Handle('w', x, y + h / 2, widget));
        handlesMap.push(new Handle('e', x + w, y + h / 2, widget));
        handlesMap.push(new Handle('n', x + w / 2, y, widget));
        handlesMap.push(new Handle('s', x + w / 2, y + h, widget));
      }

      /**
       * @override
       * @param {CanvasRenderingContext2D} ctx 
       */
    }, {
      key: "paint",
      value: function paint(widget, ctx) {
        var _this2 = this;
        var handlesMap = this.getHandlesMap(),
          _this$toOverlayBox2 = this.toOverlayBox(widget),
          x = _this$toOverlayBox2.x,
          y = _this$toOverlayBox2.y,
          w = _this$toOverlayBox2.w,
          h = _this$toOverlayBox2.h;
        ctx.lineWidth = 1;
        ctx.strokeStyle = 'lime';
        ctx.strokeRect(x, y, w, h);

        // paint the handles
        handlesMap.forEach(function (handle) {
          return _this2.$paintHandle(ctx, handle.getX(), handle.getY());
        });
        this.emit('paintComplete', widget);
      }

      /**
       * 
       * @inheritdoc
       */
    }, {
      key: "makeHandleTracker",
      value: function makeHandleTracker(handle, controller, canvasPane, x, y, _ref) {
        var _ref$preserveAspectRa = _ref.preserveAspectRatio,
          preserveAspectRatio = _ref$preserveAspectRa === void 0 ? false : _ref$preserveAspectRa;
        var selectedWidgets = controller.getSelectedWidgets();
        return new RectangularHandleTracker(this, controller, canvasPane, selectedWidgets, x, y, handle, preserveAspectRatio);
      }

      /**
       * @private
       * @param {CanvasRenderingContext2D} ctx 
       * @param {Number} x 
       * @param {Number} y 
       */
    }, {
      key: "$paintHandle",
      value: function $paintHandle(ctx, x, y) {
        var handleSize = this.getHandleSize();
        var n = handleSize * 2 + 1;
        ctx.strokeStyle = 'black';
        ctx.fillStyle = 'lime';
        ctx.strokeRect(x - handleSize, y - handleSize, n, n);
        ctx.fillRect(x - handleSize, y - handleSize, n, n);
      }
    }]);
  }(Artisan);
});
