function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/PolygonArtisan
 */

/* eslint-env browser */

define(['nmodule/bajaui/rc/ux/shape/Polygon', 'nmodule/gx/rc/baja/PolygonGeom', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/ShapeArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/PolygonHandleTracker'], function (Polygon, PolygonGeom, wysiwygUtils, ShapeArtisan, PolygonHandleTracker) {
  'use strict';

  var getParentLastBuiltWidget = wysiwygUtils.getParentLastBuiltWidget,
    nearest = wysiwygUtils.nearest,
    getIndexOfHandle = wysiwygUtils.getIndexOfHandle;

  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/PolygonArtisan
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/ShapeArtisan
   */
  return /*#__PURE__*/function (_ShapeArtisan) {
    function PolygonArtisan() {
      _classCallCheck(this, PolygonArtisan);
      return _callSuper(this, PolygonArtisan, arguments);
    }
    _inherits(PolygonArtisan, _ShapeArtisan);
    return _createClass(PolygonArtisan, [{
      key: "getTranslatedPoints",
      value:
      /**
       * Translate the Polygon's geometry to be relative to the overlay.
       *
       * @override
       * @private
       * @param {module:nmodule/bajaui/rc/ux/shape/Polygon} polygon
       * @returns {Array.<{ x: number, y: number }>} the points in the polygon's `PolygonGeom`,
       * translated to be relative to the overlay.
       */
      function getTranslatedPoints(polygon) {
        var _this = this;
        var canvasPane = getParentLastBuiltWidget(polygon);
        var polygonGeom = polygon.properties().getValue('geom');
        return polygonGeom.getPoints().map(function (point) {
          return _this.translatePoint({
            point: {
              x: point.x(),
              y: point.y()
            },
            from: canvasPane,
            to: 'overlay'
          });
        });
      }

      /**
       * 
       * @inheritdoc
       */
    }, {
      key: "makeHandleTracker",
      value: function makeHandleTracker(handle, controller, canvasPane, x, y) {
        var selectedWidgets = controller.getSelectedWidgets();
        return new PolygonHandleTracker(this, controller, canvasPane, selectedWidgets, x, y, handle);
      }
    }, {
      key: "getShapeCtor",
      value: function getShapeCtor() {
        return Polygon;
      }

      /**
       * Maybe this is not an Artisan's job?
       * Add a new point to an existing Polygon and return the modified geom
       * @private
       * @param {{ x, y }} point the "overlay" point to add to an existing Polygon
       * @param {module:nmodule/bajaui/rc/ux/shape/Polygon} polygon 
       * @returns {module:nmodule/gx/rc/baja/PolygonGeom}
       */
    }, {
      key: "$addPoint",
      value: function $addPoint(point, polygon) {
        var _this2 = this;
        // First we translate the existing polygon points to overlay and insert the new point
        // Next we re-translate the overlay points relative to the canvas and make a new geom.
        var translatedPoints = this.getTranslatedPoints(polygon);
        var nearestIdx = nearest(point, translatedPoints, true);
        if (nearestIdx === translatedPoints.length - 1) {
          translatedPoints.push(point);
        } else {
          translatedPoints.splice(nearestIdx + 1, 0, point);
        }
        var canvasPane = getParentLastBuiltWidget(polygon);
        var retranslatedPoints = translatedPoints.map(function (point) {
          return _this2.translatePoint({
            point: point,
            from: 'overlay',
            to: canvasPane
          });
        });
        return new PolygonGeom(retranslatedPoints.map(function (pt) {
          return pt.x;
        }), retranslatedPoints.map(function (pt) {
          return pt.y;
        }), retranslatedPoints.length);
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Handle} handle 
       * @returns {module:nmodule/gx/rc/baja/PolygonGeom}
       */
    }, {
      key: "$deletePoint",
      value: function $deletePoint(handle) {
        var index = getIndexOfHandle(handle);
        var polygon = handle.getWidget(),
          geom = polygon.properties().getValue('geom');
        if (geom.size() <= 3) {
          return geom;
        } // cannot make a polygon with less than 3 points  
        var points = geom.getPoints();
        points.splice(index, 1);
        return new PolygonGeom(points.map(function (pt) {
          return pt.x();
        }), points.map(function (pt) {
          return pt.y();
        }), points.length);
      }
    }]);
  }(ShapeArtisan);
});
