function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/PathArtisan
 */

define(['log!nmodule.uxBuilder.rc.ux.wysiwyg.artisans.PathArtisan', 'nmodule/bajaui/rc/ux/shape/Path', 'nmodule/gx/rc/baja/PathGeom', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/ShapeArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/ArcToArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/CurveToArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/HLineToArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/LineToArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/MoveToArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/QuadToArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SmoothCurveToArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SmoothQuadToArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/VLineToArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/PathHandleTracker'], function (log, Path, PathGeom, wysiwygUtils, ShapeArtisan, ArcToArtisan, CurveToArtisan, HLineToArtisan, LineToArtisan, MoveToArtisan, QuadToArtisan, SmoothCurveToArtisan, SmoothQuadToArtisan, VLineToArtisan, PathHandleTracker) {
  'use strict';

  var logWarning = log.warning.bind(log); // Can be switched to fine if this become too chatty in the console

  var MoveTo = PathGeom.MoveTo,
    LineTo = PathGeom.LineTo,
    HLineTo = PathGeom.HLineTo,
    VLineTo = PathGeom.VLineTo,
    CurveTo = PathGeom.CurveTo,
    SmoothCurveTo = PathGeom.SmoothCurveTo,
    QuadTo = PathGeom.QuadTo,
    SmoothQuadTo = PathGeom.SmoothQuadTo,
    ArcTo = PathGeom.ArcTo,
    ClosePath = PathGeom.ClosePath;
  var nearest = wysiwygUtils.nearest,
    getParentLastBuiltWidget = wysiwygUtils.getParentLastBuiltWidget,
    $getPoint = wysiwygUtils.$getPoint;

  /**
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/PathArtisan
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/ShapeArtisan
   */
  return /*#__PURE__*/function (_ShapeArtisan) {
    function PathArtisan() {
      _classCallCheck(this, PathArtisan);
      return _callSuper(this, PathArtisan, arguments);
    }
    _inherits(PathArtisan, _ShapeArtisan);
    return _createClass(PathArtisan, [{
      key: "addHandles",
      value: function addHandles(path) {
        var _this = this;
        var pathGeom = path.properties().getValue('geom');
        var nextPt = this.$getStartingPoint(pathGeom);
        var handlesMap = this.getHandlesMap();
        // TODO Refactor if needed at a later point.
        // We will hold on to another map will all the handles drawn in the 
        // canvas coordinates. This is required for PathHandleTracker to resize/morph
        // correctly.
        this.$canvasHandlesMap = [];
        pathGeom.$getSegments().forEach(function (segment, i) {
          var segmentArtisan = _this.$makeSegmentArtisan(segment);
          if (segmentArtisan && nextPt) {
            nextPt = segmentArtisan.addHandles(path, nextPt, handlesMap, i, _this.$canvasHandlesMap);
          }
        });
      }
    }, {
      key: "paint",
      value: function paint(path, ctx) {
        var _this2 = this;
        var pathGeom = path.properties().getValue('geom');
        var nextPt = this.$getStartingPoint(pathGeom);
        var handlesMap = this.getHandlesMap();
        pathGeom.$getSegments().forEach(function (segment, i) {
          var segmentArtisan = _this2.$makeSegmentArtisan(segment);
          if (segmentArtisan && nextPt) {
            nextPt = segmentArtisan.paintPathBars(path, nextPt, handlesMap, ctx);
          }
        });
        nextPt = this.$getStartingPoint(pathGeom);
        pathGeom.$getSegments().forEach(function (segment, i) {
          var segmentArtisan = _this2.$makeSegmentArtisan(segment);
          if (segmentArtisan && nextPt) {
            nextPt = segmentArtisan.paintHandles(path, nextPt, handlesMap, ctx);
          }
        });
      }
    }, {
      key: "makeHandleTracker",
      value: function makeHandleTracker(handle, controller, canvasPane, overlayX, overlayY) {
        return new PathHandleTracker(this, controller, canvasPane, [], overlayX, overlayY, handle);
      }
    }, {
      key: "getShapeCtor",
      value: function getShapeCtor() {
        return Path;
      }

      /**
       * @private
       * @param {module:nmodule/gx/rc/baja/PathGeom~Segment} segment 
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/path/SegmentArtisan}
       */
    }, {
      key: "$makeSegmentArtisan",
      value: function $makeSegmentArtisan(segment) {
        var controller = this.$controller;
        if (segment instanceof ArcTo) {
          return new ArcToArtisan(segment, controller);
        } else if (segment instanceof CurveTo) {
          return new CurveToArtisan(segment, controller);
        } else if (segment instanceof HLineTo) {
          return new HLineToArtisan(segment, controller);
        } else if (segment instanceof LineTo) {
          return new LineToArtisan(segment, controller);
        } else if (segment instanceof MoveTo) {
          return new MoveToArtisan(segment, controller);
        } else if (segment instanceof QuadTo) {
          return new QuadToArtisan(segment, controller);
        } else if (segment instanceof SmoothCurveTo) {
          return new SmoothCurveToArtisan(segment, controller);
        } else if (segment instanceof SmoothQuadTo) {
          return new SmoothQuadToArtisan(segment, controller);
        } else if (segment instanceof VLineTo) {
          return new VLineToArtisan(segment, controller);
        }
      }

      /**
       * The handle points are already translated to overlay. This method simply uses the 
       * translated segments to return a new overlay translated geom. This translated geom is 
       * subsequently used for Path handle tracking.
       *  
       * @private
       * @returns {module:nmodule/gx/rc/baja/PathGeom} Path translated to overlay geom
       */
    }, {
      key: "$getOverlayTranslatedGeom",
      value: function $getOverlayTranslatedGeom() {
        var handlesMap = this.getHandlesMap(),
          path = handlesMap[0].getWidget();
        var translatedGeom = new PathGeom();
        var segments = [];
        handlesMap.forEach(function (handle) {
          var role = handle.getRole();
          segments[role.$idx] = segments[role.$idx] || role.translate(path, 0, 0);
        });
        // ClosePath will never have a handle, so let's make sure it is not missed in the translation
        var origGeom = path.properties().getValue('geom'),
          origSegments = origGeom.$getSegments();
        if (origSegments.length !== segments.length && origSegments[origSegments.length - 1] instanceof ClosePath) {
          segments.push(new ClosePath());
        }
        translatedGeom.$setSegments(segments);
        return translatedGeom;
      }

      /**
       * @private
       * @override
       * @param {module:nmodule/gx/rc/baja/PathGeom} geom 
       * @returns {module:nmodule/gx/rc/baja/Point}
       */
    }, {
      key: "$getStartingPoint",
      value: function $getStartingPoint(geom) {
        // Must at least have 2 segments
        var segments = geom.$getSegments();
        if (segments.length < 2) {
          logWarning('Must be made of at least 2 segments.');
          return null;
        }

        // First segment must be an absolute moveto
        var firstSegment = geom.$getSegmentByIndex(0);
        if (!(firstSegment instanceof MoveTo && firstSegment.getAbsolute())) {
          logWarning('First segment must be an absolute MoveTo.');
          return null;
        }
        return firstSegment.getPoint();
      }

      /**
       * Add a new point to an existing Path and return the modified geom
       * @private
       * @param {{ x, y }} point the "overlay" point to add to an existing Polygon
       * @param {module:nmodule/bajaui/rc/ux/shape/Path} path 
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "$addPoint",
      value: function $addPoint(point, path) {
        // First translate the Path to the new point's coordinate system (overlay)
        var translatedGeom = this.$getOverlayTranslatedGeom(),
          segments = translatedGeom.$getSegments();
        var nextPt = this.$getStartingPoint(translatedGeom).toJson();
        var translatedPoints = [nextPt];
        var oldGeom = path.properties().getValue('geom');
        segments.forEach(function (segment) {
          if (typeof segment.getPoint === 'function') {
            nextPt = segment.getPoint().toJson();
          } else if (typeof segment.getEnd === 'function') {
            nextPt = segment.getEnd().toJson();
          } else if (typeof segment.getX === 'function') {
            var x = segment.getX();
            nextPt = {
              x: segment.getAbsolute() ? x : nextPt.x + x,
              y: nextPt.y
            };
          } else if (typeof segment.getY === 'function') {
            var y = segment.getY();
            nextPt = {
              x: nextPt.x,
              y: segment.getAbsolute() ? y : nextPt.y + y
            };
          }
          translatedPoints.push(nextPt);
        });
        var nearestIdx = nearest(point, translatedPoints, false);
        if (nearestIdx === 0) {
          // First segment always has to be an absolute MoveTo, so just return the original geom
          return oldGeom;
        }
        // Translate the overlay point to canvas and then insert the new point into the geom
        // by adding a line segment from the nearest segment index that was determined above.
        var canvasPane = getParentLastBuiltWidget(path);
        var translatedPt = this.translatePoint({
          point: point,
          from: 'overlay',
          to: canvasPane
        });
        var segmentstoModify = oldGeom.$getSegments();
        var newLineSegment = new LineTo(true, translatedPt.x, translatedPt.y);
        segmentstoModify.splice(nearestIdx, 0, newLineSegment);
        var newGeom = new PathGeom();
        newGeom.$setSegments(segmentstoModify);
        return newGeom;
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Handle} handle 
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "$deletePoint",
      value: function $deletePoint(handle) {
        var polygon = handle.getWidget(),
          geom = polygon.properties().getValue('geom');
        var indexOfSegmentToDelete = handle.getSegmentIndex();
        var segments = geom.$getSegments(),
          len = segments.length;
        if (len <= 2 || len === 3 && len[2] instanceof ClosePath) {
          return geom;
        }
        if (indexOfSegmentToDelete === 0) {
          var _segments = _slicedToArray(segments, 2),
            firstSegment = _segments[0],
            nextSegment = _segments[1],
            point = $getPoint(nextSegment, firstSegment.getPoint().toJson());
          var newMoveToSegment = new MoveTo(true, point.x, point.y);
          segments[0] = newMoveToSegment;
          segments.splice(1, 1);
        } else {
          segments.splice(indexOfSegmentToDelete, 1);
        }
        geom.$setSegments(segments);
        return geom;
      }
    }]);
  }(ShapeArtisan);
});
