function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Handle
 */

define(['nmodule/bajaui/rc/ux/shape/Ellipse', 'nmodule/bajaui/rc/ux/shape/Rect', 'nmodule/bajaui/rc/ux/shape/Shape'], function (Ellipse, Rect, Shape) {
  'use strict';

  /**
   * Factor used to decide the size and style of a handle that is painted 
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Artisan~HandleSize
   */
  var HandleSize = Object.freeze({
    SMALL: 2,
    LARGE: 3
  });
  function isValidName(name) {
    var regex = /\b(?:nw|ne|sw|se|w|e|n|s)\b/;
    return regex.test(name);
  }
  function getMouseStyle(name, widget) {
    if (widget instanceof Shape && !(widget instanceof Ellipse) && !(widget instanceof Rect)) {
      return 'move';
    }
    return isValidName(name) ? name + '-resize' : 'none';
  }

  /**
   * A handle is the rectangular artifact drawn around a widget on selection.
   * It represents the points used for resizing a widget in various directions.
   * 
   * @since Niagara 4.15
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Handle
   */
  var Handle = /*#__PURE__*/function () {
    /**
     * 
     * @param {string} name required and used to set the correct cursor on this handle
     * @param {Number} x x coordinate of this handle, relative to the overlay
     * @param {Number} y y coordinate of this handle, relative to the overlay
     * @param {module:bajaux/Widget} widget 
     */
    function Handle(name, x, y, widget) {
      _classCallCheck(this, Handle);
      this.$x = x;
      this.$y = y;
      this.$mouseStyle = getMouseStyle(name, widget);
      this.$widget = widget;
      this.$name = name;
    }
    return _createClass(Handle, [{
      key: "getName",
      value: function getName() {
        return this.$name;
      }
    }, {
      key: "getX",
      value: function getX() {
        return this.$x;
      }
    }, {
      key: "getY",
      value: function getY() {
        return this.$y;
      }
    }, {
      key: "getMouseStyle",
      value: function getMouseStyle() {
        return this.$mouseStyle;
      }
    }, {
      key: "getWidget",
      value: function getWidget() {
        return this.$widget;
      }
    }, {
      key: "getBoundingBox",
      value: function getBoundingBox(artisan) {
        var handleSize = artisan.getHandleSize();
        var n = handleSize * 2 + 1;
        return {
          x: this.getX() - handleSize,
          y: this.getY() - handleSize,
          w: n,
          h: n
        };
      }

      /**
       * 
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Handle} handle 
       * @returns {boolean}
       */
    }, {
      key: "sameAs",
      value: function sameAs(handle) {
        return this.getMouseStyle() === handle.getMouseStyle() && this.getWidget() === handle.getWidget();
      }
    }]);
  }();
  Handle.HandleSize = HandleSize;

  /**
   * An object with available handle sizes to use for drawing around a selected widget
   * 
   * @typedef module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Artisan~HandleSize
   */

  return Handle;
});
