function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/ArtisanFactory
 */

define(['nmodule/bajaui/rc/ux/shape/Ellipse', 'nmodule/bajaui/rc/ux/shape/Line', 'nmodule/bajaui/rc/ux/shape/Path', 'nmodule/bajaui/rc/ux/shape/Polygon', 'nmodule/bajaui/rc/ux/shape/Rect', 'nmodule/gx/rc/baja/RectGeom', 'nmodule/gx/rc/baja/EllipseGeom', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/AbstractRectArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/LineArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/PathArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/PolygonArtisan', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/RectangularArtisan'], function (Ellipse, Line, Path, Polygon, Rect, RectGeom, EllipseGeom, AbstractRectArtisan, LineArtisan, PathArtisan, PolygonArtisan, RectangularArtisan) {
  'use strict';

  /**
   * Creates the appropriate Artisan for a widget type
   *
   * @since Niagara 4.15
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/ArtisanFactory
   */
  return /*#__PURE__*/function () {
    function ArtisanFactory() {
      _classCallCheck(this, ArtisanFactory);
    }
    return _createClass(ArtisanFactory, null, [{
      key: "makeArtisan",
      value:
      /**
       * @param {module:bajaux/Widget} widget
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController} controller
       * @param {boolean} [markHandles=true] marks handle points on the widget when true
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Artisan}
       */
      function makeArtisan(widget, controller) {
        var markHandles = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
        var artisan;
        if (widget instanceof Line) {
          artisan = new LineArtisan(controller);
        } else if (widget instanceof Polygon) {
          artisan = new PolygonArtisan(controller);
        } else if (widget instanceof Path) {
          artisan = new PathArtisan(controller);
        } else if (widget instanceof Rect) {
          artisan = new AbstractRectArtisan(controller, Rect, RectGeom);
        } else if (widget instanceof Ellipse) {
          artisan = new AbstractRectArtisan(controller, Ellipse, EllipseGeom);
        } else {
          artisan = new RectangularArtisan(controller);
        }
        if (markHandles) {
          artisan.addHandles(widget);
        }
        return artisan;
      }
    }]);
  }();
});
