function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Artisan
 */

define(['bajaux/Widget', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Handle'], function (Widget, wysiwygUtils, Handle) {
  'use strict';

  var HandleSize = Handle.HandleSize;
  var toLayoutRectangle = wysiwygUtils.toLayoutRectangle;

  /**
   * Handles logic related to painting additional info to "decorate" widgets on the screen,
   * typically by adding handles (green squares) at touchpoints for the user to click and drag.
   *  
   * @since Niagara 4.15
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Artisan
   */
  return /*#__PURE__*/function () {
    function Artisan(controller) {
      _classCallCheck(this, Artisan);
      if (!controller) {
        throw new Error('controller required');
      }
      this.$controller = controller;
      this.$handlesMap = [];
      this.$handleSize = HandleSize.LARGE;
    }
    return _createClass(Artisan, [{
      key: "getHandleSize",
      value: function getHandleSize() {
        return this.$handleSize;
      }
    }, {
      key: "setHandleSize",
      value: function setHandleSize(handleSize) {
        this.$handleSize = handleSize;
      }
    }, {
      key: "addHandles",
      value: function addHandles(widget) {
        throw new Error('addHandles() not implemented.');
      }

      /**
       * 
       * @returns {object}
       */
    }, {
      key: "bounds",
      value: function bounds(widget) {
        var jq = widget && widget.jq();
        return toLayoutRectangle(jq && jq[0].getBoundingClientRect());
      }

      /**
       * @abstract
       * @param {module:bajaux/Widget} widget
       * @param {CanvasRenderingContext2D} ctx
       */
    }, {
      key: "paint",
      value: function paint(widget, ctx) {
        throw new Error('paint() not implemented.');
      }
    }, {
      key: "getHandlesMap",
      value: function getHandlesMap() {
        return this.$handlesMap;
      }

      /**
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController~PointTranslation} params
       * @returns {{ x: number, y: number }}
       */
    }, {
      key: "translatePoint",
      value: function translatePoint(params) {
        return this.$controller.$translatePoint(params);
      }

      /**
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController~RectTranslation} params
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle}
       */
    }, {
      key: "translateRect",
      value: function translateRect(params) {
        return this.$controller.$translateRect(params);
      }

      /**
       * @param {module:bajaux/Widget} widget
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle} the widget's bounding box on
       * screen, relative to the overlay
       */
    }, {
      key: "toOverlayBox",
      value: function toOverlayBox(widget) {
        return this.translateRect({
          rect: widget,
          to: 'overlay'
        });
      }

      /**
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Handle} handle 
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController} controller 
       * @param {module:nmodule/bajaui/rc/ux/CanvasPane} canvasPane
       * @param {Number} overlayX 
       * @param {Number} overlayY 
       * @param {object} [params] 
       */
    }, {
      key: "makeHandleTracker",
      value: function makeHandleTracker(handle, controller, canvasPane, overlayX, overlayY, params) {
        throw new Error('makeHandleTracker() not implemented.');
      }
    }]);
  }();
});
