function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/artisans/AbstractRectArtisan
 */

define(['nmodule/bajaui/rc/ux/shape/Rect', 'nmodule/gx/rc/baja/RectGeom', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/RectangularArtisan'], function (Rect, RectGeom, wysiwygUtils, RectangularArtisan) {
  'use strict';

  var getParentLastBuiltWidget = wysiwygUtils.getParentLastBuiltWidget;

  /**
   * Supports the translation for the shapes Rect and Ellipse.
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/AbstractRectArtisan
   * @extends module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/RectangularArtisan
   */
  return /*#__PURE__*/function (_RectangularArtisan) {
    /**
     * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController} controller
     * @param {function} ShapeCtor
     * @param {function} GeomCtor
     */
    function AbstractRectArtisan(controller, ShapeCtor, GeomCtor) {
      var _this;
      _classCallCheck(this, AbstractRectArtisan);
      _this = _callSuper(this, AbstractRectArtisan, [controller]);
      _this.$shape = ShapeCtor || Rect;
      _this.$geom = GeomCtor || RectGeom;
      return _this;
    }

    /**
     * Translates overlay rect pixels to the CanvasPane rect pixels.
     *
     * @param {module:nmodule/bajaui/rc/ux/shape/Rect} rect
     * @param {module:nmodule/bajaui/rc/baja/Layout~Rectangle} desiredOverlayRect
     * @returns {baja.Simple}
     */
    _inherits(AbstractRectArtisan, _RectangularArtisan);
    return _createClass(AbstractRectArtisan, [{
      key: "getTranslatedGeom",
      value: function getTranslatedGeom(rect, desiredOverlayRect) {
        var canvasPane = this.$getParentWidget(rect);
        var desiredCanvasPaneRect = this.translateRect({
          rect: desiredOverlayRect,
          from: 'overlay',
          to: canvasPane
        });
        var Geom = this.$geom;
        return new Geom(desiredCanvasPaneRect.x, desiredCanvasPaneRect.y, desiredCanvasPaneRect.w, desiredCanvasPaneRect.h);
      }

      /**
       * Returns shape's point translated from 'CanvasPane' to 'overlay'.
       *
       * @param {module:nmodule/bajaui/rc/ux/shape/Shape} shape
       * @returns {Array.<{x: number, y: number}>}
       */
    }, {
      key: "getTranslatedPoints",
      value: function getTranslatedPoints(shape) {
        var canvasPane = this.$getParentWidget(shape);
        var shapeGeom = shape.properties().getValue('geom');
        return [this.translatePoint({
          point: {
            x: shapeGeom.$point.$x,
            y: shapeGeom.$point.$y
          },
          from: canvasPane,
          to: 'overlay'
        })];
      }

      /**
       * @private
       * @param {module:nmodule/bajaui/rc/ux/shape/Shape} shape
       * @returns {module:bajaux/Widget|*} the parent widget
       */
    }, {
      key: "$getParentWidget",
      value: function $getParentWidget(shape) {
        return getParentLastBuiltWidget(shape);
      }

      /**
       * PxShapeOverlayPainter will use this shape constructor to render.
       *
       * @returns {function} constructor
       */
    }, {
      key: "getShapeCtor",
      value: function getShapeCtor() {
        return this.$shape;
      }

      /**
       * Returns the start point (top left) of an Ellipse/Rect shape
       * @private
       * @param {module:nmodule/gx/rc/baja/EllipseGeom|module:nmodule/gx/rc/baja/RectGeom} geom 
       * @returns {module:nmodule/gx/rc/baja/Point}
       */
    }, {
      key: "$getStartingPoint",
      value: function $getStartingPoint(geom) {
        return geom.$point;
      }
    }]);
  }(RectangularArtisan);
});
