function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio
 * @since Niagara 4.15
 */

define(['baja!', 'baja!gx:LineGeom', 'lex!uxBuilder', 'log!nmodule.uxBuilder.rc.ux.wysiwyg.PxArtisanStudio', 'bajaux/spandrel', 'bajaux/spandrel/logging', 'bajaux/spandrel/util', 'bajaux/dragdrop/dragDropUtils', 'bajaux/events', 'bajaux/model/UxModel', 'bajaux/Widget', 'jquery', 'Promise', 'nmodule/bajaui/rc/ux/BorderPane', 'nmodule/bajaui/rc/ux/CanvasPane', 'nmodule/bajaui/rc/ux/EdgePane', 'nmodule/bajaui/rc/ux/FlowPane', 'nmodule/bajaui/rc/ux/GridPane', 'nmodule/bajaui/rc/ux/LabelPane', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/bajaui/rc/ux/PxWidget', 'nmodule/bajaui/rc/ux/ScrollPane', 'nmodule/bajaui/rc/ux/SplitPane', 'nmodule/bajaui/rc/ux/TabbedPane', 'nmodule/bajaui/rc/ux/shape/Path', 'nmodule/bajaui/rc/ux/shape/Polygon', 'nmodule/bajaui/rc/ux/shape/Rect', 'nmodule/bajaui/rc/ux/shape/Shape', 'nmodule/uxBuilder/rc/util/uxBuilderEvents', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/util/wysiwygUtils', 'nmodule/uxBuilder/rc/ux/wysiwyg/artisans/ArtisanFactory', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/AddPathTracker', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/PointTracker', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/AddPolygonTracker', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/DefaultTracker', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/MoveTracker', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/RubberBandTracker', 'nmodule/uxBuilder/rc/ux/wysiwyg/trackers/SelectedTracker', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport', 'nmodule/webEditors/rc/wb/profile/selectionModeSettings'], function (baja, types, lexs, log, spandrel, logging, util, dragDropUtils, events, UxModel, Widget, $, Promise, BorderPane, CanvasPane, EdgePane, FlowPane, GridPane, LabelPane, NullWidget, PxWidget, ScrollPane, SplitPane, TabbedPane, Path, Polygon, Rect, Shape, uxBuilderEvents, uxBuilderUtils, wysiwygUtils, ArtisanFactory, AddPathTracker, PointTracker, AddPolygonTracker, DefaultTracker, MoveTracker, RubberBandTracker, SelectedTracker, feDialogs, htmlUtils, addContextMenuSupport, selectionModeSettings) {
  'use strict';

  var finestLoggable = log.isLoggable('FINEST');
  var logFinest = log.finest.bind(log);
  var logSevere = log.severe.bind(log);
  var widgetName = logging.widgetName;
  var makeArtisan = ArtisanFactory.makeArtisan;
  var getNormalizedCoords = wysiwygUtils.getNormalizedCoords,
    getParentLastBuiltWidget = wysiwygUtils.getParentLastBuiltWidget,
    getWidgetsToMove = wysiwygUtils.getWidgetsToMove,
    isCanvasPaneChild = wysiwygUtils.isCanvasPaneChild,
    isMultitouch = wysiwygUtils.isMultitouch,
    isWobble = wysiwygUtils.isWobble,
    normalizeEventInfo = wysiwygUtils.normalizeEventInfo,
    toLayoutRectangle = wysiwygUtils.toLayoutRectangle;
  var getModel = uxBuilderUtils.getModel,
    getOriginatingNode = uxBuilderUtils.getOriginatingNode,
    isNullWidget = uxBuilderUtils.isNullWidget,
    isPane = uxBuilderUtils.isPane,
    isUxModelLocked = uxBuilderUtils.isUxModelLocked,
    repositionedAtPoint = uxBuilderUtils.repositionedAtPoint,
    requestSelection = uxBuilderUtils.requestSelection;
  var LAYOUT_CHANGED = uxBuilderEvents.LAYOUT_CHANGED;
  var UPDATE_CONTEXT_MENU = addContextMenuSupport.events.UPDATE_CONTEXT_MENU;
  var PROPERTY_CHANGED = events.PROPERTY_CHANGED;
  var getSelectionMode = selectionModeSettings.getSelectionMode,
    getSelectionModeFromEvent = selectionModeSettings.getSelectionModeFromEvent,
    TOGGLE_MODE = selectionModeSettings.TOGGLE_MODE;
  var getMultiMode = function getMultiMode(e) {
    return (e ? getSelectionModeFromEvent(e) : getSelectionMode()) === TOGGLE_MODE;
  };
  var isElement = util.isElement;
  function getShapeCtor(widget, shapeOverlay) {
    var uxBuilder = shapeOverlay.$getUxBuilder();
    if (!uxBuilder.$getPxStudio() || !widget || !(widget instanceof Shape)) {
      return;
    }
    var artisan = makeArtisan(widget, shapeOverlay.$getController(), false);
    return artisan.getShapeCtor();
  }

  /**
   * This class is responsible to paint Shape overlays.
   *
   * @since Niagara 4.15
   * @class
   * @extends module:bajaux/spandrel
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxShapeOverlayPainter
   */
  var PxShapeOverlayPainter = /*#__PURE__*/function (_spandrel) {
    function PxShapeOverlayPainter(params) {
      _classCallCheck(this, PxShapeOverlayPainter);
      return _callSuper(this, PxShapeOverlayPainter, [{
        params: params,
        defaults: {
          properties: {
            rootCssClass: '-t-PxShapeOverlayPainter'
          }
        }
      }]);
    }

    // TODO We don't have a way of drawing handles for a shape that is not part of a valid node.
    // We should come up with a different mechanism of painting these. One option is to get the 
    // paint overlay's canvas context and just paint them directly.
    /* layoutFinished() {
      const { handles, bars } = this.state();
      // TODO Paint the handles and bars
    } */
    _inherits(PxShapeOverlayPainter, _spandrel);
    return _createClass(PxShapeOverlayPainter, [{
      key: "toState",
      value: function toState() {
        return {
          geom: null,
          widget: null,
          handles: [],
          bars: []
        };
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/UxBuilder}
       */
    }, {
      key: "$getUxBuilder",
      value: function $getUxBuilder() {
        return this.properties().getValue('uxBuilder');
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayPainter}
       */
    }, {
      key: "$getController",
      value: function $getController() {
        return this.$getUxBuilder().$getPxStudio().$getPxOverlayController();
      }
    }]);
  }(spandrel(function (value, _ref) {
    var widget = _ref.widget,
      geom = _ref.geom,
      self = _ref.self;
    var Ctor = getShapeCtor(widget, self);
    return Ctor && spandrel.jsx(Ctor, {
      className: "-t-PxShapeOverlayPainter-content",
      properties: {
        geom: geom,
        stroke: baja.$('gx:Brush', 'black')
      }
    });
  }));
  /**
   * This class is responsible to paint artifacts like rubberband, lime rectangles, etc.
   * on a canvas overlay on the PxWidget.
   *
   * @since Niagara 4.15
   * @class
   * @extends module:bajaux/spandrel
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayPainter
   */
  var PxOverlayPainter = /*#__PURE__*/function (_spandrel2) {
    function PxOverlayPainter(params) {
      _classCallCheck(this, PxOverlayPainter);
      return _callSuper(this, PxOverlayPainter, [{
        params: params,
        defaults: {
          properties: {
            rootCssClass: '-t-PxOverlayPainter'
          }
        }
      }]);
    }

    /**
     * @param {Array.<module:nmodule/bajaui/rc/baja/Layout~Rectangle>} rubberBands
     * @param {Array.<module:bajaux/Widget>} selectedWidgets
     */
    _inherits(PxOverlayPainter, _spandrel2);
    return _createClass(PxOverlayPainter, [{
      key: "paint",
      value: function paint() {
        var rubberBands = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
        var selectedWidgets = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        var ctx = this.$getPaintContext();
        rubberBands.forEach(function (_ref2) {
          var x = _ref2.x,
            y = _ref2.y,
            w = _ref2.w,
            h = _ref2.h;
          ctx.strokeRect(x, y, w, h);
        });
        this.paintSelected(selectedWidgets, ctx);
      }
    }, {
      key: "paintSelected",
      value: function paintSelected() {
        var _this = this;
        var selectedWidgets = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
        var ctx = arguments.length > 1 ? arguments[1] : undefined;
        ctx = ctx || this.$getPaintContext();
        selectedWidgets.forEach(function (selectedWidget) {
          var artisan = makeArtisan(selectedWidget, _this.$getController());
          artisan.paint(selectedWidget, ctx);
        });
      }

      /**
       * @private
       * @returns {CanvasRenderingContext2D}
       */
    }, {
      key: "$getPaintContext",
      value: function $getPaintContext() {
        var jq = this.jq();
        var parent = jq.parent();
        var canvas = jq;
        canvas.prop('width', parent.width());
        canvas.prop('height', parent.height());
        return canvas[0].getContext('2d');
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/UxBuilder}
       */
    }, {
      key: "$getUxBuilder",
      value: function $getUxBuilder() {
        return this.properties().getValue('uxBuilder');
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayPainter}
       */
    }, {
      key: "$getController",
      value: function $getController() {
        return this.$getUxBuilder().$getPxStudio().$getPxOverlayController();
      }
    }]);
  }(spandrel(function () {
    return spandrel.jsx("canvas", null);
  }));
  /**
   * This class is responsible to route all the mouse/touch interactions to their respective
   * handlers/trackers.
   *
   * @since Niagara 4.15
   * @class
   * @extends module:bajaux/spandrel
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController
   */
  var PxOverlayController = /*#__PURE__*/function (_spandrel3) {
    function PxOverlayController(params) {
      var _this2;
      _classCallCheck(this, PxOverlayController);
      _this2 = _callSuper(this, PxOverlayController, [{
        params: params,
        defaults: {
          properties: {
            rootCssClass: '-t-PxOverlayController'
          }
        }
      }]);
      addContextMenuSupport(_this2);
      _this2.$tracker = new DefaultTracker(_this2);
      _this2.$selectedWidgets = [];
      _this2.$mousemoveHandler = function (e) {
        Promise.resolve(_this2.$mousemove(e))["catch"](logSevere);
      };
      _this2.$mouseupHandler = function (e) {
        _this2.$setMousemoveListenerGlobal(false);
        Promise.resolve(_this2.$mouseup(e))["catch"](logSevere);
      };
      return _this2;
    }

    /**
     * @private
     * @returns {JQuery} the overlay element that receives all mouse events
     */
    _inherits(PxOverlayController, _spandrel3);
    return _createClass(PxOverlayController, [{
      key: "$getInterceptorElement",
      value: function $getInterceptorElement() {
        return this.jq().children('.-t-PxOverlayController-mouse-interceptor');
      }

      /**
       * @returns {boolean}
       */
    }, {
      key: "supportsContextMenuAccelerators",
      value: function supportsContextMenuAccelerators() {
        return true;
      }

      /**
       * @returns {boolean}
       */
    }, {
      key: "contextMenuReadyOnMouseDown",
      value: function contextMenuReadyOnMouseDown() {
        return false;
      }
    }, {
      key: "getContextMenuSelector",
      value: function getContextMenuSelector() {
        return '.-t-PxOverlayController-mouse-interceptor';
      }

      /**
       * @returns {Promise.<module:bajaux/commands/CommandGroup>}
       */
    }, {
      key: "toContextMenuCommandGroup",
      value: function toContextMenuCommandGroup(e) {
        var _this3 = this;
        var uxBuilder = this.$getUxBuilder();
        var uxBuilderProps = uxBuilder.properties();
        var useSnap = uxBuilderProps.getValue('useSnap') && !e.shiftKey;
        var snapSize = useSnap ? uxBuilderProps.getValue('snapSize') : undefined;
        if (e.type === UPDATE_CONTEXT_MENU) {
          return uxBuilder.$makeContextMenuCommandGroup({
            snapSize: snapSize
          });
        }
        return Promise.resolve(e.originalEvent instanceof MouseEvent && this.$mouseup(e)).then(function () {
          var _this3$getSelectedWid = _this3.getSelectedWidgets(),
            _this3$getSelectedWid2 = _slicedToArray(_this3$getSelectedWid, 1),
            entity = _this3$getSelectedWid2[0];
          if (entity instanceof CanvasPane) {
            /*
            this sort of matches how PxEditor decides where to paste: when it generates the right
            click menu, it also holds on to the last coordinates the right click menu was generated
            (popupX/popupY). later on when you paste, it queries "where did the user right click
            last" to decide where to put the thing. results in slightly goofy behavior: copy ->
            right-click anywhere -> esc to close -> ctrl-v -> it goes where you last right-clicked.
            nbd.
            wish it could be less stateful (give position to PasteCommand itself), but it would be
            nice to have a better-defined mechanism to specify the point where ctrl-V goes someday,
            so the position info has to sit around in state somewhere.
             */
            var canvasPane = entity;
            var targetPoint = canvasPane.$getPositionRelativeToViewPane(e);
            uxBuilder.$beforeInsert = function (models) {
              return repositionedAtPoint(targetPoint, models, canvasPane, snapSize);
            };
          } else {
            delete uxBuilder.$beforeInsert;
          }
          e.preventDefault();
          e.stopImmediatePropagation();
          return uxBuilder.$makeContextMenuCommandGroup({
            snapSize: snapSize
          });
        });
      }

      /**
       * Ensure mousemove works correctly from the start.
       * @returns {*}
       */
    }, {
      key: "doInitialize",
      value: function doInitialize() {
        this.$setMousemoveListenerGlobal(false);
        return _superPropGet(PxOverlayController, "doInitialize", this, 3)(arguments);
      }

      /**
       * Clean up any lingering event handlers from the document.
       * @returns {*}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        $(document).off('mousemove', this.$mousemoveHandler).off('mouseup', this.$mouseupHandler);
        return _superPropGet(PxOverlayController, "doDestroy", this, 3)(arguments);
      }
    }, {
      key: "toState",
      value: function toState() {
        return {
          tracker: new DefaultTracker(this),
          selectedWidgets: []
        };
      }

      /**
       * Stores the currently selected widgets. This will not trigger a rerender itself: knowledge of
       * what widgets are selected will just be used by upcoming rerenders.
       *
       * @private
       * @param {Array.<module:bajaux/Widget>} selectedWidgets
       * @returns {Promise}
       * @see #setSelectedWidgets
       */
    }, {
      key: "$setSelectedWidgets",
      value: function $setSelectedWidgets(selectedWidgets) {
        this.$selectedWidgets = selectedWidgets;
        return Promise.resolve();
      }

      /**
       * Stores the currently selected widgets, and performs additional processing: requests the
       * UxBuilder to highlight the selected nodes, and paints the corresponding lime rectangles.
       *
       * @param {Array.<module:bajaux/Widget>} widgets
       * @param {boolean} silent true if the UxBuilder should *not* be requested to highlight the
       * selected nodes (set this to true when the selection is programmatic and not in response to
       * user input)
       * @returns {Promise}
       */
    }, {
      key: "setSelectedWidgets",
      value: function setSelectedWidgets() {
        var _this4 = this;
        var widgets = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
        var silent = arguments.length > 1 ? arguments[1] : undefined;
        return this.$setSelectedWidgets(widgets).then(function () {
          return !silent && requestSelection(widgets.map(function (w) {
            return getOriginatingNode(w);
          }), true);
        }).then(function () {
          var jq = _this4.jq();
          if (jq) {
            var domInterceptor = _this4.$getInterceptorElement();
            htmlUtils.suggestFocus(domInterceptor); // needed for spy
            domInterceptor.trigger(UPDATE_CONTEXT_MENU);
          }
          _this4.paintSelected();
        });
      }
    }, {
      key: "paintSelected",
      value: function paintSelected() {
        if (this.$isPxStudioReady()) {
          var selectedWidgets = this.getSelectedWidgets();
          var painter = this.$getPainter();
          painter.paintSelected(selectedWidgets);
        }
      }

      /**
       * @returns {Promise}
       */
    }, {
      key: "setDefaultTracker",
      value: function setDefaultTracker() {
        return this.setTracker(new DefaultTracker(this));
      }

      /**
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker} the currently active
       * tracker
       */
    }, {
      key: "getTracker",
      value: function getTracker() {
        return this.$tracker;
      }

      /**
       * Sets the current tracker for the controller. This will not trigger a rerender: nothing needs
       * to be painted yet until the tracker does something.
       *
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/trackers/Tracker} tracker
       * @returns {Promise}
       */
    }, {
      key: "setTracker",
      value: function setTracker(tracker) {
        this.$tracker = tracker;
        return Promise.resolve();
      }

      /**
       * @returns {Array<module:bajaux/Widget>}
       */
    }, {
      key: "getSelectedWidgets",
      value: function getSelectedWidgets() {
        return this.$selectedWidgets;
      }

      /**
       * @private
       * @returns {boolean}
       */
    }, {
      key: "$isPxStudioReady",
      value: function $isPxStudioReady() {
        var uxBuilder = this.$getUxBuilder();
        return !!uxBuilder.$getPxStudio();
      }

      /**
       *
       * @private
       * @param {module:bajaux/Widget} widget
       * @param {boolean} multiMode
       * @returns {Promise}
       */
    }, {
      key: "$select",
      value: function $select(widget, multiMode) {
        var _this5 = this;
        var selectedWidgets = this.getSelectedWidgets();
        var newSelectedWidgets = [widget];
        var node = getOriginatingNode(widget);
        var requestSelection = true;
        if (multiMode) {
          var index = selectedWidgets.indexOf(widget);
          newSelectedWidgets = selectedWidgets.slice();
          if (index !== -1) {
            newSelectedWidgets.splice(index, 1);
            requestSelection = false;
          } else {
            newSelectedWidgets.push(widget);
          }
        }
        var prom = requestSelection ? node.requestSelection(multiMode ? 'toggle' : 'exclusive') : node.requestDeselection();
        return this.$setSelectedWidgets(newSelectedWidgets).then(function () {
          return _this5.paintSelected();
        }).then(function () {
          return prom;
        });
      }

      /**
       * @private
       * @param {Number} overlayX
       * @param {Number} overlayY
       * @param {module:bajaux/Widget} canvasPane
       * @returns {Promise}
       */
    }, {
      key: "$startRubberBandTracker",
      value: function $startRubberBandTracker(overlayX, overlayY, canvasPane) {
        var _this6 = this;
        var painter = this.$getPainter();
        var rubberBandTracker = new RubberBandTracker(this, overlayX, overlayY, canvasPane);
        rubberBandTracker.on('update', function () {
          var rubberBand = rubberBandTracker.getRubberBand();
          if (rubberBand) {
            painter.paint([rubberBand]);
          }
        });
        return this.$resetSelection().then(function () {
          return _this6.setTracker(rubberBandTracker);
        });
      }

      /**
       * @private
       * @param {Number} overlayX
       * @param {Number} overlayY
       * @param {object} entity
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Artisan} entity.artisan
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Handle} entity.handleToTrack
       * @param {boolean} preserveAspectRatio
       * @returns {Promise}
       */
    }, {
      key: "$startHandleTracker",
      value: function $startHandleTracker(overlayX, overlayY, entity, preserveAspectRatio) {
        var _this7 = this;
        // When uxBuilder is readonly do not proceed with handle tracking.
        if (this.$getUxBuilder().isReadonly()) {
          return Promise.resolve();
        }
        var artisan = entity.artisan,
          handleToTrack = entity.handleToTrack;
        var widget = handleToTrack.getWidget();
        var parent = wysiwygUtils.getParentLastBuiltWidget(widget);
        var canvasPane = wysiwygUtils.closestWidgetOfType(CanvasPane, parent);
        if (!canvasPane) {
          throw new Error('invariant: trying to resize widget not on CanvasPane');
        }
        if (!this.$canTrack(entity)) {
          return Promise.resolve();
        }
        var tracker = artisan.makeHandleTracker(handleToTrack, this, canvasPane, overlayX, overlayY, {
          preserveAspectRatio: preserveAspectRatio
        });
        tracker.on('update', function () {
          var painter = _this7.$getPainter();
          var selectedWidgets = tracker.$widgets;
          return painter.paint(tracker.$getRubberBands(), selectedWidgets);
        });
        tracker.on('geomUpdate', function () {
          var painter = _this7.$getShapeOverlayPainter();
          return painter.state({
            widget: widget,
            geom: tracker.$overlayGeom
          });
        });
        return this.setTracker(tracker);
      }

      /**
       * @private
       * @param {module:bajaux/Widget} widget 
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Artisan} 
       */
    }, {
      key: "$makeArtisan",
      value: function $makeArtisan(widget) {
        return makeArtisan(widget, this);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$resetSelection",
      value: function $resetSelection() {
        var selectedWidgets = this.getSelectedWidgets();
        return Promise.all(selectedWidgets.map(function (w) {
          return getOriginatingNode(w).requestDeselection();
        }));
      }

      /**
       * After doing a mousedown on a movable widget, start tracking the movement on that widget as
       * the user drags the mouse around.
       *
       * @private
       * @param {Number} overlayX mousedown x, in pixels, relative to top left of overlay
       * @param {Number} overlayY mousedown y, in pixels, relative to top left of overlay
       * @returns {Promise}
       */
    }, {
      key: "$startMoveTracker",
      value: function $startMoveTracker(overlayX, overlayY) {
        // When uxBuilder is readonly do not proceed with move tracking.
        if (this.$getUxBuilder().isReadonly()) {
          return Promise.resolve();
        }
        var selectedWidgets = this.getSelectedWidgets();
        var _getWidgetsToMove = getWidgetsToMove(selectedWidgets),
          widgets = _getWidgetsToMove.widgets,
          canvasPane = _getWidgetsToMove.canvasPane;
        if (!widgets.length) {
          return Promise.resolve();
        }
        var painter = this.$getPainter();
        var moveTracker = new MoveTracker(this, canvasPane, widgets, overlayX, overlayY);
        moveTracker.on('update', function () {
          var rubberBands = moveTracker.$getRubberBands();
          // Also ensure the selected widgets stay highlighted
          var selectedWidgets = moveTracker.$widgets;
          painter.paint(rubberBands, selectedWidgets);
        });
        return this.setTracker(moveTracker);
      }

      /**
       * @private
       * @param {string} geometryName 
       * @returns {Promise}
       */
    }, {
      key: "$startDrawingTracker",
      value: function $startDrawingTracker(geometryName) {
        var _this8 = this;
        // When uxBuilder is readonly do not proceed with drawing any shapes or add/delete points.
        if (this.$getUxBuilder().isReadonly()) {
          return Promise.resolve();
        }
        switch (geometryName) {
          case 'polygon':
            {
              return this.$startAddPolygonTracker();
            }
          case 'path':
            {
              return this.$startAddPathTracker();
            }
          case 'addPoint':
          case 'deletePoint':
            {
              // Select all Paths and Polygons
              return this.$selectShapes().then(function () {
                return _this8.$startPointTracker(geometryName);
              });
            }
          default:
            {
              return this.setDefaultTracker();
            }
        }
      }

      /**
       * @private
       * @returns {Promise} 
       */
    }, {
      key: "$resetDrawingTracker",
      value: function $resetDrawingTracker() {
        this.$setCursor('auto');
        var painter = this.$getShapeOverlayPainter();
        return Promise.all([painter.state({
          widget: null,
          geom: null
        }), this.setDefaultTracker()]);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$startAddPolygonTracker",
      value: function $startAddPolygonTracker() {
        var _this9 = this;
        var tracker = new AddPolygonTracker(this);
        tracker.on('geomUpdate', function () {
          var painter = _this9.$getShapeOverlayPainter();
          return painter.state({
            widget: tracker.$getWidget(),
            geom: tracker.$overlayGeom
          });
        });
        return this.setTracker(tracker);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$startAddPathTracker",
      value: function $startAddPathTracker() {
        var _this10 = this;
        var tracker = new AddPathTracker(this);
        tracker.on('geomUpdate', function () {
          var painter = _this10.$getShapeOverlayPainter();
          return painter.state({
            widget: tracker.$getWidget(),
            geom: tracker.$overlayGeom,
            handles: tracker.$handles,
            bars: tracker.$bars
          });
        });
        return this.setTracker(tracker);
      }

      /**
       * @private
       * @param {string} commandName 'addPoint' or 'deletePoint'
       * @returns {Promise}
       */
    }, {
      key: "$startPointTracker",
      value: function $startPointTracker(commandName) {
        var _this11 = this;
        var tracker = new PointTracker(this, commandName);
        tracker.on('paintHandle', function () {
          var painter = _this11.$getShapeOverlayPainter();
          return painter.state({
            widget: tracker.$getWidget(),
            geom: tracker.$overlayGeom
          });
        });
        return this.setTracker(tracker);
      }

      /**
       * @private
       * @returns {Promise} 
       */
    }, {
      key: "$selectShapes",
      value: function $selectShapes() {
        var shapeNodessToSelect = [];
        var pxWidget = this.$getPxWidget(),
          rootModel = getModel(pxWidget.$getRootWidget());
        return rootModel.visit(function (model) {
          if (model.$represents(Path) || model.$represents(Polygon)) {
            shapeNodessToSelect.push(getOriginatingNode(model));
          }
        }).then(function () {
          return requestSelection(shapeNodessToSelect);
        });
      }

      /**
       * @private
       * @param {module:bajaux/Widget} widget
       * @returns {boolean}
       */
    }, {
      key: "$isSelected",
      value: function $isSelected(widget) {
        return this.getSelectedWidgets().includes(widget);
      }

      /**
       * @private
       * @param {Number} overlayX
       * @param {Number} overlayY
       * @param {*} widget
       * @param {boolean} multiMode
       * @returns {Promise}
       */
    }, {
      key: "$handleSelect",
      value: function $handleSelect(overlayX, overlayY, widget, multiMode) {
        var _this12 = this;
        var uxBuilder = this.$getUxBuilder();
        // Don't select the widget if it is locked.
        if (isUxModelLocked(getModel(widget), uxBuilder.$getPxStudio().$getPxLayers())) {
          return Promise.resolve();
        }
        if (widget instanceof CanvasPane) {
          finestLoggable && logFinest('PxArtisanStudio: starting RubberBandTracker');
          // Start a rubber band tracker
          return this.$startRubberBandTracker(overlayX, overlayY, widget);
        } else {
          if (this.$isSelected(widget)) {
            finestLoggable && logFinest('PxArtisanStudio: mousedown on selected widget, starting SelectedTracker');
            return this.setTracker(new SelectedTracker(this, widget, overlayX, overlayY));
          }
          finestLoggable && logFinest('PxArtisanStudio: mousedown on unselected widgets, selecting and waiting for move');
          return this.$select(widget, multiMode).then(function () {
            if (!_this12.$opEvent) {
              finestLoggable && logFinest('PxArtisanStudio: mouseup happened during $select, cannot track move');
              return;
            }
            if (isPane(getModel(widget))) {
              finestLoggable && logFinest('PxArtisanStudio: widget under mousedown was a pane, so cannot move it');
              return;
            }
            // start a move tracker...
            finestLoggable && logFinest('PxArtisanStudio: starting to track movements of widget ' + widgetName(widget));
            return _this12.$startMoveTracker(overlayX, overlayY, widget);
          });
        }
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @returns {Promise}
       */
    }, {
      key: "$dragover",
      value: function $dragover(e) {
        // When uxBuilder is readonly do not proceed with the drag actions.
        if (this.$getUxBuilder().isReadonly()) {
          return Promise.resolve();
        }
        return this.$getDropEffect(e).then(function (dropEffect) {
          e.originalEvent.dataTransfer.dropEffect = dropEffect;
        });
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @returns {Promise.<string>}
       */
    }, {
      key: "$getDropEffect",
      value: function $getDropEffect(e) {
        return this.$getDropTargetInfo(e).then(function () {
          var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
            node = _ref3.node;
          var canDrop = node && node.isDropTarget();
          return canDrop ? 'copy' : 'none';
        });
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @returns {Promise}
       */
    }, {
      key: "$drop",
      value: function $drop(e) {
        var _this13 = this;
        // When uxBuilder is readonly do not proceed with drop actions.
        if (this.$getUxBuilder().isReadonly()) {
          return Promise.resolve();
        }
        return this.$getDropTargetInfo(e).then(function (_ref4) {
          var node = _ref4.node,
            beforeInsert = _ref4.beforeInsert;
          if (!(node && node.isDropTarget())) {
            return;
          }
          return _this13.$getObjectsOnClipboard(e).then(function (objects) {
            var uxBuilder = _this13.$getUxBuilder();
            var _uxBuilder$state = uxBuilder.state(),
              baseOrd = _uxBuilder$state.baseOrd,
              pxProperties = _uxBuilder$state.pxProperties,
              pxLayers = _uxBuilder$state.pxLayers;
            return node.insert(objects.map(function (object) {
              return {
                object: object
              };
            }), {
              beforeInsert: beforeInsert,
              baseOrd: baseOrd,
              pxProperties: pxProperties,
              pxLayers: pxLayers
            });
          });
        });
      }

      /**
       * @private
       * @param {JQuery.Event} dropEvent
       * @returns {Promise.<Array.<object>>} the nav nodes or UxModelTreeNodes on the clipboard
       */
    }, {
      key: "$getObjectsOnClipboard",
      value: function $getObjectsOnClipboard(dropEvent) {
        var clipboard = dropEvent.originalEvent.dataTransfer;
        return dragDropUtils.fromClipboard(clipboard).then(function (env) {
          return env.toValues();
        });
      }

      /**
       * @private
       * @returns {boolean} true if currently idle (no ongoing gesture)
       */
    }, {
      key: "$isIdle",
      value: function $isIdle() {
        return this.getTracker() instanceof DefaultTracker;
      }

      /**
       * Single point for handling events to avoid isInitialized() checks everywhere.
       * @private
       * @param {JQuery.Event} e
       * @param {function} func
       * @returns {Promise}
       */
    }, {
      key: "$handleEvent",
      value: function $handleEvent(e, func) {
        var _this14 = this;
        if (!this.isInitialized()) {
          return Promise.resolve();
        }
        return Promise.resolve(func()).then(function () {
          return _this14.$isIdle() && _this14.$setIdleCursor(e);
        });
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @returns {Promise}
       */
    }, {
      key: "$mousedown",
      value: function $mousedown(e) {
        var _arguments = arguments,
          _this15 = this;
        this.$opEvent = e;
        this.$setMousemoveListenerGlobal(true);
        var mouseupHandler = this.$mouseupHandler;
        $(document).off('mouseup', mouseupHandler).one('mouseup', mouseupHandler);
        // NCCB-68996: normalize touch event -> mouse event here?
        return this.$handleEvent(e, function () {
          var _this15$getTracker;
          return (_this15$getTracker = _this15.getTracker()).mousedown.apply(_this15$getTracker, _toConsumableArray(_arguments));
        });
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @returns {Promise}
       */
    }, {
      key: "$mousemove",
      value: function $mousemove(e) {
        var _arguments2 = arguments,
          _this16 = this;
        return this.$handleEvent(e, function () {
          var _this16$getTracker;
          return (_this16$getTracker = _this16.getTracker()).mousemove.apply(_this16$getTracker, _toConsumableArray(_arguments2));
        });
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @returns {Promise}
       */
    }, {
      key: "$wheel",
      value: function $wheel(e) {
        var _arguments3 = arguments,
          _this17 = this;
        return this.$handleEvent(e, function () {
          var _this17$getTracker;
          return (_this17$getTracker = _this17.getTracker()).wheel.apply(_this17$getTracker, _toConsumableArray(_arguments3));
        });
      }

      /**
       * the mousemove listener needs to work in two different ways.
       *
       * when "idle" (just moving mouse without pressing anything), the mousemove handler should only
       * handle events on the controller itself, and not mousemoves from off in the nav tree or
       * something.
       *
       * when "active" (during a move, drag, scroll), it should handle events from anywhere in the
       * document. this is so that when you move your mouse off the controller, it doesn't bring
       * everything to a halt.
       *
       * @private
       * @param {boolean} global true to start listening for mousemoves from anywhere in the document
       * @returns {Promise}
       */
    }, {
      key: "$setMousemoveListenerGlobal",
      value: function $setMousemoveListenerGlobal(global) {
        var handler = this.$mousemoveHandler;
        var jq = this.jq();
        var doc = $(document);
        doc.off('mousemove', handler);
        doc[global ? 'on' : 'off']('mousemove', handler);
        jq[global ? 'off' : 'on']('mousemove', handler);
      }

      /**
       * we should only handle mouseups that correspond to a mousedown that started on the controller.
       * dragging from elsewhere and then mouseupping on the controller shouldn't count. (don't worry,
       * drops are not mouseups, they still work.)
       *
       * @private
       * @param {JQuery.Event} e
       * @returns {Promise}
       */
    }, {
      key: "$mouseup",
      value: function $mouseup(e) {
        var _arguments4 = arguments,
          _this18 = this;
        return this.$handleEvent(e, function () {
          var tracker = _this18.getTracker();
          delete _this18.$opEvent;
          return Promise.resolve(tracker.mouseup.apply(tracker, _toConsumableArray(_arguments4))).then(function () {
            /*
            If a tracker's mouseup implementation ended up setting a different tracker then
            we'll give a chance to the newly set tracker to call it's mouseup before resetting
            to default. For example, with shapes svg taking the whole canvas, any click first hits the
            shape and creates a PassThroughTracker. If the clicked widget turned out to be a CanvasPane then the tracker
            ends up setting a RubberBandTracker.
            'mousemove' also may need something like this in the future but right now I have only implemented mouseup
            on a need basis.
            */
            var newTracker = _this18.getTracker();
            if (tracker !== newTracker) {
              return newTracker.mouseup.apply(newTracker, _toConsumableArray(_arguments4));
            }
          }).then(function () {
            // If we are still drawing using a Shape pen then don't switch back to default tracker.
            var uxBuilder = _this18.$getUxBuilder();
            var activePen = uxBuilder.properties().getValue('activePen');
            if (activePen) {
              return;
            }
            return _this18.setDefaultTracker();
          });
        });
      }

      /**
       * Returns true when any uxModel from the selected widgets is locked.
       * @returns {boolean}
       */
    }, {
      key: "$isAnySelectedWidgetsUxModelIsLocked",
      value: function $isAnySelectedWidgetsUxModelIsLocked() {
        var selectedWidgets = this.getSelectedWidgets();
        var uxBuilder = this.$getUxBuilder();
        return selectedWidgets.some(function (widget) {
          return isUxModelLocked(getModel(widget), uxBuilder.$getPxStudio().$getPxLayers());
        });
      }

      /**
       * return false to prevent the default behavior (like to prevent the ScrollBar from moving down when there
       * is a selection and arrow keys pressed.
       * @private
       * @param {JQuery.Event} e
       * @returns {boolean|undefined}
       */
    }, {
      key: "$keydown",
      value: function $keydown(e) {
        // UxBuilder will not process keydown events when the UxBuilder is readonly=true,
        // or if any of the selected widget's uxModel is locked.
        if (!this.isInitialized() || this.$getUxBuilder().isReadonly() || this.$isAnySelectedWidgetsUxModelIsLocked()) {
          return;
        }
        var tracker = this.getTracker();
        var result = tracker.keydown.apply(tracker, arguments);
        if (result === false) {
          return false;
        }
        Promise.resolve(result)["catch"](logSevere);
      }

      /**
       * @private
       * @param {module:bajaux/Widget|object} entity
       * @returns {String}
       */
    }, {
      key: "$getCursor",
      value: function $getCursor(entity) {
        var _ref5 = entity || {},
          handleToTrack = _ref5.handleToTrack;
        return handleToTrack ? handleToTrack.getMouseStyle() : 'default';
      }

      /**
       * @private
       * @param {JQuery.Event} event
       * @returns {boolean}
       */
    }, {
      key: "$isActiveDrag",
      value: function $isActiveDrag(event) {
        var opEvent = this.$opEvent;
        return !(event.which > 1 || isMultitouch(event) || !opEvent || isWobble(event, opEvent));
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @returns {Promise}
       */
    }, {
      key: "$dblclick",
      value: function $dblclick(e) {
        var _this19 = this;
        e.preventDefault();
        e.stopPropagation();
        // If any of the selected uxModels are locked then do not allow double click.
        if (this.$isAnySelectedWidgetsUxModelIsLocked()) {
          return Promise.resolve();
        }
        var selectedWidgets = this.getSelectedWidgets(),
          _selectedWidgets = _slicedToArray(selectedWidgets, 1),
          selected = _selectedWidgets[0];
        return Promise["try"](function () {
          if (selected instanceof Widget && _this19.$mouseOnWidgetControl(e) !== 'expandablePaneToggle') {
            var model = getModel(selected);
            if (!isNullWidget(model)) {
              var node = getOriginatingNode(model);
              return _this19.$getUxBuilder().$showWidgetPropsInDialog([node]);
            }
          }
        });
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @returns {Promise}
       */
    }, {
      key: "$click",
      value: function $click(e) {
        return this.$handleEvent(e, function () {});
      }

      /**
       * @private
       * @param {*} entity
       * @returns {boolean}
       */
    }, {
      key: "$canTrack",
      value: function $canTrack(entity) {
        var uxBuilder = this.$getUxBuilder();
        if (uxBuilder.isReadonly()) {
          return false;
        }
        if (entity instanceof Widget) {
          return isCanvasPaneChild(entity) && !isUxModelLocked(getModel(entity), uxBuilder.$getPxStudio().$getPxLayers());
        }
        var handleToTrack = entity.handleToTrack;
        if (handleToTrack) {
          var widget = handleToTrack.getWidget();
          return isCanvasPaneChild(widget) && !isUxModelLocked(getModel(widget), uxBuilder.$getPxStudio().$getPxLayers());
        }
        return true;
      }

      /**
       * @private
       * @param {string} cursor 
       */
    }, {
      key: "$setCursor",
      value: function $setCursor(cursor) {
        if (!cursor) {
          cursor = 'auto';
        }
        this.$getInterceptorElement().css('cursor', cursor);
      }

      /**
       * Sets the cursor appropriately, depending on what is under the mouse as the user idly moves it
       * around the studio (no buttons pressed).
       *
       * @private
       * @param {JQuery.Event} mouseEvent
       * @returns {Promise}
       */
    }, {
      key: "$setIdleCursor",
      value: function $setIdleCursor(mouseEvent) {
        var _this20 = this;
        // We first wait for the PxStudio to be available.
        var uxBuilder = this.$getUxBuilder();
        if (!uxBuilder.$getPxStudio()) {
          return Promise.resolve();
        }
        var cursor = 'auto';
        return this.$getEntityUnderMouse(mouseEvent).then(function (_ref6) {
          var type = _ref6.type,
            entity = _ref6.entity;
          switch (_this20.$mouseOnWidgetControl(mouseEvent)) {
            case 'splitPaneDivider':
              if (entity instanceof SplitPane) {
                cursor = entity.properties().getValue('orientation').getOrdinal() === 0 ? 'col-resize' : 'row-resize';
              }
              break;
            case 'expandablePaneToggle':
              cursor = 'pointer';
              break;
            default:
              if (type === 'handle') {
                var widget = entity.handleToTrack.getWidget();
                if (!_this20.$canTrack(widget)) {
                  cursor = 'not-allowed';
                } else {
                  cursor = entity.handleToTrack.getMouseStyle();
                }
              }
          }
        }).then(function () {
          _this20.$getInterceptorElement().css('cursor', cursor);
        });
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController~PointTranslation} params
       * @returns {{ x: number, y: number }}
       */
    }, {
      key: "$translatePoint",
      value: function $translatePoint(_ref7) {
        var point = _ref7.point,
          from = _ref7.from,
          to = _ref7.to;
        var documentPoint;
        if (from === 'overlay') {
          documentPoint = this.$overlayPointToDocumentPoint(point);
        } else if (from === 'document') {
          documentPoint = point;
        } else if (from instanceof CanvasPane) {
          documentPoint = from.$getPositionRelativeToDocument(point);
        }
        if (to === 'overlay') {
          return this.$documentPointToOverlayPoint(documentPoint);
        } else if (to === 'document') {
          return documentPoint;
        } else if (to instanceof CanvasPane) {
          return to.$getPositionRelativeToViewPane({
            pageX: documentPoint.x,
            pageY: documentPoint.y
          });
        }
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController~RectTranslation} params
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle}
       */
    }, {
      key: "$translateRect",
      value: function $translateRect(_ref8) {
        var _this21 = this;
        var rect = _ref8.rect,
          from = _ref8.from,
          to = _ref8.to;
        if (rect instanceof Widget) {
          rect = this.$getBoundingRectangle(rect);
          from = 'document';
        }
        var documentRect;
        if (from === 'overlay') {
          documentRect = transformRect(rect, function (p) {
            return _this21.$overlayPointToDocumentPoint(p);
          });
        } else if (from === 'document') {
          documentRect = rect;
        } else if (from instanceof CanvasPane) {
          documentRect = transformRect(rect, function (p) {
            return from.$getPositionRelativeToDocument(p);
          });
        }
        if (to === 'overlay') {
          return transformRect(documentRect, function (p) {
            return _this21.$documentPointToOverlayPoint(p);
          });
        } else if (to === 'document') {
          return documentRect;
        } else if (to instanceof CanvasPane) {
          return transformRect(documentRect, function (p) {
            return to.$getPositionRelativeToViewPane({
              pageX: p.x,
              pageY: p.y
            });
          });
        }
      }

      /**
       * @private
       * @param {{x: number, y: number}} documentPoint
       * @returns {{x: number, y: number}} given point, translated to be relative to the controller overlay
       */
    }, {
      key: "$documentPointToOverlayPoint",
      value: function $documentPointToOverlayPoint(documentPoint) {
        var _this$$offset = this.$offset(),
          offsetTop = _this$$offset.top,
          offsetLeft = _this$$offset.left;
        return {
          x: documentPoint.x - offsetLeft,
          y: documentPoint.y - offsetTop
        };
      }

      /**
       * @private
       * @param {{x: number, y: number}} overlayPoint
       * @returns {{x: number, y: number}} given point, translated to be relative to the document
       */
    }, {
      key: "$overlayPointToDocumentPoint",
      value: function $overlayPointToDocumentPoint(overlayPoint) {
        var _this$$offset2 = this.$offset(),
          offsetTop = _this$$offset2.top,
          offsetLeft = _this$$offset2.left;
        return {
          x: overlayPoint.x + offsetLeft,
          y: overlayPoint.y + offsetTop
        };
      }

      /**
       * @private
       * @returns {JQuery.Coordinates}
       */
    }, {
      key: "$offset",
      value: function $offset() {
        return (this.jq() || $('<div></div>')).offset();
      }

      /**
       * @private
       * @param {module:bajaux/Widget} widget
       * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle} the bounding box of the widget,
       * relative to the document
       */
    }, {
      key: "$getBoundingRectangle",
      value: function $getBoundingRectangle(widget) {
        if (widget instanceof Rect) {
          /*
          NCCB-70622: a Rect with a gradient has a big ol 45 degree rotated <g> element, so just
          getting that element's bounding box doesn't work. we have to recalculate or the selection
          box is sqrt(2) times too big.
           */
          var canvasPane = getParentLastBuiltWidget(widget);
          if (canvasPane instanceof CanvasPane) {
            var geom = widget.properties().getValue('geom');
            return this.$translateRect({
              rect: {
                x: geom.x(),
                y: geom.y(),
                w: geom.width(),
                h: geom.height()
              },
              from: canvasPane,
              to: 'document'
            });
          }
        }
        var jq = widget.jq() || $('<div></div>');
        var isShape = widget instanceof Shape;
        if (isShape) {
          jq = jq.find('svg > g');
        }
        var rect = toLayoutRectangle(jq[0].getBoundingClientRect());
        if (isShape) {
          // compensate for the 0.5 shift that gets Shapes to correctly sit on pixels
          rect.x -= 0.5;
          rect.y -= 0.5;
        }
        return rect;
      }

      /**
       * @private
       * @param {number} pageX
       * @param {number} pageY
       * @returns {Array.<module:bajaux/Widget>}
       */
    }, {
      key: "$getWidgetsUnderMouse",
      value: function $getWidgetsUnderMouse(pageX, pageY) {
        var elements = this.$elementsUnderMouse({
          pageX: pageX,
          pageY: pageY
        });
        return elements.map(function (e) {
          return Widget["in"](e instanceof SVGElement ? e.closest('.ux-Shape') : e);
        }).filter(function (w) {
          return getOriginatingNode(w);
        });
      }

      /**
       * @private
       * @param {Number} pageX
       * @param {Number} pageY
       * @returns {Promise.<module:bajaux/Widget|undefined>} the widget (one that corresponds to a real node in
       * the widget tree) under the mouse. call `getOriginatingNode` on it to get back to the tree
       * node.
       */
    }, {
      key: "$getWidgetUnderMouse",
      value: function $getWidgetUnderMouse(pageX, pageY) {
        return Promise.resolve(this.$getWidgetsUnderMouse(pageX, pageY)[0]);
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController~EntityInfo>}
       */
    }, {
      key: "$getEntityUnderMouse",
      value: function $getEntityUnderMouse(e) {
        var pxWidget = this.$getPxWidget();

        // First let us check if the mouse is on a handle
        var selectedWidgets = this.getSelectedWidgets();
        var _getNormalizedCoords = getNormalizedCoords(e, pxWidget.$getRootWidget().jq()),
          x = _getNormalizedCoords.x,
          y = _getNormalizedCoords.y;
        var handle = this.$getHandleInfoAtPoint(x, y, selectedWidgets);
        if (handle) {
          return Promise.resolve({
            type: 'handle',
            entity: handle
          });
        }
        var _normalizeEventInfo = normalizeEventInfo(e),
          pageX = _normalizeEventInfo.pageX,
          pageY = _normalizeEventInfo.pageY;
        return this.$getWidgetUnderMouse(pageX, pageY, pxWidget).then(function (widget) {
          return widget ? {
            type: 'widget',
            entity: widget
          } : {
            type: 'none'
          };
        });
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode|null>} the tree node
       * that the user is pointing at via the PxWidget
       */
    }, {
      key: "$getNodeUnderMouse",
      value: function $getNodeUnderMouse(e) {
        return this.$getEntityUnderMouse(e).then(function (_ref9) {
          var type = _ref9.type,
            entity = _ref9.entity;
          return type === 'widget' ? getOriginatingNode(entity) : null;
        });
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @returns {Promise.<{} | module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController~DropTargetInfo>} info
       * about what we're dropping on, if no node is found an empty object is returned
       */
    }, {
      key: "$getDropTargetInfo",
      value: function $getDropTargetInfo(e) {
        var _this22 = this;
        var uxBuilder = this.$getUxBuilder();
        var uxBuilderProps = uxBuilder.properties();
        var useSnap = uxBuilderProps.getValue('useSnap') && !e.shiftKey;
        var snapSize = useSnap ? uxBuilderProps.getValue('snapSize') : undefined;
        return this.$getNodeUnderMouse(e).then(function (node) {
          return _this22.$tryToGetTheDropInfo(e, node, snapSize);
        });
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @param {nmodule/uxBuilder/rc/ux/model/UxModelTreeNodenode} node
       * @param {number} snapSize
       * @returns {Promise.<{} | module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController~DropTargetInfo>} info
       * about what we're dropping on, if no node is found an empty object is returned}
       */
    }, {
      key: "$tryToGetTheDropInfo",
      value: function $tryToGetTheDropInfo(e, node, snapSize) {
        var _this23 = this;
        return this.$getDropInfo(e, node, snapSize).then(function (info) {
          return info || _this23.$tryToGetTheDropInfo(e, node.getParent(), snapSize);
        });
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @param {nmodule/uxBuilder/rc/ux/model/UxModelTreeNodenode} node
       * @param {number} snapSize
       * @returns {Promise.<{} | module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController~DropTargetInfo>} info
       * about what we're dropping on.  Will return undefined if the node is not droppable, and an empty object if there is no supplied node}
       */
    }, {
      key: "$getDropInfo",
      value: function $getDropInfo(e, node, snapSize) {
        if (!node) {
          return Promise.resolve({});
        }
        if (node.represents(FlowPane) || node.represents(GridPane) || node.represents(TabbedPane)) {
          return Promise.resolve({
            node: node
          });
        }

        // here we replicate the special drop-widgets-onto-panes behavior from BStudio#makeDropCommand
        if (node.represents(BorderPane)) {
          return node.getKid('content').then(function (contentNode) {
            return contentNode.represents(NullWidget) ? {
              node: contentNode
            } : undefined;
          });
        }
        if (node.represents(EdgePane)) {
          return node.getKid('center').then(function (centerNode) {
            return centerNode.represents(NullWidget) ? {
              node: centerNode
            } : undefined;
          });
        }
        if (node.represents(CanvasPane)) {
          var canvasPane = node.getLastBuiltWidget();
          var beforeInsert;
          try {
            var position = canvasPane.$getPositionRelativeToViewPane(e);
            beforeInsert = function beforeInsert(models) {
              return repositionedAtPoint(position, models, canvasPane, snapSize);
            };
          } catch (e) {
            logSevere(e);
          }
          return Promise.resolve({
            node: node,
            beforeInsert: beforeInsert
          });
        }
        return Promise.resolve(undefined);
      }
      /**
       * @private
       * @param {Number} x
       * @param {Number} y
       * @param {Array.<module:bajaux/Widget>} [selectedWidgets]
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayPainter~HandleInfo|undefined}
       */
    }, {
      key: "$getHandleInfoAtPoint",
      value: function $getHandleInfoAtPoint(x, y) {
        var _this24 = this;
        var selectedWidgets = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
        var handleToTrack, artisan;
        var widgetUnderMouse = selectedWidgets.find(function (selectedWidget) {
          artisan = makeArtisan(selectedWidget, _this24);
          var handlesMap = artisan.getHandlesMap();
          handleToTrack = handlesMap.find(function (handle) {
            var _handle$getBoundingBo = handle.getBoundingBox(artisan),
              handleX = _handle$getBoundingBo.x,
              handleY = _handle$getBoundingBo.y,
              w = _handle$getBoundingBo.w,
              h = _handle$getBoundingBo.h;
            return x >= handleX && y >= handleY && x <= handleX + w && y <= handleY + h;
          });
          return !!handleToTrack;
        });
        if (widgetUnderMouse) {
          return {
            artisan: artisan,
            handleToTrack: handleToTrack
          };
        }
      }

      /**
       * returns the ScrollPane if the widget is on one.
       * @private
       * @param {module:bajaux/Widget} widget
       * @returns {module:nmodule/bajaui/rc/ux/ScrollPane|undefined}
       */
    }, {
      key: "$getScrollPane",
      value: function $getScrollPane(widget) {
        return wysiwygUtils.closestWidgetOfType(ScrollPane, widget);
      }

      /**
       * @private
       * @param {module:bajaux/Widget} widget
       * @returns {module:bajaux/Widget|undefined}
       */
    }, {
      key: "$getTabbedPaneParent",
      value: function $getTabbedPaneParent(widget) {
        if (!widget) {
          return;
        }
        return Widget["in"](widget.jq().parents(".ux-TabbedPane").last());
      }

      /**
       * Determines if the mouse special control of the widget
       * @private
       * @param {JQuery.Event} mouseEvent
       * @returns {string}
       */
    }, {
      key: "$mouseOnWidgetControl",
      value: function $mouseOnWidgetControl(mouseEvent) {
        var results;
        var elementsUnderMouse = this.$elementsUnderMouse(mouseEvent);
        elementsUnderMouse.forEach(function (element) {
          if (!results) {
            var classList = element.classList;
            if (classList.contains('split-pane-divider-inner')) {
              results = 'splitPaneDivider';
            }
            if (classList.contains('-t-ExpandablePane-cell-icon-container')) {
              results = 'expandablePaneToggle';
            }
          }
        });
        return results;
      }

      /**
       * @private
       * @param {JQuery.Event|{ pageX: number, pageY: number}} e
       * @returns {Element[]} elements under mouse, sorted from deepest to shallowest (`<html>` will be last)
       */
    }, {
      key: "$elementsUnderMouse",
      value: function $elementsUnderMouse(e) {
        var controllerJq = this.jq();
        if (!controllerJq) {
          // only happens in certain unit tests that do not actually initialize the studio or its elements
          return elementsUnderMouse(e);
        }
        // deactivate the wrapper overlays so that a fake mouse event can reach the actual elements
        var painterJq = controllerJq.prev();
        controllerJq.css('pointer-events', 'none');
        painterJq.css('pointer-events', 'none');
        try {
          return elementsUnderMouse(e);
        } finally {
          controllerJq.css('pointer-events', '');
          painterJq.css('pointer-events', '');
        }
      }

      /**
       * @private
       * @param {module:nmodule/bajaui/rc/ux/TabbedPane} tabbedPane
       * @param {module:bajaux/Widget} selectedWidget
       */
    }, {
      key: "$tabbedPaneHandler",
      value: function $tabbedPaneHandler(tabbedPane, selectedWidget) {
        var target = selectedWidget.jq().closest('.ux-BorderPane.ux-TabbedPane-tab');
        if (target.length === 0) {
          target = selectedWidget.jq().closest('.ux-BorderPane.ux-TabbedPane-content');
        }
        if (target.length === 0) {
          return;
        }
        var index = Widget["in"](target).properties().getValue('tabIndex');
        if (index >= 0) {
          tabbedPane.setSelectedIndex(index);
        }
      }

      /**
       * @private
       * @param {module:nmodule/bajaui/rc/ux/shape/Shape} widget
       * @param {JQuery.Event} e
       */
    }, {
      key: "$shapeMouseHandler",
      value: function $shapeMouseHandler(widget, e) {
        var _this$$translatePoint = this.$translatePoint({
            point: {
              x: e.pageX,
              y: e.pageY
            },
            from: 'document',
            to: 'overlay'
          }),
          overlayX = _this$$translatePoint.x,
          overlayY = _this$$translatePoint.y;
        var elements = this.$elementsUnderMouse(e);
        var _elements = _slicedToArray(elements, 1),
          element = _elements[0];
        var multiMode = getMultiMode(e);
        if (this.$isShapeHit(element, e)) {
          var shapeToSelect = Widget["in"]($(element).closest('.ux-Shape'));
          return this.$handleSelect(overlayX, overlayY, shapeToSelect, multiMode);
        } else {
          var getClosestRealWidgetElement = function getClosestRealWidgetElement() {
            return elements.find(function (el) {
              var widget = Widget["in"](el),
                model = getModel(widget);
              return model && !isElement(widget);
            });
          };
          var nextBestHitEl = getClosestRealWidgetElement();
          if (nextBestHitEl) {
            return this.$handleSelect(overlayX, overlayY, Widget["in"](nextBestHitEl), multiMode);
          }
        }
      }

      /**
       * @private
       * @param {SVGGeometryElement} element
       * @param {JQuery.Event} e
       * @returns {boolean}
       */
    }, {
      key: "$isShapeHit",
      value: function $isShapeHit(element, e) {
        var svgEl = $(element).closest('svg')[0];
        if (!svgEl) {
          return false;
        }
        var pt = svgEl.createSVGPoint();
        pt.x = e.pageX;
        pt.y = e.pageY;
        // Transform mouse coordinates to SVG coordinate system
        var svgPt = pt.matrixTransform(svgEl.getScreenCTM().inverse());
        // if this starts to throw, it's because we implemented a Shape that has a non SVGGeometryElement in it
        return element && (element.isPointInStroke(svgPt) || element.isPointInFill(svgPt));
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/UxBuilder}
       */
    }, {
      key: "$getUxBuilder",
      value: function $getUxBuilder() {
        return this.properties().getValue('uxBuilder');
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayPainter}
       */
    }, {
      key: "$getPainter",
      value: function $getPainter() {
        return this.$getUxBuilder().$getPxStudio().$getPainter();
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxShapeOverlayPainter}
       */
    }, {
      key: "$getShapeOverlayPainter",
      value: function $getShapeOverlayPainter() {
        return this.$getUxBuilder().$getPxStudio().$getShapeOverlayPainter();
      }

      /**
       * @private
       * @returns {module:nmodule/bajaui/rc/ux/PxWidget}
       */
    }, {
      key: "$getPxWidget",
      value: function $getPxWidget() {
        return this.$getUxBuilder().$getPxStudio().$getPxWidget();
      }
    }]);
  }(spandrel(function (value, _ref10) {
    var self = _ref10.self;
    return spandrel.jsx("div", {
      className: "-t-PxOverlayController-mouse-interceptor ux-select-none",
      tabIndex: "-1",
      on: {
        'mousedown touchstart': function mousedown_touchstart(e) {
          return self.$mousedown(e)["catch"](logSevere);
        },
        'dblclick': function dblclick(e) {
          return self.$dblclick(e)["catch"](feDialogs.error);
        },
        'click': function click(e) {
          return self.$click(e)["catch"](logSevere);
        },
        'dragover': function dragover(e) {
          return self.$dragover(e)["catch"](logSevere);
        },
        'drop': function drop(e) {
          return self.$drop(e)["catch"](logSevere);
        },
        'keydown': function keydown(e) {
          return self.$keydown(e);
        },
        'wheel': function wheel(e) {
          return self.$wheel(e);
        }
      }
    });
  }));
  /**
   * This widget wraps the left-hand contents of the UxBuilder: the PxWidget that displays the
   * contents of the Px page, and the overlays that enable mouse interaction with it. This class
   * just does the wrapping job; it's otherwise glue code that should be covered by integration
   * tests.
   *
   * - `baseOrd`: ORD for the PxWidget to use to resolve any relative ORDs in bindings
   * - `id`: the self-generated ID of the UxBuilder
   * - `pxProperties`: Px Properties that the Px Widget needs to render
   * - `uxBuilder`: the UxBuilder instance
   * TODO: identify all functionality uxBuilder is used for, and refactor
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxStudioWrapper
   * @extends module:bajaux/spandrel/DynamicSpandrelWidget
   */
  var PxStudioWrapper = /*#__PURE__*/function (_spandrel4) {
    function PxStudioWrapper() {
      var _this25;
      _classCallCheck(this, PxStudioWrapper);
      _this25 = _callSuper(this, PxStudioWrapper, arguments);
      _this25.postLoad = function (widget, buildContext) {
        notifyWidgetTreeThatWidgetWasBuilt(widget, buildContext.value);
      };
      return _this25;
    }

    /**
     * the paint should happen after the PxWidget itself has *fully* completed its layout cycle so
     * the widgets are in their correct final places and the rectangles can draw in the right place.
     *
     * the super.layout() call should complete the spandrel/RequestLayoutMixin process of laying out
     * all the child widgets (PxWidget is a child of this widget), and then the paint can happen.
     * fingers crossed.
     *
     * @returns {Promise}
     */
    _inherits(PxStudioWrapper, _spandrel4);
    return _createClass(PxStudioWrapper, [{
      key: "layout",
      value: function layout() {
        var _this26 = this;
        return _superPropGet(PxStudioWrapper, "layout", this, 3)([]).then(function () {
          var controller = _this26.$getPxOverlayController();
          return controller && controller.paintSelected();
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$updateSelectedWidgets",
      value: function $updateSelectedWidgets() {
        var _this27 = this;
        var uxBuilder = this.properties().getValue('uxBuilder'),
          controller = this.$getPxOverlayController();
        return uxBuilder.$getSelectedNodes().then(function (selectedNodes) {
          if (selectedNodes.length === 0) {
            return controller && controller.setSelectedWidgets(selectedNodes, true);
          }
          var pxWidget = _this27.$getPxWidget();
          if (pxWidget) {
            var rootWidget = pxWidget.$getRootWidget();
            var selectedWidgets = selectedNodes.map(function (node) {
              return node.getLastBuiltWidget();
            });
            var filteredSelection = selectedWidgets.length > 1 ? selectedWidgets.filter(function (widget) {
              return widget && widget !== rootWidget;
            }) : selectedWidgets.filter(function (widget) {
              return widget;
            });
            var _selectedNodes = _slicedToArray(selectedNodes, 1),
              selectedNode = _selectedNodes[0];
            if (selectedNode.represents(LabelPane)) {
              return uxBuilder.$handleTabbedPane(selectedNode);
            } else {
              var widget = selectedNode.getLastBuiltWidget();
              var tabbedPaneParent = controller.$getTabbedPaneParent(widget);
              if (tabbedPaneParent) {
                controller.$tabbedPaneHandler(tabbedPaneParent, widget);
              }
              return controller.setSelectedWidgets(filteredSelection, true);
            }
          }
        });
      }

      /**
       * @private
       * @returns {module:nmodule/bajaui/rc/ux/PxWidget}
       */
    }, {
      key: "$getPxWidget",
      value: function $getPxWidget() {
        return this.queryWidget('wrapper/0');
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayPainter}
       */
    }, {
      key: "$getPainter",
      value: function $getPainter() {
        return this.queryWidget('wrapper/2');
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController}
       */
    }, {
      key: "$getPxOverlayController",
      value: function $getPxOverlayController() {
        return this.queryWidget('wrapper/3');
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxShapeOverlayPainter}
       */
    }, {
      key: "$getShapeOverlayPainter",
      value: function $getShapeOverlayPainter() {
        return this.queryWidget('wrapper/1');
      }

      /**
       * @private
       * @returns {Array<object>|null}
       */
    }, {
      key: "$getPxLayers",
      value: function $getPxLayers() {
        return this.properties().getValue('pxLayers');
      }
    }]);
  }(spandrel(function (displayModel, _ref11) {
    var properties = _ref11.properties,
      self = _ref11.self;
    var baseOrd = properties.baseOrd,
      id = properties.id,
      pxProperties = properties.pxProperties,
      uxBuilder = properties.uxBuilder;
    var postLoad = self.postLoad;
    return [spandrel.jsx("div", {
      "class": "-t-UxBuilder-studioContentsWrapper",
      spandrelKey: "wrapper"
    }, spandrel.jsx(PxWidget, {
      id: id,
      className: "-t-UxBuilder-PxWidget -t-UxBuilder-ZoomPane",
      value: displayModel,
      properties: {
        editMode: true,
        baseOrd: baseOrd,
        pxProperties: pxProperties,
        postLoad: postLoad
      },
      on: _defineProperty(_defineProperty({}, LAYOUT_CHANGED, function (e, root, widget, layout) {
        var originatingNode = getOriginatingNode(widget);
        if (originatingNode) {
          return uxBuilder.$applyChangesToNodes([originatingNode], {
            widgetChanges: {
              layout: layout
            }
          });
        }
      }), PROPERTY_CHANGED, function (e, widget, property) {
        return self.rerender();
      })
    }), spandrel.jsx(PxShapeOverlayPainter, {
      className: "-t-UxBuilder-PxShapeOverlayPainter",
      properties: {
        uxBuilder: uxBuilder
      }
    }), spandrel.jsx(PxOverlayPainter, {
      tagName: "canvas",
      className: "-t-UxBuilder-PxOverlayPainter",
      properties: {
        uxBuilder: uxBuilder
      }
    }), spandrel.jsx(PxOverlayController, {
      className: "-t-UxBuilder-PxOverlayController",
      properties: {
        uxBuilder: uxBuilder
      }
    }))];
  }));
  function notifyWidgetTreeThatWidgetWasBuilt(widget, loadedValue) {
    if (loadedValue instanceof UxModel) {
      var originatingNode = getOriginatingNode(loadedValue);
      if (originatingNode) {
        originatingNode.setLastBuiltWidget(widget);
      }
    }
  }

  /**
   * @param {{ pageX: number, pageY: number }} event
   * @returns {Element[]}
   */
  function elementsUnderMouse(event) {
    return document.elementsFromPoint(event.pageX, event.pageY);
  }

  /**
   * Transform a rectangle by transforming its upper-left and lower-right points.
   *
   * @private
   * @param {module:nmodule/bajaui/rc/baja/Layout~Rectangle} rect
   * @param {function} transformPoint
   * @returns {module:nmodule/bajaui/rc/baja/Layout~Rectangle}
   */
  function transformRect(rect, transformPoint) {
    var x = rect.x,
      y = rect.y,
      w = rect.w,
      h = rect.h;
    var topLeft = transformPoint({
      x: x,
      y: y
    });
    var bottomRight = transformPoint({
      x: x + w,
      y: y + h
    });
    return {
      x: topLeft.x,
      y: topLeft.y,
      w: bottomRight.x - topLeft.x,
      h: bottomRight.y - topLeft.y
    };
  }
  return {
    PxOverlayPainter: PxOverlayPainter,
    PxOverlayController: PxOverlayController,
    PxStudioWrapper: PxStudioWrapper
  };

  /**
   * @typedef {object} module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayPainter~HandleInfo
   * @property {module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Artisan} artisan
   * @property {module:nmodule/uxBuilder/rc/ux/wysiwyg/artisans/Handle} handleToTrack
   */

  /**
   * Info about what's under a mouse click: a widget, a handle on a lime rectangle, or nothing.
   * @typedef {object} module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController~EntityInfo
   * @property {string} type `handle` or `widget`
   * @property {module:bajaux/Widget|module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayPainter~HandleInfo} [entity]
   */

  /**
   * Info about a drag/drop operation.
   * @typedef {object} module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController~DropTargetInfo
   * @property {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} [node] the node being dropped
   * on, or undefined if there is no valid target node
   * @property {function} [beforeInsert] specify this callback to perform any final modifications on
   * the UxModels just before they are applied to the target node.
   */

  /**
   * Information needed to translate a point from one coordinate system to another in UxBuilder world.
   *
   * @typedef {object} module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController~PointTranslation
   * @property {{ x: number, y: number }} point
   * @property {string|module:nmodule/bajaui/rc/ux/CanvasPane} from `overlay`, `document`, or a CanvasPane instance
   * @property {string|module:nmodule/bajaui/rc/ux/CanvasPane} to `overlay`, `document`, or a CanvasPane instance
   */

  /**
   * Information needed to translate a rectangle from one coordinate system to another in UxBuilder
   * world. Can also translate a Widget instance itself - in this case `from` is ignored.
   *
   * @typedef {object} module:nmodule/uxBuilder/rc/ux/wysiwyg/PxArtisanStudio~PxOverlayController~RectTranslation
   * @property {module:nmodule/bajaui/rc/baja/Layout~Rectangle|module:bajaux/Widget} rect
   * @property {string|module:nmodule/bajaui/rc/ux/CanvasPane} [from] `overlay`, `document`, or a CanvasPane instance
   * @property {string|module:nmodule/bajaui/rc/ux/CanvasPane} to `overlay`, `document`, or a CanvasPane instance
   */
});
