function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/sidebars/WidgetTree
 */

define(['bajaux/Widget', 'Promise', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport', 'nmodule/webEditors/rc/wb/tree/NavTree'], function (Widget, Promise, uxBuilderUtils, addContextMenuSupport, NavTree) {
  'use strict';

  var nodePathRelativeToRootContainer = uxBuilderUtils.nodePathRelativeToRootContainer;
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'uxBuilder',
      keyName: 'WidgetTree',
      properties: {
        rootCssClass: '-t-WidgetTree',
        loadKids: true
      }
    };
  };

  /**
   * Extends the NavTree to add additional functionality to it.
   *
   * In addition to the ones supported by the NavTree base class, it supports the following bajaux
   * Properties:
   *
   * - `baseOrd`: (baja.Ord) used when adding new nodes to the node in this tree, e.g. passing along
   *   to Make Widget
   * - `pxLayers`: (Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>) used when adding new
   *   nodes to the node in this tree, e.g. passing along to Make Widget
   * - `selectedPaths`: (string[][])
   *
   * @since Niagara 4.15
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/sidebars/WidgetTree
   * @extends module:nmodule/webEditors/rc/wb/tree/NavTree
   * @implements module:nmodule/webEditors/rc/wb/util/TransferWidget
   * @param {Object} [params] the object literal containing the constructor's arguments
   * @param {Object} [params.properties] the properties for the constructor
   * @param {Boolean} [params.properties.expanded=false] set to true if this tree should
   * be immediately expanded on first load
   * @param {Boolean} [params.properties.loadKids=true] set to false if this tree should
   * not attempt to load its children before it is expanded
   * @param {Boolean} [params.properties.enableHoverPreload=false] set to true if child
   * nodes should start to preload when the mouse hovers over the expand
   * button (to shave a bit of time off child node expansion)
   * @param {module:nmodule/webEditors/rc/wb/tree/NavTree~displayFilter} [params.properties.displayFilter]
   * @param {boolean} [params.properties.hideRoot] hides the root node and expands the root
   * @param {Function} [params.properties.editPropertiesFunc] function to be called when editing the
   * properties of the selected widget(s)
   */
  var WidgetTree = /*#__PURE__*/function (_NavTree) {
    function WidgetTree(params) {
      var _this;
      _classCallCheck(this, WidgetTree);
      _this = _callSuper(this, WidgetTree, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      // always load kids. vanilla NavTree does not propagate loadKids into its own kids but always
      // sets it to false.
      _this.$loadKids = true;
      var moveCommands = _this.properties().getValue('moveCommands');
      if (moveCommands) {
        var _this$getCommandGroup;
        (_this$getCommandGroup = _this.getCommandGroup()).add.apply(_this$getCommandGroup, _toConsumableArray(moveCommands));
      }
      addContextMenuSupport(_this);
      return _this;
    }
    _inherits(WidgetTree, _NavTree);
    return _createClass(WidgetTree, [{
      key: "doLoad",
      value: function doLoad(node) {
        return _superPropGet(WidgetTree, "doLoad", this, 3)(arguments);
      }

      /**
       * By implementing doChanged, we allow Widget Tree to receive Property changes without having
       * spandrel tear it down and rebuild it on each rerender. See: canUpdateProperties in
       * DynamicSpandrelWidget.
       *
       * Using the `selectedPaths` property allows the source of truth for "what widgets are selected"
       * to live at the top-level, in UxBuilder itself, and be passed down into WidgetTree and
       * PxArtisanStudio. This lets widget selections work even when Widget Tree is hidden.
       *
       * @param {string} name
       * @param {*} value
       * @returns {Promise}
       */
    }, {
      key: "doChanged",
      value: function doChanged(name, value) {
        if (name === 'selectedPaths') {
          return this.$setSelectedPaths(value);
        }
      }

      /**
       * @private
       * @param {string[][]} selectedPaths the new selected paths, relative to root
       * @returns {Promise}
       */
    }, {
      key: "$setSelectedPaths",
      value: function $setSelectedPaths(selectedPaths) {
        var _this2 = this;
        //invariant:
        if (this.value().getFullPath().join() !== 'px,rootContainer,root') {
          throw new Error('can only call $setSelectedPaths on WidgetTree containing root');
        }

        // we can't just clearSelection because it results in a flicker: nodes that are already
        // selected get deselected and reselected. we have to only deselect the nodes that were
        // selected, but now are not.
        // or else reimplement NavTree in spandrel.

        var pathStrings = selectedPaths.map(function (path) {
          return path.join();
        });
        return Promise.all(this.getSelectedNodes().map(function (node) {
          var path = nodePathRelativeToRootContainer(node);
          return _this2.traverseTo(path).then(function (_ref) {
            var tree = _ref.tree,
              success = _ref.success;
            if (success && !pathStrings.includes(path.join())) {
              return tree.setSelected(false, {
                silent: true
              });
            }
          });
        })).then(function () {
          return Promise.all(selectedPaths.map(function (path) {
            return _this2.setSelectedPath(['root'].concat(_toConsumableArray(path)), {
              silent: true,
              modified: true
            })["catch"](function (ignore) {});
          }));
        });
      }

      /**
       * When a node in the Widget Tree is selected, it will trigger a SELECTION_REQUESTED or
       * DESELECTION_REQUESTED event on the root UxModelTreeNode. This will do a round-trip up to the
       * parent UxBuilder to do the corresponding updates.
       *
       * @override
       * @param {boolean} selected
       * @param {object} [params]
       * @param {boolean} [params.silent] true to skip triggering any events
       * @param {boolean} [params.modified] true if this should modify an existing selection instead
       * of starting a new one.
       * @returns {Promise}
       */
    }, {
      key: "setSelected",
      value: function setSelected(selected) {
        var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var silent = params.silent,
          modified = params.modified;
        var wasSelected = this.isSelected();
        _superPropGet(WidgetTree, "setSelected", this, 3)(arguments); // TODO: silent: true and remove SELECTED_EVENT handler
        if (!silent && this.isSelected() !== wasSelected) {
          var node = this.value();
          return selected ? node.requestSelection(modified ? 'toggle' : 'exclusive') : node.requestDeselection();
        }
      }

      /**
       * @returns {boolean}
       */
    }, {
      key: "supportsContextMenuAccelerators",
      value: function supportsContextMenuAccelerators() {
        return true;
      }

      /**
       * Builds the context menu on right mouse click based on selected nodes
       * @returns {Promise.<module:bajaux/commands/CommandGroup>}
       */
    }, {
      key: "toContextMenuCommandGroup",
      value: function toContextMenuCommandGroup() {
        var _this3 = this;
        /*
        other nav trees just add ContextMenuSupport to the single root instance - see
        navTreeSideBar.js. currently we add it to every single node - so when you right-click it's
        *that* node that generates the context menu for you, and a single NavTree instance doesn't
        know what nodes are selected in its siblings/ancestors. so we jump back up to the root node,
        who can see the selected nodes in the whole tree. there 100% exists a cleaner way to do this.
         */
        return this.getRoot().traverseTo(['rootContainer', 'root']).then(function (_ref2) {
          var rootTree = _ref2.tree;
          return _this3.$getUxBuilder().$makeContextMenuCommandGroup({
            nodes: rootTree.getSelectedNodes()
          });
        });
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/UxBuilder}
       */
    }, {
      key: "$getUxBuilder",
      value: function $getUxBuilder() {
        return Widget["in"](this.jq().closest('.-t-UxBuilder'));
      }
    }]);
  }(NavTree);
  return WidgetTree;
});
