function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/sidebars/PxPropertiesWidget
 */

define(['baja!', 'lex!uxBuilder', 'Promise', 'underscore', 'bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/ux/commands/PxRenameCommand', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport', 'nmodule/webEditors/rc/wb/table/EditTable', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/commands/AddRowCommand', 'nmodule/webEditors/rc/wb/table/commands/RemoveCommand', 'nmodule/webEditors/rc/fe/feDialogs'], function (baja, lexs, Promise, _, spandrel, Command, CommandGroup, uxBuilderUtils, PxRenameCommand, ContextMenuSupport, EditTable, Table, AddRowCommand, RemoveCommand, feDialogs) {
  'use strict';

  var NONE = Command.flags.NONE;
  var ROW_SELECTION_CHANGED_EVENT = Table.ROW_SELECTION_CHANGED_EVENT;
  var getUxBuilderProperties = uxBuilderUtils.getUxBuilderProperties;
  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var _EditTable$columns = EditTable.columns,
    display = _EditTable$columns.display,
    edit = _EditTable$columns.edit;
  var columns = [display('name', {
    displayName: uxBuilderLex.get('PxProperty.name')
  }), edit('value', {
    displayName: uxBuilderLex.get('PxProperty.value')
  })];
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'uxBuilder',
      keyName: 'PxPropertiesWidget',
      properties: {
        rootCssClass: '-t-PxPropertiesWidget'
      }
    };
  };
  var lastName = 'newProp';
  var lastTypeSpec = baja.$('baja:TypeSpec', 'gx:Brush');

  /**
   * Widget for editing PxProperties in the UxBuilder
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/sidebars/PxPropertiesWidget
   * @extends module:bajaux/Widget
   * @since Niagara 4.15
  */
  var PxPropertiesWidget = /*#__PURE__*/function (_spandrel) {
    function PxPropertiesWidget(params) {
      var _this;
      _classCallCheck(this, PxPropertiesWidget);
      _this = _callSuper(this, PxPropertiesWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$getNew = function () {
        return _this.$add();
      };
      var commandGroup = _this.getCommandGroup();
      commandGroup.add(new AddRowCommand(function () {
        return _this.$getEditTable();
      }, {
        module: 'uxBuilder',
        lex: 'PxPropertiesWidget.commands.add'
      }));
      var getTable = function getTable() {
        return _this.$getEditTable().$getTable();
      };
      _this.$removeCommand = new RemoveCommand(getTable, {
        module: 'uxBuilder',
        lex: 'PxPropertiesWidget.commands.remove'
      });
      commandGroup.add(_this.$removeCommand);
      _this.$renameCommand = new PxRenameCommand(getTable, {
        module: 'uxBuilder',
        lex: 'PxPropertiesWidget.commands.rename',
        colName: 'name',
        flags: NONE
      });
      commandGroup.add(_this.$renameCommand);
      ContextMenuSupport(_this);
      return _this;
    }

    /**
     * Returns the jq selector that the context menu is to trigger off of.
     * @returns {string}
     */
    _inherits(PxPropertiesWidget, _spandrel);
    return _createClass(PxPropertiesWidget, [{
      key: "getContextMenuSelector",
      value: function getContextMenuSelector() {
        return 'tr';
      }

      /**
       * Returns the command group for the context menu.
       * @returns {module:bajaux/commands/CommandGroup}
       */
    }, {
      key: "toContextMenuCommandGroup",
      value: function toContextMenuCommandGroup() {
        return new CommandGroup({
          commands: [this.$renameCommand, this.$removeCommand]
        });
      }
    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        this.$updateCommands();
        return _superPropGet(PxPropertiesWidget, "doReadonly", this, 3)(arguments);
      }

      /**
       * @private
       */
    }, {
      key: "$updateCommands",
      value: function $updateCommands() {
        var _this2 = this;
        this.$getAddCommand().setEnabled(!this.isReadonly());
        this.getCommandGroup().getChildren().forEach(function (cmd) {
          return _this2.isReadonly() ? cmd.isEnabled(false) : cmd.$updateEnabled && cmd.$updateEnabled();
        });
      }

      /**
       * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties} pxProperties
       * @returns {object}
       */
    }, {
      key: "toState",
      value: function toState(pxProperties) {
        var editTableRows = Object.entries(pxProperties).map(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            name = _ref2[0],
            _ref2$ = _ref2[1],
            value = _ref2$.value,
            targets = _ref2$.targets;
          return {
            name: {
              value: name
            },
            value: {
              value: value,
              properties: getUxBuilderProperties(value.getType())
            },
            targets: {
              value: targets.slice()
            }
          };
        });
        return {
          editTableRows: editTableRows
        };
      }

      /**
       * @returns {module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties}
       */
    }, {
      key: "fromState",
      value: function fromState(_ref3) {
        var editTableRows = _ref3.editTableRows;
        return fromRows(editTableRows);
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/EditTable}
       */
    }, {
      key: "$getEditTable",
      value: function $getEditTable() {
        return this.queryWidget('editTableRows');
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getAddCommand",
      value: function $getAddCommand() {
        return this.getCommandGroup().get(0);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getRemoveCommand",
      value: function $getRemoveCommand() {
        return this.getCommandGroup().findCommand(RemoveCommand);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$add",
      value: function $add() {
        var _this3 = this;
        return this.$promptForNew().then(function (results) {
          if (!results) {
            return null;
          }
          return _this3.read().then(function (pxProperties) {
            var name = baja.SlotPath.escape(results.name);
            var typeSpec = results.typeSpec;
            if (!name) {
              throw new Error(uxBuilderLex.get('PxPropertiesWidget.commands.add.errors.emptyName'));
            }
            if (pxProperties.hasOwnProperty(name)) {
              throw new Error(uxBuilderLex.get('PxPropertiesWidget.commands.add.errors.duplicate'));
            }
            lastName = name;
            lastTypeSpec = typeSpec;
            return {
              name: {
                value: name
              },
              value: {
                value: baja.$(typeSpec)
              },
              targets: {
                value: []
              }
            };
          });
        });
      }

      /**
       * @private
       * @returns {Promise<{ name: string, typeSpec: baja.Simple }|null>} object with name and
       * type spec, or null if user clicked cancel
       */
    }, {
      key: "$promptForNew",
      value: function $promptForNew() {
        var defaultName = baja.SlotPath.unescape(this.$generateUniqueName(lastName));
        return feDialogs.props({
          name: {
            displayName: '%lexicon(uxBuilder:PxProperty.name)%',
            value: defaultName
          },
          typeSpec: {
            displayName: '%lexicon(uxBuilder:PxProperty.type)%',
            value: lastTypeSpec,
            properties: {
              allowNull: false,
              showAbstract: false,
              targetType: 'baja:Simple'
            }
          }
        }, {
          title: uxBuilderLex.get('PxPropertiesWidget.commands.add.description')
        });
      }

      /**
       * @private
       * @param {string} name
       * @returns {string} a unique name based on the currently entered px properties
       */
    }, {
      key: "$generateUniqueName",
      value: function $generateUniqueName(name) {
        var _this$state = this.state(),
          editTableRows = _this$state.editTableRows;
        return baja.$('baja:Component', fromRows(editTableRows, false)).getUniqueName(name);
      }
    }]);
  }(spandrel(function (pxProperties, _ref4) {
    var self = _ref4.self,
      editTableRows = _ref4.editTableRows;
    var getNew = self.$getNew;
    return spandrel.jsx(EditTable, {
      bind: true,
      lax: true,
      spandrelKey: "editTableRows",
      value: editTableRows,
      on: _defineProperty({}, ROW_SELECTION_CHANGED_EVENT, function () {
        return self.$updateCommands();
      }),
      properties: {
        columns: columns,
        getNew: getNew
      }
    });
  }, {
    strategy: 'niagara'
  }));
  /**
   * @param {Array.<object>} rows current rows in the `EditTable`
   * @param {boolean} [includeTargets=true]
   * @returns {Object}
   */
  function fromRows(rows) {
    var includeTargets = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    var pxProperties = {};
    rows.forEach(function (pxProperty) {
      var name = pxProperty.name.value;
      var value = pxProperty.value.value;
      var targets = pxProperty.targets && pxProperty.targets.value || [];
      pxProperties[name] = {
        value: value
      };
      if (includeTargets) {
        pxProperties[name].targets = targets;
      }
    });
    return pxProperties;
  }
  return PxPropertiesWidget;
});
