function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _toArray(r) { return _arrayWithHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableRest(); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx UxModel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget
 */

define(['baja!', 'baja!bajaui:LayerStatus,bajaui:LayerTag', 'lex!uxBuilder', 'log!nmodule.uxBuilder.rc.ux.sidebars.PropertiesWidget', 'bajaux/events', 'bajaux/spandrel', 'bajaux/spandrel/util', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/model/UxModel', 'Promise', 'underscore', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/bajaui/rc/ux/TitlePane', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/ux/ListOfBindingsWidget', 'nmodule/uxBuilder/rc/ux/UxBuilderPropertySheet', 'nmodule/uxBuilder/rc/ux/UxBuilderPropertySheetRow', 'nmodule/uxBuilder/rc/ux/commands/propertiesContextMenuCommands', 'nmodule/uxBuilder/rc/ux/model/UxModelTreeNode', 'nmodule/webEditors/rc/fe/baja/util/ComplexDiff', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/util/textUtils', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport'], function (baja, types, lexs, log, events, spandrel, util, Widget, Command, CommandGroup, UxModel, Promise, _, NullWidget, TitlePane, uxBuilderUtils, ListOfBindingsWidget, UxBuilderPropertySheet, UxBuilderPropertySheetRow, propertiesContextMenuCommands, UxModelTreeNode, ComplexDiff, compUtils, feDialogs, textUtils, addContextMenuSupport) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var MODIFY_EVENT = events.MODIFY_EVENT;
  var any = _.any,
    compact = _.compact,
    constant = _.constant,
    isEmpty = _.isEmpty,
    isNumber = _.isNumber,
    isString = _.isString,
    values = _.values;
  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var layerDisplay = uxBuilderLex.get('WidgetTree.properties.layerTag.label');
  var toFriendly = textUtils.toFriendly;
  var AddConverterCommand = propertiesContextMenuCommands.AddConverterCommand,
    DeleteConverterCommand = propertiesContextMenuCommands.DeleteConverterCommand,
    UnlinkPxPropertyCommand = propertiesContextMenuCommands.UnlinkPxPropertyCommand,
    makeLinkCommandGroup = propertiesContextMenuCommands.makeLinkCommandGroup;
  var ANIMATION_EDIT_REQUESTED_EVENT = UxBuilderPropertySheetRow.ANIMATION_EDIT_REQUESTED_EVENT;
  var cloneWithChanges = uxBuilderUtils.cloneWithChanges,
    configureConverterWithUxBuilderProperties = uxBuilderUtils.configureConverterWithUxBuilderProperties,
    generateUniqueBindingName = uxBuilderUtils.generateUniqueBindingName,
    getBindingTypesFor = uxBuilderUtils.getBindingTypesFor,
    getMergedProperties = uxBuilderUtils.getMergedProperties,
    isUxModelEditable = uxBuilderUtils.isUxModelEditable,
    isUxModelLocked = uxBuilderUtils.isUxModelLocked,
    nodePathRelativeToRoot = uxBuilderUtils.nodePathRelativeToRoot,
    resolveWidgetDisplayName = uxBuilderUtils.resolveWidgetDisplayName,
    sortWidgetProperties = uxBuilderUtils.sortWidgetProperties,
    $getLinkedPropertyPaths = uxBuilderUtils.$getLinkedPropertyPaths,
    $newBindingCopy = uxBuilderUtils.$newBindingCopy;
  var setPropertiesSilently = util.setPropertiesSilently;
  var toObject = compUtils.toObject;
  var _baja$Flags = baja.Flags,
    HIDDEN = _baja$Flags.HIDDEN,
    READONLY = _baja$Flags.READONLY,
    TRANSIENT = _baja$Flags.TRANSIENT;
  var UNBOUND_INDEX = -1; // need an explicit value for bindingIndex so changes will apply when unbinding

  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'uxBuilder',
      keyName: 'PropertiesWidget',
      properties: {
        rootCssClass: '-t-PropertiesWidget',
        substituteMode: false
      }
    };
  };
  var addPxLayersToLayerProps = function addPxLayersToLayerProps(widgetProps, pxLayers) {
    if (!widgetProps.LayerTag) {
      widgetProps.LayerTag = {
        value: baja.$('bajaui:LayerTag')
      };
    }
    widgetProps.LayerTag.properties = Object.assign({}, widgetProps.LayerTag.properties, {
      pxLayers: JSON.stringify(pxLayers)
    });
    return widgetProps;
  };

  /**
   * Tries to bind the ord of the binding to it's OrdTarget.
    * @param {baja.Ord} [child]
   * @param {module:nmodule/bajaui/rc/baja/binding/Binding} binding
   * @param {baja.Ord} base
   * @returns {Promise.<module:nmodule/bajaui/rc/baja/binding/Binding>}
   */
  function tryToBind(child, binding, base) {
    function logErrorAndReturnBinding(binding, error) {
      // When a binding is unresolved, log the error and set the ordTarget to null,
      // when caller checks for binding.isBound() it returns false.
      logSevere(error);
      binding.setOrdTarget(null);
      return binding;
    }

    // When there are no local changes return the input binding.
    if (!child && binding.isBound()) {
      return Promise.resolve(binding);
    }
    try {
      if (!child) {
        child = binding.getOrd();
      }
      return baja.Ord.make({
        base: base,
        child: child
      }).normalize().resolve().then(function (ordTarget) {
        // When a local change is made and it is resolved then set binding ord target and ord to the local ord change.
        binding.setOrdTarget(ordTarget);
        binding.setOrd(child);
        return binding;
      })["catch"](function (error) {
        return logErrorAndReturnBinding(binding, error);
      });
    } catch (error) {
      return Promise.resolve(logErrorAndReturnBinding(binding, error));
    }
  }

  /**
   * Will return true if a converter can be added for the binding.
   * Also, when there are any binding changes, it will set the binding's ord
   * with the binding's changed ord when it is not null.
   *
   * @param {String} bindingKey
   * @param {module:nmodule/bajaui/rc/baja/binding/Binding} binding
   * @param {Object} state
   * @param {Array.<Object>} [state.bindingChanges]
   * @param {baja.Ord} state.baseOrd
   * @returns {Promise.<boolean>}
   */
  function canAddConverterTo(bindingKey, binding, _ref) {
    var bindingChanges = _ref.bindingChanges,
      baseOrd = _ref.baseOrd;
    var bindingRegEx = /binding(\d+)/;
    var isValueBinding = baja.hasType(binding, 'bajaui:ValueBinding');
    if (bindingRegEx.test(bindingKey) && isValueBinding) {
      var bindingIndex = parseInt(bindingKey.match(bindingRegEx)[1]);
      var unBoundBindingObject = !isEmpty(bindingChanges) && bindingChanges[bindingIndex];
      return tryToBind(unBoundBindingObject && unBoundBindingObject.ord, binding, baseOrd).then(function (binding) {
        return binding.isBound();
      });
    }
    return Promise.resolve(false);
  }

  /**
   * Converts a Binding into the JSON for loading into its corresponding section in the Property
   * Sheet. It will have one row for every property on the Binding.
   * @param {baja.Component} bindingComp
   * @returns {module:nmodule/webEditors/rc/fe/feDialogs~EditableJSON}
   */
  function toBindingJson(bindingComp) {
    var bindingObj = toObject(bindingComp);
    return Object.keys(bindingObj).reduce(function (obj, slotName) {
      var flags = bindingComp.getFlags(slotName);
      return Object.assign(obj, _defineProperty({}, slotName, {
        value: bindingObj[slotName],
        properties: bindingComp.getFacets(slotName).toObject(),
        displayName: bindingComp.getDisplayName(slotName),
        hidden: !!(flags & HIDDEN),
        readonly: !!(flags & READONLY),
        "transient": !!(flags & TRANSIENT)
      }));
    }, {});
  }

  /**
   * Sidebar version of the UxModel properties editor
   *
   * It supports the following `bajaux` `Properties`
   *
   * - `pxLayers`: It is a JSON string of an Array, which has information about PxLayers.
   *    Example: Javascript Array, [{name: 'newLayer', status: baja.$('bajaui:LayerStatus')}] is represented in JSON string as `[{"name":"newLayer","status":{"$ordinal":0}}]`
   * - `baseOrd`: It is baja.Ord to represent the base ord for resolving ords.
   * - `substituteMode` : it is an optional property, when set to true, will provide substitute styling like adjusting animated display ords as `<ord>`.
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget
   * @extends module:bajaux/Widget
   * @since Niagara 4.15
   */
  var PropertiesWidget = /*#__PURE__*/function (_spandrel) {
    function PropertiesWidget(params) {
      var _this;
      _classCallCheck(this, PropertiesWidget);
      _this = _callSuper(this, PropertiesWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.getCommandGroup().add(new Command({
        module: 'uxBuilder',
        lex: 'PropertiesWidget.commands.addBinding',
        enabled: false,
        func: function func() {
          return _this.$showAvailableBindingsForNode();
        }
      }));
      addContextMenuSupport(_this);
      return _this;
    }

    /**
     * when a row is modified, ensure that the new value is propagated to the correct place.
     * @private
     * @param  {module:nmodule/uxBuilder/rc/ux/UxBuilderPropertySheetRow} modifiedRow
     * @returns {Promise}
     */
    _inherits(PropertiesWidget, _spandrel);
    return _createClass(PropertiesWidget, [{
      key: "$doReadModifiedRow",
      value: function $doReadModifiedRow(modifiedRow) {
        var _this2 = this;
        return modifiedRow.read().then(function (value) {
          var _this2$state = _this2.state(),
            bindingChanges = _this2$state.bindingChanges;
          var _modifiedRow$$getPath = modifiedRow.$getPath(),
            _modifiedRow$$getPath2 = _toArray(_modifiedRow$$getPath),
            bucketName = _modifiedRow$$getPath2[0],
            slotPath = _modifiedRow$$getPath2.slice(1);
          if (bucketName === 'widgetProps') {
            return _this2.$markWidgetPropertyChanged(slotPath[0], value);
          } else {
            var index = _this2.$getBindingIndex(bucketName);
            var slotPathString = slotPath.join('/');
            bindingChanges[index][slotPathString] = value.newCopy(true);
            if (slotPathString === 'ord') {
              return _this2.$displayNewBindingOrdOnAnimatedWidgetProperties(index, value);
            }
          }
        }).then(function () {
          _this2.setModified(true);
        });
      }

      /**
       * when a widget property is animated, the ord of the binding animating that property is shown
       * in the row for that property.
       *
       * when the user changes that binding's ord, take the new ord and slot it into all the widget
       * property rows animated by that binding.
       *
       * @private
       * @param {number} bindingIndex
       * @param {baja.Ord} newOrd
       * @returns {Promise}
       */
    }, {
      key: "$displayNewBindingOrdOnAnimatedWidgetProperties",
      value: function $displayNewBindingOrdOnAnimatedWidgetProperties(bindingIndex, newOrd) {
        return this.$resolveWidgetPropertyRows().then(function (widgetPropertyRows) {
          return Promise.all(widgetPropertyRows.map(function (row) {
            if (row.properties().toObject().bindingIndex === bindingIndex) {
              return row.load(newOrd);
            }
          }));
        });
      }

      /**
       * when the user changes a widget property, we have to keep track of that change so that it can
       * be selectively applied when the user is selecting multiple widgets and editing their
       * properties.
       *
       * @private
       * @param {string} propertyName
       * @param {*} newValue
       */
    }, {
      key: "$markWidgetPropertyChanged",
      value: function $markWidgetPropertyChanged(propertyName, newValue) {
        var _this$state = this.state(),
          widgetChanges = _this$state.widgetChanges;
        // todo: don't mutate state without a rerender
        widgetChanges[propertyName] = newValue;
      }

      /**
       * @private
       * @returns {Promise.<Array.<module:nmodule/uxBuilder/rc/ux/UxBuilderPropertySheetRow>>}
       */
    }, {
      key: "$resolveWidgetPropertyRows",
      value: function $resolveWidgetPropertyRows() {
        var propertySheet = this.$getPropertySheet();
        return propertySheet.$drill(['widgetProps']).then(function (row) {
          return row.$setExpanded(true).then(function () {
            var widgetPropertySheet = row.$getSubPropertySheet();
            return widgetPropertySheet.$getKidRows();
          });
        });
      }

      /**
       * Returns the index in the json file of the supplied bindingId
       * @private
       * @param {string} bindingId
       * @param {Object} [json] optional json if required
       * @returns {number}
       */
    }, {
      key: "$getBindingIndex",
      value: function $getBindingIndex(bindingId, json) {
        var _this$$getJsonBinding = this.$getJsonBindingsInfo(json || this.state().json),
          jsonBindingKeys = _this$$getJsonBinding.jsonBindingKeys;
        return jsonBindingKeys.indexOf(bindingId);
      }

      /**
       * @private
       * @param {String} rowPath
       * @returns {Promise}
       */
    }, {
      key: "$clearReadErrorsFromState",
      value: function $clearReadErrorsFromState(rowPath) {
        var _this$state2 = this.state(),
          _this$state2$readErro = _this$state2.readError,
          readError = _this$state2$readErro === void 0 ? {} : _this$state2$readErro;
        if (readError[rowPath]) {
          delete readError[rowPath];
          return this.state({
            readError: readError
          });
        }
        return Promise.resolve();
      }

      /**
       * @private
       * @param {String} rowPath
       * @param {Error} err
       * @returns {Promise}
       */
    }, {
      key: "$addErrorsToState",
      value: function $addErrorsToState(rowPath, err) {
        var _this3 = this;
        logSevere(err);
        var _this$state3 = this.state(),
          _this$state3$readErro = _this$state3.readError,
          readError = _this$state3$readErro === void 0 ? {} : _this$state3$readErro;
        readError[rowPath] = err;
        return this.state({
          readError: readError
        }).then(function () {
          return _this3.setModified(true);
        });
      }

      /**
       * @private
       * @returns {String}
       */
    }, {
      key: "$getReadErrorsAsString",
      value: function $getReadErrorsAsString() {
        var _this$state4 = this.state(),
          readError = _this$state4.readError;
        if (isEmpty(readError)) {
          return '';
        }
        return values(readError).join('\n');
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} node
       * @returns {Array.<String>}
       */
    }, {
      key: "$getNodePath",
      value: function $getNodePath(node) {
        return nodePathRelativeToRoot(node);
      }
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this4 = this;
        /*
         TODO NCCB-62120: i would expect this to be possible in an inline onUxModify
         if the UxBuilder picks up on a modify event before widgetChanges has the new value,
         it will apply stale values. intercept it here, and, only fire the modify event for
         PropertiesWidget after we're sure that a read() call will resolve the latest values.
         */
        dom.on(MODIFY_EVENT, '.-t-PropertiesWidget-propertySheet', function (e, ed, modifiedRow) {
          if (modifiedRow && typeof modifiedRow.$getPath === 'function') {
            var rowPath = modifiedRow.$getPath().join();
            _this4.$doReadModifiedRow(modifiedRow).then(function () {
              return _this4.$clearReadErrorsFromState(rowPath);
            })["catch"](function (err) {
              return _this4.$addErrorsToState(rowPath, err);
            });
          }
          return false;
        });
        return _superPropGet(PropertiesWidget, "doInitialize", this, 3)(arguments);
      }
    }, {
      key: "requestFocus",
      value: function requestFocus() {
        var _this5 = this;
        var propertySheet = this.$getPropertySheet();
        Promise.all([propertySheet.$drill(['widgetProps', 'text']),
        //For Label
        propertySheet.$drill(['widgetProps', 'image']),
        //For Picture
        propertySheet.$drill(['widgetProps', 'ord']) //For PxInclude
        ]).then(function (_ref2) {
          var _ref3 = _slicedToArray(_ref2, 3),
            textRow = _ref3[0],
            imageRow = _ref3[1],
            ordRow = _ref3[2];
          var row = textRow || imageRow || ordRow;
          if (row) {
            var _row$properties$toObj = row.properties().toObject(),
              isAnimated = _row$properties$toObj.isAnimated,
              isLinked = _row$properties$toObj.isLinked;
            if (!isAnimated && !isLinked) {
              row.requestFocus();
              return;
            }
          }
          _superPropGet(PropertiesWidget, "requestFocus", _this5, 3)([]);
        })["catch"](logSevere);
      }

      /**
       * Loads the properties for the selected nodes into the state for the widget
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget~PropertiesWidgetState>}
       */
    }, {
      key: "toState",
      value: function toState(nodes) {
        var _this6 = this;
        var editingSingleNode = nodes.length === 1;
        var bindingChanges = [];
        var pxLayers = this.properties().getValue('pxLayers', []);

        // if any of the UxModel(s) are not editable, PropertiesWidget is rendered empty.
        if (!nodes.length || any(nodes, function (node) {
          return !isUxModelEditable(node.value());
        })) {
          return Promise.resolve({
            json: {},
            widgetChanges: {},
            bindingChanges: []
          });
        }
        var widgetProperties = {};
        if (editingSingleNode) {
          var _nodes$0$value$getMet = nodes[0].value().getMetadata(),
            pxDataTypeSpec = _nodes$0$value$getMet.pxDataTypeSpec;
          if (pxDataTypeSpec) {
            widgetProperties.pxDataTypeSpec = pxDataTypeSpec;
          }
        }
        var isAnyUxModelReadOnly = isAnyUxModelHasAReadOnlyLayer(nodes, pxLayers);
        return this.$convertPropertyValueTypes(nodes).then(function () {
          return getMergedProperties(nodes);
        }).then(function (propsToDisplay) {
          return Promise.all([_this6.$toDisplay(nodes), uxBuilderUtils.formatPropertiesForSidebar(propsToDisplay, isAnyUxModelReadOnly)]).then(function (_ref4) {
            var _ref5 = _slicedToArray(_ref4, 2),
              displayName = _ref5[0],
              widgetProps = _ref5[1];
            widgetProps = addPxLayersToLayerProps(widgetProps, pxLayers);
            widgetProps = sortWidgetProperties(widgetProps);
            widgetProps.LayerTag.displayName = layerDisplay;
            widgetProps = _this6.$applyAnimationAndLinkStatus(nodes, {
              widgetProps: widgetProps,
              isAnyUxModelReadOnly: isAnyUxModelReadOnly
            });
            var json = {
              widgetProps: {
                value: widgetProps,
                displayName: displayName,
                properties: widgetProperties
              }
            };
            var bindingsToAdd = [];
            if (editingSingleNode) {
              var value = nodes[0].value();
              var bindings = value.getBindingList().getBindings();
              bindings.forEach(function (binding, i) {
                var bindingNameList = bindings.map(function (binding) {
                  return binding.getName();
                });
                var bindingCopy = $newBindingCopy(binding);
                var name = binding.getName();
                if (!name) {
                  name = generateUniqueBindingName(bindingNameList, bindingCopy);
                  binding.getName = constant(name);
                }
                bindingCopy.getName = constant(name);
                var slots = bindingCopy.getSlots().toArray();
                slots.forEach(function (slot) {
                  if (!slot.isFrozen()) {
                    bindingCopy.setFlags({
                      slot: slot,
                      flags: slot.getFlags() | HIDDEN
                    });
                  }
                });
                var bindingJson = toBindingJson(bindingCopy);
                var bindingName = bindingCopy.getName();
                json['binding' + i] = {
                  displayName: binding.getTypeDisplayName(),
                  name: bindingName,
                  value: _this6.$applyLinkStatusForBinding({
                    bindingName: bindingName,
                    bindingJson: bindingJson,
                    isAnyUxModelReadOnly: isAnyUxModelReadOnly
                  }),
                  type: bindingCopy.getType(),
                  bindingValue: bindingCopy,
                  properties: {
                    bindingTypeSpec: binding.getType().getTypeSpec()
                  }
                };
                bindingsToAdd.push(binding);
                bindingChanges.push(toObject(binding));
              });
            }
            return {
              json: json,
              widgetChanges: {},
              bindingChanges: bindingChanges,
              bindingsToAdd: bindingsToAdd,
              linkedPropertyPaths: {}
            };
          });
        });
      }

      /**
       * Refresh the widget's internal state, overriding binding information as appropriate. The
       * given values will be _applied_ directly, not merged with existing values.
       * @private
       * @param {object} [changesToApply]
       * @param {Array.<module:nmodule/bajaui/rc/baja/binding/Binding>} [changesToApply.bindingsToAdd]
       * @param {Array.<object>} [changesToApply.bindingChanges]
       * @returns {Promise}
       */
    }, {
      key: "$refreshState",
      value: function $refreshState(changesToApply) {
        var _this7 = this;
        return this.read().then(function (changes) {
          return cloneWithChanges(_this7.value().map(function (node) {
            return node.value();
          }), Object.assign(changes, changesToApply));
        }).then(function (clones) {
          return Promise.all(clones.map(UxModelTreeNode.make));
        }).then(function (newNodes) {
          return _this7.toState(newNodes);
        }).then(function (_ref6) {
          var json = _ref6.json,
            bindingsToAdd = _ref6.bindingsToAdd,
            bindingChanges = _ref6.bindingChanges;
          return _this7.state({
            json: json,
            bindingsToAdd: bindingsToAdd,
            bindingChanges: bindingChanges
          });
        });
      }

      /**
       * Adding a binding is allowed if you are editing exactly 1 node, it's not readonly, and it's
       * not a NullWidget.
       * @private
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
       * @returns {boolean}
       */
    }, {
      key: "$canAddBindingTo",
      value: function $canAddBindingTo(nodes) {
        var pxLayers = this.properties().getValue('pxLayers') || [];
        return !this.isReadonly() && nodes.length === 1 && !isAnyUxModelHasAReadOnlyLayer(nodes, pxLayers) && !nodes[0].represents(NullWidget);
      }

      /**
       * Used to set the modified value of the properties widget editors to false after the UxBuilder
       * has been saved the changes
       * @param {module:bajaux/Widget} widget
       * @private
       */
    }, {
      key: "$clearModified",
      value: function $clearModified(widget) {
        var _this8 = this;
        widget = widget || this;
        var children = widget.getChildWidgets();
        children.forEach(function (child) {
          child.setModified(false);
          if (child instanceof UxBuilderPropertySheet) {
            _this8.$clearModified(child);
          }
        });
      }

      /**
       * Normalizes the properties that may have a value set in the Widget's constructor that does not
       * match the type of the corresponding bajaui value. For instance, GridPane has a columnCount of
       * 3 (a Double) but BGridPane uses a BInteger for that slot. Therefore, the user expects to see
       * an IntegerEditor on the GridPane's property sheet.
       *
       * Note that this method has a side effect of writing the change directly to the node - by
       * showing the node in the PropertiesWidget, the types of the node's values may be changed. This
       * is safe in GridPane's case because it doesn't do anything with its values that is
       * Double-specific.
       *
       * @private
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
       * @returns {Promise} to be resolved with the node's property values have been converted to the
       * expected types
       */
    }, {
      key: "$convertPropertyValueTypes",
      value: function $convertPropertyValueTypes(nodes) {
        var typesToImport = [];
        var uxModelPropertiesToConvert = [];
        nodes.forEach(function (node) {
          var propertiesToConvert = [];
          var uxModel = node.value();
          var propertyInfo = uxModel.$getDefaultPropertiesInfo();
          var properties = propertyInfo.properties;
          var metaProperties = propertyInfo.metaProperties;
          Object.keys(properties).forEach(function (key) {
            // the default value for this property, set in the Widget's constructor
            var defaultValue = properties[key];
            var metaProperty = metaProperties[key];
            if (metaProperty) {
              // the type spec for this property, set in the Widget's constructor
              var typeSpec = metaProperties[key].typeSpec;
              var defaultValueType = defaultValue.getType();
              if (defaultValueType && defaultValueType.getTypeSpec() !== typeSpec && (isNumber(defaultValue) || isString(defaultValue))) {
                if (!typesToImport.includes(typeSpec)) {
                  typesToImport.push(typeSpec);
                }
                propertiesToConvert.push({
                  propKey: key,
                  typeSpec: typeSpec
                });
              }
            }
          });
          uxModelPropertiesToConvert.push({
            uxModel: uxModel,
            propertiesToConvert: propertiesToConvert
          });
        });
        if (typesToImport.length > 0) {
          return baja.importTypes(typesToImport).then(function () {
            uxModelPropertiesToConvert.forEach(function (_ref7) {
              var uxModel = _ref7.uxModel,
                propertiesToConvert = _ref7.propertiesToConvert;
              // these are the properties
              var properties = uxModel.getProperties();
              propertiesToConvert.forEach(function (propertyToConvert) {
                var propKey = propertyToConvert.propKey,
                  typeSpec = propertyToConvert.typeSpec;
                var value = properties[propKey];
                if (isNumber(value) && typeSpec === 'baja:String') {
                  value = value.encodeToString();
                }
                value = baja.$(typeSpec, value);
                properties[propKey] = value;
              });
            });
          });
        }
        return Promise.resolve();
      }

      /**
       * @param {object} state
       * @returns {module:nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget~WidgetNodeChanges}
       */
    }, {
      key: "fromState",
      value: function fromState(_ref8) {
        var widgetChanges = _ref8.widgetChanges,
          bindingChanges = _ref8.bindingChanges,
          bindingsToAdd = _ref8.bindingsToAdd,
          linkedPropertyPaths = _ref8.linkedPropertyPaths;
        return {
          widgetChanges: widgetChanges,
          bindingChanges: bindingChanges,
          bindingsToAdd: bindingsToAdd,
          linkedPropertyPaths: linkedPropertyPaths
        };
      }

      /**
       * @param {Array<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} uxModelTreeNodes
       * @param {Object} state
       * @param {boolean} [state.readonly]
       * @param {Array<{ name: String, status: baja.FrozenEnum }>} [state.pxLayers]
       * @param {Object} state.pxProperties
       * @param {baja.Ord} state.baseOrd
       * @returns {Promise}
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget~WidgetNodeChanges>}
       */
    }, {
      key: "toContextMenuCommandGroup",
      value:
      /**
       * @param {Event} e
       * @returns {Promise.<module:bajaux/commands/CommandGroup>}
       */
      function toContextMenuCommandGroup(e) {
        var _this9 = this;
        var target = e.target;
        var self = this;
        var nodes = this.value(),
          isPropertyOfWidget = function isPropertyOfWidget(propertyName) {
            return propertyName !== 'LayerTag' && self.state().json.widgetProps.value[propertyName] != null;
          };
        if (!target) {
          return Promise.resolve(null);
        }
        var isMerged = nodes.length > 1;
        var row = Widget["in"](target.closest('.PropertySheetRow')),
          path = row.$getPath(),
          _path = _slicedToArray(path, 2),
          bucketName = _path[0],
          propertyName = _path[1],
          to = row.value();
        var isSubstitute = row.properties().getValue('substituteValue') !== null;
        var isAnimated = row.properties().getValue('isAnimated');
        var cmdGroup = new CommandGroup();

        // If propertyName is undefined or property is not a widget property (like LayerTag) then
        // just return and empty group because we cannot have context menu on the titles/buckets
        if (isSubstitute && !isAnimated || !propertyName || bucketName === 'widgetProps' && !isPropertyOfWidget(propertyName)) {
          return Promise.resolve(cmdGroup);
        }
        // We can only animate widget properties
        var canShowAnimateCmd = bucketName === 'widgetProps' && !isMerged,
          isAlreadyAnimated = false,
          isWidgetPropertyFrozen = false;
        var isAlreadyLinked = this.$isAlreadyLinked(this.$rowPathToPropertyPath(path));
        var promise = Promise.resolve(cmdGroup);
        var rowReadonly = row.isReadonly();
        var sheetReadonly = this.$getPropertySheet().isReadonly();
        if (canShowAnimateCmd) {
          promise = this.$getUsableBindings().then(function (bindings) {
            isWidgetPropertyFrozen = _this9.$isPropertyFrozen(propertyName, bindings);
            if (isWidgetPropertyFrozen) {
              return cmdGroup;
            }
            isAlreadyAnimated = _this9.$isAlreadyAnimated(propertyName, bindings);
            var canAnimate = bindings.length > 0 && _this9.$canAnimate(isAlreadyAnimated, isAlreadyLinked);
            var canUnAnimate = bindings.length > 0 && !canAnimate && !isAlreadyLinked;
            canAnimate = rowReadonly ? false : canAnimate;
            canUnAnimate = sheetReadonly || rowReadonly && !isAlreadyAnimated ? false : canUnAnimate;
            cmdGroup.add(new AddConverterCommand(propertyName, to, bindings, row, canAnimate, _this9));
            cmdGroup.add(new DeleteConverterCommand(row, canUnAnimate, _this9));
            return cmdGroup;
          });
        }
        return promise.then(function (cmdGroup) {
          if (isWidgetPropertyFrozen) {
            return cmdGroup;
          }
          var canLink = rowReadonly ? false : _this9.$canLink(isAlreadyLinked, isAlreadyAnimated);
          if (canLink) {
            var linkCmdGroup = makeLinkCommandGroup(row, row.value().getType(), _this9);
            cmdGroup.add(linkCmdGroup);
          }

          // If it is already linked, then it can Unlink
          var canUnLink = sheetReadonly || rowReadonly && !isAlreadyLinked ? false : isAlreadyLinked;
          if (canUnLink) {
            cmdGroup.add(new UnlinkPxPropertyCommand(row, _this9));
          }
          return cmdGroup;
        });
      }

      /**
       * @private
       * @returns {Promise.<Array.<Object>>}
       */
    }, {
      key: "$getUsableBindings",
      value: function $getUsableBindings() {
        var _this$state5 = this.state(),
          json = _this$state5.json,
          bindingChanges = _this$state5.bindingChanges;
        var baseOrd = this.properties().getValue('baseOrd');
        return Promise.all(Object.entries(json).map(function (_ref9) {
          var _ref10 = _slicedToArray(_ref9, 2),
            key = _ref10[0],
            bindingValue = _ref10[1].bindingValue;
          return Promise["try"](function () {
            return bindingValue && canAddConverterTo(key, bindingValue, {
              bindingChanges: bindingChanges,
              baseOrd: baseOrd
            });
          }).then(function (canAddConverter) {
            return canAddConverter && {
              key: key,
              bindingValue: bindingValue
            };
          });
        })).then(compact);
      }

      /**
       * Returns the property sheet for the widget
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/UxBuilderPropertySheet}
       */
    }, {
      key: "$getPropertySheet",
      value: function $getPropertySheet() {
        return this.queryWidget('json');
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getAddBindingCommand",
      value: function $getAddBindingCommand() {
        return this.getCommandGroup().get(0);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$showAvailableBindingsForNode",
      value: function $showAvailableBindingsForNode() {
        var _this10 = this;
        var _this$value = this.value(),
          _this$value2 = _slicedToArray(_this$value, 1),
          selectedNode = _this$value2[0];
        return getBindingTypesFor(selectedNode).then(function (bindingTypes) {
          return feDialogs.showFor({
            title: uxBuilderLex.get('PropertiesWidget.commands.addBinding.displayName'),
            type: ListOfBindingsWidget,
            value: bindingTypes
          }).then(function (selectedBinding) {
            return selectedBinding && _this10.$addBinding(selectedBinding.type);
          });
        });
      }

      /**
       * @private
       * @param {String} bindingTypeSpec
       * @returns {Promise}
       */
    }, {
      key: "$addBinding",
      value: function $addBinding(bindingTypeSpec) {
        var _this11 = this;
        return baja.importTypes([bindingTypeSpec]).then(function () {
          var _this11$state = _this11.state(),
            _this11$state$binding = _this11$state.bindingsToAdd,
            bindingsToAdd = _this11$state$binding === void 0 ? [] : _this11$state$binding,
            json = _this11$state.json;
          var binding = baja.$(bindingTypeSpec);
          var _this11$$getJsonBindi = _this11.$getJsonBindingsInfo(json),
            jsonBindingNames = _this11$$getJsonBindi.jsonBindingNames;
          binding.getName = constant(generateUniqueBindingName(jsonBindingNames, binding));
          return _this11.$refreshState({
            bindingsToAdd: [].concat(_toConsumableArray(bindingsToAdd), [binding])
          });
        }).then(function () {
          return _this11.setModified(true);
        });
      }

      /**
       * Returns the bindings stored in the array and the names of the bindings
       * @private
       * @param {Object} json the json value from the state
       * @param {boolean} [reverse] should the arrays be returned in reversed order
       * @returns {{jsonBindingKeys: Array.<String>, jsonBindingNames: Array<String>}}
       */
    }, {
      key: "$getJsonBindingsInfo",
      value: function $getJsonBindingsInfo(json) {
        var reverse = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        var jsonBindingKeys = [];
        var jsonBindingNames = [];
        Object.entries(json).forEach(function (_ref11) {
          var _ref12 = _slicedToArray(_ref11, 2),
            key = _ref12[0],
            json = _ref12[1];
          if (/binding(\d+)/.test(key)) {
            jsonBindingKeys.push(key);
            jsonBindingNames.push(json.name);
          }
        });
        if (reverse) {
          jsonBindingKeys.reverse();
          jsonBindingNames.reverse();
        }
        return {
          jsonBindingKeys: jsonBindingKeys,
          jsonBindingNames: jsonBindingNames
        };
      }

      /**
       * Deletes the binding from the state
       * @private
       * @param {String} bindingId matches the property in the state
       * @returns {Promise}
       */
    }, {
      key: "$deleteBinding",
      value: function $deleteBinding(bindingId) {
        var _this12 = this;
        var index = this.$getBindingIndex(bindingId);
        var state = this.state();
        var bindingsToAdd = withoutIndex(state.bindingsToAdd, index);
        var bindingChanges = withoutIndex(state.bindingChanges, index);
        return this.$refreshState({
          bindingsToAdd: bindingsToAdd,
          bindingChanges: bindingChanges
        }).then(function () {
          return _this12.setModified(true);
        });
      }

      /**
       * @private
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes either the nodes
       * initially loaded, or new node copies from $refreshState
       * @param {Object} params
       * @param {module:nmodule/webEditors/rc/fe/feDialogs~EditableJSON} params.widgetProps
       * @param {boolean} [params.isAnyUxModelReadOnly]
       * @returns {module:nmodule/webEditors/rc/fe/feDialogs~EditableJSON}
       */
    }, {
      key: "$applyAnimationAndLinkStatus",
      value: function $applyAnimationAndLinkStatus(nodes, _ref13) {
        var _this13 = this;
        var widgetProps = _ref13.widgetProps,
          _ref13$isAnyUxModelRe = _ref13.isAnyUxModelReadOnly,
          isAnyUxModelReadOnly = _ref13$isAnyUxModelRe === void 0 ? false : _ref13$isAnyUxModelRe;
        Object.entries(widgetProps).forEach(function (_ref14) {
          var _ref15 = _slicedToArray(_ref14, 2),
            key = _ref15[0],
            value = _ref15[1];
          _this13.$applyAnimationStatus(nodes, key, value);
          _this13.$applyLinkStatus([key], value);
          _this13.$applyReadonly({
            value: value,
            isAnyUxModelReadOnly: isAnyUxModelReadOnly
          });
          _this13.$applySubstituteModeProperties(value);
        });
        return widgetProps;
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/fe/feDialogs~EditableJSON} propertyValueObj
       */
    }, {
      key: "$applySubstituteModeProperties",
      value: function $applySubstituteModeProperties(propertyValueObj) {
        if (!this.properties().getValue('substituteMode')) {
          return;
        }
        if (propertyValueObj.properties.isAnimated) {
          propertyValueObj.properties.isSubstituteAnimated = true;
        }
      }

      /**
       * @private
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes either the nodes
       * initially loaded, or new node copies from $refreshState
       * @param {String} widgetPropertyName name of widget property
       * @param {module:nmodule/webEditors/rc/fe/feDialogs~EditableJSON} widgetPropertyValueObj value and
       * metadata for that widget property
       */
    }, {
      key: "$applyAnimationStatus",
      value: function $applyAnimationStatus(nodes, widgetPropertyName, widgetPropertyValueObj) {
        var isAnimatingThisProperty = function isAnimatingThisProperty(binding) {
          return bindingIsAnimatingWidgetProperty(binding, widgetPropertyName);
        };
        if (nodes.length === 1) {
          widgetPropertyValueObj.properties = widgetPropertyValueObj.properties || {};
          var bindings = nodes[0].value().getBindingList().getBindings();
          var widgetPropertyIsAnimated = false;
          var bindingIndex = UNBOUND_INDEX;
          bindings.forEach(function (binding, index) {
            // Apply animation status for non-frozen slots.
            if (isAnimatingThisProperty(binding)) {
              widgetPropertyIsAnimated = true;
              bindingIndex = index;
              widgetPropertyValueObj.value = baja.Ord.make(binding.getOrd());
            }
          });

          // Set a flag for the widget property to note it is animated
          widgetPropertyValueObj.properties.isAnimated = widgetPropertyIsAnimated;
          widgetPropertyValueObj.properties.bindingIndex = bindingIndex;
        } else {
          var isPropertyBound = function isPropertyBound(nodes) {
            return nodes.some(function (node) {
              var bindings = node.value().getBindingList().getBindings();
              // Apply animation status for non-frozen slots.
              return bindings.some(function (binding) {
                return isAnimatingThisProperty(binding);
              });
            });
          };
          if (isPropertyBound(nodes)) {
            widgetPropertyValueObj.properties = Object.assign(widgetPropertyValueObj.properties || {}, {
              isAnimated: true,
              isMergedProperty: true
            });
            widgetPropertyValueObj.value = '';
          }
        }
      }

      /**
       * @private
       * @param {Object} params
       * @param {Object} params.value
       * @param {boolean} [params.isAnyUxModelReadOnly]
       */
    }, {
      key: "$applyReadonly",
      value: function $applyReadonly(_ref16) {
        var value = _ref16.value,
          _ref16$isAnyUxModelRe = _ref16.isAnyUxModelReadOnly,
          isAnyUxModelReadOnly = _ref16$isAnyUxModelRe === void 0 ? false : _ref16$isAnyUxModelRe;
        var props = value.properties || {};
        value.readonly = value.readonly || this.isReadonly() || isAnyUxModelReadOnly || props.isLinked || props.isAnimated || props.substituteValue !== undefined;
      }

      /**
       * @private
       * @param {String[]} propertyPath
       * @param {module:nmodule/webEditors/rc/fe/feDialogs~EditableJSON} propertyValueObj
       */
    }, {
      key: "$applyLinkStatus",
      value: function $applyLinkStatus(propertyPath, propertyValueObj) {
        var _this14 = this;
        var nodes = this.value();
        var linkedPxPropertyNames = nodes.map(function (node) {
          return _this14.$getLinkedPxProperty(node.value(), propertyPath);
        }).filter(function (name, i, array) {
          return name && array.indexOf(name) === i;
        });
        if (linkedPxPropertyNames.length > 0) {
          propertyValueObj.properties = Object.assign(propertyValueObj.properties || {}, {
            isLinked: true,
            isMergedProperty: nodes.length > 1
          });
          propertyValueObj.value = linkedPxPropertyNames.join(',');
        } else {
          //reload scenarios requires the isLinked to be false to undo an existing link
          propertyValueObj.properties = Object.assign(propertyValueObj.properties || {}, {
            isLinked: false,
            isMergedProperty: nodes.length > 1
          });
        }
      }

      /**
       * @private
       * @param {object} params
       * @param {string} params.bindingName
       * @param {module:nmodule/webEditors/rc/fe/feDialogs~EditableJSON} params.bindingJson
       * @param {boolean} [params.isAnyUxModelReadOnly]
       * @returns {module:nmodule/webEditors/rc/fe/feDialogs~EditableJSON}
       */
    }, {
      key: "$applyLinkStatusForBinding",
      value: function $applyLinkStatusForBinding(_ref17) {
        var _this15 = this;
        var bindingName = _ref17.bindingName,
          bindingJson = _ref17.bindingJson,
          _ref17$isAnyUxModelRe = _ref17.isAnyUxModelReadOnly,
          isAnyUxModelReadOnly = _ref17$isAnyUxModelRe === void 0 ? false : _ref17$isAnyUxModelRe;
        Object.entries(bindingJson).forEach(function (_ref18) {
          var _ref19 = _slicedToArray(_ref18, 2),
            key = _ref19[0],
            value = _ref19[1];
          _this15.$applyLinkStatus([bindingName, key], value);
          _this15.$applyReadonly({
            value: value,
            isAnyUxModelReadOnly: isAnyUxModelReadOnly
          });
        });
        return bindingJson;
      }

      /**
       * @private
       * @param {String} propertyName
       * @param {Array.<module:nmodule/bajaui/rc/baja/binding/Binding>} bindings
       * @returns {boolean}
       */
    }, {
      key: "$isPropertyFrozen",
      value: function $isPropertyFrozen(propertyName, bindings) {
        return bindings.some(function (binding) {
          return binding.bindingValue.has(propertyName) && binding.bindingValue.getSlot(propertyName).isFrozen();
        });
      }

      /**
       * Check if this property is already animated.
       * @private
       * @param {String} propertyName
       * @param {Array.<module:nmodule/bajaui/rc/baja/binding/Binding>} bindings
       * @returns {boolean}
       */
    }, {
      key: "$isAlreadyAnimated",
      value: function $isAlreadyAnimated(propertyName, bindings) {
        var _this$state6 = this.state(),
          bindingChanges = _this$state6.bindingChanges;
        var bindingChange = bindingChanges.find(function (bindingObj) {
          return !isEmpty(bindingObj) && bindingObj.hasOwnProperty(propertyName);
        });

        // If there is a local change check if it was reset
        if (bindingChange) {
          return bindingChange[propertyName] !== null;
        } else {
          // If there are no local changes check if the property was already animated at load time
          return bindings.some(function (_ref20) {
            var bindingValue = _ref20.bindingValue;
            return baja.hasType(bindingValue, 'bajaui:ValueBinding') && bindingValue.has(propertyName);
          });
        }
      }

      /**
       * @private
       * @param {string} rowPath path to a row in the property sheet
       * @returns {string[]} path to that property in the UxModel
       */
    }, {
      key: "$rowPathToPropertyPath",
      value: function $rowPathToPropertyPath(rowPath) {
        var _rowPath = _slicedToArray(rowPath, 2),
          bucketName = _rowPath[0],
          propertyName = _rowPath[1];
        if (bucketName === 'widgetProps') {
          return [propertyName];
        } else {
          // binding
          return [this.state().json[bucketName].name, propertyName];
        }
      }

      /**
       * Check if this property is already linked to a PxProperty
       * @private
       * @param {String[]} propertyPath
       * @returns {boolean}
       */
    }, {
      key: "$isAlreadyLinked",
      value: function $isAlreadyLinked(propertyPath) {
        var _this16 = this;
        var nodes = this.value();
        return nodes.some(function (node) {
          return _this16.$getLinkedPxProperty(node.value(), propertyPath);
        });
      }

      /**
       * @private
       * @param {module:bajaux/model/UxModel} model
       * @param {string} propertyPath
       * @returns {string|null}
       */
    }, {
      key: "$getLinkedPxProperty",
      value: function $getLinkedPxProperty(model, propertyPath) {
        var pathStr = propertyPath.join('/');
        var _this$state7 = this.state(),
          _this$state7$linkedPr = _this$state7.linkedPropertyPaths,
          linkedPropertyPaths = _this$state7$linkedPr === void 0 ? {} : _this$state7$linkedPr;
        var linkedOnLoad = $getLinkedPropertyPaths(model)[pathStr];
        var linkedByUser = linkedPropertyPaths[pathStr];
        if (linkedByUser === null) {
          return null; // user removed it
        } else {
          return linkedByUser || linkedOnLoad;
        }
      }

      /**
       * @private
       * @param {boolean} isAlreadyAnimated
       * @param {boolean} isAlreadyLinked
       * @returns {boolean}
       */
    }, {
      key: "$canAnimate",
      value: function $canAnimate(isAlreadyAnimated, isAlreadyLinked) {
        return !isAlreadyAnimated && !isAlreadyLinked;
      }

      /**
       * @private
       * @param {boolean} isAlreadyLinked
       * @param {boolean} isAlreadyAnimated
       * @returns {boolean}
       */
    }, {
      key: "$canLink",
      value: function $canLink(isAlreadyLinked, isAlreadyAnimated) {
        return !isAlreadyAnimated && !isAlreadyLinked;
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/UxBuilderPropertySheetRow} widgetPropertyRow the source property to animate
       * @param {object} bindingObj a { key, value } pair representing the binding to apply
       * @returns {Promise}
       */
    }, {
      key: "$doAnimateProperty",
      value: function $doAnimateProperty(widgetPropertyRow) {
        var _this17 = this;
        var _ref21 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          key = _ref21.key,
          value = _ref21.value;
        var _widgetPropertyRow$$g = widgetPropertyRow.$getPath(),
          _widgetPropertyRow$$g2 = _slicedToArray(_widgetPropertyRow$$g, 1),
          bucketName = _widgetPropertyRow$$g2[0];
        return Promise["try"](function () {
          if (bucketName === 'widgetProps') {
            var index = _this17.$getBindingIndex(key);
            var newBindingsToAdd = _this17.state().bindingsToAdd.slice();
            newBindingsToAdd[index] = value;
            return _this17.$refreshState({
              bindingsToAdd: newBindingsToAdd
            }).then(function () {
              return _this17.setModified(true);
            });
          }
        });
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/UxBuilderPropertySheetRow} widgetPropertyRow
       * @param {baja.Value} value
       * @param {object} [params={}]
       * @returns {Promise}
       */
    }, {
      key: "$setRowValueAndAnimateStatus",
      value: function $setRowValueAndAnimateStatus(widgetPropertyRow, value) {
        var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var isAnimated = params.isAnimated;
        this.$togglePropertyAnimationStatus(isAnimated, widgetPropertyRow);
        var propertyName = widgetPropertyRow.getKey();
        //saving off the current inputted value, in case they remove the animate (dialog needed this)
        return widgetPropertyRow.read().then(function (readValue) {
          widgetPropertyRow.properties().add('prevValue', readValue);
          return setPropertiesSilently(widgetPropertyRow, Object.assign({
            isAnimated: isAnimated
          }, params));
        }).then(function () {
          var comp = widgetPropertyRow.$getPropertySheet().value();
          comp.set({
            slot: propertyName,
            value: value
          });
          comp.setFlags({
            slot: propertyName,
            flags: comp.getFlags(propertyName) & baja.Flags.READONLY
          });
          return widgetPropertyRow.setReadonly(true).then(function () {
            return widgetPropertyRow.load(value);
          });
        });
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/UxBuilderPropertySheetRow} widgetPropertyRow the property to unanimate
       * @returns {Promise}
       */
    }, {
      key: "$doUnanimateProperty",
      value: function $doUnanimateProperty(widgetPropertyRow) {
        var _this18 = this;
        var _this$state8 = this.state(),
          bindingChanges = _this$state8.bindingChanges;
        var _widgetPropertyRow$$g3 = widgetPropertyRow.$getPath(),
          _widgetPropertyRow$$g4 = _slicedToArray(_widgetPropertyRow$$g3, 2),
          bucketName = _widgetPropertyRow$$g4[0],
          propertyName = _widgetPropertyRow$$g4[1];
        var localBindingChangeIndex = bindingChanges.findIndex(function (bindingChange) {
          return !isEmpty(bindingChange) && bindingChange.hasOwnProperty(propertyName);
        });
        return Promise["try"](function () {
          // If there is a local change simply remove it from bindingChanges
          if (localBindingChangeIndex !== -1) {
            var newBindingChanges = bindingChanges.slice();
            newBindingChanges[localBindingChangeIndex][propertyName] = null;
            _this18.$togglePropertyAnimationStatus(false, widgetPropertyRow);
            _this18.setModified(true);
            return _this18.state({
              bindingChanges: newBindingChanges
            });
          } else {
            return _this18.$getUsableBindings().then(function (bindings) {
              var _bindings$find = bindings.find(function (_ref22) {
                  var bindingValue = _ref22.bindingValue;
                  return baja.hasType(bindingValue, 'bajaui:ValueBinding') && bindingValue.getConverter(propertyName);
                }),
                key = _bindings$find.key,
                bindingValue = _bindings$find.bindingValue;
              var index = _this18.$getBindingIndex(key);
              return bindingValue.remove(propertyName).then(function () {
                if (bucketName === 'widgetProps') {
                  var _newBindingChanges = bindingChanges.slice();
                  _newBindingChanges[index][propertyName] = null;
                  _this18.$togglePropertyAnimationStatus(false, widgetPropertyRow);
                  _this18.setModified(true);
                  return _this18.state({
                    bindingChanges: _newBindingChanges
                  });
                }
              });
            });
          }
        }).then(function () {
          // Finally reload the default instance of the original type of this property
          return _this18.$resetRowValueEditor(widgetPropertyRow, {
            isAnimated: false,
            bindingIndex: -1
          });
        });
      }

      /**
       * @private
       * @param {boolean} isAnimated
       * @param {module:nmodule/uxBuilder/rc/ux/UxBuilderPropertySheetRow} widgetPropertyRow
       */
    }, {
      key: "$togglePropertyAnimationStatus",
      value: function $togglePropertyAnimationStatus(isAnimated, widgetPropertyRow) {
        var dom = widgetPropertyRow.jq();
        if (isAnimated) {
          dom.addClass('-t-UxBuilderPropertySheetRow-animate-highlight');
          dom.on('click', '.col-value', function () {
            widgetPropertyRow.trigger(ANIMATION_EDIT_REQUESTED_EVENT, widgetPropertyRow.$getPath()[1]);
          });
        } else {
          dom.removeClass('-t-UxBuilderPropertySheetRow-animate-highlight');
          dom.off('click', '.col-value');
        }
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/UxBuilderPropertySheetRow} propertyRowToReset
       * @param {object} [params]
       * @returns {Promise}
       */
    }, {
      key: "$resetRowValueEditor",
      value: function $resetRowValueEditor(propertyRowToReset) {
        var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var _ref23 = propertyRowToReset.$getPath() || [],
          _ref24 = _slicedToArray(_ref23, 2),
          bucketName = _ref24[0],
          propertyName = _ref24[1],
          _this$value3 = this.value(),
          _this$value4 = _slicedToArray(_this$value3, 1),
          node = _this$value4[0];
        var defaultValue;
        if (bucketName === 'widgetProps') {
          defaultValue = propertyRowToReset.properties().getValue('prevValue');
          if (defaultValue === undefined || defaultValue === null) {
            defaultValue = node.value().getProperties()[propertyName];
          }
          if (defaultValue === undefined) {
            defaultValue = node.value().getDefaultProperties()[propertyName];
          }
        } else {
          var _this$state9 = this.state(),
            json = _this$state9.json,
            binding = json[bucketName].type.getInstance();
          defaultValue = binding.get(propertyName);
        }
        return Promise["try"](function () {
          return Promise.resolve(setPropertiesSilently(propertyRowToReset, Object.assign({}, params))).then(function () {
            var comp = propertyRowToReset.$getPropertySheet().value();
            comp.set({
              slot: propertyName,
              value: defaultValue
            });
            comp.setFlags({
              slot: propertyName,
              flags: comp.getFlags(propertyName) & ~baja.Flags.READONLY
            });
            return propertyRowToReset.load(defaultValue).then(function () {
              return propertyRowToReset.setReadonly(false);
            });
          });
        });
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/UxBuilderPropertySheetRow} widgetPropertyRow the source property to link from
       * @param {String} pxPropertyName the target PxProperty to link to
       * @returns {Promise}
       */
    }, {
      key: "$doLinkToPxProperty",
      value: function $doLinkToPxProperty(widgetPropertyRow, pxPropertyName) {
        var _this19 = this;
        var _ref25 = this.state() || {},
          linkedPropertyPaths = _ref25.linkedPropertyPaths,
          bindingChanges = _ref25.bindingChanges;
        var pxProperties = this.properties().getValue('pxProperties', {});
        var pxProperty = pxProperties[pxPropertyName] || {};
        var newBindingChanges = bindingChanges.slice();
        var propertyPathToLink;
        var _ref26 = widgetPropertyRow.$getPath() || [],
          _ref27 = _slicedToArray(_ref26, 2),
          bucketName = _ref27[0],
          propertyName = _ref27[1];
        if (bucketName === 'widgetProps') {
          propertyPathToLink = propertyName;
        } else {
          var bindingName = this.state().json[bucketName].name;
          var bindingChangeIndex = this.$getBindingIndex(bucketName);
          var bindingChange = newBindingChanges[bindingChangeIndex];
          bindingChange[propertyName] = pxProperty.value;
          propertyPathToLink = bindingName + '/' + propertyName;
        }
        return this.$setRowValueAndLinkStatus(widgetPropertyRow, pxPropertyName, {
          isLinked: true
        }).then(function () {
          return _this19.state({
            linkedPropertyPaths: Object.assign({}, linkedPropertyPaths, _defineProperty({}, propertyPathToLink, pxPropertyName)),
            bindingChanges: newBindingChanges
          });
        }).then(function () {
          return _this19.setModified(true);
        });
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/UxBuilderPropertySheetRow} widgetPropertyRow
       * @param {String} pxPropertyName
       * @param {object} [params={}]
       * @returns {Promise}
       */
    }, {
      key: "$setRowValueAndLinkStatus",
      value: function $setRowValueAndLinkStatus(widgetPropertyRow, pxPropertyName) {
        var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var _ref28 = params || {
            isLinked: true
          },
          isLinked = _ref28.isLinked;
        this.$togglePropertyLinkedStatus(isLinked, widgetPropertyRow);
        var propertyName = widgetPropertyRow.getKey();
        //saving off the current inputted value, in case they remove the link (dialog needed this)
        return widgetPropertyRow.read().then(function (value) {
          widgetPropertyRow.properties().add('prevValue', value);
          return setPropertiesSilently(widgetPropertyRow, Object.assign({
            isLinked: isLinked
          }, params));
        }).then(function () {
          var comp = widgetPropertyRow.$getPropertySheet().value();
          comp.set({
            slot: propertyName,
            value: pxPropertyName
          });
          comp.setFlags({
            slot: propertyName,
            flags: comp.getFlags(propertyName) & baja.Flags.READONLY
          });
          return widgetPropertyRow.setReadonly(true).then(function () {
            return widgetPropertyRow.load(pxPropertyName);
          });
        });
      }

      /**
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/UxBuilderPropertySheetRow} widgetPropertyRow the source property to unlink from
       * @returns {Promise}
       */
    }, {
      key: "$doUnlinkFromPxProperty",
      value: function $doUnlinkFromPxProperty(widgetPropertyRow) {
        var _this20 = this;
        var _ref29 = this.state() || {},
          linkedPropertyPaths = _ref29.linkedPropertyPaths,
          bindingChanges = _ref29.bindingChanges;
        var _widgetPropertyRow$$g5 = widgetPropertyRow.$getPath(),
          _widgetPropertyRow$$g6 = _slicedToArray(_widgetPropertyRow$$g5, 2),
          bucketName = _widgetPropertyRow$$g6[0],
          propertyName = _widgetPropertyRow$$g6[1];
        var propertyPathToUnlink;
        var newBindingChanges = bindingChanges.slice();
        return Promise["try"](function () {
          if (bucketName === 'widgetProps') {
            propertyPathToUnlink = propertyName;
          } else {
            var bindingObj = _this20.state().json[bucketName];
            var name = bindingObj.name;
            var bindingChangeIndex = _this20.$getBindingIndex(bucketName);
            var bindingChange = newBindingChanges[bindingChangeIndex];
            // Reset binding property to its default
            bindingChange[propertyName] = null;
            propertyPathToUnlink = name + '/' + propertyName;
          }
          _this20.$togglePropertyLinkedStatus(false, widgetPropertyRow);
          return _this20.state({
            linkedPropertyPaths: Object.assign({}, linkedPropertyPaths, _defineProperty({}, propertyPathToUnlink, null)),
            bindingChanges: newBindingChanges
          }).then(function () {
            return _this20.setModified(true);
          });
        }).then(function () {
          // Reset link and reload the default instance of this property
          return _this20.$resetRowValueEditor(widgetPropertyRow, {
            isLinked: false
          });
        });
      }

      /**
       * @private
       * @param {boolean} isLinked
       * @param {module:nmodule/uxBuilder/rc/ux/UxBuilderPropertySheetRow} widgetPropertyRow
       */
    }, {
      key: "$togglePropertyLinkedStatus",
      value: function $togglePropertyLinkedStatus(isLinked, widgetPropertyRow) {
        var dom = widgetPropertyRow.jq();
        dom.toggleClass('-t-UxBuilderPropertySheetRow-link-highlight', !!isLinked);
      }

      /**
       * @private
       * @param {String} propertyName
       * @param {module:bajaux/Widget} [rowEd]
       * @returns {Promise}
       */
    }, {
      key: "$animatedPropertyCellClickHandler",
      value: function $animatedPropertyCellClickHandler(propertyName, rowEd) {
        var _this21 = this;
        var bindingChangeIndex = -1,
          promise;
        var _this$state10 = this.state(),
          json = _this$state10.json,
          bindingChanges = _this$state10.bindingChanges;
        var baseOrd = this.properties().getValue('baseOrd');
        var newBindingChanges = bindingChanges.slice();
        var binding;
        // Check if there is any local animation set for the property
        var localBindingChange = newBindingChanges.find(function (bindingChange) {
          var bindingIndex = rowEd && rowEd.properties().getValue('bindingIndex') || 0;
          var jsonEntry = json['binding' + bindingIndex];
          binding = jsonEntry && jsonEntry.bindingValue;
          return !isEmpty(bindingChange) && bindingChange.hasOwnProperty(propertyName);
        });
        if (localBindingChange) {
          promise = Promise.resolve(localBindingChange[propertyName]);
          //converterValue
        } else {
          promise = Promise.all(Object.entries(json).map(function (_ref30) {
            var _ref31 = _slicedToArray(_ref30, 2),
              key = _ref31[0],
              bindingValue = _ref31[1].bindingValue;
            return canAddConverterTo(key, bindingValue, {
              bindingChanges: bindingChanges,
              baseOrd: baseOrd
            }).then(function (isBound) {
              return isBound ? key : undefined;
            });
          })).then(function (bucketNames) {
            return bucketNames.find(function (bucketName) {
              return !!bucketName;
            });
          }).then(function (bucketName) {
            bindingChangeIndex = _this21.$getBindingIndex(bucketName);
            binding = json[bucketName].bindingValue;
            return binding.getConverter(propertyName);
          });
        }
        return promise.then(function (converterValue) {
          return _this21.$resolveFromTarget(binding, rowEd).then(function (fromTarget) {
            var from = fromTarget && fromTarget.getObject();
            var to;
            var properties = json.widgetProps.properties;
            if (properties.pxDataTypeSpec) {
              var widgetInstance = baja.$(properties.pxDataTypeSpec);
              to = widgetInstance.get(propertyName);
            }
            converterValue = converterValue.newCopy(true);
            configureConverterWithUxBuilderProperties(converterValue, from, to, fromTarget, binding, propertyName);
            return feDialogs.showFor({
              value: converterValue,
              formFactor: 'any',
              properties: converterValue.getFacets().toObject()
            });
          }).then(function (readValue) {
            if (!readValue) {
              return;
            }
            return Promise["try"](function () {
              if (readValue instanceof ComplexDiff) {
                var value = converterValue.newCopy(true);
                return readValue.apply(value);
              } else {
                return readValue;
              }
            }).then(function (newValue) {
              newValue = newValue.newCopy(true);
              if (localBindingChange) {
                localBindingChange[propertyName] = newValue;
              } else {
                newBindingChanges[bindingChangeIndex][propertyName] = newValue;
              }
              _this21.setModified(true);
              return _this21.state({
                bindingChanges: newBindingChanges
              });
            });
          });
        });
      }

      /**
       * @private
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
       * @returns {Promise.<String>}
       */
    }, {
      key: "$toDisplay",
      value: function $toDisplay(nodes) {
        if (nodes.length > 1) {
          return Promise.resolve(uxBuilderLex.get('PropertiesWidget.subtitle.multipleWidgets'));
        } else if (this.properties().getValue('substituteMode')) {
          return resolveWidgetDisplayName(nodes[0].value()); //avoid showing the Binding and also avoid showing "root" when Preserve Identities=true
        } else {
          var preserveIdentities;
          return UxModelTreeNode.$getUxBuilderOptions().then(function (options) {
            preserveIdentities = options.getPreserveIdentities();
            return nodes[0].toDisplay(true);
          }).then(function (name) {
            name = name.replace(/ /g, '');
            return preserveIdentities ? name : toFriendly(name);
          });
        }
      }

      /**
       * @private
       * @param {baja.Component|null} binding
       * @param {module:bajaux/Widget} [rowEd]
       * @returns {Promise.<module:baja/ord/OrdTarget|undefined>}
       */
    }, {
      key: "$resolveFromTarget",
      value: function $resolveFromTarget(binding, rowEd) {
        var _this22 = this;
        if (binding) {
          var target = binding.getOrdTarget();
          return Promise.resolve(target);
        }
        if (!rowEd) {
          return Promise.resolve();
        }
        return rowEd.read() //Once NCCB-69661 fixes the animation ord for the row, this should hopefully pick up any modified binding ord.
        .then(function (child) {
          var base = _this22.properties().getValue('baseOrd');
          return baja.Ord.make({
            base: base,
            child: child
          }).resolve({
            lease: true
          });
        })["catch"](function () {});
      }
    }], [{
      key: "promptForChanges",
      value: function promptForChanges(uxModelTreeNodes, _ref32) {
        var readonly = _ref32.readonly,
          pxLayers = _ref32.pxLayers,
          pxProperties = _ref32.pxProperties,
          baseOrd = _ref32.baseOrd;
        // TODO NCCB-65624
        var WrappedPropertiesWidget = /*#__PURE__*/function (_spandrel2) {
          function WrappedPropertiesWidget(params) {
            var _this23;
            _classCallCheck(this, WrappedPropertiesWidget);
            _this23 = _callSuper(this, WrappedPropertiesWidget, [{
              params: params,
              defaults: {
                properties: {
                  rootCssClass: '-t-WrappedPropertiesWidget'
                }
              }
            }]);
            _this23.validators().add(function () {
              return _this23.$validateForReadErrors();
            });
            return _this23;
          }

          /**
           * @private
           * @returns {Promise}
           */
          _inherits(WrappedPropertiesWidget, _spandrel2);
          return _createClass(WrappedPropertiesWidget, [{
            key: "$validateForReadErrors",
            value: function $validateForReadErrors() {
              // When you have errors in modified rows of the PropertiesWidget,
              // then reset the readError and reject the validation.
              var propertiesWidget = this.$getPropertiesWidget();
              var readErrorStr = propertiesWidget.$getReadErrorsAsString();
              if (!isEmpty(readErrorStr)) {
                throw new Error(readErrorStr);
              }
            }
          }, {
            key: "doRead",
            value: function doRead() {
              return this.$getPropertiesWidget().read();
            }
          }, {
            key: "requestFocus",
            value: function requestFocus() {
              return this.$getPropertiesWidget().requestFocus();
            }

            /**
             * @private
             * @returns {module:bajaux/Widget}
             */
          }, {
            key: "$getPropertiesWidget",
            value: function $getPropertiesWidget() {
              return this.queryWidget('*').$getContentWidget();
            }
          }]);
        }(spandrel(function () {
          return UxModel.jsx(TitlePane, null, UxModel.jsx(PropertiesWidget, {
            name: "content",
            value: uxModelTreeNodes,
            readonly: readonly,
            properties: {
              pxLayers: pxLayers,
              pxProperties: pxProperties,
              baseOrd: baseOrd
            }
          }));
        }));
        return feDialogs.showFor({
          type: WrappedPropertiesWidget,
          value: {}
        });
      }
    }]);
  }(spandrel(function (_, _ref33) {
    var json = _ref33.json,
      self = _ref33.self,
      properties = _ref33.properties;
    var addBindingCmd = self.$getAddBindingCommand();
    addBindingCmd.setEnabled(self.$canAddBindingTo(self.value()));
    var className = "-t-PropertiesWidget-propertySheet";
    if (properties.substituteMode === true) {
      className += " -t-PropertiesWidget-substituteMode";
    }
    return UxModel.jsx(UxBuilderPropertySheet, {
      className: className,
      spandrelKey: "json",
      value: json,
      lax: true // TODO: 65372
      ,
      on: _defineProperty({}, ANIMATION_EDIT_REQUESTED_EVENT, function (e, ed, rowEd, propertyName) {
        return self.$animatedPropertyCellClickHandler(propertyName, rowEd)["catch"](feDialogs.error);
      })
    });
  }, {
    strategy: 'niagara'
  }));
  /**
   * Returns true when any uxModel in the selected nodes has a pxLayer in a 'locked' state.
   *
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} pxLayers
   * @returns {boolean}
   */
  function isAnyUxModelHasAReadOnlyLayer(nodes, pxLayers) {
    // If any one of the selected node's layer is in locked state,
    // then let caller know that one of the uxModel cannot be modified, and it is in readonly state.
    return nodes && nodes.some(function (node) {
      return isUxModelLocked(node.value(), pxLayers);
    });
  }

  /**
   * @param {module:nmodule/bajaui/rc/baja/binding/Binding} binding
   * @param {string} widgetPropertyName
   * @returns {boolean}
   */
  function bindingIsAnimatingWidgetProperty(binding, widgetPropertyName) {
    // when you animate a widget property from a binding, that binding gets a dynamic slot
    // with the same name as the animated widget property.
    return binding.has(widgetPropertyName) && !binding.getSlot(widgetPropertyName).isFrozen();
  }
  function withoutIndex(arr, i) {
    var ret = arr.slice();
    ret.splice(i, 1);
    return ret;
  }
  return PropertiesWidget;
});

/**
 * Information about the changes that the user wants to make to the selected nodes.
 *
 * @typedef module:nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget~WidgetNodeChanges
 * @property {object} [widgetChanges] the widget property names and values that the user changed
 * @property {Array.<Object.<string, baja.Value|null>>} [bindingChanges] property names and values
 * that the user changed on each binding in `bindingsToAdd`. if the value is null, consider that
 * value "unset" by the user, and reset it to the default slot value on save. this would happen when
 * a binding property was unanimated. Not present if multiple nodes are edited.
 * @property {Array.<module:nmodule/bajaui/rc/baja/binding/Binding>} [bindingsToAdd] the bindings
 * to set on the node. Not present if multiple nodes are edited.
 * @property {Object.<string, string>} [linkedPropertyPaths] a map from property path (/-separated)
 * to the PxProperty name that property is linked to for that node. the value will be falsy if
 * the user chose to unlink that property path. (this represents the link changes that the *user*
 * entered while using the PropertiesWidget.) this can include widget properties, and paths into
 * Binding properties.
 */

/**
 * Describes the state of the PropertiesWidget.
 *
 * When implementing, it is important to remember that this information will be used to calculate
 * changes that are made to the actual Px page. These changes will occur in two different ways:
 *
 * - Instantly, when a change is made to the Properties sidebar. The user types and immediately sees
 *   their changes reflected in the preview pane.
 * - In batch, after the user makes several changes in the Properties dialog. The user will make
 *   multiple changes, click OK, and then those changes will be applied at once.
 *
 * For cases where the user might multi-select more than one node, and make changes to them all at
 * once, we keep track of *only* those changed properties, under `widgetChanges`. This is because we
 * don't want to overwrite any properties that the user did *not* change.
 *
 * @typedef module:nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget~PropertiesWidgetState
 * @property {module:nmodule/webEditors/rc/fe/feDialogs~EditableJSON} json a json representation of
 * the contents of the property sheet, as created *at the time the nodes were first loaded*. it does
 * not update over time. It contains one bucket, "widgetProps", for the properties of the edited
 * widget, and 0 or more buckets starting with the name "binding" for the properties of any
 * bindings.
 * @property {Object.<string, baja.Value>} widgetChanges a mapping of property name to property
 * value, for the changes to widget properties that the user made
 * @property {Array.<Object.<string, baja.Value>>} bindingChanges mappings of property path
 * (`/`-separated) to property value, for the changes to binding properties that the user made.
 * There is one for each binding, so if the user did not make changes to a binding, an empty object
 * will be at that index.
 * @property {Array.<baja.Component>} [bindingsToAdd] new bindings to add to the widget (not present
 * when PropertiesWidget is not editable)
 * @property {object} [linkedPropertyPaths] any linked property paths (not present when
 * PropertiesWidget is not editable)
 * @see module:nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget#toState
 * @see module:nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget#fromState
 */
