function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */
/* global niagara */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/sidebars/BoundOrdsEditor
 */

define(["baja!", 'bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'jquery', 'lex!uxBuilder', 'log!nmodule.uxBuilder.ux.UxBuilder', 'Promise', 'nmodule/bajaui/rc/ux/PxInclude', 'nmodule/uxBuilder/rc/fe/BoundOrdReplaceEditor', 'nmodule/uxBuilder/rc/util/uxBuilderEvents', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/ValueWithPopoutWidget', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport', 'nmodule/webEditors/rc/wb/profile/profileUtils', 'nmodule/webEditors/rc/wb/table/EditTable', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/columns/IconColumn', 'nmodule/webEditors/rc/wb/table/model/columns/ToStringColumn', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/uxBuilder/rc/util/uxBuilderUtils'], function (baja, spandrel, Command, CommandGroup, $, lexs, log, Promise, PxInclude, BoundOrdReplaceEditor, uxBuilderEvents, feDialogs, ValueWithPopoutWidget, addContextMenuSupport, profileUtils, EditTable, Table, IconColumn, ToStringColumn, TableModel, uxBuilderUtils) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var logInfo = log.info.bind(log);
  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var CELL_ACTIVATED_EVENT = Table.CELL_ACTIVATED_EVENT;
  var display = EditTable.columns.display;
  var okIcon = baja.Icon.make([uxBuilderLex.get('BoundOrdsEditor.commands.relativizeOk.icon')]);
  var notOkIcon = baja.Icon.make([uxBuilderLex.get('BoundOrdsEditor.commands.relativizeNotOk.icon')]);
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'uxBuilder',
      keyName: 'BoundOrdsEditor',
      properties: {
        rootCssClass: '-t-BoundOrdsEditor'
      }
    };
  };

  /**
   * Resolves the Ord to a relativized base.
   *
   * @param {baja.Ord} ord
   * @returns {Promise}
   */
  function resolveOrd(ord) {
    return baja.Ord.make({
      base: profileUtils.getCurrentOrd().relativizeToSession(),
      child: ord
    }).resolve();
  }

  /**
   * @class
   * @inner
   * @extends module:nmodule/webEditors/rc/wb/table/model/columns/IconColumn
   */
  var RelativizeOrdColumn = /*#__PURE__*/function (_IconColumn) {
    function RelativizeOrdColumn() {
      _classCallCheck(this, RelativizeOrdColumn);
      return _callSuper(this, RelativizeOrdColumn, arguments);
    }
    _inherits(RelativizeOrdColumn, _IconColumn);
    return _createClass(RelativizeOrdColumn, [{
      key: "getValueFor",
      value: function getValueFor(row) {
        return baja.Icon.make([row.getSubject().icon.value]);
      }
    }]);
  }(IconColumn);
  var relativizeTableColumns = [new RelativizeOrdColumn('icon'), display('before', {
    displayName: uxBuilderLex.get('BoundOrdsEditor.commands.relativize.before')
  }), display('after', {
    displayName: uxBuilderLex.get('BoundOrdsEditor.commands.relativize.after')
  })];
  var $getBoundOrdsFromUxModelTree = uxBuilderUtils.$getBoundOrdsFromUxModelTree,
    relativizeOrd = uxBuilderUtils.relativizeOrd;

  /**
   * Sidebar for the UxBuilder that handles the BoundOrds of an UxModel
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/sidebars/BoundOrds
   * @extends module:bajaux/Widget
   * @since Niagara 4.15
   */
  var BoundOrds = /*#__PURE__*/function (_spandrel) {
    function BoundOrds(params) {
      var _this;
      _classCallCheck(this, BoundOrds);
      _this = _callSuper(this, BoundOrds, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$editOrdCommand = new Command({
        module: 'uxBuilder',
        lex: 'commands.editOrd',
        func: function func() {
          return _this.$promptForEditOrd();
        }
      });
      _this.$relativizeOrdCommand = new Command({
        module: 'uxBuilder',
        lex: 'BoundOrdsEditor.commands.relativize',
        func: function func() {
          return _this.$promptRelativizeOrdDialog();
        }
      });
      _this.getCommandGroup().add(_this.$relativizeOrdCommand);
      _this.$replaceOrdCommand = new Command({
        module: 'uxBuilder',
        lex: 'BoundOrdsEditor.commands.searchReplace',
        func: function func() {
          return _this.$promptForSearchReplaceDialog();
        }
      });
      _this.getCommandGroup().add(_this.$replaceOrdCommand);
      addContextMenuSupport(_this);
      return _this;
    }

    /**
     * @private
     * @param {Array.<baja.Ord>} boundOrds
     * @returns {Promise.<Array.<baja.Struct>>}
     */
    _inherits(BoundOrds, _spandrel);
    return _createClass(BoundOrds, [{
      key: "$getMatchedPxLayers",
      value: function $getMatchedPxLayers(boundOrds) {
        var uxModelTreeNode = this.properties().getValue('getRootNode')();
        var filterFunction = function filterFunction(treeNode) {
          return doesNodeHaveSelectedBoundOrds(boundOrds, treeNode.value());
        };
        return uxBuilderUtils.findAllMatchingNodes(uxModelTreeNode, filterFunction).then(function (matchedNodes) {
          return matchedNodes.map(function (uxModelTreeNode) {
            return uxModelTreeNode.value().getProperties().LayerTag;
          }).filter(function (layerTag) {
            return !!layerTag;
          });
        });
      }

      /**
       * Will set the visibility of the commands based on following conditions.
       * Is BoundOrdsEditor readonly.
       * layer is locked/invisible
       * Is editor not file based (for relativizeOrdCommand only)
       *
       * @private
       * @param {Array.<baja.Ord>} boundOrds
       * @returns {Promise}
       */
    }, {
      key: "$setCommandVisibility",
      value: function $setCommandVisibility(boundOrds) {
        var _this2 = this;
        var pxLayers = this.properties().getValue('pxLayers', []);
        return this.$getMatchedPxLayers(boundOrds).then(function (pxLayersForNodesWithBoundOrds) {
          var isAnyLayerNotNormal = pxLayersForNodesWithBoundOrds.find(function (pxLayerForNode) {
            return pxLayers.find(function (pxLayer) {
              return pxLayer.name === pxLayerForNode.getLayerName() && !baja.$('bajaui:LayerStatus', 'normal').equals(pxLayer.status);
            });
          });
          var fileBased = _this2.properties().getValue('fileBased');
          _this2.$relativizeOrdCommand.setEnabled(!_this2.isReadonly() && !isAnyLayerNotNormal && !fileBased);
          _this2.$replaceOrdCommand.setEnabled(!_this2.isReadonly() && !isAnyLayerNotNormal);
        });
      }

      /**
       * @private
       * @param {Array.<baja.Ord>} boundOrds
       * @returns {Array.<{ icon: baja.Icon, before: baja.Ord, after: baja.Ord }>}
       */
    }, {
      key: "$validateAndGetRelativizedOrds",
      value: function $validateAndGetRelativizedOrds(boundOrds) {
        var baseOrd = this.properties().getValue('baseOrd');
        return boundOrds.map(function (boundOrd) {
          try {
            var relativizedOrd = relativizeOrd(baseOrd, boundOrd);
            return {
              icon: {
                value: okIcon
              },
              before: {
                value: boundOrd
              },
              after: {
                value: relativizedOrd
              }
            };
          } catch (error) {
            logSevere(error);
          }
          return {
            icon: {
              value: notOkIcon
            },
            before: {
              value: boundOrd
            },
            after: {
              value: boundOrd
            }
          };
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$promptRelativizeOrdDialog",
      value: function $promptRelativizeOrdDialog() {
        var _this3 = this;
        var relativizedBoundOrds = this.$validateAndGetRelativizedOrds(this.state().boundOrds);
        return feDialogs.showFor({
          title: uxBuilderLex.get('BoundOrdsEditor.commands.relativize.displayName'),
          value: relativizedBoundOrds,
          type: EditTable,
          properties: {
            columns: relativizeTableColumns,
            showControls: false,
            rootCssClass: '-t-BoundOrdsEditor-relativizeOrd-dialog'
          }
        }).then(function (response) {
          return response && _this3.$triggerOrdRelativizeRequested(relativizedBoundOrds);
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$promptForSearchReplaceDialog",
      value: function $promptForSearchReplaceDialog() {
        var _this4 = this;
        var selectedRows = this.$getTable().getSelectedRows();
        var selectedOrds;
        if (selectedRows.length > 0) {
          selectedOrds = selectedRows.map(function (row) {
            return row.getSubject();
          });
        } else {
          selectedOrds = this.state().boundOrds;
        }
        var searchReplaceParam = selectedOrds.map(function (selectedOrd) {
          return {
            fromOrd: selectedOrd,
            toOrd: selectedOrd
          };
        });
        return feDialogs.showFor({
          title: uxBuilderLex.get('BoundOrdsEditor.commands.searchReplace.displayName'),
          value: searchReplaceParam,
          type: BoundOrdReplaceEditor
        }).then(function (ordChanges) {
          if (ordChanges && ordChanges.length > 0) {
            return _this4.$triggerOrdReplaceRequested(ordChanges, 'commands.searchReplace');
          }
        });
      }

      /**
       * Apply the changes to the ords
       * @private
       * @param {Array.<Object>} ordChanges and array of objects in the format of {fromOrd: baja.Ord, toOrd: baja.Ord}
       * @param {String} lexKey the key for the undo and redo lexicon entries
       */
    }, {
      key: "$triggerOrdReplaceRequested",
      value: function $triggerOrdReplaceRequested(ordChanges, lexKey) {
        ordChanges = ordChanges.filter(function (_ref) {
          var fromOrd = _ref.fromOrd,
            toOrd = _ref.toOrd;
          return fromOrd.encodeToString() !== toOrd.encodeToString();
        });
        ordChanges.length && this.trigger(uxBuilderEvents.ORD_REPLACEMENT_REQUESTED, ordChanges, lexKey);
      }

      /**
       * @private
       * @param {Array.<{ icon: baja.Icon, before: baja.Ord, after: baja.Ord }>} relativizedBoundOrds
       */
    }, {
      key: "$triggerOrdRelativizeRequested",
      value: function $triggerOrdRelativizeRequested(relativizedBoundOrds) {
        var fromToObjArray = [];
        relativizedBoundOrds.forEach(function (_ref2) {
          var icon = _ref2.icon,
            before = _ref2.before,
            after = _ref2.after;
          if (okIcon.equals(icon.value)) {
            fromToObjArray.push({
              fromOrd: before.value,
              toOrd: after.value
            });
          }
        });
        fromToObjArray.length && this.trigger(uxBuilderEvents.ORD_REPLACEMENT_REQUESTED, fromToObjArray, 'commands.relativize');
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$promptForEditOrd",
      value: function $promptForEditOrd() {
        var _this5 = this;
        var selectedRows = this.$getTable().getSelectedRows();
        if (selectedRows.length !== 1 || this.isReadonly()) {
          return Promise.resolve();
        }
        var ordString = selectedRows[0].getSubject();
        var fromOrd = baja.Ord.make(ordString);
        var dom = $('<div class="-t-BoundOrdsEditor-dialog"></div>');
        return feDialogs.showFor({
          dom: dom,
          value: fromOrd,
          type: ValueWithPopoutWidget,
          formFactor: 'mini',
          title: uxBuilderLex.get('commands.editOrd.displayName'),
          properties: {
            popoutCssClass: 'ux-btn-tb',
            chooseView: true,
            allowHyperlink: false //hyperlink turned off because we will use the GotoOrdCommand on the context menu
          }
        }).then(function (toOrd) {
          if (toOrd && !fromOrd.equivalent(toOrd)) {
            _this5.trigger(uxBuilderEvents.ORD_REPLACEMENT_REQUESTED, [{
              fromOrd: fromOrd,
              toOrd: toOrd
            }], 'commands.editOrd');
          }
        });
      }

      /**
       * Builds the sidebar editor for the BoundOrds
       * @private
       * @returns {object}
       */
    }, {
      key: "$buildEditor",
      value: function $buildEditor() {
        var _this6 = this;
        var keyModel = new TableModel({
          rows: this.state().boundOrds,
          columns: [new ToStringColumn(' ')]
        });
        return [spandrel.jsx(Table, {
          spandrelKey: "boundOrdsTable",
          className: "-t-BoundOrdsEditor-table",
          on: _defineProperty({}, CELL_ACTIVATED_EVENT, function () {
            return _this6.$editOrdCommand.invoke();
          }),
          value: keyModel
        })];
      }

      /**
       * Extracts the BoundOrds from the UxModel and stores them in the state for the editor
       * @param {module:bajaux/model/UxModel} model
       * @returns {Object}
       */
    }, {
      key: "toState",
      value: function toState(model) {
        var _this7 = this;
        return $getBoundOrdsFromUxModelTree(model).then(function (boundOrds) {
          boundOrds.sort();
          return _this7.$setCommandVisibility(boundOrds).then(function () {
            return {
              boundOrds: boundOrds
            };
          });
        });
      }

      /**
       * Returns the jq selector that the context menu is to trigger off of.
       * @returns {string}
       */
    }, {
      key: "getContextMenuSelector",
      value: function getContextMenuSelector() {
        return 'tr';
      }

      /**
       * Builds the context menu on right mouse click based on selected nodes
       * @param {Event} event the event that triggered the context menu
       * @returns {module:bajaux/commands/CommandGroup}
       */
    }, {
      key: "toContextMenuCommandGroup",
      value: function toContextMenuCommandGroup(event) {
        var _this8 = this;
        var cmdGroup = new CommandGroup();
        var commands = cmdGroup.getChildren();
        var target = event.currentTarget;
        var selectedIdx = target ? target.rowIndex : undefined;
        var selectedOrd = this.$getTable().getModel().getRow(selectedIdx).getSubject();
        var goToOrdCommand = new Command({
          module: 'uxBuilder',
          lex: 'BoundOrdsEditor.commands.gotoOrd',
          enabled: function enabled() {
            return true;
          },
          func: function func() {
            return _this8.$hyperlinkTo(selectedOrd);
          }
        });
        commands.push(goToOrdCommand);
        cmdGroup.setChildren(commands);

        // Resolve the selectedOrd and disable the command when there is an error while the ord resolution.
        return resolveOrd(selectedOrd)["catch"](function (err) {
          // When ord resolution fails, the GotoOrdCommand will be disabled and user cannot hypelink to unresolvable ord.
          logInfo(err);
          goToOrdCommand.setEnabled(false);
        }).then(function () {
          return cmdGroup;
        });
      }

      /**
       * @private
       * @param {baja.Ord} ord
       * @returns {Promise}
       */
    }, {
      key: "$hyperlinkTo",
      value: function $hyperlinkTo(ord) {
        return resolveOrd(ord).then(function (result) {
          // When the target component is not navigable for example; like a slot, then we will navigate to its component.
          if (result.getComponent()) {
            return niagara.env.hyperlink(result.getComponent().getNavOrd());
          }
          // When target is a navigable Component, we will hyperlink to it.
          return niagara.env.hyperlink(ord);
        });
      }

      /**
       * Returns the table widget
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/Table}
       */
    }, {
      key: "$getTable",
      value: function $getTable() {
        return this.queryWidget('boundOrdsTable');
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    return self.$buildEditor();
  }, {
    strategy: 'niagara'
  }));
  /**
   * @param {Array.<baja.Ord>} allBoundOrds
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {boolean}
   */
  function doesNodeHaveSelectedBoundOrds(allBoundOrds, uxModel) {
    var boundOrds = uxBuilderUtils.$getBoundOrdsFromUxModel(uxModel);
    var isInProperties = allBoundOrds.find(function (selectedBoundOrd) {
      return boundOrds.find(function (boundOrd) {
        return boundOrd.equivalent(selectedBoundOrd);
      });
    });
    return !!isInProperties;
  }
  return BoundOrds;
});
