function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/model/UxModelTreeNodeEnvelope
 */
define(['baja!', 'Promise', 'underscore', 'bajaux/dragdrop/Envelope', 'nmodule/bajaui/rc/baja/Layout', 'nmodule/bajaui/rc/ux/CanvasPane'], function (baja, Promise, _, Envelope, Layout, CanvasPane) {
  'use strict';

  /**
   * Envelope for transforming raw JSON into UxModelTreeNode instances, or vice versa.
   *
   * @class
   * @extends module:bajaux/dragdrop/Envelope
   * @alias module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNodeEnvelope
   * @since Niagara 4.15
   */
  var UxModelTreeNodeEnvelope = /*#__PURE__*/function (_Envelope) {
    /**
     * @private
     * @param {Object} [params] the object literal for the method's arguments.
     * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} [params.parent] the parent that will be used for insertion.
     * @param {Object} [params.json] encoded json of the input node
     * @throws {Error} if a non-Array given
     */
    function UxModelTreeNodeEnvelope() {
      var _this;
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        parent = _ref.parent,
        json = _ref.json;
      _classCallCheck(this, UxModelTreeNodeEnvelope);
      _this = _callSuper(this, UxModelTreeNodeEnvelope, arguments);
      _this.$parent = parent;
      _this.$json = json;
      return _this;
    }

    /**
     * @param {Array.<nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes either an array of raw
     * JSON to be converted to UxModelTreeNode, or an array of UxModelTreeNode to be converted
     * @param {Object} [params] the object literal for the method's arguments.
     * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} [params.parent] the parent that will be used for insertion.
     * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties} [params.pxProperties]
     * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNodeEnvelope>}
     */
    _inherits(UxModelTreeNodeEnvelope, _Envelope);
    return _createClass(UxModelTreeNodeEnvelope, [{
      key: "getMimeType",
      value:
      /**
       * @returns {string} `niagara/ux-model-tree-node`
       */
      function getMimeType() {
        return 'niagara/ux-model-tree-node';
      }

      /**
       * Get the JSON representations of the envelope's UxTreeNodes:
       * @see module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode#encodeToJson
       * @returns {Promise.<Array.<object>>} promise to be resolved with an array of raw
       * JSON objects
       */
    }, {
      key: "toJson",
      value: function toJson() {
        return Promise.resolve(this.$json);
      }

      /**
       * Get the actual Widgets represented by this envelope.
       *
       * @returns {Promise.<Array.<{ widget: baja.Component, linkedPropertyPaths: object }>>} array
       * containing baja.Component instances (subclasses of `bajaui:Widget`) and any Px Properties
       * their own property paths are linked to.
       */
    }, {
      key: "toValues",
      value: function toValues() {
        var _this2 = this;
        var json = this.$json,
          values = this.$values,
          parent = this.$parent;
        if (values) {
          return Promise.resolve(values);
        }
        return Promise.resolve().then(function () {
          return Promise.all(_.map(json, function (row) {
            return toValue(row);
          }));
        }).then(function (values) {
          var widgets = _.pluck(values, 'widget');
          if (parent && parent.represents(CanvasPane)) {
            //See BPxTree.java#makeInsertCommand, the PxEditor is able to utilize the widget's entire bounds
            //to determine an appropriate shift amount based on Artisan Bounds. Since Widget bounds are
            //not yet available for unmounted widgets, we are just utilizing any existing widget layouts
            //to keep the differences between the widgets consistent, but shift them to the top/left
            //until an artisan drop starts invoking this with a specific destination.
            var shiftAmount = getShiftAmount(widgets);
            shiftLayout(widgets, shiftAmount.x, shiftAmount.y);
          }
          return _this2.$values = values.map(function (_ref2) {
            var widget = _ref2.widget;
            return {
              widget: widget
            };
          });
        });
      }
    }], [{
      key: "make",
      value: function make(nodes) {
        var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          parent = _ref3.parent,
          pxProperties = _ref3.pxProperties;
        if (!Array.isArray(nodes)) {
          throw new Error('array required');
        }
        return Promise.all(nodes.map(function (node) {
          if (node && node.encodeToJson) {
            return node.encodeToJson({
              pxProperties: pxProperties
            });
          }
          return node;
        })).then(function (json) {
          return new UxModelTreeNodeEnvelope({
            parent: parent,
            json: json
          });
        });
      }
    }]);
  }(Envelope);
  /**
   * @param {Object} obj
   * @returns {Promise.<{ name: String, widget: baja.Component}>}
   */
  function toValue(obj) {
    var typeSpec = obj.t;
    var name = obj.n;
    return baja.importTypes([typeSpec]).then(function () {
      var widget = baja.$(typeSpec);
      widget.add({
        slot: 'linkedPropertyPaths',
        value: JSON.stringify(obj.l),
        flags: baja.Flags.TRANSIENT
      });
      return Promise.all((obj.k || []).map(function (kid) {
        return toValue(kid).then(function (kidData) {
          var name = kidData.name,
            kid = kidData.widget;
          if (widget.getSlot(name) === null) {
            widget.add({
              slot: name,
              value: kid
            });
          } else {
            widget.set({
              slot: name,
              value: kid
            });
          }
        });
      })).then(function () {
        return Promise.all((obj.p || []).map(function (bson) {
          return baja.bson.decodeAsync(bson.v).then(function (decodedValue) {
            var propertyName = bson.n;

            //ensure to utilize the flags for dynamic WebWidget properties
            var flags = bson.f;
            var flagMask = flags && baja.Flags.decodeFromString(flags) || 0;
            if (widget.getSlot(propertyName) === null) {
              widget.add({
                slot: propertyName,
                value: decodedValue,
                flags: flagMask
              });
            } else {
              widget.set({
                slot: propertyName,
                value: decodedValue
              });
            }
          });
        }));
      }).then(function () {
        return Promise.all((obj.bnd || []).map(function (bson) {
          return baja.bson.decodeAsync(bson).then(function (binding) {
            return widget.add({
              value: binding
            });
          });
        }));
      }).then(function () {
        return {
          widget: widget,
          name: name
        };
      });
    });
  }

  /**
   * @param {Array.<baja.Component>} widgets
   * @returns {{x: number, y: number}}
   */
  function getShiftAmount(widgets) {
    //TODO NCCB-67876: see BPxTree.java#makeInsertCommand, the artisans need to know the bounds of the widgets.
    //For now, we'll move based on an any pre-defined absolute layout specified, but this does not take into
    //account many things like shapes, Layout.fill, Layout.percentage, etc. It also doesn't help when
    //copying multiple widgets from a non-canvasParent (like from the Palette) where the layout is all zero
    // and it needs to be adjusted based on the bounds given the artisans.
    var shiftX = Number.MAX_VALUE;
    var shiftY = Number.MAX_VALUE;
    for (var i = 0; i < widgets.length; i++) {
      var widget = widgets[i];
      var layout = widget.getLayout();
      if (layout === Layout.FILL) {
        continue;
      }
      if (layout.getXUnit() === Layout.ABS) {
        shiftX = Math.min(layout.getX(), shiftX);
      }
      if (layout.getYUnit() === Layout.ABS) {
        shiftY = Math.min(layout.getY(), shiftY);
      }
    }
    if (shiftX === Number.MAX_VALUE) {
      shiftX = 0;
    }
    if (shiftY === Number.MAX_VALUE) {
      shiftY = 0;
    }
    return {
      x: shiftX,
      y: shiftY
    };
  }

  /**
   * @param {Array.<baja.Component>} widgets
   * @param {Number} shiftX
   * @param {Number} shiftY
   */
  function shiftLayout(widgets, shiftX, shiftY) {
    for (var i = 0; i < widgets.length; i++) {
      var widget = widgets[i];
      var layout = widget.getLayout();
      if (layout !== Layout.FILL && layout.getXUnit() === Layout.ABS && layout.getYUnit() === Layout.ABS) {
        widget.setLayout(Layout.makeAbs(layout.getX() - shiftX, layout.getY() - shiftY, layout.getWidth(), layout.getHeight()));
      }
    }
  }
  return UxModelTreeNodeEnvelope;
});
