function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/model/UxModelTreeNode
 */
define(['baja!', 'lex!bajaux,uxBuilder', 'bajaux/model/UxModel', 'bajaux/Widget', 'Promise', 'underscore', 'nmodule/bajaui/rc/util/pxUtils', 'nmodule/bajaui/rc/ux/CanvasPane', 'nmodule/bajaui/rc/ux/Label', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/bajaui/rc/ux/PxInclude', 'nmodule/uxBuilder/rc/ux/UxBuilderOptions', 'nmodule/js/rc/tinyevents/tinyevents', 'nmodule/uxBuilder/rc/util/uxBuilderEvents', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/util/uxModelUtils', 'nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand', 'nmodule/uxBuilder/rc/ux/factory/UxModelFactory', 'nmodule/uxBuilder/rc/ux/factory/impl/WidgetNodesToUxModelFactory', 'nmodule/uxBuilder/rc/ux/model/UxBuilderEditContext', 'nmodule/uxBuilder/rc/ux/model/UxModelTreeNodeEnvelope', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/wb/tree/TreeNode'], function (baja, lexs, UxModel, Widget, Promise, _, pxUtils, CanvasPane, Label, NullWidget, PxInclude, UxBuilderOptions, tinyevents, uxBuilderEvents, uxBuilderUtils, uxModelUtils, ReplaceUxModelCommand, UxModelFactory, WidgetNodesToUxModelFactory, UxBuilderEditContext, UxModelTreeNodeEnvelope, compUtils, typeUtils, TreeNode) {
  'use strict';

  var findIndex = _.findIndex,
    isFunction = _.isFunction,
    pluck = _.pluck,
    uniq = _.uniq,
    mapObject = _.mapObject;
  var _lexs = _slicedToArray(lexs, 2),
    bajauxLex = _lexs[0],
    uxBuilderLex = _lexs[1];
  var _formatDisplayNames = compUtils.formatDisplayNames;
  var getTypeDisplayName = typeUtils.getTypeDisplayName;
  var DESELECTION_REQUESTED = uxBuilderEvents.DESELECTION_REQUESTED,
    DROP_REQUESTED = uxBuilderEvents.DROP_REQUESTED,
    SELECTION_REQUESTED = uxBuilderEvents.SELECTION_REQUESTED,
    TREE_MODIFIED = uxBuilderEvents.TREE_MODIFIED;
  var applyPxProperties = pxUtils.applyPxProperties;
  var generateUniqueNames = uxBuilderUtils.generateUniqueNames,
    _getOriginatingNode = uxBuilderUtils.getOriginatingNode,
    isFreeFormPane = uxBuilderUtils.isFreeFormPane,
    isNullWidget = uxBuilderUtils.isNullWidget,
    isReversed = uxBuilderUtils.isReversed,
    isPane = uxBuilderUtils.isPane,
    pasteToInsertOps = uxBuilderUtils.pasteToInsertOps,
    resolveWidgetDisplayName = uxBuilderUtils.resolveWidgetDisplayName,
    $getLinkedPropertyPaths = uxBuilderUtils.$getLinkedPropertyPaths,
    $setOriginatingNode = uxBuilderUtils.$setOriginatingNode,
    withPxPropertiesApplied = uxBuilderUtils.withPxPropertiesApplied;
  var getInstance = uxModelUtils.getInstance,
    getKidModelsIncludingDefaults = uxModelUtils.getKidModelsIncludingDefaults,
    getUxModelDefaults = uxModelUtils.getUxModelDefaults;
  var DEFAULT_WIDGET_NAME = bajauxLex.get('widget.displayName');
  var DEFAULT_WIDGET_ICON = [bajauxLex.get('widget.icon')];
  var FALLBACK_DISPLAY_NAME = uxBuilderLex.get('UxBuilder.fallbackWidgetDisplayName');
  var KIDS = 'k';
  var NAME = 'n';
  var PROPERTIES = 'p';
  var TYPE_SPEC = 't';
  var VALUE = 'v';
  var BINDINGS = 'bnd';
  var FLAGS = 'f';
  var LINKED_PROPERTY_PATHS = 'l';

  /**
   * TreeNode for displaying a `UxModel` instance in the UxBuilder Widget Tree.
   *
   * There are several "sources of truth" in UxBuilder that need some disambiguation.
   *
   * **UxModel**:
   *
   * UxModel works in two ways in UxBuilder.
   *
   * 1: There is exactly *one* `UxModel` instance that represents the source of truth for "how
   * widgets are configured in the Px file." This instance lives in the state of `UxBuilder` itself,
   * wrapped in a node under the `wrapperNode` state key; it also gets loaded directly into WidgetTree so that WidgetTree
   * commands may mutate it as the designer makes changes. *This* instance represents the actual
   * contents of the `.px` file; it is what gets converted directly into JSON and posted back up to
   * the station to be saved. It essentially represents the thoughts of the Px page designer.
   *
   * 2: A *clone* of that `UxModel` gets generated when the `UxBuilder` renders itself, and that clone
   * is passed to the child widgets that display it in different ways (e.g. `PxWidget` displays the
   * page visually, `BoundOrdsEditor` finds the bound ORDs in it and displays them as a list). In
   * this way, it represents "instructions to the framework on how to paint widgets to the screen."
   *
   * **UxModelTreeNode**:
   *
   * This defines the contents of the Widget Tree. It takes the source-of-truth `UxModel` (1 above)
   * and displays it to the page designer in a way that makes sense and allows them to make changes.
   *
   * It's not necessarily one-to-one with the contents of the `UxModel` - one way it differs is that
   * you'll get extra `UxModelTreeNode`s that represent placeholders for frozen child widgets that
   * have not yet been configured (e.g. `content` and `label` belonging to a BorderPane). This
   * information comes from the `Widget` itself as described next.
   *
   * **Widget**:
   *
   * The actual `bajaux/Widget` instances are the source of truth for "what Properties can be
   * configured." This is because the UxModelTreeNode data ultimately originates from a .px file,
   * and the .px file does *not* have knowledge of all Properties a Widget has - it only knows the
   * properties that are configured away from their default values; default property values are not
   * persisted to the file.
   *
   * Who *does* know what Properties can be configured on a Widget is the Widget itself. These are
   * typically configured in the `widgetDefaults()` block implemented in each Widget's .js file.
   * UxBuilder doesn't do anything special to access this information - `UxModel` itself knows how
   * to instantiate the widget to find what properties it declares, so they will all be included in
   * the result of its `getProperties()` method.
   *
   * In addition, a Widget knows what possible child widgets it could be configured with. For
   * instance, a BorderPane knows it can have a "content" widget and a "label" widget. This
   * information comes from a `$uxModelDefaults` function that it might implement.
   *
   * `UxModelTreeNode`, `UxModel`, and `Widget` will need to have some degree of knowledge of each
   * other; see documentation on other methods in this class for more details.
   *
   * @class
   * @since Niagara 4.15
   * @alias module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode
   * @extends module:nmodule/webEditors/rc/wb/tree/TreeNode
   * @implements module:nmodule/webEditors/rc/wb/util/EncodableToEnvelope
   */
  var UxModelTreeNode = /*#__PURE__*/function (_TreeNode) {
    /**
     * Not to be called directly; use `make()` instead.
     *
     * @param {module:bajaux/model/UxModel} uxModel
     * @param {string} name
     * @param {object} params
     * @param {string} params.display
     * @param {Array.<string>} params.icon
     * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} params.kids
     * @param {Array.<string>} params.allNames all known names of UxModel kids including defaults,
     * used for ordering
     */
    function UxModelTreeNode(uxModel, name, _ref) {
      var _this;
      var display = _ref.display,
        icon = _ref.icon,
        kids = _ref.kids,
        allNames = _ref.allNames;
      _classCallCheck(this, UxModelTreeNode);
      _this = _callSuper(this, UxModelTreeNode, [name, display, kids]);

      /*
      we have to wait on event handlers to resolve, because the UxModelTreeNode itself is the
      emitter of selected/added/removed/etc. events.
       example reasoning:
       - requirement: after adding a new node, we need to select the newly selected nodes in the
        widget tree.
      - to select the new node, it has to already *exist* in the nav tree.
      - we need to node.add(newNode).then(() => selectTheNewNodes())
      - therefore, node.add() must wait until the new node exists in the widget tree before it
        resolves and moves onto selectTheNewNodes.
      - the new node will appear in the widget tree after NavTree responds to the `added` event
        triggered by node.add().
      - therefore, we have to wait on the `added` event handler to complete before node.add()
        resolves.
       */
      tinyevents(_this, {
        resolveHandlers: true
      });
      $setOriginatingNode(uxModel, _this);
      /*
        Every node in the UxModel needs to be aware of its originating UxModelTreeNode at any time.
        Therefore, we do not initialize the tree asynchronously via $loadKids like we typically
        would, because TreeNode sets parentage only after the asynchronous $loadKids call -
        potentially too late. So we manually set it here, up front.
       */
      kids.forEach(function (kid) {
        kid.$parent = _this;
      });
      _this.value = function () {
        return uxModel;
      };
      _this.$icon = icon;
      _this.$allNames = allNames;
      return _this;
    }

    /**
     * Allow traversing from a UxModel used to build a widget in the Px preview, back to the
     * node from which that widget came.
     *
     * @param {module:bajaux/model/UxModel|module:bajaux/Widget} uxModel the model, or the widget
     * instance holding the model
     * @returns {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} the node holding this model
     */
    _inherits(UxModelTreeNode, _TreeNode);
    return _createClass(UxModelTreeNode, [{
      key: "destroy",
      value:
      /**
       * @override
       * @private
       * @returns {Promise}
       */
      function destroy() {
        /*
        problem: we hide the widget tree, spandrel destroy()s the NavTree which also destroy()s the
        TreeNode, we re-show the widget tree, same TreeNode, still destroyed, NavTree won't load it.
         considered the alternatives:
        - destroyNode=false flag to NavTree (not ready to introduce abstraction for just one use case)
        - hide widget tree instead of destroying it (maybe in future if needed but would disrupt ongoing sidebar work)
        - load a clone into the NavTree instead of the real TreeNode (would destroy/rerender NavTree on every change, unusable)
         so just making UxModelTreeNode indestructible seems like the best solution for now. it doesn't
        hold any resources that won't otherwise be freed when the UxBuilder is destroyed.
         */
        return Promise.resolve();
      }

      /**
       * When a node is removed, bubble a deselection request up for UxBuilder to receive, so the
       * removed node can also be removed from selectedPaths.
       *
       * @override
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode|string} kid
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>}
       */
    }, {
      key: "remove",
      value: function remove(kid) {
        return this.$doRemove(kid);
      }

      /**
       * Impl of remove()
       * @private
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode|string} kid
       * @param {object} [params]
       * @param {boolean} [params.silent] skip emitting a TREE_MODIFIED event for this removal
       * (set to true on recursive calls - we want one event per public call)
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>}
       */
    }, {
      key: "$doRemove",
      value: function $doRemove(kid, params) {
        var _this2 = this;
        var silent = params && params.silent;
        return _superPropGet(UxModelTreeNode, "remove", this, 3)(arguments).then(function (removed) {
          removed.requestDeselection();
          return Promise.resolve(!silent && _this2.treeModified()).then(function () {
            return removed;
          });
        });
      }

      /**
       * Returns the last Widget instance built in the UxBuilder's PxWidget view in accordance with
       * the instructions from this tree node.
       *
       * The most common use case in which a child Widget would change instances over time, would be
       * if the node for a child Widget of a Pane had its `visible` property changed to false. In this
       * case, the Pane may not render anything at all for that node, and the old Widget would be
       * destroyed. A new instance would be built once `visible` changed back to true.
       *
       * Therefore, do not rely on this method returning the same Widget instance over time. Call it
       * to retrieve the latest value as needed.
       *
       * @returns {module:bajaux/Widget|undefined}
       */
    }, {
      key: "getLastBuiltWidget",
      value: function getLastBuiltWidget() {
        var w = this.$lastBuiltWidget;
        if (w && !w.isDestroyed()) {
          return w;
        }
      }

      /**
       * The `UxModelTreeNode` will need to be aware of the actual Widget instance that was built from
       * the instructions (the UxModel) that the Node provided.
       *
       * The reasons and usages for this are enumerated here. *Any* use of this Widget instance that
       * is not listed here is forbidden.
       *
       * **Knowing all Widget Properties to show**
       *
       * The Widget Properties dialog is shown when the user double-clicks the Node, and in order to
       * show all the available Properties in the dialog, we must ask the Widget itself. (Typically
       * the UxModel already knows about the widget's properties, but one exception is WebWidget which
       * exposes the properties of its child widget as its own.) So the Node must know about the
       * Widget instance that was built from the instructions it contains.
       *
       * **Highlighting a Widget on selection**
       *
       * When the user selects a node in the Widget Tree, we highlight the corresponding widget in the
       * main Px view.
       *
       * (More usages can be added in the future, but we have to be very thoughtful about them.)
       *
       * @param {module:bajaux/Widget} widget
       * @returns {Promise}
       */
    }, {
      key: "setLastBuiltWidget",
      value: function setLastBuiltWidget(widget) {
        this.$lastBuiltWidget = widget;
        return Promise.resolve();
      }

      /**
       * @param {function} Ctor
       * @returns {boolean} true if this node represents an instance of the given constructor
       */
    }, {
      key: "represents",
      value: function represents(Ctor) {
        return this.value().$represents(Ctor);
      }

      /**
       * @returns {boolean} true if this node allows a drop (is NullWidget or freeform pane)
       */
    }, {
      key: "isDropTarget",
      value: function isDropTarget() {
        var uxModel = this.value();
        return uxModel.getType() === NullWidget || isFreeFormPane(uxModel);
      }

      /**
       * @override
       * @param {Array.<*>} objects
       * @returns {Promise}
       */
    }, {
      key: "doDrop",
      value: function doDrop(objects) {
        return this.bubbleUp(DROP_REQUESTED, objects);
      }

      /**
       * Bubbles up a tinyevent all the way up to be emitted on the root node of this tree. The
       * first argument of the handler will be the node that originated the event, followed by the
       * arguments.
       *
       * @param {string} event the tinyevent to emit
       * @param {...*} args
       * @returns {Promise} to be resolved after all async event handlers have completed
       * @see module:nmodule/js/rc/tinyevents/tinyevents
       */
    }, {
      key: "bubbleUp",
      value: function bubbleUp(event) {
        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }
        return this.$doBubbleUp(event, this, args);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doBubbleUp",
      value: function $doBubbleUp(event, sourceNode, args) {
        var parent = this.getParent();
        if (parent) {
          return parent.$doBubbleUp(event, sourceNode, args);
        } else {
          return Promise.all(this.emit.apply(this, [event, sourceNode].concat(_toConsumableArray(args))));
        }
      }

      /**
       * Bubbles a SELECTION_REQUESTED event up to the root node, with the desired action:
       *
       * - `'exclusive'`: this should be the only node selected; deselect everything else
       * - `'toggle'`: add to the selection if not selected; deselect it if it is
       * - `'ensure'`: if not selected, select this one exclusively; if already selected, don't change
       *   any other selections (use this one for a right-click)
       *
       * @param {'exclusive' | 'toggle' | 'ensure'} [action] specify what kind of selection is desired
       * @returns {Promise}
       */
    }, {
      key: "requestSelection",
      value: function requestSelection(action) {
        return this.bubbleUp(SELECTION_REQUESTED, action);
      }

      /**
       * Bubbles a DESELECTION_REQUESTED event up to the root node.
       * @returns {Promise}
       */
    }, {
      key: "requestDeselection",
      value: function requestDeselection() {
        return this.bubbleUp(DESELECTION_REQUESTED);
      }

      /**
       * Bubbles a TREE_MODIFIED event up to the root node.
       * @param {object} [params]
       * @param {boolean} [params.silent] set to true if this should be a "stealth" modification: it
       * will update the tree and rerender but not mark the UxBuilder modified.
       * @returns {Promise}
       */
    }, {
      key: "treeModified",
      value: function treeModified() {
        var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        return this.bubbleUp(TREE_MODIFIED, params);
      }

      /**
       * Inserts some new child objects into the tree node. This happens during a right-click->New,
       * dropping from the palette, pasting, etc.
       *
       * If this node represents a NullWidget (for example, the `content` kid of a BorderPane that
       * doesn't have a widget configured yet), this will result in *replacing* this node with the
       * single inserted object, or rejecting if you're trying to insert multiple objects.
       *
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertOp>|module:nmodule/webEditors/rc/wb/commands/PasteCommand~PasteParams} toInsert the
       * insert ops representing the objects to be inserted, or pasteParams if invoking Paste command
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertParams} params
       * @returns {Promise}
       * @see module:nmodule/webEditors/rc/wb/commands/PasteCommand#$getPasteParams
       */
    }, {
      key: "insert",
      value: function insert(toInsert) {
        var _this3 = this;
        var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var beforeInsert = params.beforeInsert || function (models) {
          return models;
        };
        return (toInsert.mark ? this.$makePasteContext(toInsert, params) : this.$makeDropContext(toInsert, params)).then(function (insertContext) {
          if (!insertContext) {
            return;
          }
          var models = insertContext.models,
            node = insertContext.node,
            params = insertContext.params;
          return _this3.$newKids(models).then(function (models) {
            return beforeInsert(models);
          }).then(function (models) {
            return ReplaceUxModelCommand.add(node, models, params);
          });
        });
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/commands/PasteCommand~PasteParams} pasteParams
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertParams} params
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertContext>}
       */
    }, {
      key: "$makePasteContext",
      value: function $makePasteContext(pasteParams, params) {
        var _this4 = this;
        return pasteToInsertOps(this, pasteParams).then(function (insertOps) {
          return pastedNodesToUxModels(insertOps, params);
        }).then(function (models) {
          return _this4.$makeInsertContext(models, params);
        });
      }

      /**
       * @private
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertOp>} insertOps
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertParams} params
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertContext|undefined>} resolves
       * to falsy if user canceled the insert process
       */
    }, {
      key: "$makeDropContext",
      value: function $makeDropContext(insertOps, params) {
        var _this5 = this;
        return navNodesToUxModels(insertOps, params).then(function (models) {
          return models && _this5.$makeInsertContext(models, params);
        });
      }

      /**
       * @private
       * @param {Array.<module:bajaux/model/UxModel>} models UxModels to insert
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertParams} params insert
       * params - might get altered if a different node winds up being the insert target
       * @returns {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertContext}
       */
    }, {
      key: "$makeInsertContext",
      value: function $makeInsertContext(models, params) {
        var node = this;
        var model = this.value();
        if (model.getType() === NullWidget) {
          // c.f. BPxTree#makeDropCommand

          if (models.length !== 1) {
            throw new Error(uxBuilderLex.get('errors.dropMultipleOntoSinglePlaceholder'));
          }
          node = this.getParent();
          params = Object.assign({}, params, {
            names: [model.getName()]
          });
        }
        return {
          models: models,
          node: node,
          params: params
        };
      }

      /**
       * @param {object} uxModelData same data to be used to create a UxModel
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>}
       */
    }, {
      key: "toDisplay",
      value:
      /**
       * @param {boolean} baseName should only the base name be returned
       * @returns {Promise.<String>} Display name of the TreeNode
       */
      function toDisplay() {
        var baseName = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
        var uxModel = this.value();
        if (!uxModel.getType()) {
          return _superPropGet(UxModelTreeNode, "toDisplay", this, 3)([]);
        }
        return UxModelTreeNode.$resolveWidgetInfo(uxModel, baseName).then(function (_ref2) {
          var display = _ref2.display;
          return display;
        });
      }

      /**
       * @private
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/UxBuilderOptions>}
       */
    }, {
      key: "modifyKid",
      value:
      /**
       *
       * @param {string} name
       * @param {module:bajaux/model/UxModel|module:bajaux/model/UxModel~UxModelParams} newKid
       * @param {boolean} [silent] does not bubbleUp treeModified when true
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>}
       */
      function modifyKid(name, newKid, silent) {
        var _this6 = this;
        if (!name || !newKid) {
          return die('name and UxModel required');
        }
        var myModel = this.value();
        return Promise.all([UxModel.make(newKid).then(function (model) {
          return model.clone({
            name: name
          });
        }), this.getKid(name)]).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            newKidModel = _ref4[0],
            existingKidNode = _ref4[1];
          if (!existingKidNode) {
            throw new Error("kid ".concat(name, " not found"));
          }
          if (newKidModel.getType() !== existingKidNode.value().getType()) {
            throw new Error('modifyKid cannot change the type of a node (use replaceKid)');
          }
          var oldKidModel = myModel.get(name);
          replaceOrAddUxModelInArray(myModel.$obj.kids, newKidModel, name, _this6.$allNames);
          return Promise.all([unbindPreviousBindings(oldKidModel), existingKidNode.$applyModel(newKidModel, {
            keepExistingKids: true
          }).then(function () {
            return triggerNameAndIconRepaint(_this6, name);
          })]).then(function () {
            return !silent && existingKidNode.treeModified();
          }).then(function () {
            return existingKidNode;
          });
        });
      }

      /**
       * Updates the contents of this node with a brand new UxModel. This installs the new UxModel in
       * two places:
       *
       * - sets the given UxModel as a new kid of this node's UxModel, and
       * - updates the appropriate UxModelTreeNode kid of this node with the new UxModel
       *
       * After calling, `this.value().getKids()` will include the new UxModel and `this.getKids()`
       * will resolve the same TreeNode instances as before, but with the new UxModel applied to the
       * appropriate node.
       *
       * @private
       * @param {string} name
       * @param {module:bajaux/model/UxModel} newKidModel the new kid UxModel to put.
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} to be resolved with
       * the updated UxModelTreeNode
       */
    }, {
      key: "replaceKid",
      value: function replaceKid(name, newKidModel) {
        return this.$doReplaceKid(name, newKidModel);
      }

      /**
       * Impl of replaceKid
       * @private
       * @param {string} name
       * @param {module:bajaux/model/UxModel} newKidModel the new kid UxModel to put.
       * @param {object} [params]
       * @param {boolean} [params.silent] skip emitting a TREE_MODIFIED event for this replacement
       * (set to true on recursive calls - we want one event per public call)
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} to be resolved with
       * the updated UxModelTreeNode
       */
    }, {
      key: "$doReplaceKid",
      value: function $doReplaceKid(name, newKidModel, params) {
        var _this7 = this;
        if (!name || !newKidModel) {
          return die('name and UxModel required');
        }
        var silent = params && params.silent;

        // parent is me. i'm the parent.
        // when page is ScrollPane/CanvasPane/Label, and user deletes the Label,
        // i am ScrollPane, and newKidModel is CanvasPane without the Label.
        // the logic of "cloning kid with new grandkids" is handled in ReplaceUxModelCommand.
        var myModel = this.value(); // i'm ScrollPane
        var oldKidModel = myModel.get(name); // old CanvasPane, with the Label we're deleting

        return Promise.all([UxModel.make(newKidModel).then(function (model) {
          return model.clone({
            name: name
          });
        }), this.getKid(name)]).then(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 2),
            newKidModel = _ref6[0],
            existingKidNode = _ref6[1];
          return validateUxModel(newKidModel).then(function () {
            if (!existingKidNode) {
              throw new Error("kid \"".concat(name, "\" not found to replace"));
            }
            replaceOrAddUxModelInArray(myModel.$obj.kids, newKidModel, name, _this7.$allNames); // now ScrollPane has CanvasPane with no Label kid

            return unbindPreviousBindings(oldKidModel).then(function () {
              var existingModel = existingKidNode.value();
              return existingKidNode.$applyModel(newKidModel).then(function () {
                return diffKids(existingKidNode, existingModel, newKidModel);
              }).then(function () {
                return triggerNameAndIconRepaint(_this7, name);
              }).then(function () {
                return !silent && existingKidNode.treeModified();
              }).then(function () {
                return newKidModel;
              });
            });
          });
        });
      }

      /**
       * Ensures this node's display name, value, icon, and kids correctly reflect the given UxModel.
       * In other words, after this method, this node will hold the given UxModel.
       *
       * @private
       * @param {module:bajaux/model/UxModel} uxModel
       * @param {object} [params]
       * @param {boolean} [params.keepExistingKids] if true, the current UxModel kids will be *applied* to the
       * given UxModel, mutating it, and ensuring that this node's children do not change (used when
       * setting properties, but not structure, of this node)
       * @returns {Promise}
       */
    }, {
      key: "$applyModel",
      value: function $applyModel(uxModel) {
        var _this8 = this;
        var _ref7 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          keepExistingKids = _ref7.keepExistingKids;
        return UxModelTreeNode.$resolveWidgetInfo(uxModel).then(function (_ref8) {
          var display = _ref8.display,
            icon = _ref8.icon,
            allNames = _ref8.allNames;
          if (keepExistingKids) {
            /*
            TODO: in most cases, we don't want to mutate UxModels.
            i should be able to uxModel.clone({ kids: this.value.getKids() })
            and use that instead. but this would also clone uxModel's kids, and those might
            currently be loaded into child UxModelTreeNodes, so in order to be puritanical about
            never mutating UxModels we'd have to make this recursive and re-slot all the cloned kids
            into the right place. which would be a whole thing. do this when called for, but not before.
            same for replaceOrAddUxModelInArray
             */
            uxModel.$obj.kids = _this8.value().getKids();
          }
          $setOriginatingNode(uxModel, _this8);
          _this8.value = function () {
            return uxModel;
          };
          _this8.getIcon = function () {
            return icon;
          };
          _this8.$display = display;
          _this8.$allNames = allNames;
        });
      }

      /**
       * Creates new `UxModel`s to add to this node (may replace existing NullWidget nodes, or
       * append new nodes to a freeform pane).
       *
       * @private
       * @param {Array.<module:bajaux/model/UxModel~UxModelParams>} kidDatas
       * @returns {Promise.<Array.<module:bajaux/model/UxModel>>}
       */
    }, {
      key: "$newKids",
      value: function $newKids(kidDatas) {
        var _this9 = this;
        return toUniquelyNamedKidModels(this, kidDatas).then(function (newKids) {
          var parentModel = _this9.value();
          var instance = getInstance(parentModel);
          if (isFunction(instance.$newKids)) {
            return instance.$newKids(parentModel, newKids, new UxBuilderEditContext());
          } else {
            return newKids;
          }
        });
      }

      /**
       * @returns {Array<string>}
       */
    }, {
      key: "getIcon",
      value: function getIcon() {
        return this.$icon;
      }

      /**
       * @inheritDoc
       */
    }, {
      key: "mayHaveKids",
      value: function mayHaveKids() {
        return isPane(this.value());
      }

      /**
       * Writes the current value of the UxModelTreeNode to JSON. When pxProperties are provided,
       * the encodeToJson will also add information on which properties are linked to existing targets.
       * @param {Object} [params] the object literal containing the method's arguments
       * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties} [params.pxProperties]
       * @returns {Promise.<Object>} a JSON object that represents this tree node value
       */
    }, {
      key: "encodeToJson",
      value: function encodeToJson() {
        var _this10 = this;
        var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        return this.value().clone().then(function (clone) {
          var _params$pxProperties = params.pxProperties,
            pxProperties = _params$pxProperties === void 0 ? {} : _params$pxProperties;
          // applies px properties as slots to the clone.
          applyPxProperties(clone, pxProperties, mapObject(pxProperties, function (_ref9) {
            var value = _ref9.value;
            return value;
          }));
          // applies link values as slots to the clone.
          return withPxPropertiesApplied(clone, pxProperties).then(function (clone) {
            return _this10.$encodeUxModelToJson(clone, params);
          });
        });
      }

      /**
       * @returns {string}
       */
    }, {
      key: "toString",
      value: function toString() {
        return "UxModelTreeNode[path=".concat(this.getFullPath().join('/'), "]");
      }

      /**
       * Adds the uxModel to the json
       * @private
       * @param {module:bajaux/model/UxModel} uxModel the uxModel or value of the UxModelTreeNode to encode to JSON
       * @param {Object} [params] the object literal containing the method's arguments
       * @returns {Object} the JSON encoding
       */
    }, {
      key: "$encodeUxModelToJson",
      value: function $encodeUxModelToJson(uxModel) {
        var _this11 = this;
        var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var propertiesNormalized;
        var json = {};
        var name = uxModel.getName();
        var propertiesJson = [];
        var kidsJson = [];
        var bindingsJson = [];
        var typeSpec = uxModel.getMetadata().pxDataTypeSpec;
        if (!typeSpec) {
          if (isNullWidget(uxModel)) {
            // the alternative is to require every $uxModelDefaults to specify bajaui:NullWidget.
            // this seems like a reasonable shorthand
            typeSpec = 'bajaui:NullWidget';
          } else {
            throw new Error('pxDataTypeSpec required');
          }
        }
        json[TYPE_SPEC] = typeSpec;
        var properties = uxModel.getProperties();
        var node = _getOriginatingNode(uxModel);
        var widget = node ? node.getLastBuiltWidget() : undefined;
        var defaultValues = uxModel.getDefaultProperties();
        var parentNode = node.getParent();
        var isCanvasPane = !parentNode || parentNode.represents(CanvasPane);
        var linkedPropertyPaths = $getLinkedPropertyPaths(uxModel);
        if (widget) {
          propertiesNormalized = uxBuilderUtils.normalizeProperties(baja.$(typeSpec), widget, uxModel);
          // the normalized properties should have the values from uxModel.getProperties already in it.
          properties = propertiesNormalized ? propertiesNormalized.toValueMap() : properties;
        }
        Object.entries(properties).forEach(function (property) {
          var _transient = false;
          var propertyNormalized;
          var defaultNormalized;
          var propName = property[0];
          var propValue = property[1];

          // can not have properties with names that start with '$'
          if (!baja.hasType(propValue) || propName.startsWith('$')) {
            return;
          }
          if (propertiesNormalized) {
            propertyNormalized = propertiesNormalized.get(propName);
            defaultNormalized = propertiesNormalized.getDefaultValue(propName);
          }
          var metaProperty = uxModel.$getMetaPropertyInfo(propName);
          var defaultValue = defaultNormalized !== undefined && defaultNormalized !== null ? defaultNormalized : defaultValues ? defaultValues[propName] : undefined;
          var flagStr = _this11.$getFlagStr(propertyNormalized, metaProperty, propValue);
          _transient = flagStr.includes('t');
          var propType = propValue.getType();
          var propTypeSpec = propType.getTypeSpec();
          if (!isCanvasPane && propName === 'layout' && (baja.hasType(propValue, 'bajaui:Layout') || baja.hasType(defaultValue, 'bajaui:Layout'))) {
            return;
          }
          var usefulEncoding;
          if (propName !== 'layout' && (_transient || !flagStr.includes('3') && uxBuilderUtils.$equalsDefault(defaultValue, propValue))) {
            usefulEncoding = false;
          } else {
            usefulEncoding = true;
          }
          if (linkedPropertyPaths[propName]) {
            usefulEncoding = true;
          }
          if (usefulEncoding) {
            //the type spec 'baja:String' is used as a default, and in that case we want the typeSpec of the property value.
            var _typeSpec = metaProperty && metaProperty.typeSpec && metaProperty.typeSpec !== 'baja:String' ? metaProperty.typeSpec : propTypeSpec;
            var propJson = _defineProperty(_defineProperty(_defineProperty({}, NAME, propName), VALUE, baja.bson.encodeValue(propValue)), TYPE_SPEC, _typeSpec);
            if (flagStr) {
              propJson[FLAGS] = flagStr;
            }
            propertiesJson.push(propJson);
          }
        });
        uxModel.getKids().forEach(function (kid) {
          kidsJson.push(_this11.$encodeUxModelToJson(kid, params));
        });
        uxModel.getBindingList().getBindings().forEach(function (binding) {
          bindingsJson.push(baja.bson.encodeValue(binding));
        });

        //if there is no name for the widget do not include that parameter
        if (baja.SlotPath.isValidName(name)) {
          json[NAME] = name;
        }
        json[PROPERTIES] = propertiesJson;
        json[KIDS] = kidsJson;
        json[BINDINGS] = bindingsJson;
        json[LINKED_PROPERTY_PATHS] = linkedPropertyPaths;
        return json;
      }

      /**
       * @private
       * @param {Object} propertyNormalized the property values from the nomalized properties
       * @param {Object} metaProperty the property values from the metaProperties
       * @param {Object} propValue the value of the property
       * @returns {string}
       */
    }, {
      key: "$getFlagStr",
      value: function $getFlagStr(propertyNormalized, metaProperty, propValue) {
        var readonly = false;
        var hidden = false;
        var _transient2 = false;
        var userDefined3 = false;
        if (metaProperty) {
          readonly = !!metaProperty.readonly;
          hidden = !!metaProperty.hidden;
          _transient2 = !!metaProperty["transient"];
          userDefined3 = !!metaProperty.userDefined3 || metaProperty.webWidgetProperty && typeUtils.isSimple(propValue);
        }
        if (propertyNormalized) {
          readonly = readonly || !!propertyNormalized.readonly;
          hidden = hidden || !!propertyNormalized.hidden;
          _transient2 = _transient2 || !!propertyNormalized["transient"];
        }
        return (readonly ? 'r' : '') + (hidden ? 'h' : '') + (_transient2 ? 't' : '') + (userDefined3 ? '3' : '');
      }

      /**
       * Ensures the correct ordering of this node's kid nodes.
       * @private
       */
    }, {
      key: "$reorder",
      value: function $reorder() {
        var uxModel = this.value();
        var desiredNames = this.$allNames.slice();
        if (shouldReverseKids(uxModel)) {
          desiredNames.reverse();
        }
        this.$kids.sort(function (a, b) {
          return desiredNames.indexOf(toName(a)) - desiredNames.indexOf(toName(b));
        });
        this.emit('reordered');
      }

      /**
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} subject
       * @param {Object} [params] the object literal for the method's arguments.
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} [params.parent] the parent that will be used for insertion.
       * @param {module:nmodule/webEditors/rc/wb/util/TransferWidget} [params.transferWidget]
       * @returns <Promise.<{module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNodeEnvelope}>>
       */
    }, {
      key: "toEnvelope",
      value: function toEnvelope(subject, params) {
        return UxModelTreeNodeEnvelope.make.apply(UxModelTreeNodeEnvelope, arguments);
      }

      /**
       * @static
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} subject
       * @param {Object} [params] the object literal for the method's arguments.
       * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} [params.parent] the parent that will be used for insertion.
       * @param {module:nmodule/webEditors/rc/wb/util/TransferWidget} [params.transferWidget]
       * @returns <Promise.<{module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNodeEnvelope}>>
       */
    }], [{
      key: "getOriginatingNode",
      value: function getOriginatingNode(uxModel) {
        return _getOriginatingNode(uxModel);
      }

      /**
       * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>} nodes
       * @returns {Promise.<string>} a formatted display string for identifying multiple nodes
       */
    }, {
      key: "formatDisplayNames",
      value: function formatDisplayNames(nodes) {
        return Promise.all(nodes.map(function (node) {
          return typeof node === 'string' ? node : node.toDisplay();
        })).then(function (displayNames) {
          return _formatDisplayNames(displayNames);
        });
      }
    }, {
      key: "make",
      value: function make(uxModelData) {
        // in the future when we start editing, changes to this data will persist into the Node
        // itself, generating a new UxModel to be passed to the widget and triggering a rererender.
        return Promise.resolve(uxModelData instanceof UxModel ? uxModelData : UxModel.make(uxModelData)).then(function (uxModel) {
          var name = uxModel.getName() || 'root';
          if (!uxModel.getType()) {
            return new UxModelTreeNode(uxModel, name, {
              display: name,
              icon: DEFAULT_WIDGET_ICON,
              kids: [],
              allNames: []
            });
          }
          return UxModelTreeNode.$resolveWidgetInfo(uxModel).then(function (_ref10) {
            var display = _ref10.display,
              icon = _ref10.icon,
              allNames = _ref10.allNames;
            return resolveKidModels(uxModel).then(function (kidModels) {
              return Promise.all(kidModels.map(function (kidModel) {
                return validateUxModel(kidModel).then(function () {
                  return UxModelTreeNode.make(kidModel);
                });
              }));
            }).then(function (kids) {
              return new UxModelTreeNode(uxModel, name, {
                display: display,
                icon: icon,
                kids: kids,
                allNames: allNames
              });
            });
          });
        });
      }
    }, {
      key: "$getUxBuilderOptions",
      value: function $getUxBuilderOptions() {
        return UxBuilderOptions.make();
      }

      /**
       * @private
       * @param {module:bajaux/model/UxModel} uxModel
       * @param {boolean} baseName should only the base name be returned
       * @returns {Promise<{display: string, icon: string[] }>}
       */
    }, {
      key: "$resolveWidgetInfo",
      value: function $resolveWidgetInfo(uxModel) {
        var baseName = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        var name = uxModel.getName() || 'root';
        var Ctor = uxModel.getType();
        var display;
        var widgetName;
        var binding;
        return resolveWidgetInfo(uxModel).then(function (_ref11) {
          var displayName = _ref11.displayName,
            iconUri = _ref11.iconUri;
          var _uxModel$getBindingLi = uxModel.getBindingList().getBindings(),
            _uxModel$getBindingLi2 = _slicedToArray(_uxModel$getBindingLi, 1),
            firstBinding = _uxModel$getBindingLi2[0];
          var onFreeFormPane = UxModelTreeNode.$onFreeFormPane(uxModel);
          if (onFreeFormPane === false) {
            displayName = "".concat(displayName).concat(name ? " (".concat(name.replace(/^./, name[0].toUpperCase()), ")") : '');
          }
          var _uxModel$getMetadata = uxModel.getMetadata(),
            pxDataTypeSpec = _uxModel$getMetadata.pxDataTypeSpec;
          if (Ctor === NullWidget && !pxDataTypeSpec) {
            display = name;
          } else {
            display = displayName;
            if (!baseName) {
              // see: WidgetNode#makeText
              if (baja.hasType(firstBinding, 'bajaui:Binding')) {
                binding = String(firstBinding.get('ord'));
              } else if (uxModel.$represents(Label)) {
                var _uxModel$getPropertie = uxModel.getProperties(),
                  text = _uxModel$getPropertie.text,
                  image = _uxModel$getPropertie.image;
                if (text) {
                  widgetName = text;
                } else if (!image.isNull()) {
                  widgetName = image.getOrdList().toString();
                }
              } else if (uxModel.$represents(PxInclude)) {
                var ord = uxModel.getProperties().ord;
                if (ord) {
                  binding = String(ord);
                }
              }
              display = "".concat(display).concat(widgetName ? " (".concat(widgetName, ")") : '');
              display = "".concat(display).concat(binding ? " [".concat(binding, "]") : '');
            }
          }
          return getKidModelsIncludingDefaults(uxModel).then(function (kids) {
            return {
              display: display,
              icon: [iconUri],
              allNames: namesOf(kids)
            };
          });
        });
      }

      /**
       * Returns true if the supplied model is on a free form pane
       * @private
       * @param uxModel
       * @returns {boolean|undefined} if the parent can not be determined, we return undefined.
       */
    }, {
      key: "$onFreeFormPane",
      value: function $onFreeFormPane(uxModel) {
        var treeNode = UxModelTreeNode.getOriginatingNode(uxModel);
        if (treeNode) {
          var parentTreeNode = treeNode.getParent();
          var parentModel = parentTreeNode && parentTreeNode.value();
          return parentModel ? parentModel && isFreeFormPane(parentModel) : undefined;
        }
        return undefined;
      }
    }, {
      key: "toEnvelope",
      value: function toEnvelope(subject, params) {
        return UxModelTreeNodeEnvelope.make.apply(UxModelTreeNodeEnvelope, arguments);
      }
    }]);
  }(TreeNode);
  /**
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {Promise}
   */
  function resolveWidgetInfo(uxModel) {
    return UxModelTreeNode.$getUxBuilderOptions().then(function (options) {
      var name = uxModel.getName() || 'root';
      var instance = getInstance(uxModel);
      var preserveIdentities = options.getPreserveIdentities();
      // When preserveIdentities is enabled use uxModel's name as the displayName.
      return Promise.all([Promise["try"](function () {
        return preserveIdentities ? name : resolveWidgetDisplayName(uxModel, instance);
      }), resolveIcon(uxModel, instance)]).then(function (_ref12) {
        var _ref13 = _slicedToArray(_ref12, 2),
          displayName = _ref13[0],
          iconUri = _ref13[1];
        if (displayName === DEFAULT_WIDGET_NAME) {
          displayName = FALLBACK_DISPLAY_NAME;
        }
        return {
          displayName: displayName,
          iconUri: iconUri
        };
      });
    });
  }
  function resolveKidModels(uxModel) {
    return getKidModelsIncludingDefaults(uxModel).then(function (allKidModels) {
      return shouldReverseKids(uxModel) ? allKidModels.reverse() : allKidModels;
    });
  }

  /**
   * @param {module:bajaux/Widget} instance
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {Promise.<String|baja.Icon>}
   */
  function resolveIcon(uxModel, instance) {
    if (uxModel.getMetadata().pxDataTypeSpec) {
      var _uxModel$getMetadata2 = uxModel.getMetadata(),
        pxDataTypeSpec = _uxModel$getMetadata2.pxDataTypeSpec;
      return baja.importTypes([pxDataTypeSpec]).then(function () {
        return baja.lt(pxDataTypeSpec).getIcon();
      });
    }
    return instance.toIcon();
  }
  function replaceOrAddUxModelInArray(arr, obj, name, allNames) {
    var index = findIndex(arr, function (o) {
      return o.getName() === name;
    });
    if (index < 0) {
      if (!allNames.includes(name)) {
        throw new Error('invariant');
      }
      arr.push(obj);
      arr.sort(function (a, b) {
        return allNames.indexOf(a.getName()) - allNames.indexOf(b.getName());
      });
    } else {
      arr[index] = obj;
    }
  }
  function unbindPreviousBindings(uxModel) {
    var binding = uxModel && uxModel.getBindingList().getBindings()[0];
    return Promise.resolve(binding && binding.$requestUnbindAll());
  }
  function generateUniqueName(names, desiredName) {
    var _generateUniqueNames = generateUniqueNames(names, [desiredName]),
      _generateUniqueNames2 = _slicedToArray(_generateUniqueNames, 1),
      uniqueName = _generateUniqueNames2[0];
    return uniqueName;
  }
  function shouldReverseKids(uxModel) {
    return !isPane(uxModel) || isReversed(uxModel);
  }
  function die(err) {
    return Promise.reject(new Error(err));
  }

  /**
   * When the given node receives a new UxModel, ensure its kid nodes represent the kids of the new
   * UxModel.
   *
   * This has to be a manual process because NavTree predates spandrel and so doesn't have any
   * inherent diffing behavior.
   *
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} node
   * @param {module:bajaux/model/UxModel} existingModel the UxModel previously held by the node
   * @param {module:bajaux/model/UxModel} newModel the new UxModel to be applied to the node
   * @returns {Promise}
   */
  function diffKids(node, existingModel, newModel) {
    var newKidModels = newModel.getKids();
    return Promise.all([UxModel.make(getUxModelDefaults(existingModel)), UxModel.make(getUxModelDefaults(newModel)), node.getKids()]).then(function (_ref14) {
      var _ref15 = _slicedToArray(_ref14, 2),
        oldDefaultsModel = _ref15[0],
        newDefaultsModel = _ref15[1];
      var oldNames = namesOf(existingModel.getKids());
      var allOldNames = [].concat(_toConsumableArray(oldNames), _toConsumableArray(namesOf(oldDefaultsModel.getKids())));
      var newNames = namesOf(newKidModels);
      var removedNames = uniq(allOldNames.filter(function (oldName) {
        return !newNames.includes(oldName);
      }));
      var defaultsToAdd = newDefaultsModel.getKids().filter(function (d) {
        return !newNames.includes(d.getName());
      });
      return Promise.all([].concat(_toConsumableArray(defaultsToAdd.map(function (defaultModel) {
        return node.getKid(defaultModel.getName()).then(function (existingNode) {
          if (existingNode) {
            // update default node to new values
            return existingNode.$applyModel(defaultModel);
          } else {
            // add new default node
            return UxModelTreeNode.make(defaultModel).then(function (kid) {
              return node.add(kid);
            });
          }
        });
      })), _toConsumableArray(removedNames.map(function (removedName) {
        var def = newDefaultsModel.get(removedName);
        if (def) {
          // revert removed node back to default values
          return node.getKid(removedName).then(function (defaultNode) {
            var existingModel = defaultNode.value();
            return defaultNode.$applyModel(def).then(function () {
              return diffKids(defaultNode, existingModel, def);
            }).then(function () {
              return triggerNameAndIconRepaint(node, removedName);
            });
          });
        } else {
          // remove node altogether
          return node.$doRemove(removedName, {
            silent: true
          });
        }
      })), _toConsumableArray(newKidModels.map(function (newModel) {
        var newName = newModel.getName();
        return node.getKid(newName).then(function (existingNode) {
          if (existingNode) {
            // replace existing kid with new one
            return node.$doReplaceKid(newName, newModel, {
              silent: true
            });
          } else {
            // add new one
            return UxModelTreeNode.make(newModel).then(function (newNode) {
              return node.add(newNode);
            });
          }
        });
      }))));
    }).then(function () {
      node.$reorder();
      node.$kidsLoaded = false;
    });
  }
  function toName(x) {
    return x.getName();
  }
  function namesOf(nodes) {
    return nodes.map(toName);
  }
  function triggerNameAndIconRepaint(parentNode, name) {
    parentNode.emit('renamed', name, name);
  }

  /**
   * Checks if the UxModel and its kids have a valid parent/child relationship.
   *
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {Promise.<boolean>}
   * @throws {Error} When a parent and child relationship is invalid.
   */
  function validateUxModel(uxModel) {
    var childPxDataTypeSpec;
    var parentPxDataTypeSpec;
    var isChildLegal;
    var isParentLegal;
    return uxModel.visit(function (model) {
      var kids = model.getKids();
      var parentWidget = getInstance(model);
      parentPxDataTypeSpec = model.getMetadata().pxDataTypeSpec;
      return kids.every(function (kid) {
        var childWidget = getInstance(kid);
        childPxDataTypeSpec = kid.getMetadata().pxDataTypeSpec;
        //When widgets that do not implement isChildLegal and isParentLegal, we will make them legal, by default.
        isChildLegal = parentWidget.isChildLegal ? parentWidget.isChildLegal(kid) : true;
        isParentLegal = childWidget.isParentLegal ? childWidget.isParentLegal(model) : true;
        return isChildLegal && isParentLegal;
      });
    }).then(function (isValid) {
      if (!isValid) {
        return Promise.all([getTypeDisplayName(childPxDataTypeSpec), getTypeDisplayName(parentPxDataTypeSpec)]).then(function (_ref16) {
          var _ref17 = _slicedToArray(_ref16, 2),
            childTypeString = _ref17[0],
            parentTypeString = _ref17[1];
          if (!isChildLegal) {
            throw new Error(uxBuilderLex.get('UxBuilder.invalidChild.message', childTypeString, parentTypeString));
          }
          throw new Error(uxBuilderLex.get('UxBuilder.invalidParent.message', parentTypeString, childTypeString));
        });
      }
      return isValid;
    });
  }

  /**
   * @param {Array.<baja.NavNode>} navNodes the nav nodes being dropped by the user
   * @returns {Promise.<Array.<baja.NavNode>>} the actual objects to be converted into UxModels for
   * insertion
   */
  function resolveForInsert(navNodes) {
    return Promise.all(navNodes.map(function (navNode) {
      if (!resolvableForInsert(navNode)) {
        return navNode;
      }
      var navOrd = navNode.getNavOrd();
      return navOrd ? navOrd.get() : navNode;
    }));
  }

  /**
   * When drag/dropping a nav node for inserting via Make Widget, we typically want to get() the
   * object that nav node is pointing at. For instance - if it's a nav node to a BWidget in a module
   * palette, we want to get() that actual BWidget instance out of the palette so its properties can
   * be applied to the widget we put into the px page.
   *
   * Special cases where we *don't* want to get() the object, but insert the nav node directly
   * instead:
   *
   * - history nodes will run the whole history query and resolve to BoxTables, leading to a wasted
   *   network call and a failed drop.
   *
   * @param {baja.NavNode} navNode
   * @returns {boolean}
   */
  function resolvableForInsert(navNode) {
    var type = baja.lt(navNode.getNavTypeSpec());
    /*
    the alternative here is to check for baja:ITable, but at the moment i don't feel confident
    that's correct in all cases. if later on we get confident that it's correct, let's make that
    change.
     */
    // TODO: NCCB-68316, remove
    return !type.is('history:IHistory') && !type.is('history:HistoryDevice') && !type.is('history:HistoryFolder');
  }

  /**
   * Convert nav nodes from the station to UxModels to be inserted into the Widget Tree.
   *
   * This code path does *not* respect `linkedPropertyPaths`, based on the presumption that
   * links to Px Properties are information that can be known only by existing UxModelTreeNodes.
   * That is: it doesn't make sense to say, I'm dropping a fresh NumericWritable from the
   * component space, and these are the Px Properties that it wants to link to. That information
   * just doesn't exist until after the Make Widget conversion process.
   *
   * @private
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertOp>} insertOps
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertParams} params
   * @returns {Promise.<Array.<module:bajaux/model/UxModel>|undefined>}
   */
  function navNodesToUxModels(insertOps, params) {
    var navNodes = pluck(insertOps, 'object');
    return baja.importTypes(navNodes.map(function (n) {
      return n.getNavTypeSpec();
    })).then(function () {
      return resolveForInsert(navNodes);
    }).then(function (objects) {
      return UxModelFactory.toUxModels(objects, params);
    });
  }

  /**
   * Convert existing UxModelTreeNodes to UxModels to be inserted into the Widget Tree. This will
   * happen when copying from Station NavTree or the UxBuilder and pasting back into UxBuilder (either the same .px page or
   * a different one).
   *
   * This code path *does* check for `linkedPropertyPaths` as Px Property links are known by the
   * UxModelTreeNodes we originally copied.
   *
   * @private
   * @param {Array.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertOp>} insertOps
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertParams} params
   * @returns {Promise}
   */
  function pastedNodesToUxModels(insertOps, params) {
    return navNodesToUxModels(insertOps, params).then(function (models) {
      if (!models) {
        return;
      }
      if (insertOps.length !== models.length) {
        //if there are a different number of UxModels being generated that what is coming in,
        //then there should be no linkedPropertyPaths to handle.
        //LinkedPropertyPaths handling is only required for WidgetNodesToUxModelFactory which will
        //always return the same number of models as InsertOps.
        return models;
      }
      return Promise.all(models.map(function (model, i) {
        return uxBuilderUtils.withPropertyPathsLinked(model, insertOps[i].linkedPropertyPaths);
      }));
    });
  }

  /**
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} parentNode
   * @param {Array.<module:bajaux/model/UxModel~UxModelParams|module:bajaux/model/UxModel>} kidDatas
   * @returns {Promise.<Array.<module:bajaux/model/UxModel>>}
   */
  function toUniquelyNamedKidModels(parentNode, kidDatas) {
    return Promise.all(kidDatas.map(function (kidData) {
      return UxModel.make(kidData);
    })).then(function (kidModels) {
      return Promise.all(kidModels.map(function (kidModel) {
        if (kidModel.getName()) {
          return kidModel;
        }
        return guessUniqueName(parentNode, kidModel).then(function (name) {
          return kidModel.clone({
            name: name
          });
        });
      }));
    });
  }

  /**
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} parentNode
   * @param {module:bajaux/model/UxModel} uxModel
   * @returns {Promise.<string>}
   */
  function guessUniqueName(parentNode, uxModel) {
    var existingNames = namesOf(parentNode.value().getKids());
    var metadata = uxModel.getMetadata();
    var pxDataTypeSpec = metadata && metadata.pxDataTypeSpec;
    if (!pxDataTypeSpec) {
      return Promise.resolve(generateUniqueName(existingNames, 'Widget'));
    }
    return baja.importTypes([pxDataTypeSpec]).then(function (_ref18) {
      var _ref19 = _slicedToArray(_ref18, 1),
        pxDataType = _ref19[0];
      return generateUniqueName(existingNames, pxDataType.getTypeName());
    });
  }
  return UxModelTreeNode;
});

/**
 * @typedef {object} module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertOp
 * @property {baja.NavNode} object the object to be converted and inserted into the UxModel tree
 * @property {Object<string, string | any>} [linkedPropertyPaths] linked property paths to apply to
 * the inserted node - they'll be known if you're copy/pasting a widget that already has links
 * present.
 */

/**
 * Additional context information used when inserting into a UxModelTreeNode.
 *
 * @typedef {module:nmodule/uxBuilder/rc/ux/commands/ReplaceUxModelCommand~ReplaceParams} module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertParams
 * @property {baja.Ord} [baseOrd]
 * @property {module:nmodule/bajaui/rc/rpc/uxBuilder~PxProperties} [pxProperties]
 * @property {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxLayer>} [pxLayers]
 * @property {function} [beforeInsert] specify this callback to perform any final modifications on
 * the UxModels just before they are applied to the target node.
 */

/**
 * When inserting anything into a UxModelTreeNode (NavNodes from nav tree, copied nodes from Widget
 * Tree, etc.) we'll normalize that into a specified context before actually doing the insert.
 *
 * @typedef {object} module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertContext
 * @property {Array.<module:bajaux/model/UxModel>} models the UxModels converted from the input
 * objects, ready to insert into the UxModelTreeNode
 * @property {UxModelTreeNode} node the actual UxModelTreeNode to insert into (can vary depending on
 * what node you initially invoked the insert operation on)
 * @property {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode~InsertParams} params
 */
