function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/model/UxBuilderEditContext
 */
define(['nmodule/uxBuilder/rc/util/uxBuilderUtils'], function (uxBuilderUtils) {
  'use strict';

  var generateUniqueNames = uxBuilderUtils.generateUniqueNames,
    resolveWidgetDisplayName = uxBuilderUtils.resolveWidgetDisplayName;

  /**
   * An instance of this class will be provided to any widget-specific hooks to be called when it is
   * edited. At the moment, only used to allow TabbedPane special behavior when adding new child
   * nodes.
   *
   * Future functionality (not set in stone just possibilities):
   *
   * - isDuplicating (see: instanceof BCanvasPane check in BStudio)
   * - isDropping (no known functionality difference vs right-click->New, yet)
   *
   * Other future "contexts":
   *
   * - DragContext (CanvasPane has specific drag-over behavior compared to other panes)
   */
  return /*#__PURE__*/function () {
    function UxBuilderEditContext() {
      _classCallCheck(this, UxBuilderEditContext);
    }
    return _createClass(UxBuilderEditContext, [{
      key: "toWidgetDisplayName",
      value:
      /**
       * @param {module:bajaux/model/UxModel} uxModel
       * @returns {Promise.<string>}
       */
      function toWidgetDisplayName(uxModel) {
        return resolveWidgetDisplayName(uxModel);
      }

      /**
       * @param {module:bajaux/model/UxModel} uxModel
       * @param {Array.<string>} desiredNames
       * @returns {Array.<string>} names guaranteed unique for this UxModel and the desired names
       */
    }, {
      key: "getUniqueNames",
      value: function getUniqueNames(uxModel, desiredNames) {
        var existingNames = uxModel.getKids().map(function (m) {
          return m.getName();
        });
        return generateUniqueNames(existingNames, desiredNames);
      }
    }]);
  }();
});
