function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'lex!uxBuilder', 'Promise'], function (baja, lexs, Promise) {
  'use strict';

  var OrdTarget = require('bajaScript/baja/ord/OrdTarget');
  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];

  /**
   * API Status: **Private**
   * @exports nmodule/uxBuilder/rc/ux/make/mwUtils
   */
  var exports = {};

  /**
   * @param {baja.NavNode} navNode
   * @returns {module:baja/ord/OrdTarget}
   */
  exports.toOrdTarget = function (navNode) {
    try {
      var base = {
        ord: navNode.getNavOrd().normalize().relativizeToSession()
      };

      //For now, we are not re-resolving the navOrd for a proper OrdTarget.
      // If a proper OrdTarget is needed in the future (like for utilizing any of the attributes copied over in OrdTarget.clone),
      // then a re-resolve would be one possibility to make that happen.
      var ordTarget = new OrdTarget(base);
      ordTarget.object = navNode;
      return ordTarget;
    } catch (error) {
      throw new Error(uxBuilderLex.get('errors.cannotCreateWidgetsFor', navNode));
    }
  };

  /**
   *
   * @param {Array.<baja.NavNode>} navNodes
   * @returns {Array.<module:baja/ord/OrdTarget>}
   */
  exports.toOrdTargets = function (navNodes) {
    return navNodes.map(function (navNode) {
      return exports.toOrdTarget(navNode);
    });
  };

  /**
   * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} uxModelTreeNode
   */
  exports.setLastBuiltWidget = function (uxModelTreeNode) {
    var Ctor = uxModelTreeNode.value().getType();
    if (Ctor) {
      uxModelTreeNode.setLastBuiltWidget(new Ctor());
    }
  };

  /**
   * Add the frozen facets on a Component with the flags hidden and transient.
   *
   * If the `Component` is mounted, this will **asynchronously** add or set
   * the `Property` to the `Component` on the server.
   *
   * This method can be helpful for adding temporary facets to a Widget for display-only purposes.
   * To remove these facets, call `removeFrozenFacets` later.
   *
   * @param {baja.Component} comp
   * @param {baja.FacetsMap} facetsMap
   * @returns {Promise.<baja.Property>} a promise that will be resolved with the newly added Property.
   */
  exports.setFrozenFacets = function (comp, facetsMap) {
    if (comp.getSlot('slotFacets_')) {
      return comp.set({
        slot: 'slotFacets_',
        value: facetsMap
      });
    }
    return comp.add({
      slot: 'slotFacets_',
      value: facetsMap,
      flags: baja.Flags.TRANSIENT | baja.Flags.HIDDEN
    });
  };

  /**
   *
   * If the `Component` is mounted, this will **asynchronously** remove
   * the Property from the `Component` on the server if the `slotFacets` property is present.
   *
   * @param {baja.Component} comp
   * @returns {Promise} a promise that will be resolved once the Property has
   * been removed.
   */
  exports.removeFrozenFacets = function (comp) {
    if (comp.getSlot('slotFacets_')) {
      return comp.remove('slotFacets_');
    }
    return Promise.resolve();
  };
  return exports;
});
