function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/make/MwWorkbenchView
 */

define(['baja!', 'baja!workbench:WbViewBinding,bajaui:Layout', 'bajaux/spandrel', 'bajaux/model/UxModel', 'lex!uxBuilder', 'Promise', 'underscore', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/bajaui/rc/ux/WebWidget', 'nmodule/uxBuilder/rc/ux/make/MwPropertiesWidget', 'nmodule/uxBuilder/rc/ux/make/UxMwConfig', 'nmodule/uxBuilder/rc/ux/model/UxModelTreeNode', 'nmodule/uxBuilder/rc/ux/make/mwUtils', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor'], function (baja, types, spandrel, UxModel, lexs, Promise, _, NullWidget, WebWidget, MwPropertiesWidget, UxMwConfig, UxModelTreeNode, mwUtils, OrderedMapEditor) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'uxBuilder',
      keyName: 'MwWorkbenchView',
      properties: {
        rootCssClass: '-t-MwWorkbenchView'
      }
    };
  };
  var setFrozenFacets = mwUtils.setFrozenFacets,
    removeFrozenFacets = mwUtils.removeFrozenFacets,
    setLastBuiltWidget = mwUtils.setLastBuiltWidget;
  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var substituteOrdDisplay = uxBuilderLex.get('makeWidget.substituteOrdDisplay');

  /**
   * MwWorkbenchView implementation, used to create a Px widget from a workbench view
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/make/MwWorkbenchView
   * @extends {module:nmodule/uxBuilder/rc/ux/make/UxMwConfig}
   * @since Niagara 4.15
  */
  var MwWorkbenchView = /*#__PURE__*/function (_spandrel) {
    function MwWorkbenchView(params) {
      _classCallCheck(this, MwWorkbenchView);
      return _callSuper(this, MwWorkbenchView, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * 
     * @private
     * @param {Object} state
     * @returns {Object}
     */
    _inherits(MwWorkbenchView, _spandrel);
    return _createClass(MwWorkbenchView, [{
      key: "$buildEditor",
      value: function $buildEditor(state) {
        var self = state.self,
          uxModelTreeNodes = state.uxModelTreeNodes,
          selectedViewName = state.selectedViewName,
          viewNames = state.viewNames,
          properties = state.properties;
        var _properties$baseOrd = properties.baseOrd,
          baseOrd = _properties$baseOrd === void 0 ? baja.Ord.make('station:|slot:/') : _properties$baseOrd,
          _properties$pxLayers = properties.pxLayers,
          pxLayers = _properties$pxLayers === void 0 ? [] : _properties$pxLayers,
          _properties$pxPropert = properties.pxProperties,
          pxProperties = _properties$pxPropert === void 0 ? {} : _properties$pxPropert;
        return [spandrel.jsx("div", {
          className: "-t-UxMwConfig-selectView"
        }, spandrel.jsx(OrderedMapEditor, {
          "class": "-t-UxMwWorkbench-view",
          value: selectedViewName,
          spandrelKey: "viewSelection",
          lax: true,
          properties: {
            map: viewNames
          },
          onUxModifiedValue: function onUxModifiedValue(selectedViewName) {
            return self.$buildTreeNode(selectedViewName).then(function (uxModelTreeNode) {
              return self.state({
                uxModelTreeNodes: [uxModelTreeNode],
                selectedViewName: selectedViewName
              });
            });
          }
        })), spandrel.jsx("div", {
          className: "-t-UxMwConfig-details"
        }, spandrel.jsx(MwPropertiesWidget, {
          spandrelKey: "changes",
          lax: true,
          bind: true,
          name: "uxModelTreeNodes",
          value: {
            uxModelTreeNodes: uxModelTreeNodes,
            pxProperties: pxProperties
          },
          properties: {
            pxLayers: pxLayers,
            pxProperties: pxProperties,
            baseOrd: baseOrd
          },
          validate: true
        }))];
      }

      /**
       * @param {Array.<module:baja/ord/OrdTarget>} ordTargets
       * @returns {Promise.<boolean>}
       */
    }, {
      key: "isValidFor",
      value: function isValidFor(ordTargets) {
        return this.$getViews(ordTargets).then(function (viewViews) {
          return Object.keys(viewViews).length !== 0;
        });
      }

      /**
       *
       * @param {Object} value
       * @returns {Promise}
       */
    }, {
      key: "toState",
      value: function toState(value) {
        var _this = this;
        var ordTargets = value.ordTargets;
        var viewNames;
        var selectedViewName;
        return this.$getViews(ordTargets).then(function (views) {
          _this.$views = views;
          viewNames = Object.keys(views);
          selectedViewName = viewNames[0];
          return _this.$buildTreeNode(selectedViewName);
        }).then(function (uxModelTreeNode) {
          return {
            uxModelTreeNodes: [uxModelTreeNode],
            ordTargets: ordTargets,
            selectedViewName: selectedViewName,
            viewNames: viewNames
          };
        });
      }

      /**
       *
       * @param {Object} state
       * @returns {Promise}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var _this2 = this;
        var _this$state = this.state(),
          ordTargets = _this$state.ordTargets;
        var x = 0;
        var y = 0;
        return this.$getPropertiesWidget().read().then(function (_ref) {
          var uxModelTreeNodes = _ref.uxModelTreeNodes,
            pxProperties = _ref.pxProperties;
          _this2.properties().setValue('pxProperties', pxProperties);
          var model = uxModelTreeNodes[0].value();
          return Promise.all(ordTargets.map(function (ordTarget) {
            return model.clone().then(function (newModel) {
              var bindings = model.getBindingList().getBindings();
              var newBindings = [];
              bindings.forEach(function (binding) {
                var newBinding = binding.newCopy();
                if (newBinding.getType().is('workbench:WbViewBinding')) {
                  newBinding.setOrd(ordTarget.getOrd());
                  removeFrozenFacets(newBinding);
                }
                newBindings.push(newBinding);
              });
              newModel.getBindingList().$setNewBindingsArray(newBindings);
              newModel.getProperties().layout = baja.$('bajaui:Layout', x + ',' + y + ',100,100');
              y = y + 100;
              return newModel;
            });
          })).then(function (uxModels) {
            return {
              ordTargets: ordTargets,
              uxModels: _.flatten(uxModels),
              pxProperties: pxProperties
            };
          });
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getViewSelection",
      value: function $getViewSelection() {
        return this.queryWidget('**/viewSelection');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPropertiesWidget",
      value: function $getPropertiesWidget() {
        return this.queryWidget('**/changes');
      }

      /**
       * Returns a list of shared views based on the ords targets selected
       * @private
       * @param {Array<module:baja/ord/OrdTarget>} ordTargets the selected ord targets
       * @returns {Promise.<Array.<Object>>}
       */
    }, {
      key: "$getViews",
      value: function $getViews(ordTargets) {
        var _this3 = this;
        var ords = ordTargets.map(function (ordTarget) {
          return ordTarget.ord;
        });
        var excludeList = [{
          typeSpec: "pxEditor:PxEditor"
        }, {
          typeSpec: "baja:AbstractPxView"
        }];
        return Promise.all(ords.map(function (ord) {
          var ordStr = ord.encodeToString();
          return baja.rpc('type:workbench:WorkbenchRpc', 'getWorkbenchViewList', ordStr);
        })).then(function (results) {
          var viewsLists = [];
          results.forEach(function (result) {
            viewsLists.push(result.list.slice());
          });
          return viewsLists;
        }).then(function (viewLists) {
          var views = _this3.$mergeArray(viewLists, true);
          return Promise.all(views.map(function (view) {
            return view.typeSpec;
          })).then(function (types) {
            return baja.importTypes(types);
          }).then(function () {
            excludeList.forEach(function (excludeEntry) {
              views = views.filter(function (view) {
                return !baja.lt(view.typeSpec).is(excludeEntry.typeSpec);
              });
            });
            var viewMap = {};
            views.forEach(function (view) {
              viewMap[view.displayName] = view;
            });
            return viewMap;
          });
        });
      }

      /**
       * Merges an array of arrays, generating one array that includes the all entries or only the entries
       * that are common in all the arrays
       * @private
       * @param {Array.<Array.<*>>} arrays
       * @param {boolean} inCommonEntries include only the entries that are in all the arrays
       * @returns {Array.<*>}
       */
    }, {
      key: "$mergeArray",
      value: function $mergeArray(arrays, inCommonEntries) {
        function getTypeSpec(entry) {
          return entry.moduleName + ":" + entry.typeName;
        }
        var newArray = [];
        if (inCommonEntries) {
          var wrkArray = this.$mergeArray(arrays, false);
          wrkArray.forEach(function (wrkEntry) {
            var inAll = true;
            arrays.forEach(function (arr) {
              var match = false;
              arr.forEach(function (entry) {
                if (entry.typeSpec === wrkEntry.typeSpec) {
                  match = true;
                }
              });
              if (!match) {
                inAll = false;
              }
            });
            if (inAll) {
              newArray.push(wrkEntry);
            }
          });
        } else {
          arrays.forEach(function (arr) {
            arr.forEach(function (entry) {
              var match = false;
              entry.typeSpec = getTypeSpec(entry);
              newArray.forEach(function (newEntry) {
                if (getTypeSpec(newEntry) === entry.typeSpec) {
                  match = true;
                }
              });
              if (!match) {
                newArray.push(entry);
              }
            });
          });
        }
        return newArray;
      }

      /**
       * Builds tree nodes based on the selected view name
       * @private
       * @param {String} selectedViewName
       * @returns {Promise.<module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode>}
       */
    }, {
      key: "$buildTreeNode",
      value: function $buildTreeNode(selectedViewName) {
        return this.$buildModel(selectedViewName).then(function (uxModel) {
          return UxModelTreeNode.make(uxModel);
        }).then(function (uxModelTreeNode) {
          setLastBuiltWidget(uxModelTreeNode);
          return uxModelTreeNode;
        });
      }

      /**
       * Builds a UxModel based on the supplied selected view name
       * @private
       * @param {String} selectedViewName
       * @returns {Promise.<bajaux/model/UxModel>}
       */
    }, {
      key: "$buildModel",
      value: function $buildModel(selectedViewName) {
        var selectedView = this.$views[selectedViewName];
        var viewTypeSpec = selectedView.typeSpec;
        // would normally get this from state(), but on the initial load of this, state has not been set
        var _this$value = this.value(),
          ordTargets = _this$value.ordTargets;
        var ord = ordTargets && ordTargets.length > 0 ? ordTargets[0].ord : baja.Ord.DEFAULT;
        var typeSpec;
        var pxDataTypeSpec;
        var properties;
        var viewType;
        return baja.importTypes([viewTypeSpec]).then(function (_ref2) {
          var _ref3 = _slicedToArray(_ref2, 1),
            vt = _ref3[0];
          viewType = vt;
          if (!viewType.is('web:IFormFactor')) {
            return baja.rpc('type:uxBuilder:PxUxRpc', 'getWebWidgetWrapperInfo', viewTypeSpec);
          }
        }).then(function (results) {
          var uxTypeSpec = results ? results.uxTypeSpec : undefined;
          var binding = baja.$('workbench:WbViewBinding', {
            ord: ord
          });
          var facetsMap = baja.FacetsMap.make({
            ord: baja.Facets.make({
              substituteValue: substituteOrdDisplay
            })
          });
          setFrozenFacets(binding, facetsMap);
          var type = WebWidget;
          if (viewType.is('web:IFormFactor')) {
            typeSpec = 'workbench:WebWidget';
            pxDataTypeSpec = 'workbench:WebWidget';
            properties = {
              js: baja.Ord.make('view:' + viewTypeSpec)
            };
          } else {
            if (uxTypeSpec) {
              typeSpec = 'uxBuilder:WebWidgetWrapper';
              pxDataTypeSpec = viewTypeSpec;
              properties = {
                js: baja.Ord.make('view:' + uxTypeSpec)
              };
            } else {
              type = NullWidget;
              typeSpec = viewTypeSpec;
              pxDataTypeSpec = viewTypeSpec;
            }
          }
          return UxModel.make({
            type: type,
            metadata: {
              typeSpec: typeSpec,
              pxDataTypeSpec: pxDataTypeSpec
            },
            properties: properties,
            bindings: [binding]
          });
        });
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    return self.$buildEditor(state);
  }, {
    strategy: 'niagara',
    "extends": UxMwConfig
  }));
  return MwWorkbenchView;
});
