function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/make/MwPropertiesWidget
 */
define(['bajaux/spandrel', 'underscore', 'nmodule/bajaui/rc/ux/TitlePane', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/ux/make/mwUtils', 'nmodule/uxBuilder/rc/ux/model/UxModelTreeNode', 'nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget'], function (spandrel, _, TitlePane, uxBuilderUtils, mwUtils, UxModelTreeNode, PropertiesWidget) {
  'use strict';

  var isEmpty = _.isEmpty;
  var setLastBuiltWidget = mwUtils.setLastBuiltWidget;
  var cloneWithChanges = uxBuilderUtils.cloneWithChanges;
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'uxBuilder',
      keyName: 'MwPropertiesWidget',
      properties: {
        rootCssClass: '-t-MwPropertiesWidget'
      }
    };
  };

  /**
   * Validates MwPropertiesWidget for any read errors.
   *
   * @param {module:nmodule/uxBuilder/rc/ux/make/MwPropertiesWidget} self
   * @throws {Error}
   */
  function validateMwPropertiesWidget(self) {
    var innerPropertiesWidget = self.$getPropertiesWidget();
    var readErrorStr = innerPropertiesWidget.$getReadErrorsAsString();
    if (!isEmpty(readErrorStr)) {
      throw new Error(readErrorStr);
    }
  }

  /**
   * A wrapper for the PropertiesWidget. Since Spandrel widgets are supposed to read the same object type
   * that they load in and PropertiesWidget doesn't do that, this widget works better when it needs to be
   * bound to a state (like how it's used with the MwBoundLabel).
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/make/MwPropertiesWidget
   * @extends module:bajaux/Widget
   * @since Niagara 4.15
   */
  var MwPropertiesWidget = /*#__PURE__*/function (_spandrel) {
    function MwPropertiesWidget(params) {
      var _this;
      _classCallCheck(this, MwPropertiesWidget);
      _this = _callSuper(this, MwPropertiesWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.validators().add(function () {
        return validateMwPropertiesWidget(_this);
      });
      return _this;
    }
    _inherits(MwPropertiesWidget, _spandrel);
    return _createClass(MwPropertiesWidget, [{
      key: "doRead",
      value: function doRead() {
        var _this2 = this;
        return this.$getPropertiesWidget().read().then(function (changes) {
          var nodes = _this2.$getPropertiesWidget().value();
          var model = nodes[0].value();
          return cloneWithChanges([model], changes).then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 1),
              cloned = _ref2[0];
            return cloned;
          }).then(function (uxModel) {
            return UxModelTreeNode.make(uxModel);
          }).then(function (uxModelTreeNode) {
            setLastBuiltWidget(uxModelTreeNode);
            return {
              uxModelTreeNodes: [uxModelTreeNode]
            };
          });
        });
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/sidebars/PropertiesWidget}
       */
    }, {
      key: "$getPropertiesWidget",
      value: function $getPropertiesWidget() {
        return this.queryWidget('**/content');
      }
    }]);
  }(spandrel(function (value, _ref3) {
    var _ref3$properties = _ref3.properties,
      pxLayers = _ref3$properties.pxLayers,
      pxProperties = _ref3$properties.pxProperties,
      baseOrd = _ref3$properties.baseOrd;
    var uxModelTreeNodes = value.uxModelTreeNodes;
    return spandrel.jsx(TitlePane, null, spandrel.jsx(PropertiesWidget, {
      bind: true,
      lax: true,
      spandrelKey: "content",
      name: "content",
      value: uxModelTreeNodes,
      properties: {
        pxLayers: pxLayers,
        pxProperties: pxProperties,
        baseOrd: baseOrd,
        substituteMode: true
      }
    }));
  }));
  return MwPropertiesWidget;
});
