function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx UxModel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/make/MwPalettePreview
 */
define(['baja!', 'baja!bajaui:Orientation', 'bajaux/spandrel', 'lex!uxBuilder', 'Promise', 'underscore', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/commands/ToggleCommand', 'bajaux/model/UxModel', 'bajaux/util/CommandButtonGroup', 'nmodule/bajaui/rc/util/ScaledWrapper', 'nmodule/bajaui/rc/ux/Label', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/bajaui/rc/ux/SplitPane', 'nmodule/bajaui/rc/ux/TabbedPane', 'nmodule/uxBuilder/rc/ux/factory/impl/WidgetNodesToUxModelFactory', 'nmodule/webEditors/rc/servlets/palette', 'nmodule/webEditors/rc/servlets/userData', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/model/columns/DisplayNameColumn', 'nmodule/webEditors/rc/wb/tree/NavTree', 'nmodule/webEditors/rc/wb/tree/PaletteNavTree'], function (baja, types, spandrel, lexs, Promise, _, Command, CommandGroup, ToggleCommand, UxModel, CommandButtonGroup, ScaledWrapper, Label, NullWidget, SplitPane, TabbedPane, WidgetNodesToUxModelFactory, palette, userData, Table, Row, TableModel, DisplayNameColumn, NavTree, PaletteNavTree) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var DIVIDER_WIDTH_3 = 3;
  var DIVIDER_WIDTH_0 = 0;
  var SPLIT_PANE_HEIGHT_70 = 70;
  var SPLIT_PANE_HEIGHT_100 = 100;
  var DESELECTED_EVENT = NavTree.DESELECTED_EVENT,
    SELECTED_EVENT = NavTree.SELECTED_EVENT;
  var PREVIEW_SUFFIX = 'Preview';
  var pick = _.pick,
    map = _.map;
  var getJson = userData.getJson,
    putJson = userData.putJson;
  var DEFAULT_STORAGE_KEY = '.mwPalettePreview';
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'uxBuilder',
      keyName: 'MwPalettePreview',
      properties: {
        rootCssClass: '-t-MwPalettePreview',
        storageKey: DEFAULT_STORAGE_KEY,
        showCommandBar: false
      }
    };
  };

  /**
   * @class
   * @inner
   * @typedef module:nmodule/uxBuilder/rc/ux/make/MwPalettePreview~BoundTableDisplayNameColumn
   * @extends module:nmodule/webEditors/rc/wb/table/model/columns/DisplayNameColumn
   */
  var BoundTableDisplayNameColumn = /*#__PURE__*/function (_DisplayNameColumn) {
    function BoundTableDisplayNameColumn() {
      _classCallCheck(this, BoundTableDisplayNameColumn);
      return _callSuper(this, BoundTableDisplayNameColumn, arguments);
    }
    _inherits(BoundTableDisplayNameColumn, _DisplayNameColumn);
    return _createClass(BoundTableDisplayNameColumn, [{
      key: "getValueFor",
      value: function getValueFor(row) {
        return String(row.getSubject());
      }
    }]);
  }(DisplayNameColumn);
  /**
   * Returns the default TableModel to display BoundTable Preview.
   *
   * @returns {{columns: Array.<BoundTableDisplayNameColumn>, rows: Array.<module:nmodule/webEditors/rc/wb/table/model/Row>}}
   */
  function getColumnsAndRowsForBoundTable() {
    var columnsAndRows = {
      columns: [],
      rows: []
    };
    var colNames = ['A', 'B', 'C', 'D'];
    colNames.forEach(function (displayName) {
      columnsAndRows.columns.push(new BoundTableDisplayNameColumn('displayName', {
        displayName: displayName
      }));
    });
    for (var i = 1; i <= 5; i++) {
      columnsAndRows.rows.push(new Row(i));
    }
    return columnsAndRows;
  }

  /**
   * @returns {Promise<module:bajaux/model/UxModel>}
   */
  function getNoPreviewUxModel() {
    return UxModel.make({
      type: Label,
      properties: {
        text: uxBuilderLex.get('UxMwFromPalette.palettePreview.contentNotAvailable.message')
      }
    });
  }

  /**
   * Returns the default model to display TabbedPane Preview.
   *
   * @returns {Promise}
   */
  function getDefaultTabbedPaneModel() {
    return UxModel.make({
      kids: [{
        type: Label,
        kids: [{
          name: 'label',
          type: Label,
          properties: {
            text: uxBuilderLex.get('UxMwFromPalette.palettePreview.tabbedPane.tabOne')
          }
        }, {
          name: 'content',
          type: Label,
          properties: {}
        }]
      }, {
        type: Label,
        kids: [{
          name: 'label',
          type: Label,
          properties: {
            text: uxBuilderLex.get('UxMwFromPalette.palettePreview.tabbedPane.tabTwo')
          }
        }, {
          name: 'content',
          type: NullWidget,
          properties: {}
        }]
      }]
    }).then(function (model) {
      return UxModel.make({
        type: TabbedPane,
        value: model
      });
    });
  }

  /**
   * It will provide a preview for the palette components.
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/make/MwPalettePreview
   * @since Niagara 4.15
   */
  return /*#__PURE__*/function (_spandrel) {
    function MwPalettePreview(params) {
      var _this;
      _classCallCheck(this, MwPalettePreview);
      _this = _callSuper(this, MwPalettePreview, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$makePaletteCommands();
      return _this;
    }
    _inherits(MwPalettePreview, _spandrel);
    return _createClass(MwPalettePreview, [{
      key: "toState",
      value: function toState(value) {
        var _this2 = this;
        return Promise["try"](function () {
          return value || palette.getPalettes(PaletteNavTree.getOpenPalettes());
        }).then(function (paletteTreeNode) {
          return Promise.all([_this2.$resolveUserData(), getNoPreviewUxModel()]) //Set a No-Preview uxModel for the first load
          .then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              showPreview = _ref2[0].showPreview,
              previewModel = _ref2[1];
            return {
              paletteTreeNode: paletteTreeNode,
              showPreview: showPreview,
              previewModel: previewModel
            };
          });
        });
      }

      /**
      * Build the palette spandrel, and it uses the state information to build the PaletteTreeNode and the PreviewModel.
      *
      * @private
      * @param {Object} params
      * @param {module:nmodule/uxBuilder/rc/ux/model/UxModelTreeNode} params.paletteTreeNode
      * @param {nmodule:bajaux/model/UxModel} previewModel
      * @param {boolean} showPreview
      * @param {module:bajaux/Properties} properties
      * @returns {module:bajaux/spandrel~SpandrelData}
      */
    }, {
      key: "$buildEditor",
      value: function $buildEditor(_ref3) {
        var _this3 = this;
        var paletteTreeNode = _ref3.paletteTreeNode,
          previewModel = _ref3.previewModel,
          showPreview = _ref3.showPreview,
          properties = _ref3.properties;
        var dividerPosition = showPreview ? SPLIT_PANE_HEIGHT_70 : SPLIT_PANE_HEIGHT_100;
        var dividerWidth = showPreview ? DIVIDER_WIDTH_3 : DIVIDER_WIDTH_0;
        // Enable or disable the palettePreviewCommand with the value of showPreview. Often showPreview is saved in user state.
        this.getCommandGroup().getChildren()[2].setSelected(showPreview);
        var showCommandBar = properties.showCommandBar;
        return [showCommandBar && UxModel.jsx(CommandButtonGroup, {
          value: this.getCommandGroup(),
          spandrelKey: "paletteCommands",
          properties: {
            toolbar: true
          }
        }), UxModel.jsx(SplitPane, {
          className: "-t-MwPalette-splitPane",
          spandrelKey: "mwSplitPane",
          properties: {
            orientation: baja.$("bajaui:Orientation", "vertical"),
            dividerPosition: dividerPosition,
            dividerWidth: dividerWidth,
            moveableDivider: showPreview
          }
        }, UxModel.jsx(PaletteNavTree, {
          "class": "-t-makeWidget-palette",
          value: paletteTreeNode,
          name: "widget1",
          on: _defineProperty({}, SELECTED_EVENT + " " + DESELECTED_EVENT, function (e, widget) {
            var nodes = widget.getSelectedNodes();
            var nodeValue;
            if (nodes.length > 0) {
              var paletteNode = nodes[0];
              nodeValue = paletteNode.value();
            }
            // When a node is available with a nodeValue, then update the preview model.
            if (nodes.length && nodeValue) {
              return _this3.$updateStateWithPreviewModel(nodeValue.ord);
            }
            // When nodes are unselected, or the selected node does not have a value, show "No content available" to the user.
            return getNoPreviewUxModel().then(function (previewModel) {
              return _this3.state({
                previewModel: previewModel
              });
            });
          })
        }), showPreview && UxModel.jsx(ScaledWrapper, {
          name: "widget2",
          className: "-t-MwPalette-widget2-wrapper"
        }, UxModel.jsx("widget", {
          src: previewModel,
          name: "content",
          className: "-t-MwFromPalette-PalettePreview"
        })))];
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$resolveUserData",
      value: function $resolveUserData() {
        var STORAGE_KEY = this.properties().getValue('storageKey') + PREVIEW_SUFFIX;
        return getJson(STORAGE_KEY, {
          showPreview: false
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$saveToUserData",
      value: function $saveToUserData() {
        var STORAGE_KEY = this.properties().getValue('storageKey') + PREVIEW_SUFFIX;
        var storageState = pick(this.state(), 'showPreview');
        return putJson(STORAGE_KEY, storageState);
      }

      /**
       * @private
       */
    }, {
      key: "$makePaletteCommands",
      value: function $makePaletteCommands() {
        var _this4 = this;
        this.getCommandGroup().add(new Command({
          module: 'webEditors',
          lex: 'commands.addPalette',
          func: function func() {
            return _this4.$getPaletteWidget().$getAddPaletteCommand().invoke().then(function () {
              return _this4.$savePalette();
            });
          }
        })).add(new Command({
          module: 'webEditors',
          lex: 'commands.closePalette',
          func: function func() {
            return _this4.$getPaletteWidget().$getClosePaletteCommand().invoke().then(function () {
              return _this4.$savePalette();
            });
          }
        })).add(new ToggleCommand({
          module: 'uxBuilder',
          lex: 'UxMwFromPalette.palettePreview',
          func: function func() {
            var showPreview = !_this4.state().showPreview;
            return _this4.state({
              showPreview: showPreview
            }).then(function () {
              return _this4.$savePalette();
            });
          }
        }));
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSplitPane",
      value: function $getSplitPane() {
        return this.queryWidget('**/mwSplitPane');
      }

      /**
       * Returns the PaletteWidget from SplitPane.
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPaletteWidget",
      value: function $getPaletteWidget() {
        return this.$getSplitPane().$getWidget1();
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPaletteCommandsWidget",
      value: function $getPaletteCommandsWidget() {
        return this.queryWidget('**/paletteCommands');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPreviewWidget",
      value: function $getPreviewWidget() {
        return this.$getSplitPane().$getWidget2().$getContent();
      }

      /**
       * Saves the Palette with recent changes.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$savePalette",
      value: function $savePalette() {
        var _this5 = this;
        return this.$saveToUserData().then(function () {
          return _this5.$getPaletteWidget().value().getKids().then(function (kids) {
            var openPalettes = map(kids, function (kid) {
              return kid.getName();
            });
            PaletteNavTree.savePalettes(openPalettes);
          });
        });
      }
    }, {
      key: "doSave",
      value: function doSave() {
        var _arguments = arguments,
          _this6 = this;
        return this.$saveToUserData().then(function () {
          return _superPropGet(MwPalettePreview, "doSave", _this6, 3)(_arguments);
        });
      }

      /**
       * @private
       * @param {baja.Ord|string} ord
       * @returns {Promise}
       */
    }, {
      key: "$updateStateWithPreviewModel",
      value: function $updateStateWithPreviewModel(ord) {
        var _this7 = this;
        return baja.Ord.make(ord).get().then(function (widget) {
          //create a new Table model when the type is a BoundTable.
          if (baja.hasType(widget, 'bajaui:BoundTable')) {
            return UxModel.make({
              type: Table,
              value: new TableModel(getColumnsAndRowsForBoundTable())
            }).then(function (previewModel) {
              return _this7.state({
                previewModel: previewModel
              });
            });
          }

          // Set the default TabbedPane to the state when the widget is a TabbedPane.
          if (baja.hasType(widget, 'bajaui:TabbedPane')) {
            return getDefaultTabbedPaneModel().then(function (previewModel) {
              return _this7.state({
                previewModel: previewModel
              });
            });
          }

          // When widget is not a TabbedPane or BoundTable, check for compPreviewWidget.
          var compPreviewWidget = widget.get('compPreviewWidget') || widget;
          return new WidgetNodesToUxModelFactory().convert([compPreviewWidget])["catch"](function () {
            return Promise.all([getNoPreviewUxModel()]);
          }).then(function (_ref5) {
            var _ref6 = _slicedToArray(_ref5, 1),
              previewModel = _ref6[0];
            return _this7.state({
              previewModel: previewModel
            });
          });
        });
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self,
      paletteTreeNode = state.paletteTreeNode,
      previewModel = state.previewModel,
      showPreview = state.showPreview,
      properties = state.properties;
    return self.$buildEditor({
      paletteTreeNode: paletteTreeNode,
      previewModel: previewModel,
      showPreview: showPreview,
      properties: properties
    });
  }));
});
