function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx UxModel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/make/MwFromPalette
 */

define(['baja!', 'baja!workbench:WbViewBinding,bajaui:Layout', 'bajaux/spandrel', 'bajaux/model/UxModel', 'lex!uxBuilder', 'Promise', 'underscore', 'nmodule/bajaui/rc/baja/Layout', 'nmodule/uxBuilder/rc/util/uxBuilderUtils', 'nmodule/uxBuilder/rc/ux/factory/impl/WidgetNodesToUxModelFactory', 'nmodule/uxBuilder/rc/ux/make/MwPalettePreview', 'nmodule/uxBuilder/rc/ux/make/MwPropertiesWidget', 'nmodule/uxBuilder/rc/ux/make/mwUtils', 'nmodule/uxBuilder/rc/ux/make/UxMwConfig', 'nmodule/uxBuilder/rc/ux/model/UxModelTreeNode', 'nmodule/webEditors/rc/servlets/userData', 'nmodule/webEditors/rc/servlets/palette', 'nmodule/webEditors/rc/wb/tree/NavTree', 'nmodule/webEditors/rc/wb/tree/PaletteNavTree'], function (baja, types, spandrel, UxModel, lexs, Promise, _, Layout, uxBuilderUtils, WidgetNodesToUxModelFactory, MwPalettePreview, MwPropertiesWidget, mwUtils, UxMwConfig, UxModelTreeNode, userData, palette, NavTree, PaletteNavTree) {
  'use strict';

  var STORAGE_KEY = 'uxBuilder.MwFromPalette';
  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var setFrozenFacets = mwUtils.setFrozenFacets,
    removeFrozenFacets = mwUtils.removeFrozenFacets,
    setLastBuiltWidget = mwUtils.setLastBuiltWidget;
  var getJson = userData.getJson,
    putJson = userData.putJson;
  var cloneWithChanges = uxBuilderUtils.cloneWithChanges;
  var substituteOrdDisplay = uxBuilderLex.get('makeWidget.substituteOrdDisplay');
  var nullDisplay = uxBuilderLex.get('makeWidget.null');
  var DESELECTED_EVENT = NavTree.DESELECTED_EVENT,
    SELECTED_EVENT = NavTree.SELECTED_EVENT;
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'uxBuilder',
      keyName: 'MwFromPalette',
      properties: {
        rootCssClass: '-t-MwFromPalette'
      }
    };
  };

  /**
   * MwFromPalette implementation, used to create a Widget from the palette.
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/make/MwFromPalette
   * @extends {module:nmodule/uxBuilder/rc/ux/make/UxMwConfig}
   * @since Niagara 4.15
   */
  var MwFromPalette = /*#__PURE__*/function (_spandrel) {
    function MwFromPalette(params) {
      _classCallCheck(this, MwFromPalette);
      return _callSuper(this, MwFromPalette, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     *
     * @private
     * @param {Object} state
     * @returns {Object}
     */
    _inherits(MwFromPalette, _spandrel);
    return _createClass(MwFromPalette, [{
      key: "$buildEditor",
      value: function $buildEditor(state) {
        var self = state.self,
          properties = state.properties,
          changes = state.changes,
          hyperlinkChecked = state.hyperlinkChecked,
          hyperlinkReadonly = state.hyperlinkReadonly,
          paletteTreeNode = state.paletteTreeNode;
        var _properties$baseOrd = properties.baseOrd,
          baseOrd = _properties$baseOrd === void 0 ? baja.Ord.make('station:|slot:/') : _properties$baseOrd,
          _properties$pxLayers = properties.pxLayers,
          pxLayers = _properties$pxLayers === void 0 ? [] : _properties$pxLayers,
          pxProperties = properties.pxProperties;
        var uxModelTreeNodes = changes.uxModelTreeNodes;
        if (uxModelTreeNodes.length) {
          this.$updateBindingConfiguration(changes.uxModelTreeNodes[0].value(), hyperlinkChecked);
        }
        var showProperties = !!uxModelTreeNodes.length;
        return [UxModel.jsx("div", {
          className: "-t-UxMwConfig-summary ux-border"
        }, UxModel.jsx("any", {
          bind: true,
          lax: true,
          spandrelKey: "hyperlinkChecked",
          value: hyperlinkChecked,
          "class": "-t-MwBoundLabel-hyperlink",
          readonly: hyperlinkReadonly,
          properties: {
            displayType: "checkbox",
            trueText: uxBuilderLex.get('makeWidget.hyperlink'),
            falseText: uxBuilderLex.get('makeWidget.hyperlink')
          },
          onUxModifiedValue: function onUxModifiedValue(hyperlinkChecked) {
            return self.$hyperlinkModified(hyperlinkChecked);
          }
        }), UxModel.jsx(MwPalettePreview, {
          spandrelKey: "mwPalettePreview",
          properties: {
            storageKey: STORAGE_KEY,
            showCommandBar: true
          },
          value: paletteTreeNode,
          on: _defineProperty({}, SELECTED_EVENT + " " + DESELECTED_EVENT, function (e, widget) {
            var nodes = widget.getSelectedNodes();
            var ord = '';
            var fullPath;
            var nodeValue;
            if (nodes.length > 0) {
              var paletteNode = nodes[0];
              fullPath = paletteNode.getFullPath();
              nodeValue = paletteNode.value();
              if (nodeValue) {
                ord = nodeValue.ord;
              }
            }
            return Promise["try"](function () {
              if (ord !== self.state().paletteOrd) {
                return self.$updateOrd(ord, fullPath);
              }
            });
          })
        })), showProperties && UxModel.jsx("div", {
          className: "-t-UxMwConfig-details"
        }, UxModel.jsx(MwPropertiesWidget, {
          bind: true,
          lax: true,
          spandrelKey: "changes",
          name: "uxModelTreeNodes",
          value: state.changes,
          properties: {
            pxLayers: pxLayers,
            pxProperties: pxProperties,
            baseOrd: baseOrd
          },
          validate: true
        })), !showProperties && UxModel.jsx("div", {
          className: "-t-UxMwConfig-details-empty"
        })];
      }

      /**
       * @private
       * @param {boolean} hyperlinkChecked
       * @returns {Promise}
       */
    }, {
      key: "$hyperlinkModified",
      value: function $hyperlinkModified(hyperlinkChecked) {
        var _this = this;
        var uxModelTreeNodes = this.state().changes.uxModelTreeNodes;
        if (uxModelTreeNodes.length) {
          var model = uxModelTreeNodes[0].value();
          return cloneWithChanges([model], {}).then(function (_ref2) {
            var _ref3 = _slicedToArray(_ref2, 1),
              cloned = _ref3[0];
            _this.$updateBindingConfiguration(cloned, hyperlinkChecked);
            return UxModelTreeNode.make(cloned).then(function (uxModelTreeNode) {
              var changes = {
                uxModelTreeNodes: [uxModelTreeNode]
              };
              return _this.state({
                hyperlinkChecked: hyperlinkChecked,
                changes: changes
              });
            });
          });
        }
        return this.state({
          hyperlinkChecked: hyperlinkChecked
        });
      }

      /**
       * @private
       * @param {String} paletteOrd
       * @param {Array.<String>} palettePath
       * @returns {Promise}
       */
    }, {
      key: "$updateOrd",
      value: function $updateOrd(paletteOrd, palettePath) {
        var _this2 = this;
        var _this$state = this.state(),
          hyperlinkChecked = _this$state.hyperlinkChecked;
        return this.$getChangesFromOrd(paletteOrd, hyperlinkChecked).then(function (changes) {
          var uxModelTreeNodes = changes.uxModelTreeNodes;
          var hyperlinkReadonly = uxModelTreeNodes.length && _this2.$isHyperlinkReadonly(uxModelTreeNodes[0].value());
          var hyperlinkChecked = _this2.state().hyperlinkChecked && !hyperlinkReadonly;
          return _this2.state({
            changes: changes,
            paletteOrd: paletteOrd,
            palettePath: palettePath,
            hyperlinkReadonly: hyperlinkReadonly,
            hyperlinkChecked: hyperlinkChecked
          });
        });
      }

      /**
       * @private
       * @param {module:bajaux/model/UxModel} uxModel
       * @param {boolean} hyperlinkChecked
       */
    }, {
      key: "$updateBindingConfiguration",
      value: function $updateBindingConfiguration(uxModel, hyperlinkChecked) {
        var bindings = uxModel.getBindingList().getBindings();
        if (bindings.length > 0) {
          var primaryBinding = bindings[0];
          var hyperlinkSubstitute = hyperlinkChecked ? substituteOrdDisplay : nullDisplay;
          var facetMapParams = {
            ord: baja.Facets.make({
              substituteValue: substituteOrdDisplay
            })
          };
          if (baja.hasType(primaryBinding, 'bajaui:ValueBinding')) {
            facetMapParams.hyperlink = baja.Facets.make({
              substituteValue: hyperlinkSubstitute
            });
          }
          var facetsMap = baja.FacetsMap.make(facetMapParams);
          setFrozenFacets(primaryBinding, facetsMap);
        }
      }

      /**
       * @private
       * @param {module:bajaux/model/UxModel} [uxModel]
       * @returns {boolean}
       */
    }, {
      key: "$isHyperlinkReadonly",
      value: function $isHyperlinkReadonly(uxModel) {
        if (!uxModel) {
          return true;
        }
        var bindings = uxModel.getBindingList().getBindings();
        if (bindings.length > 0) {
          var primaryBinding = bindings[0];
          return !baja.hasType(primaryBinding, 'bajaui:ValueBinding');
        }
        return true;
      }

      /**
       * @private
       * @param {String} paletteOrd
       * @param {boolean} hyperlinkChecked
       * @returns {Promise.<Object>}
       */
    }, {
      key: "$getChangesFromOrd",
      value: function $getChangesFromOrd(paletteOrd, hyperlinkChecked) {
        var _this3 = this;
        return Promise.resolve(paletteOrd && baja.Ord.make(paletteOrd).get()).then(function (widget) {
          if (!widget) {
            return {
              uxModelTreeNodes: []
            };
          }
          var factory = new WidgetNodesToUxModelFactory();
          return factory.convert([widget])["catch"](function () {
            return [];
          }).then(function (_ref4) {
            var _ref5 = _slicedToArray(_ref4, 1),
              uxModel = _ref5[0];
            if (!uxModel) {
              return {
                uxModelTreeNodes: []
              };
            }
            _this3.$updateBindingConfiguration(uxModel, hyperlinkChecked);
            return UxModelTreeNode.make(uxModel).then(function (uxModelTreeNode) {
              setLastBuiltWidget(uxModelTreeNode);
              var uxModelTreeNodes = [uxModelTreeNode];
              return {
                uxModelTreeNodes: uxModelTreeNodes
              };
            });
          });
        });
      }
    }, {
      key: "requestFocus",
      value: function requestFocus() {
        this.$getPaletteWidget().setSelectedPath(this.state().palettePath || []);
      }
    }, {
      key: "doSave",
      value: function doSave() {
        var _arguments = arguments,
          _this4 = this;
        return this.$setStorageState().then(function () {
          return _superPropGet(MwFromPalette, "doSave", _this4, 3)(_arguments);
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$setStorageState",
      value: function $setStorageState() {
        var storageState = _.pick(this.state(), 'paletteOrd', 'palettePath', 'hyperlinkChecked');
        return putJson(STORAGE_KEY, storageState);
      }

      /**
       * @returns {boolean}
       */
    }, {
      key: "isValidFor",
      value: function isValidFor() {
        return true;
      }

      /**
       * @param {Object} value
       * @returns {Promise}
       */
    }, {
      key: "toState",
      value: function toState(value) {
        var _this5 = this;
        var ordTargets = value.ordTargets;
        return this.$resolveStorageState().then(function (storageState) {
          var paletteOrd = storageState.paletteOrd,
            palettePath = storageState.palettePath,
            hyperlinkChecked = storageState.hyperlinkChecked;
          return palette.getPalettes(PaletteNavTree.getOpenPalettes()).then(function (paletteTreeNode) {
            return _this5.$getChangesFromOrd(paletteOrd, hyperlinkChecked).then(function (changes) {
              var uxModelTreeNodes = changes.uxModelTreeNodes;
              var hyperlinkReadonly = uxModelTreeNodes.length && _this5.$isHyperlinkReadonly(uxModelTreeNodes[0].value());
              hyperlinkChecked = hyperlinkChecked && !hyperlinkReadonly;
              return {
                changes: changes,
                ordTargets: ordTargets,
                paletteTreeNode: paletteTreeNode,
                paletteOrd: paletteOrd,
                palettePath: palettePath,
                hyperlinkChecked: hyperlinkChecked,
                hyperlinkReadonly: hyperlinkReadonly
              };
            });
          });
        });
      }

      /*
       * @param {Object} state
       * @returns {Promise}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var ordTargets = state.ordTargets,
          changes = state.changes,
          hyperlinkChecked = state.hyperlinkChecked;
        var uxModelTreeNodes = changes.uxModelTreeNodes;
        var model = uxModelTreeNodes.length && uxModelTreeNodes[0].value();
        var x = 0;
        var y = 0;
        if (!model) {
          return Promise.resolve({
            ordTargets: ordTargets,
            uxModels: []
          });
        }
        var singleOrdTarget = ordTargets.length === 1;
        return Promise.all(ordTargets.map(function (ordTarget) {
          return model.clone({
            bindings: model.getBindingList().getBindings().map(function (binding) {
              return binding.newCopy(true);
            })
          }).then(function (newModel) {
            var bindings = newModel.getBindingList().getBindings();
            if (bindings.length > 0) {
              var primaryBinding = bindings[0];
              primaryBinding.setOrd(ordTarget.getOrd());
              if (hyperlinkChecked && baja.hasType(primaryBinding, 'bajaui:ValueBinding')) {
                primaryBinding.setHyperlink(ordTarget.getOrd());
              }
              removeFrozenFacets(primaryBinding);
            }
            var props = newModel.getProperties();
            //TODO: NCCB-67876. Ideally, this layout would know the size of the space taken up by the preferred size of the Widget,
            //and not rely on the layout being re-set as a property. Since many widget palette items do have the layout set to something
            // absolute, this is mostly OK.
            var layout = props.layout;
            var width = 100;
            var height = 100;
            var skipLayout = false;
            if (layout && layout.getWidthUnit() === Layout.ABS && layout.getHeightUnit() === Layout.ABS) {
              width = layout.getWidth();
              height = layout.getHeight();
            } else if (layout && layout === Layout.FILL && singleOrdTarget) {
              skipLayout = true;
            }
            if (!skipLayout) {
              props.layout = baja.$('bajaui:Layout', x + ',' + y + ',' + width + ',' + height);
            }
            y = y + height;
            return newModel;
          });
        })).then(function (uxModels) {
          return {
            ordTargets: ordTargets,
            uxModels: _.flatten(uxModels)
          };
        });
      }

      /**
       * @private
       * @returns {Promise.<Object>}
       */
    }, {
      key: "$resolveStorageState",
      value: function $resolveStorageState() {
        var defaultStorageState = {
          paletteOrd: '',
          palettePath: [],
          hyperlinkChecked: false
        };
        return getJson(STORAGE_KEY, defaultStorageState);
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getHyperlinkCheckedWidget",
      value: function $getHyperlinkCheckedWidget() {
        return this.queryWidget('**/hyperlinkChecked');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPropertiesWidget",
      value: function $getPropertiesWidget() {
        return this.queryWidget('**/changes');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPreviewWidget",
      value: function $getPreviewWidget() {
        return this.queryWidget('**/mwPalettePreview').$getPreviewWidget();
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPaletteWidget",
      value: function $getPaletteWidget() {
        return this.queryWidget('**/mwPalettePreview').$getPaletteWidget();
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPaletteCommandsWidget",
      value: function $getPaletteCommandsWidget() {
        return this.queryWidget('**/mwPalettePreview').$getPaletteCommandsWidget();
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    return self.$buildEditor(state);
  }, {
    strategy: 'niagara',
    "extends": UxMwConfig
  }));
  return MwFromPalette;
});
