function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx UxModel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/make/MwActionBatch
 */
define(['baja!', 'baja!bajaui:Layout,gx:Brush', 'bajaux/spandrel', 'bajaux/model/UxModel', 'lex!uxBuilder', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/uxBuilder/rc/ux/make/UxMwConfig', 'nmodule/webEditors/rc/fe/baja/util/slotUtils', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/model/columns/IconColumn', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/TableModel'], function (baja, types, spandrel, UxModel, lexs, Promise, _, asyncUtils, UxMwConfig, slotUtils, Column, Row, IconColumn, Table, TableModel) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var isHidden = slotUtils.isHidden;
  var ROW_SELECTION_CHANGED_EVENT = Table.ROW_SELECTION_CHANGED_EVENT;
  var actionIcon = baja.Icon.make(['module://icons/x16/action.png']);
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'uxBuilder',
      keyName: 'MwActionBatch',
      properties: {
        rootCssClass: '-t-MwActionBatch'
      }
    };
  };

  /**
   * MwActionBatch shows actions for Components.
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/make/MwActionBatch
   * @extends {module:nmodule/uxBuilder/rc/ux/make/UxMwConfig}
   */
  var MwActionBatch = /*#__PURE__*/function (_spandrel) {
    function MwActionBatch(params) {
      var _this;
      _classCallCheck(this, MwActionBatch);
      _this = _callSuper(this, MwActionBatch, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.validators().add(function () {
        if (_this.$getTable().getSelectedRows().length === 0) {
          throw new Error(uxBuilderLex.get('UxMwActionBatch.noActionsSelected'));
        }
      });
      return _this;
    }

    /**
     * @param {Array.<module:baja/ord/OrdTarget>} ordTargets
     * @returns {Promise.<boolean>}
     */
    _inherits(MwActionBatch, _spandrel);
    return _createClass(MwActionBatch, [{
      key: "isValidFor",
      value: function isValidFor(ordTargets) {
        var _this2 = this;
        return baja.importTypes(['kitPx:ImageButton', 'kitPx:ActionBinding']).then(function () {
          return _this2.$getCommonActions(ordTargets).length > 0;
        })["catch"](function () {
          return false;
        });
      }

      /**
       * @returns {Promise.<Array.<module:bajaux/model/UxModel>>}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var _this3 = this;
        var _this$value = this.value(),
          ordTargets = _this$value.ordTargets;
        return Promise.all([asyncUtils.doRequire('nmodule'.toLowerCase() + '/kitPx/rc/ux/ImageButton'), baja.importTypes(['kitPx:ImageButton', 'kitPx:ActionBinding'])]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 1),
            ImageButton = _ref2[0];
          var actions = _.invoke(_this3.$getTable().getSelectedRows(), 'getSubject');
          var uxModels = [];
          var x = 0;
          ordTargets.forEach(function (ordTarget) {
            var y = 0;
            actions.forEach(function (action) {
              uxModels.push(UxModel.make({
                type: ImageButton,
                metadata: {
                  pxDataTypeSpec: 'kitPx:ImageButton'
                },
                properties: {
                  text: ordTarget.getObject().getDisplayName(action),
                  layout: baja.$('bajaui:Layout', x + ',' + y + ',100,20')
                },
                bindings: [baja.$('kitPx:ActionBinding', {
                  ord: baja.Ord.make(ordTarget.getObject().getNavOrd() + "|slot:" + action).normalize().relativizeToSession(),
                  widgetEvent: 'actionPerformed'
                })]
              }));
              y += 20;
            });
            x += 100;
          });
          return Promise.all(uxModels);
        }).then(function (uxModels) {
          return {
            ordTargets: ordTargets,
            uxModels: uxModels
          };
        });
      }

      /**
       * @private
       * @param {Array.<module:baja/ord/OrdTarget>} ordTargets
       * @returns {Array.<String>}
       */
    }, {
      key: "$getCommonActions",
      value: function $getCommonActions(ordTargets) {
        var actionsInAllComponents = [];
        if (ordTargets.length > 0) {
          var ordTarget = ordTargets[0];
          var ordTargetObject = ordTarget && ordTarget.getObject();
          if (baja.hasType(ordTargetObject, 'baja:Component')) {
            actionsInAllComponents = Object.keys(ordTargetObject.getSlots().actions().filter(function (slot) {
              return !isHidden(slot);
            }).toMap());
          }
        }
        for (var i = actionsInAllComponents.length - 1; i >= 0; i--) {
          for (var j = 1; j < ordTargets.length; j++) {
            var component = ordTargets[j].getObject();
            if (!baja.hasType(component, 'baja:Component')) {
              return [];
            }
            if (actionsInAllComponents[i]) {
              var slot = component.getSlot(actionsInAllComponents[i]);
              if (!slot || !slot.isAction() || isHidden(slot)) {
                actionsInAllComponents[i] = undefined;
              }
            }
          }
        }

        //filter out undefined;
        actionsInAllComponents = actionsInAllComponents.filter(function (item) {
          return item;
        });
        return actionsInAllComponents;
      }

      /**
       * @private
       * @returns {module:bajaux/Widget|undefined}
       */
    }, {
      key: "$getTable",
      value: function $getTable() {
        return this.queryWidget("**/table");
      }
    }]);
  }(spandrel(function (_ref3, _ref4) {
    var ordTargets = _ref3.ordTargets;
    var self = _ref4.self;
    var actionsInAllComponents = self.$getCommonActions(ordTargets);
    var tableModel = new TableModel({
      columns: getColumns(ordTargets),
      rows: actionsInAllComponents.map(function (action) {
        return new Row(action, actionIcon);
      })
    });
    return UxModel.jsx(Table, {
      spandrelKey: "table",
      className: "ux-border",
      value: tableModel,
      on: _defineProperty({}, ROW_SELECTION_CHANGED_EVENT, function () {
        self.setModified(true);
      }),
      properties: {
        fixedHeaders: false
      }
    });
  }, {
    "extends": UxMwConfig
  }));
  function getColumns(ordTargets) {
    var ToDisplayNameColumn = /*#__PURE__*/function (_Column) {
      function ToDisplayNameColumn() {
        _classCallCheck(this, ToDisplayNameColumn);
        return _callSuper(this, ToDisplayNameColumn, arguments);
      }
      _inherits(ToDisplayNameColumn, _Column);
      return _createClass(ToDisplayNameColumn, [{
        key: "getValueFor",
        value: function getValueFor(row) {
          if (ordTargets.length > 0) {
            return ordTargets[0].getObject().getDisplayName(row.getSubject());
          } else {
            return String(row.getSubject());
          }
        }
      }]);
    }(Column);
    return [new IconColumn('icon'), new ToDisplayNameColumn('toString')];
  }
  return MwActionBatch;
});
