function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx UxModel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/uxBuilder/rc/ux/make/MakeWidget
 */
define(['baja!', 'baja!bajaui:Layout,gx:Brush', 'bajaux/spandrel', 'bajaux/model/UxModel', 'lex!uxBuilder', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/uxBuilder/rc/ux/make/mwUtils', 'nmodule/webEditors/rc/fe/ValueWithPopoutWidget', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/servlets/registry', 'nmodule/webEditors/rc/servlets/userData'], function (baja, types, spandrel, UxModel, lexs, Promise, _, asyncUtils, mwUtils, ValueWithPopoutWidget, feDialogs, OrderedMapEditor, registry, userData) {
  'use strict';

  var toOrdTarget = mwUtils.toOrdTarget;
  var getAgentOnInfo = registry.getAgentOnInfo;
  var doRequire = asyncUtils.doRequire;
  var _lexs = _slicedToArray(lexs, 1),
    uxBuilderLex = _lexs[0];
  var get = userData.get;
  var previousConfigType = 'uxBuilder.mwPreviousConfigType';
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'uxBuilder',
      keyName: 'MakeWidget',
      properties: {
        rootCssClass: '-t-MakeWidget'
      }
    };
  };

  /**
   * MakeWidget implementation for showing and configuring the available UxMwConfigs so that new UxModels can be added.
   *
   * @class
   * @alias module:nmodule/uxBuilder/rc/ux/make/MakeWidget
   * @extends {module:bajaux/Widget}
   */
  var MakeWidget = /*#__PURE__*/function (_spandrel) {
    function MakeWidget(params) {
      var _this;
      _classCallCheck(this, MakeWidget);
      _this = _callSuper(this, MakeWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.validators().add(function () {
        var state = _this.state();
        if (!Object.keys(state.configMap).length) {
          throw new Error(uxBuilderLex.get('MakeWidget.noMwConfigsAvailable'));
        }
      });
      return _this;
    }

    /**
     * @returns {Promise.<Array.<module:bajaux/model/UxModel>>}
     */
    _inherits(MakeWidget, _spandrel);
    return _createClass(MakeWidget, [{
      key: "doRead",
      value: function doRead() {
        var configWidget = this.$getConfigWidget();
        return configWidget && configWidget.makeUxModels();
      }
    }, {
      key: "doSave",
      value: function doSave() {
        var configWidget = this.$getConfigWidget();
        var _this$state = this.state(),
          configType = _this$state.configType;
        return Promise.all([configWidget && configWidget.save(), configType && userData.put(previousConfigType, configType)]);
      }
    }, {
      key: "requestFocus",
      value: function requestFocus() {
        var configWidget = this.$getConfigWidget();
        configWidget && configWidget.requestFocus();
      }

      /**
       * @param {Object} originalState
       * @param {Array.<baja.NavNode>} originalState.navNodes
       * @returns {Promise.<Object>}
       */
    }, {
      key: "toState",
      value: function toState(originalState) {
        return this.$getState(originalState);
      }

      /**
       * @private
       * @param {String} [newConfigType]
       * @param {String} [existingConfigType]
       * @returns {Promise.<String>}
       */
    }, {
      key: "$resolveConfigType",
      value: function $resolveConfigType(newConfigType, existingConfigType) {
        return Promise.resolve(newConfigType || existingConfigType || get(previousConfigType));
      }

      /**
       * @private
       * @param {Object} originalState
       * @param {params} params
       * @param {String} [params.newConfigType]
       * @param {baja.OrdList} [params.newOrdList]
       * @returns {Promise.<Object>}
       */
    }, {
      key: "$getState",
      value: function $getState(originalState) {
        var _this2 = this;
        var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          newConfigType = _ref.newConfigType,
          newOrdList = _ref.newOrdList;
        var state = Object.assign({}, originalState);
        return this.$resolveConfigType(newConfigType, state.configType).then(function (configType) {
          var navNodes = state.navNodes,
            ordTargets = state.ordTargets;
          var ordTargetPromise;
          if (newOrdList) {
            ordTargetPromise = Promise.all(newOrdList.getOrds().map(function (ord) {
              return ord.resolve()["catch"](function (ignore) {});
            }));
          } else if (!ordTargets) {
            ordTargetPromise = Promise.resolve(navNodes.map(function (navNode) {
              return toOrdTarget(navNode);
            }));
          } else {
            ordTargetPromise = Promise.resolve(ordTargets);
          }
          return ordTargetPromise.then(function (ordTargets) {
            state.ordTargets = ordTargets;
            return _this2.$getUxMwConfigs(ordTargets);
          }).then(function (configs) {
            state.configs = configs;
            return Promise.all(configs.map(function (config) {
              return Promise.all([doRequire(config.js.id, config.js.deps), baja.importTypes([config.type])]).then(function (_ref2) {
                var _ref3 = _slicedToArray(_ref2, 1),
                  MwConfigWidget = _ref3[0];
                return Promise.all([baja.lt(config.type).getDisplayName({}), new MwConfigWidget().isValidFor(state.ordTargets)]).then(function (_ref4) {
                  var _ref5 = _slicedToArray(_ref4, 2),
                    displayName = _ref5[0],
                    isValidFor = _ref5[1];
                  if (isValidFor) {
                    return {
                      displayName: displayName,
                      config: config,
                      MwConfigWidget: MwConfigWidget
                    };
                  }
                });
              });
            })).then(function (configMapEntries) {
              var configMap = {};
              configMapEntries = configMapEntries.filter(function (configMapEntry) {
                return configMapEntry;
              });
              var configTypeFound = !!configMapEntries.find(function (configMapEntry) {
                var config = configMapEntry.config;
                return configType === config.type;
              });
              configMapEntries.forEach(function (configMapEntry, i) {
                var config = configMapEntry.config;
                if (!configTypeFound && i === 0 || configType === config.type) {
                  state.configType = config.type;
                  state.MwConfigWidget = configMapEntry.MwConfigWidget;
                }
                configMap[configMapEntry.displayName] = configMapEntry.config.type;
              });
              state.configMap = configMap;
              return state;
            });
          });
        });
      }

      /**
       * @private
       * @param {String} newConfigType
       * @returns {Promise}
       */
    }, {
      key: "$configModified",
      value: function $configModified(newConfigType) {
        var _this3 = this;
        var state = this.state();
        return this.$getState(state, {
          newConfigType: newConfigType
        }).then(function (newState) {
          _this3.setModified(true);
          return _this3.state(newState).then(function () {
            _this3.requestFocus();
          });
        });
      }

      /**
       * @private
       * @param {baja.OrdList} newOrdList
       * @returns {Promise}
       */
    }, {
      key: "$ordListModified",
      value: function $ordListModified(newOrdList) {
        var _this4 = this;
        var state = this.state();
        return this.$getState(state, {
          newOrdList: newOrdList
        }).then(function (newState) {
          _this4.setModified(true);
          return _this4.state(newState);
        });
      }

      /**
       * @private
       * @param {Array.<module:baja/ord/OrdTarget>} ordTargets
       * @returns {Promise.<Array.<module:nmodule/webEditors/rc/servlets/registry~TypeInfo>>} resolves to the available TypeInfos, one for each
       * `uxBuilder:IUxMwConfig` registered.
       */
    }, {
      key: "$getUxMwConfigs",
      value: function $getUxMwConfigs(ordTargets) {
        return Promise.all(ordTargets.map(function (ordTarget) {
          var ordTargetObject = ordTarget && ordTarget.getObject();
          if (ordTargetObject === null || ordTargetObject === undefined) {
            return [];
          }
          return getAgentOnInfo(ordTargetObject.getType(), {
            is: 'uxBuilder:IUxMwConfig'
          });
        })).then(function (agentsArray) {
          var results = [];
          agentsArray.forEach(function (agents) {
            agents.forEach(function (agent) {
              if (results.indexOf(agent) < 0) {
                results.push(agent);
              }
            });
          });
          return results;
        });
      }

      /**
       * @private
       * @returns {module:nmodule/uxBuilder/rc/ux/make/UxMwConfig|undefined}
       */
    }, {
      key: "$getConfigWidget",
      value: function $getConfigWidget() {
        return this.queryWidget('**/configWidget');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget|undefined}
       */
    }, {
      key: "$getConfigTypeWidget",
      value: function $getConfigTypeWidget() {
        return this.queryWidget('**/configTypeWidget');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget|undefined}
       */
    }, {
      key: "$getOrdListWidget",
      value: function $getOrdListWidget() {
        return this.queryWidget('**/ordListWidget');
      }

      /**
       * @param {Array.<baja.NavNode>} navNodes
       * @param {Object} params
       * @returns {Promise.<Array.<module:bajaux/model/UxModel>>}
       */
    }], [{
      key: "showFor",
      value: function showFor(navNodes, params) {
        return _showFor(navNodes, params);
      }
    }]);
  }(spandrel(function (value, _ref6) {
    var self = _ref6.self,
      ordTargets = _ref6.ordTargets,
      MwConfigWidget = _ref6.MwConfigWidget,
      configMap = _ref6.configMap,
      configType = _ref6.configType,
      properties = _ref6.properties;
    var ordList = baja.OrdList.make(ordTargets.map(function (ordTarget) {
      return ordTarget && ordTarget.getOrd() || baja.Ord.DEFAULT;
    }));
    var hasConfig = Object.keys(configMap).length;
    return [UxModel.jsx(ValueWithPopoutWidget, {
      value: ordList,
      spandrelKey: "ordListWidget",
      onUxModifiedValue: function onUxModifiedValue(newOrdList) {
        return self.$ordListModified(newOrdList);
      }
    }), UxModel.jsx(OrderedMapEditor, {
      "class": "-t-UxMwConfig-configType",
      value: configType,
      spandrelKey: "configTypeWidget",
      lax: true,
      properties: {
        map: configMap
      },
      onUxModifiedValue: function onUxModifiedValue(newConfigType) {
        return self.$configModified(newConfigType);
      }
    }), hasConfig && UxModel.jsx(MwConfigWidget, {
      "class": "-t-UxMwConfig-config",
      validate: true,
      spandrelKey: "configWidget",
      properties: properties,
      value: {
        ordTargets: ordTargets
      }
    })];
  }, {
    strategy: "niagara"
  }));
  /**
   *
   * @param {Array.<baja.NavNode>} navNodes
   * @param {Object} params
   * @returns {Promise.<Array.<module:bajaux/model/UxModel>>}
   */
  function _showFor(navNodes, params) {
    return feDialogs.showFor({
      value: {
        navNodes: navNodes
      },
      type: MakeWidget,
      title: uxBuilderLex.get('MakeWidget.title'),
      properties: _.pick(params, 'baseOrd', 'pxLayers', 'pxProperties')
    });
  }
  return MakeWidget;
});
